#!/bin/sh

# Don't start without a kernel as a parameter
if [ "$2" = "" ]; then
  echo "usage: $0 kernel machine"
  exit 1
fi

# Does the kernel exist at all
if [ ! -r $1 ]; then
  echo "ERROR! kernel $1 does not exist or is not readable."
  exit 1
fi

# Does the machine configuration exist at all
if [ ! -r initial-conf-$2/myname ]; then
  echo "ERROR! initial-conf-$2 does not exist or is not readable."
  exit 1
fi

# Does the common configuration exist at all
if [ ! -r initial-conf-common/rc.conf ]; then
  echo "ERROR! initial-conf-common does not exist or is not readable."
  exit 1
fi

rm -rf initial-conf
cp -r initial-conf-common initial-conf
cp -r initial-conf-$2/* initial-conf
./build-kernel.sh $1
cp obj/bsd.gz ../$2.gz
