// Circle.h : Declaration of the CCircle

#ifndef __CIRCLE_H_
#define __CIRCLE_H_

#include "resource.h"       // main symbols
#include "ClockFace.h"
#include "clock.h"

EXTERN_C const CLSID CLSID_Circle;

/////////////////////////////////////////////////////////////////////////////
// CCircle
class ATL_NO_VTABLE CCircle :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CCircle, &CLSID_Circle>,
	public IPropertyPageImpl<CCircle>,
	public CDialogImpl<CCircle>
{
private:
	bool	m_bShown;

public:
	CCircle() 
	{
		m_dwTitleID = IDS_TITLECircle;
		m_dwHelpFileID = IDS_HELPFILECircle;
		m_dwDocStringID = IDS_DOCSTRINGCircle;
		m_bShown = false;
	}

	enum {IDD = IDD_CIRCLE};

DECLARE_REGISTRY_RESOURCEID(IDR_CIRCLE)

BEGIN_COM_MAP(CCircle) 
	COM_INTERFACE_ENTRY_IMPL(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CCircle)
	CHAIN_MSG_MAP(IPropertyPageImpl<CCircle>)
	COMMAND_HANDLER(IDC_QUARTERDRAWN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_QUARTERSIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_QUARTERTHICKNESS, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_FIVEDRAWN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_FIVESIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_FIVETHICKNESS, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_MINDRAWN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_MINSIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_MINTHICKNESS, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_OUTERDRAWN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_OUTERTHICKNESS, EN_CHANGE, OnClicked)
END_MSG_MAP()

	STDMETHOD(Apply)(void)
	{
		ATLTRACE(_T("CClockProp::Apply\n"));

		for (UINT i = 0; i < m_nObjects; i++)
		{
	        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

			pClock -> put_Drawn (CClock::ecQuarterGrad,
				IsDlgButtonChecked (IDC_QUARTERDRAWN));

			pClock -> put_Size (CClock::ecQuarterGrad, 
				static_cast <double> (GetDlgItemInt (IDC_QUARTERSIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecQuarterGrad, 
				(short) GetDlgItemInt (IDC_QUARTERTHICKNESS));


			pClock -> put_Drawn (CClock::ecFiveGrad,
				IsDlgButtonChecked (IDC_FIVEDRAWN));

			pClock -> put_Size (CClock::ecFiveGrad, 
				static_cast <double> (GetDlgItemInt (IDC_FIVESIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecFiveGrad, 
				(short) GetDlgItemInt (IDC_FIVETHICKNESS));


			pClock -> put_Drawn (CClock::ecSingleGrad,
				IsDlgButtonChecked (IDC_MINDRAWN));

			pClock -> put_Size (CClock::ecSingleGrad, 
				static_cast <double> (GetDlgItemInt (IDC_MINSIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecSingleGrad, 
				(short) GetDlgItemInt (IDC_MINTHICKNESS));


			pClock -> put_Drawn (CClock::ecCircle,
				IsDlgButtonChecked (IDC_OUTERDRAWN));

			pClock -> put_Thickness (CClock::ecCircle, 
				(short) GetDlgItemInt (IDC_OUTERTHICKNESS));

		}

		m_bDirty = FALSE;
		return S_OK;
	}

	STDMETHOD(Show)(UINT nCmdShow)
	{
		ATLTRACE(_T("CClockProp::Show\n"));

		if (! m_bShown) {

			short n;
			double db;

			for (UINT i = 0; i < m_nObjects; i++) {

		        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

				if (	GetDlgItemInt (IDC_OUTERTHICKNESS) ||
						GetDlgItemInt (IDC_QUARTERSIZE) ||
						GetDlgItemInt (IDC_FIVESIZE) ||
						GetDlgItemInt (IDC_MINSIZE))
					continue;

				pClock -> get_Drawn (CClock::ecQuarterGrad, &n);
				CheckDlgButton (IDC_QUARTERDRAWN, n);

				pClock -> get_Size (CClock::ecQuarterGrad, &db);
				SetDlgItemInt (IDC_QUARTERSIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecQuarterGrad, &n);
				SetDlgItemInt (IDC_QUARTERTHICKNESS, n, FALSE);


				pClock -> get_Drawn (CClock::ecFiveGrad, &n);
				CheckDlgButton (IDC_FIVEDRAWN, n);

				pClock -> get_Size (CClock::ecFiveGrad, &db);
				SetDlgItemInt (IDC_FIVESIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecFiveGrad, &n);
				SetDlgItemInt (IDC_FIVETHICKNESS, n, FALSE);


				pClock -> get_Drawn (CClock::ecSingleGrad, &n);
				CheckDlgButton (IDC_MINDRAWN, n);

				pClock -> get_Size (CClock::ecSingleGrad, &db);
				SetDlgItemInt (IDC_MINSIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecSingleGrad, &n);
				SetDlgItemInt (IDC_MINTHICKNESS, n, FALSE);


				pClock -> get_Drawn (CClock::ecCircle, &n);
				CheckDlgButton (IDC_OUTERDRAWN, n);

				pClock -> get_Thickness (CClock::ecCircle, &n);
				SetDlgItemInt (IDC_OUTERTHICKNESS, n, FALSE);

			}

			m_bShown = true;

		}

		return IPropertyPageImpl<CCircle>::Show (nCmdShow);
	}


	LRESULT OnClicked (WORD wNotify, WORD wID, HWND hWnd, BOOL& bHandled)
	{
	    SetDirty(TRUE);
		return 0;
	}

};

#endif //__CIRCLE_H_
