// ClockProp.h : Declaration of the CClockProp

#ifndef __CLOCKPROP_H_
#define __CLOCKPROP_H_

#include "resource.h"       // main symbols
#include "ClockFace.h"
#include "clock.h"

EXTERN_C const CLSID CLSID_ClockProp;

/////////////////////////////////////////////////////////////////////////////
// CClockProp
class ATL_NO_VTABLE CClockProp :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CClockProp, &CLSID_ClockProp>,
	public IPropertyPageImpl<CClockProp>,
	public CDialogImpl<CClockProp>
{
private:
	bool	m_bShown;

public:
	CClockProp() 
	{
		m_dwTitleID = IDS_TITLEClockProp;
		m_dwHelpFileID = IDS_HELPFILEClockProp;
		m_dwDocStringID = IDS_DOCSTRINGClockProp;
		m_bShown = false;
	}

	enum {IDD = IDD_CLOCKPROP};

DECLARE_REGISTRY_RESOURCEID(IDR_CLOCKPROP)

BEGIN_COM_MAP(CClockProp) 
	COM_INTERFACE_ENTRY_IMPL(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CClockProp)
	CHAIN_MSG_MAP(IPropertyPageImpl<CClockProp>)
	COMMAND_HANDLER(IDC_HOURHIDDEN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_HOURPLAIN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_HOURDECORATIVE, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_HOURSIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_HOURTHICKNESS, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_MINUTEHIDDEN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_MINUTEPLAIN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_MINUTEDECORATIVE, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_MINUTESIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_MINUTETHICKNESS, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_SECONDHIDDEN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_SECONDPLAIN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_SECONDDECORATIVE, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_SECONDSIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_SECONDTHICKNESS, EN_CHANGE, OnClicked)
END_MSG_MAP()

	STDMETHOD(Apply)(void)
	{
		ATLTRACE(_T("CClockProp::Apply\n"));

		for (UINT i = 0; i < m_nObjects; i++)
		{
	        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

			pClock -> put_Drawn (CClock::ecHour,
				IsDlgButtonChecked (IDC_HOURHIDDEN) ? 0 :
				IsDlgButtonChecked (IDC_HOURDECORATIVE) ? 2 : 1);

			pClock -> put_Size (CClock::ecHour, 
				static_cast <double> (GetDlgItemInt (IDC_HOURSIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecHour, 
				(short) GetDlgItemInt (IDC_HOURTHICKNESS));


			pClock -> put_Drawn (CClock::ecMinute,
				IsDlgButtonChecked (IDC_MINUTEHIDDEN) ? 0 :
				IsDlgButtonChecked (IDC_MINUTEDECORATIVE) ? 2 : 1);

			pClock -> put_Size (CClock::ecMinute, 
				static_cast <double> (GetDlgItemInt (IDC_MINUTESIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecMinute,
				(short) GetDlgItemInt (IDC_MINUTETHICKNESS));


			pClock -> put_Drawn (CClock::ecSecond,
				IsDlgButtonChecked (IDC_SECONDHIDDEN) ? 0 :
				IsDlgButtonChecked (IDC_SECONDDECORATIVE) ? 2 : 1);

			pClock -> put_Size (CClock::ecSecond, 
				static_cast <double> (GetDlgItemInt (IDC_SECONDSIZE)) / 100.0);

			pClock -> put_Thickness (CClock::ecSecond,
				(short) GetDlgItemInt (IDC_SECONDTHICKNESS));

		}

		m_bDirty = FALSE;
		return S_OK;
	}

	STDMETHOD(Show)(UINT nCmdShow)
	{
		ATLTRACE(_T("CClockProp::Show\n"));

		if (! m_bShown) {

			short n;
			double db;

			for (UINT i = 0; i < m_nObjects; i++) {

		        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

				if (	IsDlgButtonChecked (IDC_HOURHIDDEN) ||
						IsDlgButtonChecked (IDC_HOURDECORATIVE) ||
						IsDlgButtonChecked (IDC_HOURPLAIN))
					continue;

				pClock -> get_Drawn (CClock::ecHour, &n);
				CheckDlgButton (IDC_HOURHIDDEN, (n == 0));
				CheckDlgButton (IDC_HOURPLAIN, (n == 1));
				CheckDlgButton (IDC_HOURDECORATIVE, (n == 2));

				pClock -> get_Size (CClock::ecHour, &db);
				SetDlgItemInt (IDC_HOURSIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecHour, &n);
				SetDlgItemInt (IDC_HOURTHICKNESS, n, FALSE);


				pClock -> get_Drawn (CClock::ecMinute, &n);
				CheckDlgButton (IDC_MINUTEHIDDEN, (n == 0));
				CheckDlgButton (IDC_MINUTEPLAIN, (n == 1));
				CheckDlgButton (IDC_MINUTEDECORATIVE, (n == 2));

				pClock -> get_Size (CClock::ecMinute, &db);
				SetDlgItemInt (IDC_MINUTESIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecMinute, &n);
				SetDlgItemInt (IDC_MINUTETHICKNESS, n, FALSE);


				pClock -> get_Drawn (CClock::ecSecond, &n);
				CheckDlgButton (IDC_SECONDHIDDEN, (n == 0));
				CheckDlgButton (IDC_SECONDPLAIN, (n == 1));
				CheckDlgButton (IDC_SECONDDECORATIVE, (n == 2));

				pClock -> get_Size (CClock::ecSecond, &db);
				SetDlgItemInt (IDC_SECONDSIZE, static_cast <short> (db * 100), FALSE);

				pClock -> get_Thickness (CClock::ecSecond, &n);
				SetDlgItemInt (IDC_SECONDTHICKNESS, n, FALSE);

			}

			m_bShown = true;

		}

		return IPropertyPageImpl<CClockProp>::Show (nCmdShow);
	}


	LRESULT OnClicked (WORD wNotify, WORD wID, HWND hWnd, BOOL& bHandled)
	{
	    SetDirty(TRUE);
		return 0;
	}

};

#endif //__CLOCKPROP_H_
