// Element.h : Declaration of the CElement

#ifndef __ELEMENT_H_
#define __ELEMENT_H_

#include "resource.h"       // main symbols
#include "ClockFace.h"
#include "clock.h"

EXTERN_C const CLSID CLSID_Element;

/////////////////////////////////////////////////////////////////////////////
// CElement
class ATL_NO_VTABLE CElement :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CElement, &CLSID_Element>,
	public IPropertyPageImpl<CElement>,
	public CDialogImpl<CElement>
{
private:
	bool m_bShown;

public:
	CElement() 
	{
		m_dwTitleID = IDS_TITLEElement;
		m_dwHelpFileID = IDS_HELPFILEElement;
		m_dwDocStringID = IDS_DOCSTRINGElement;
		m_bShown = false;
	}

	enum {IDD = IDD_ELEMENT};

DECLARE_REGISTRY_RESOURCEID(IDR_ELEMENT)

BEGIN_COM_MAP(CElement) 
	COM_INTERFACE_ENTRY_IMPL(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CElement)
	CHAIN_MSG_MAP(IPropertyPageImpl<CElement>)
	COMMAND_HANDLER(IDC_AMPMHIDDEN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_AMPMTEXT, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_AMPMICON, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_CENTREDRAWN, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_CENTRESIZE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_WINDER, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_DIGITAL, BN_CLICKED, OnClicked)
	COMMAND_HANDLER(IDC_GRAVITY, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_LEGENDDRAWN, EN_CHANGE, OnClicked)
END_MSG_MAP()

	STDMETHOD(Apply)(void)
	{
		ATLTRACE(_T("CClockProp::Apply\n"));
//		BSTR bstr;

		for (UINT i = 0; i < m_nObjects; i++)
		{
	        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

			pClock -> put_Drawn (CClock::ecAMPM,
				IsDlgButtonChecked (IDC_AMPMHIDDEN) ? 0 :
				IsDlgButtonChecked (IDC_AMPMICON) ? 2 : 1);


			pClock -> put_Drawn (CClock::ecCentre,
				IsDlgButtonChecked (IDC_CENTREDRAWN));

			pClock -> put_Size (CClock::ecCentre, 
				static_cast <double> (GetDlgItemInt (IDC_CENTRESIZE)) / 100.0);


			pClock -> put_Drawn (CClock::ecWindUp,
				IsDlgButtonChecked (IDC_WINDER));

			pClock -> put_Drawn (CClock::ecWindDown,
				IsDlgButtonChecked (IDC_WINDER));

			pClock -> put_Drawn (CClock::ecWinderArm,
				IsDlgButtonChecked (IDC_WINDER));


			pClock -> put_Drawn (CClock::ecDigital,
				IsDlgButtonChecked (IDC_DIGITAL));


			pClock -> put_Drawn (CClock::ecCyberspace,
				IsDlgButtonChecked (IDC_LEGENDDRAWN));


			pClock -> put_GravityWellX (
				static_cast <long> (GetDlgItemInt (IDC_GRAVITY)));

			pClock -> put_GravityWellY (
				static_cast <long> (GetDlgItemInt (IDC_GRAVITY)));

		}

		m_bDirty = FALSE;
		return S_OK;
	}

	STDMETHOD(Show)(UINT nCmdShow)
	{
		ATLTRACE(_T("CClockProp::Show\n"));

		if (! m_bShown) {

			short n;
			double db;
			long l;

			for (UINT i = 0; i < m_nObjects; i++) {

		        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

				if (	IsDlgButtonChecked (IDC_AMPMHIDDEN) ||
						IsDlgButtonChecked (IDC_AMPMTEXT) ||
						IsDlgButtonChecked (IDC_AMPMICON))
					continue;

				pClock -> get_Drawn (CClock::ecAMPM, &n);
				CheckDlgButton (IDC_AMPMHIDDEN, (n == 0));
				CheckDlgButton (IDC_AMPMTEXT, (n == 1));
				CheckDlgButton (IDC_AMPMICON, (n == 2));


				pClock -> get_Drawn (CClock::ecCentre, &n);		
				CheckDlgButton (IDC_CENTREDRAWN, n);

				pClock -> get_Size (CClock::ecCentre, &db);
				SetDlgItemInt (IDC_CENTRESIZE, static_cast <short> (db * 100), FALSE);

		
				pClock -> get_Drawn (CClock::ecDigital, &n);		
				CheckDlgButton (IDC_DIGITAL, n);


				pClock -> get_Drawn (CClock::ecWinderArm, &n);
				CheckDlgButton (IDC_WINDER,	n);


				pClock -> get_GravityWellX (&l);
				SetDlgItemInt (IDC_GRAVITY, l, FALSE);


				pClock -> get_Drawn (CClock::ecCyberspace, &n);		
				CheckDlgButton (IDC_LEGENDDRAWN, n);


			}

			m_bShown = true;

		}

		return IPropertyPageImpl<CElement>::Show (nCmdShow);
	}


	LRESULT OnClicked (WORD wNotify, WORD wID, HWND hWnd, BOOL& bHandled)
	{
	    SetDirty(TRUE);
		return 0;
	}

};

#endif //__ELEMENT_H_
