// Time.h : Declaration of the CTime

#ifndef __TIME_H_
#define __TIME_H_

#include "resource.h"       // main symbols
#include "ClockFace.h"
#include "clock.h"

EXTERN_C const CLSID CLSID_Time;

/////////////////////////////////////////////////////////////////////////////
// CTime
class ATL_NO_VTABLE CTime :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CTime, &CLSID_Time>,
	public IPropertyPageImpl<CTime>,
	public CDialogImpl<CTime>
{
private:
	bool	m_bShown;

public:
	CTime() 
	{
		m_dwTitleID = IDS_TITLETime;
		m_dwHelpFileID = IDS_HELPFILETime;
		m_dwDocStringID = IDS_DOCSTRINGTime;
		m_bShown = false;
	}

	enum {IDD = IDD_TIME};

DECLARE_REGISTRY_RESOURCEID(IDR_TIME)

BEGIN_COM_MAP(CTime) 
	COM_INTERFACE_ENTRY_IMPL(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CTime)
	CHAIN_MSG_MAP(IPropertyPageImpl<CTime>)
	COMMAND_HANDLER(IDC_HOUR, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_MINUTE, EN_CHANGE, OnClicked)
	COMMAND_HANDLER(IDC_SECOND, EN_CHANGE, OnClicked)
END_MSG_MAP()

	STDMETHOD(Apply)(void)
	{
		ATLTRACE(_T("CClockProp::Apply\n"));

		for (UINT i = 0; i < m_nObjects; i++)
		{
	        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

			pClock -> SetTime (
				GetDlgItemInt (IDC_HOUR), 
				GetDlgItemInt (IDC_MINUTE),
				GetDlgItemInt (IDC_SECOND));

		}

		m_bDirty = FALSE;
		return S_OK;
	}

	STDMETHOD(Show)(UINT nCmdShow)
	{
		ATLTRACE(_T("CClockProp::Show\n"));

		if (! m_bShown) {

			for (UINT i = 0; i < m_nObjects; i++) {

		        CComQIPtr<IClock, &IID_IClock> pClock (m_ppUnk[i]);

				int nHour = GetDlgItemInt (IDC_HOUR);
				int nMinute = GetDlgItemInt (IDC_MINUTE);
				int nSecond = GetDlgItemInt (IDC_SECOND);

				if (	GetDlgItemInt (IDC_HOUR) || 
						GetDlgItemInt (IDC_MINUTE) ||
						GetDlgItemInt (IDC_SECOND))
					continue;

				SetDlgItemInt (IDC_HOUR, 10, FALSE);
				SetDlgItemInt (IDC_MINUTE, 30, FALSE);
				SetDlgItemInt (IDC_SECOND, 45, FALSE);

			}

			m_bShown = true;

		}

		return IPropertyPageImpl<CTime>::Show (nCmdShow);
	}


	LRESULT OnClicked (WORD wNotify, WORD wID, HWND hWnd, BOOL& bHandled)
	{
	    SetDirty(TRUE);
		return 0;
	}

};

#endif //__TIME_H_
