/* define tab stops
L---!---!---!---!---!---!---!---!---!---!---!---!--------------------------!R
*/
/***************************************************************************/
/*                                                                         */
/*                            C    U   B   E                               */
/*                                                                         */
/***************************************************************************/
/*                                                                         */
/*  Programmer:     Christof Fetzer                                        */
/*  Date:           12-08-85                                               */
/*  Last Update:    12-08-85                                               */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*                          I N C L U D E S                                */
/***************************************************************************/

#include    "gembind.h"                         /* gembind definitions     */
#include    "portab.h"
#include    "sintab.h"                          /* sinus table (sintab)    */
#include    "costab.h"                          /* cosinus table (costab)  */
#include    "obdefs.h"                          /* object defs             */
#include    "machine.h"				/* machine dependent macros*/
#include    "cubever.h"                         /* Accessory or Application*/
#include    "cubemess.h"			/* Cube messages	   */

/***************************************************************************/
/*                          D E F I N E S                                  */
/***************************************************************************/

#define ARROW           0                       /* Mouse style type        */
#define	HOUR_GLASS	2			/*   "     "     "         */

#define	DESK		0                       /* Desk handle             */

#define END_UPDATE	0                       /* used with wind_update   */
#define	BEG_UPDATE	1                       /* for start and end       */

#define	MENU_ENABLE     1                       /* enable menu item        */
#define	MENU_DISABLE    0                       /* disable menue item      */

#define	FINELINE	1                       /* line width 1            */
#define	THICKLINE	4			/* line width 4	           */
#define SOLID           1                       /* solid line style        */
/*
#define WHITE           0                       /* white colour            */
#define BLACK           1                       /* black colour            */
*/
#define	REPLACE		1			/* replace write mode      */
#define TRANSPARENT     2                       /* transparent write mode  */
#define XOR             3                       /* xor write mode          */
#define REV_TRANSPARENT 4                       /* reverse transparent mode*/

#define INIT            0                       /* flag for init. spinning */
#define CLEAR           1                       /* flag for clearing the last cube */
#define NOCLEAR         2                       /* flag for no clearing of the last cube */
#define	REDRAW		4			/* just redraw picture	   */
#define	CALC		5			/* calculat new cube	   */

#define	STEP		3			/* rotation angle	   */


/***************************************************************************/
/***************************************************************************/
/****								        ****/
/****			    Data Structures			        ****/
/****								        ****/
/***************************************************************************/
/***************************************************************************/


/***************************************************************************/
/*                       G L O B A L   V A R I A B L E S                   */
/***************************************************************************/

GLOBAL WORD	contrl[11];		/* control inputs		   */
GLOBAL WORD	intin [80];		/* max string length               */
GLOBAL WORD	ptsin [80];		/* polygon fill points		   */
GLOBAL WORD	intout[45];		/* open workstation output	   */
GLOBAL WORD	ptsout[12];


/***************************************************************************/
/*                      L O C A L   V A R I A B L E S                      */
/***************************************************************************/

WORD	gl_wchar;			/* character width		   */
WORD	gl_hchar;			/* character height		   */
WORD	gl_wbox;			/* box (cell) width	           */
WORD	gl_hbox;			/* box (cell) height		   */
WORD	gem_handle;			/* GEM vdi handle		   */
WORD	vdi_handle;			/* type vdi handle		   */
WORD    cube_whndl;                     /* cube window handle             */
WORD	work_out [57];			/* open virt workstation values	   */
WORD    work_in [11];                   /* open virt workst. input values  */
GRECT	work_area;			/* current window work area	   */
WORD	gl_apid;			/* application ID		   */
WORD	gl_rmsg[8];			/* message buffer		   */
LONG	ad_rmsg;			/* LONG pointer to message bfr	   */
WORD	gl_itemcube = 0;		/* type menu item		   */
WORD	gl_xfull;			/* full window 'x'		   */
WORD	gl_yfull;			/* full window 'y'		   */
WORD	gl_wfull;			/* full window 'w' width	   */
WORD	gl_hfull;			/* full window 'h' height	   */
WORD	ev_which;			/* event message returned value	   */
WORD	ev_moflags;			/* flag if the mouse is in or out of the wdw */
WORD	gp_x;				/* previously used window 'x'	   */
WORD	gp_y;				/* previously used window 'y'	   */
WORD	gp_w;				/* previously used window 'w'	   */
WORD	gp_h;				/* previously used window 'h'	   */

BYTE	*wdw_title = M_TITLE;		/* window title			   */

int     x0;				/* x-cor. of wdw centre            */
int	y0;                             /* y-cor. of wdw centre            */
int     l;                              /* side length of cube             */

WORD	attrib [5];			/* current setting of all attributes */

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/************************************************/
/*		cube_init			*/
/************************************************/

cube_init ()					/* open workstation	   */
{

        int     i;        

        gl_apid = appl_init ();                 /* establish data structure*/
#if	(VERSION & ACCESSORY)			/* enter disp in menu	   */
	wind_update (BEG_UPDATE);
#endif

        work_in [0] = 1;                        /* use screen device       */
        for (i = 1; i < 10; i++)                /* use standard values     */
            work_in [i] = 1;                    /* e.g. 1                  */
        work_in [10] = 2;                       /* use the RC system       */
                                                /* get char. size, handle  */
        vdi_handle = graf_handle ( &gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
        v_opnwk (work_in, &vdi_handle, work_out); /* open work station	   */

/* get the full size of the screen                                         */
 	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);

	/**/					/* init. message address*/
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);
#if	(VERSION & ACCESSORY)			/* enter disp in menu	*/
	gl_itemcube = menu_register (gl_apid, ADDR(M_ITITLE));
#endif
	return (TRUE);

}


/************************************************/
/*		    do_init                     */
/************************************************/

do_init ()                                      /* open window 		   */
{


/* create window with the follwing options: 0x02f =  NAME | CLOSER | MOVER */
/*						     | FULL | CREATE	   */
	cube_whndl = wind_create(0x02f, gl_xfull, gl_yfull, gl_wfull, gl_hfull);

/* grow boxes and open window in its fullest size                          */
        do_open (cube_whndl, gl_xfull/2, gl_yfull/2, gl_xfull, gl_yfull,gl_wfull/2, gl_hfull/2);
/* get the work area size                                                  */
 	wind_get (cube_whndl, WF_WXYWH, &work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
/* set window title							   */
	wind_set (cube_whndl, WF_NAME,(WORD) LLOWD(ADDR(wdw_title)), (WORD) LHIWD(ADDR(wdw_title)), 0, 0);

	get_attr ();				/* get attributes	   */
	clear_disp (&work_area);		/* clear work area	   */
	set_attr ();				/* set old attributes	   */

/* calculate the centre of the window and the cube side length		   */
        x0 = work_area.g_x + (work_area.g_w >> 1); /* calc. wdw x-centre   */
        y0 = work_area.g_y + (work_area.g_h >> 1); /* calc. wdw y-centre   */
        l = min(work_area.g_w, work_area.g_h) / 3;/* calc. cube side len. */
        return (cube_whndl);                    /* and return wdw handle   */
}

/************************************************/
/*                  do_open                     */
/************************************************/

int do_open (wh, org_x, org_y, x, y, w, h)      /* grow and open specified wdw */
int	wh;                                     /* vdi handle              */
int	org_x, org_y;                           /* start of growing boxes  */
int	x, y, w, h;                             /* coordinates of the wdw  */
{

	int	ret_code;

	graf_mouse (HOUR_GLASS, 0x0L);          /* set mouse style         */ 
/*  grow boxes from org_x / y, size 21/21 to the full window size          */
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);   /* open window             */
	graf_mouse(ARROW,0x0L);                 /* set normal mouse style  */
	return(ret_code);                       /* return wdw handle       */
}


/***************************************************************************/
/*                          S P I N N I N G                                */
/***************************************************************************/

/*------------------------------*/
/*	spin			*/
/*------------------------------*/
VOID	spin (items, array)	/* draw cube applying the current rectangle list   */
WORD	items;                                  /* number of lines to draw */
WORD	array [];                               /* polyline array          */
{

	WORD	ev_mmox,
                ev_mmoy,
                ev_mmokstatem, 
                ev;
	GRECT	box;                            /* contains next rectangle */
	BOOLEAN	cl_mouse = FALSE;               /* flag if mouse is cleared */

#if	(VERSION & NOFLICKER)     /* stop flickering of the 'mouse'        */

/* get the actual mouse position                                           */
	graf_mkstate (&ev_mmox, &ev_mmoy, &ev_mmokstatem, &ev); 
	if (inside (ev_mmox, ev_mmoy, &work_area)) 
	{                                       /* if mouse is in the wdw  */
            graf_mouse(M_OFF, 0x0L);		/* clear mouse set flag    */
            cl_mouse = TRUE;			/* for turn it again on    */
	}

#else                                           /* if normal mode just     */
	graf_mouse (M_OFF, 0x0L);               /* switch the mouse off    */
#endif

/* get the first rectangle of the window                                   */
	wind_get(cube_whndl, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )            /* while there are any     */
	{                                       /* rectangles left         */
            if (rc_intersect(&work_area, &box)) /* if update array in this */
	    {                                   /* rectangle set clip area */
	        set_clip (TRUE, &box);          /* for this area and       */
                v_pline (cube_whndl, items, array); /* redraw polyline     */
                set_clip (FALSE, &box);         /* reset clip area         */
            }                                   /* and get next one        */
            wind_get(cube_whndl, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
#if	(VERSION & NOFLICKER)		        /* if in NOFLICKERING mode */
	if (cl_mouse)                           /* test if mouse is turned */
#endif                                          /* off turn it off and     */
            graf_mouse(M_ON, 0x0L);             /* just turn it off        */
}

/*------------------------------*/
/*	spinning		*/
/*------------------------------*/

spinning (area, angle, init)                    /* rotate cube in a given  */
GRECT   *area;                                  /* area and                */
WORD    angle;                                  /* through a given angle   */
BOOLEAN init;                                   /* initialize flag         */
{

        static  int     pxy_ar1 [40];           /* first polyline array    */
        static  int     pxy_ar2 [40];           /* second polyline array   */
        static  int     *pxy;                   /* actually used array     */
        static  int     *pxy_old;               /* prev array to clear wdw */  
        static  int	alpha = 1;              /* angle -  view axis to i */ 
        static  int	beta =  5;              /* angle -  view axis to j */
        static  int	gamma = 1;              /* angle -  view axis to k */
        int     *tmp;                           /* temporary pointer       */
	int	i;				/* index var for init	   */
        double  ix;
        double  iy;
        double  iz;
        double  kx;
	double  ky;
        double  kz;
        double  jx;
        double  jy;
        double  jz;
        double  lx;
        double  ly;
        double  ax;
        double  ay;
        double  bx;
        double  by;
        int     xa, ya;
        int     xb, yb;
        int     xc, yc;
        int     xp, yp;


    
	if (init == INIT)			/* if init initialize the  */
	{                                       /* polyline array 1 and 2  */
		for (i = 0; i < 32; ++ i)       /* and init. pointer 1     */
			pxy_ar1 [i] = pxy_ar2 [i] = 0;
	        pxy = pxy_ar1;                  /* and 2 pointing to this  */
        	pxy_old = pxy_ar2;              /* two areas               */
	}	
	else if (init == REDRAW)		/* if redraw option	   */
	{					/* set the right mode	   */
	    set_clip (TRUE, area);		/* set clip area	   */
            vswr_mode (cube_whndl, REPLACE);   	/* replace write draw mode */
            vsl_type  (cube_whndl, SOLID);      /* set solid line type     */
            vsl_width (cube_whndl, FINELINE);   /* set width of lines      */
            vsl_color (cube_whndl, BLACK);  	/* set color (BLACK)       */
	    v_pline (cube_whndl, 16, pxy_old);	/* and redraw cube	   */
            vswr_mode (cube_whndl, TRANSPARENT);/* trans. write draw mode  */
	    set_clip (FALSE, area);		/* reset clip area	   */
	}
	else
    	{
            wind_update (BEG_UPDATE);           /* start of window update  */
	    get_attr ();			/* get current attributes  */
            vswr_mode (cube_whndl, REPLACE);   	/* replace write draw mode */
            vsl_type  (cube_whndl, SOLID);      /* set solid line type     */
            vsl_width (cube_whndl, FINELINE);   /* set width of lines      */
            vsl_ends  (cube_whndl, 0, 0);       /* set normal line end     */ 
            ix = -sintab [alpha];
            kx = costab [alpha];
            jy = costab [beta];
            jz = sintab [beta];
            iy = -kx * jz;
            iz = kx * jy;
            ky = -ix * jz;
            kz = -ix * jy;
            if (iz < 0.0)
                 ix = -ix, iy = -iy;
            if (jz < 0.0)
                jy = -jy;
            if (kz < 0.0)
                 kx = -kx, ky = -ky;
            lx = l * costab [gamma];
            ly = l * sintab [gamma];
            ax = ix - kx;
            ay = iy + jy - ky;
            xa = ax * lx + ay * ly + x0;
            ya = ay * lx + ax * ly + y0;
            bx = ix + kx;
            by = iy - jy + ky;
            xb = bx * lx + by * ly + x0;
            yb = by * lx - bx * ly + y0;
            xc = 2.0 * jy * ly - xa + x0 + x0;
            yc = 2.0 * jy * lx - ya + y0 + y0;
            xp = xa + xb + xc - 2*x0;
            yp = ya + yb + yc - 2*y0;

            pxy  [0] = xa;                      /* init. polyline array    */
            pxy  [1] = ya;                      /* from point A            */
            pxy  [2] = ms (xb, x0);
            pxy  [3] = ms (yb, y0);             /* to point /B             */
            pxy  [4] = xc;      
            pxy  [5] = yc;                      /* to point C              */
            pxy  [6] = xp;      
            pxy  [7] = yp;                      /* to point P              */
            pxy  [8] = xa;                      /* init. polyline array    */
            pxy  [9] = ya;                      /* from point A            */
            pxy [10] = ms (xc, x0);  
            pxy [11] = ms (yc, y0);             /* to point /C             */
            pxy [12] = xb;      
            pxy [13] = yb;                      /* to point B              */
            pxy [14] = xp;
            pxy [15] = yp;                      /* to point P              */
            pxy [16] = xb;      
            pxy [17] = yb;                      /* to point B              */
            pxy [18] = ms (xa, x0);
            pxy [19] = ms (ya, y0);             /* to point /A             */
            pxy [20] = xc;      
            pxy [21] = yc;                      /* to point C              */
            pxy [22] = ms (xa, x0);
            pxy [23] = ms (ya, y0);             /* to point /A             */
            pxy [24] = ms (xp, x0);
            pxy [25] = ms (yp, y0);             /* to point /P             */
            pxy [26] = ms (xb, x0);
            pxy [27] = ms (yb, y0);             /* to point /B             */
            pxy [28] = ms (xp, x0);
            pxy [29] = ms (yp, y0);             /* to point /P             */
            pxy [30] = ms (xc, x0);  
            pxy [31] = ms (yc, y0);             /* to point /C             */

            if (init == CLEAR)                  /* only if flag set clear  */
            {                                   /* old cube                */
                vsl_color (cube_whndl, WHITE);  /* set color (WHITE)       */
                spin (16, pxy_old); 		/* and clear old cube  */
            }
            vsl_color (cube_whndl, BLACK);      /* set color (BLACK)       */
	    if (init != CALC)			/* if not only calculating */
	            spin (16, pxy);      	/* draw new cube           */
            tmp = pxy;                          /* swap pointers           */
            pxy = pxy_old;
            pxy_old = tmp;
            alpha = (alpha+angle) % 180;        /* incr. view angels       */
            vsl_color (cube_whndl, BLACK);  	/* set color (BLACK)       */
	    set_attr ();			/* set old attributes	   */

            wind_update (END_UPDATE);           /* end of update           */
	} /* else */
}

/***************************************************************************/
/*                          m s                                            */
/***************************************************************************/
WORD
ms (val1, val2)                                 /* negate point            */
WORD	val1, val2;
{                                               /* e. g. P -> /P           */
                                                /* normaly val2 is x0 or y0*/
	return (val2 + val2 - val1);
}
/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	cube_term		*/
/*------------------------------*/
cube_term()
{
	do_close(cube_whndl, gl_wfull/2, gl_hfull/2);
	wind_delete (cube_whndl);           /* draw boxes & delete window  */
	v_clsvwk (vdi_handle);		    /* close virtual work station  */
	appl_exit ();			    /* application exit            */
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID
do_close(wh, org_x, org_y)	/* close and shrink specified window	   */
WORD	wh;
WORD	org_x, org_y;
{
	WORD	x, y, w, h;

	graf_mouse(HOUR_GLASS,0x0L);            /* change mouse cursor     */
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h); /* get whole act. window   */
	wind_close(wh);                         /* close it                */
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h); /* draw boxes    */
	graf_mouse(ARROW,0x0L);                 /* turn mouse cursor on    */
}



/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	min			*/
/*------------------------------*/
WORD
min(a, b)			/* return min of two values	*/
WORD		a, b;
{
	return( (a < b) ? a : b );
}


/*------------------------------*/
/*	max			*/
/*------------------------------*/
WORD
max(a, b)			/* return max of two values	*/
WORD		a, b;
{
	return( (a > b) ? a : b );
}


/*------------------------------*/
/*	rc_equal		*/
/*------------------------------*/
WORD
rc_equal(p1, p2)		/* tests if the two rectangles are equal */
GRECT		*p1, *p2;
{
	if ((p1->g_x != p2->g_x) ||
	    (p1->g_y != p2->g_y) ||
	    (p1->g_w != p2->g_w) ||
	    (p1->g_h != p2->g_h))
		return(FALSE);
	return(TRUE);
}

/*------------------------------*/
/*	rc_intersect		*/
/*------------------------------*/
WORD
rc_intersect(p1, p2)		/* compute inter of two rectangles	*/
GRECT		*p1, *p2;
{
	WORD		tx, ty, tw, th;

	tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
	th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
	tx = max(p2->g_x, p1->g_x);
	ty = max(p2->g_y, p1->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
	return( (tw > tx) && (th > ty) );
}


/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD
align_x(x)		/* forces word alignment for column positon,	*/
WORD	x;		/*   rounding to nearest word			*/
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	

/*------------------------------*/
/*	string_addr		*/
/*------------------------------*/
LONG
string_addr(which)		/* returns a tedinfo LONG string addr	*/
WORD	which;
{
	LONG	where;

	rsrc_gaddr(R_STRING, which, &where);
	return (where);
} 


/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID
do_redraw(wh, area)		/* redraw message applying area clip	*/
WORD	wh;
GRECT	*area;
{
	GRECT	box;

	

	spinning (&work_area, 0, CALC);		/* calc. new cube 	   */
	get_attr ();				/* get attributes 	   */
	wind_update (BEG_UPDATE);
	graf_mouse(M_OFF, 0x0L);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while (box.g_w && box.g_h)
	{
		if (rc_intersect(area, &box))
		{
                    if (wh == cube_whndl)
                    {
			    clear_disp (&box);	/* clear area      	   */
/* redraw the cube in the given area                                       */
                            spinning (&box, 0, REDRAW);
                    }
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
	wind_update (END_UPDATE);
	set_attr ();				/* set attributes	   */
        spinning (&work_area, 0, NOCLEAR);      /* and just redraw it      */
}



/*------------------------------*/
/*	clear_disp		*/
/*------------------------------*/
VOID
clear_disp (clip_area)	/* clear area applying input clip		   */
GRECT	*clip_area;
{
	WORD	pxy[4];

	set_clip (TRUE, clip_area);             /* set clip area           */
	vsf_interior (cube_whndl, 1);
	vsf_color (cube_whndl, WHITE);          /* set colour to white     */
	grect_to_array(&work_area, pxy);        /* convert struct to array */
	graf_mouse (M_OFF, 0x0L);               /* turn mouse on           */
	vr_recfl (cube_whndl, pxy);	        /* clear entire area	   */
	graf_mouse(M_ON, 0x0L);                 /* turn mouse on           */
	set_clip(FALSE, clip_area);             /* disable clib area       */
}

/*------------------------------*/
/*	grect_to_array		*/
/*------------------------------*/
VOID
grect_to_array(area, array)	/* convert x,y,w,h to upr lt x,y and	*/
GRECT	*area;			/*		      lwr rt x,y	*/
WORD	*array;
{
	*array++ = area->g_x;
	*array++ = area->g_y;
	*array++ = area->g_x + area->g_w - 1;
	*array = area->g_y + area->g_h - 1;
}


/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID
set_clip(clip_flag, s_area)	/* set clip to specified area		*/
WORD	clip_flag;
GRECT	*s_area;
{
	WORD	pxy[4];

	grect_to_array(s_area, pxy);
	vs_clip(cube_whndl, clip_flag, pxy);
}


/*------------------------------*/
/*	inside			*/
/*------------------------------*/
BOOLEAN	inside (x, y, pt)	/* determine if x,y is in rectangle	*/
WORD	x, y;
GRECT	*pt;
{
	if ( (x >= pt->g_x) && (y >= pt->g_y) &&
	    (x < pt->g_x + pt->g_w) && (y < pt->g_y + pt->g_h) )
		return(TRUE);
	else
		return(FALSE);
} /* inside */



/*------------------------------*/
/*	do_full			*/
/*------------------------------*/
VOID
do_full(wh)	/* depending on current window state, either make window*/
WORD	wh;	/*   full size -or- return to previous shrunken size	*/
{
	GRECT	curr;
	GRECT	full;

	graf_mouse(M_OFF,0x0L);
	wind_get(wh, WF_CXYWH, &curr.g_x, &curr.g_y, &curr.g_w, &curr.g_h);
	wind_get(wh, WF_FXYWH, &full.g_x, &full.g_y, &full.g_w, &full.g_h);
	if (rc_equal(&curr, &full))
	{					/* is full now so change*/
		/**/					/*   to previous	*/
		graf_shrinkbox(gp_x, gp_y, gp_w, gp_h,
			full.g_x, full.g_y, full.g_w, full.g_h);
		wind_set(wh, WF_CXYWH, gp_x, gp_y, gp_w, gp_h);
	}
	else
	{					/* is not full so make	*/
		/**/					/*   it full		*/
		graf_growbox(curr.g_x, curr.g_y, curr.g_w, curr.g_h,
			full.g_x, full.g_y, full.g_w, full.g_h);
		wind_get(cube_whndl, WF_CXYWH, &gp_x, &gp_y, &gp_w, &gp_h); 
		wind_set(wh, WF_CXYWH, full.g_x, full.g_y, full.g_w, full.g_h);
	}
	graf_mouse(M_ON,0x0L);
}


/*------------------------------*/
/*	get_attr		*/
/*------------------------------*/

get_attr ()			/* get current settings all attributes 	   */
{				/* that affect fill areas, interior style  */
				/* fill color, fill style index and write mode */

	vqf_attributes (cube_whndl, attrib);
}

/*------------------------------*/
/*	set_attr		*/
/*------------------------------*/

set_attr ()			/* set attributes saved by get_attr ()	   */
{

	vsf_interior (cube_whndl, attrib [0]);	/* set fill interior style */
	vsf_color (cube_whndl, attrib [1]);	/* set fill color index	   */
	vsf_style (cube_whndl, attrib [2]);	/* set fill style	   */
	vswr_mode (cube_whndl, attrib [3]);	/* set write mode	   */
}
/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()				/* handle revieved message */
{
	BOOLEAN	done = FALSE;                   /* exit code               */
	WORD	wdw_hndl;

	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	   */
	switch( gl_rmsg[0] )			/* switch on disp of msg   */
	{
	case AC_OPEN:				/* do accessory open	   */

            if ( (gl_rmsg[4] == gl_itemcube) && 
	 	(!cube_whndl))		        /* unless already open	   */
	    {
		do_init ();                     /* create wdw and open int */
		done = -1;                      /* set open flag           */
	    }
	    else				/* do window topped	   */
		wind_set (cube_whndl, WF_TOP, 0, 0, 0, 0);
	    break;

	case WM_REDRAW:				/* do redraw wdw contnts   */
            do_redraw (wdw_hndl, &work_area);	/* we must always update the whole window */
            return (done);                      /* we made a new redraw    */
	    break;                              /* just return             */

	case WM_TOPPED:				/* do window topped	   */
	    wind_set (wdw_hndl, WF_TOP, 0, 0, 0, 0);
	    break;

	case AC_CLOSE:				/* do accessory close	   */
	    done = TRUE;                        /* set exit flag           */
	    cube_whndl = 0;
	    break;

	case WM_CLOSED:				/* do window closed	   */
#if	(VERSION & ACCESSORY)			/* close to menu bar	   */
	    do_close (cube_whndl, gl_wbox*4, gl_hbox/2);
#else						/* close to screen centre  */
	    do_close (cube_whndl, gl_wfull/2, gl_hfull/2);
#endif
            wind_delete (cube_whndl);           /* delete window           */
      	    cube_whndl = 0;
	    done = TRUE;
	    break;

	case WM_SIZED:				/* do window size or	   */
	case WM_MOVED:				/* do window move	   */
	    wind_set (cube_whndl, WF_CXYWH,     /* set new window          */
            gl_rmsg[4], gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
	    wind_get (cube_whndl, WF_WXYWH,     /* get work area size      */
            &work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
/* calculate the centre of the window and the cube side length		   */
            x0 = work_area.g_x + (work_area.g_w >> 1); /* calc. wdw x-centre   */
            y0 = work_area.g_y + (work_area.g_h >> 1); /* calc. wdw y-centre   */
            l = min(work_area.g_w, work_area.g_h) / 3;/* calc. cube side len. */
	    do_redraw (cube_whndl, &work_area); /* clear wdw-and draw cube */
	    break;

	case WM_FULLED:
	    do_full (wdw_hndl);                 /* make it full or prev size */
	    wind_get (cube_whndl, WF_WXYWH,     /* and get the new size    */
            &work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
/* calculate the centre of the window and the cube side length		   */
            x0 = work_area.g_x + (work_area.g_w >> 1); /* calc. wdw x-centre   */
            y0 = work_area.g_y + (work_area.g_h >> 1); /* calc. wdw y-centre   */
            l = min(work_area.g_w, work_area.g_h) / 3;/* calc. cube side len. */
	    do_redraw (cube_whndl, &work_area);
	    break;

	}   /* switch */
/* set polyline modes							   */

	return(done);                           /* return the exit flag    */
} /* hndl_mesag */


/***************************************************************************/
/*                          R O T A T E                                    */
/***************************************************************************/

WORD    rotate ()			
{

	WORD	ready = FALSE, ev_mwitch, done;
	LONG	delay = 2;			/* timer delay in ms	   */
	WORD	ev_mmox, ev_mmoy, ev_mmobutton, ev_mmokstate,
		ev_mkreturn, ev_mbreturn, ev_mflags, ev;
	WORD	rot_angle;			/* rotate angle step	   */


/* initialize rotation angle ( given in degree)				   */
	rot_angle = STEP;
	
	spinning (&work_area, 0, INIT);		/* initialize spinning vars*/
/* draw first cube without clearing the 'last' cube                        */
        spinning (&work_area, 0, NOCLEAR);
	graf_mouse(ARROW,0x0L);                 /* show mouse cursor       */
#if (VERSION & ACCESSORY)                       /* if compiled as acces-   */
	wind_update (END_UPDATE);               /* sory end of window up-  */
#endif                                          /* date                    */
	ev_mflags = MU_M1 |                     /* we wait for the enters  or leave the wdw */ 
                    MU_MESAG |                  /* or we receive a message */
                    MU_TIMER |                  /* or a timer event        */
                    MU_BUTTON;                  /* or a button is pressed  */

/* get the actual coordinates of the mouse                                 */
      	graf_mkstate (&ev_mmox, &ev_mmoy, &ev_mmokstatem, &ev);
	if (inside (ev_mmox, ev_mmoy, &work_area)) /* if mouse is in the wdw	*/
	    ev_moflags = 1;			/* set flag wait for lea-  */
	else                                    /* ving the wdw or else    */
	    ev_moflags = 0;		        /* for entering it         */
	do					/* wait until ready flag   */
	{
	    do                                  /* wait for timer event    */
	    {
	        ev_mwitch = evnt_multi (ev_mflags, 2, 0x01, 0x01,
		    ev_moflags, work_area.g_x, work_area.g_y,
		    work_area.g_w, work_area.g_h,
		    0,0,0,0,0,
		    ad_rmsg,
		    LLOWD(delay), LHIWD(delay),
		    &ev_mmox, &ev_mmoy,
		    &ev_mmobutton, &ev_mmokstate,
		    &ev_mkreturn, &ev_mbreturn);
		if (ev_mwitch & MU_MESAG)       /* if message bit set      */
		{
		    done = hndl_mesag();        /* handle message          */
		    if (done)                   /* if wdw closed           */
                        return (-1);            /* return to caller        */
	        }				
		if (ev_mwitch & MU_M1)          /* if mouse event          */
		    ev_moflags = ! ev_moflags;  /* just invert the flag    */
		if (ev_mwitch & MU_BUTTON)      /* if button pressed       */
		{                               /* stop rotating           */
		    rot_angle = 0;		/* clear rotate angle 	   */ 
		    do                          /* wait until double click */
		    {                           /* wait for button or mes- */
		        ev = evnt_multi (0x12, 2, 0x01, 0x01,/* sage event */
			    0,0,0,0,0,0,0,0,0,0, /* wait for max. a        */
			    ad_rmsg,0,0,        /* double click            */
			    &ev_mmox, &ev_mmoy,
			    &ev_mmobutton, &ev_mmokstate,
			    &ev_mkreturn, &ev_mbreturn);
			if (ev & MU_MESAG)      /* if we received a message*/
			{
			    done = hndl_mesag(); /* handle event message   */
			    if (done)           /* if wdw was closed       */
				return (-1);    /* return to caller        */
			}	
                        if (ev & MU_BUTTON && ev_mbreturn == 1)
                        {                       /* if one click            */
                            spinning (&work_area, 1, CLEAR);
                        }                       /* rotate cube             */
			++rot_angle;
		    } /*do */                   /* wait for double click   */
		    while (!((ev & MU_BUTTON) && ev_mbreturn == 2));
		} /* if (ev_mwitch & MU_BUTTON) */
	    } /* do */
	    while (! (ev_mwitch & MU_TIMER));	/* wait for timer event    */
	    spinning (&work_area, rot_angle, CLEAR);/* rotate cube	   */
	} /* do */
	while (!ready);			/* until read is TRUE	   */
	return (0);
}



/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Type Event Handler			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	cube			*/
/*------------------------------*/
cube ()
{
	BOOLEAN	done;

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_mesag(ad_rmsg);	/* wait for message	*/
#if (VERSION & ACCESSORY)
		wind_update(BEG_UPDATE);	/* begin window update	*/
#endif
		done = hndl_mesag();		/* handle event message	*/
		if (done == -1)			/* if open flag then	*/
			rotate ();		/* rotate cube		*/
#if	(VERSION & ACCESSORY)			/* if desk accessory 	*/
		else				/* spinning makes it else */
			wind_update(END_UPDATE);/* end window update	*/
		done = FALSE;	/* never exit loop for desk accessory	*/
#endif
	}
}


/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
GEMAIN ()
{
	if (cube_init())			/* initialization	*/
	{
#if	(VERSION & ACCESSORY)
		wind_update(END_UPDATE);
		cube ();
#else						/* simulate AC_OPEN	*/
		gl_rmsg[0] = AC_OPEN;
		gl_rmsg[4] = gl_itemcube;
		hndl_mesag();
		rotate ();
		cube_term();			/* termination		*/
#endif
	}

}

