
/* fix_date */

/******************************************************************/ 
/*                                                                */
/*                     GEM Alarm Program                          */
/*                                                                */
/*  Does lots of lovely things with alarms! It displays them,     */
/*  and allows updates. THIS IS THE DOS+ VERSION, AND IT WON'T    */
/*  WORK WITH OTHER OPERATING SYSTEMS. Sorry! It wants the DOS+   */
/*  program ALARM to run concurrently with GEM.                   */
/*                                                                */
/*  (c) 1986 Digital Research (UK) Ltd..                          */
/*                                                                */
/*  This bit written by Dylan Harris of Software Experts Ltd.,    */
/*  and we can be found on 0784-31333 for the time being.         */
/*  Dedicated to Malcolm Arnold (for yet more good music)         */
/*                                                                */
/*  Imagine my horror when I realised that this program was going */
/*  to be used as an 'example'. Help. I hearby apologise to all   */
/*  and sundry that its not exactly perfect, it could be mega     */
/*  tidied up, and so on and so forth. Still, at least I can      */
/*  retreat to the traditional programmer's hideaway, and admit   */
/*  that, as far as I know, it works.                             */
/*                                                                */
/*  Many of the ALARM file processing routines were nicked from   */
/*  the DOS+ alarm program, although I had to fiddle around with  */
/*  them for GEM. Unfortunately, this means that they are not     */
/*  quite the same, so if you modify the relevent pieces of       */
/*  source code, be careful.                                      */
/*                                                                */
/******************************************************************/


/****************************/
/* the traditional includes */
/****************************/

#include "portab.h"       /* portable type definitions */
#include "machine.h"      /* machine specific definitions and references */
#include "gembind.h"      /* AES externals and constants */
#include "obdefs.h"       /* OBJECT tree structures and constants */
#include "treeaddr.h"	  /* references to fields of type OBJECT */
#include "alarm.h"	  /* this program's resource file reference */

/**************************/
/* references to A86 code */
/**************************/

extern VOID bg_alarm ();
extern VOID get_sem ();
extern VOID free_sem ();
extern VOID get_ds ();
extern VOID get_byte ();
extern VOID put_byte ();
extern VOID copy_str ();

/*************************/
/* some interesting keys */
/*************************/

#define NUM_ALARMS 32
#define F1 0x3B00
#define F2 0x3C00
#define F3 0x3D00
#define TAB 0x0f09
#define BACKTAB 0x0f00
#define CTRL_I 0x1709
#define DOWN_ARROW 0x5000
#define UP_ARROW 0x4800
#define PAGEUP 0x4900
#define PAGEDOWN 0x5100
#define HOME 0x4700
#define END 0x4f00
#define HELP_KEY 0x5400

/*****************************************/
/* global variables (how did you guess?) */
/*****************************************/

WORD  ap_id;		/* GEM process identity */
WORD  cell_width,
      cell_height;      /* character sizes */
WORD  unwanted;         /* parameters with unwanted information */

WORD  is_dosplus;	/* TRUE if running under DOS+ */

LONG  ok_string;        /* address of "ok" free string */
WORD  length_ok;        /* length of "ok" free string */
BYTE  spare_ok [] = "  ?  ";  /* use as "ok" if no resource file */
LONG  alarm_string;     /* address of window title free string */
BYTE  spare_alarm [] = "";    /* use as title if no resource file */
WORD  change_id,	/* menu entry id of Change alarms entry */
      new_id;		/* menu entry id of New File entry */
WORD  length_alarm;	/* length of alarm string */
WORD  resource_file_loaded;  /* true if resource file was loaded */

WORD  buffer [8];     /* buffer for message from GEM */
LONG  buffer_address; /* address of above */
LONG  delay = 6000;  /* delay between polling for messages */
WORD  low_delay,      /* above split into two words for event */
      high_delay;

WORD  current_message;  /* current message being displayed */

LONG  dates [6],	/* address of the six date te_ptext strings */
      times [6],        /* address of the six time te_ptext strings */
      messes [6],	/* address of the six message te_ptext strings */
      			/* (for te_ptext, see AES chapter 6 on TEDINFOs) */
      am_obspec [6],	/* address of AM obspec string (as te_ptext above) */
      am_addr,          /* address of an AM string */
      pm_addr;		/* address of "PM" free string */
WORD  date_mode,	/* 0 = american, 1 = europe 2 = japan */
      time_mode;	/* 0 = twenty-four hour, 1 = am, 2 = pm  (note the
      			   two ins't standard, its just this prog) */

#define is_dig(c) (((c)>='0') && ((c)<='9'))

UWORD q_alarms;		/* number alarms in file */

struct	MYTIME
{
UWORD	day;			/* days since 1/1/78 */
BYTE	hour;			/* cardinal */
BYTE	min;			/* cardinal */
};  

struct MYTIME now;

/* offsets in the data segment of the background ALARM.CMD program */
#define ALARM_DRIVE 	0x100
#define ALARM_FLAG  	0x101
#define ALARM_TEXT	0x102

WORD  data_segment;       /* ALARM.CMD's data segment */
WORD  tell_background;    /* number of disk drive for new alarm file;
		             -1 for none */	
WORD  alarm_file_loaded;  /* true if alarm file currently loaded */
WORD  dosplus_alarm_file; /* true if dosplus alrm prog would like this file */
BYTE  alarm_fn [256];	  /* alarm file disk, directory and name */
LONG  filename_address;   /* address of alarm_fn */

#define	BUF_SIZE	1857
#define	MSG_SIZE	43
				/* max number of characters in any */
				/* message + 3 (the first two bytes are */
				/* used for max and actual string lengths, */
				/* the last byte is for null termination) */

BYTE buf [BUF_SIZE];			/* ALARM.DAT data read into here */
struct MYTIME alarm [NUM_ALARMS];	 	/* list of alarm dates */
WORD mode_time [NUM_ALARMS];
BYTE msgs [NUM_ALARMS] [MSG_SIZE];	/* list of message strings */

BYTE scrap_buffer [80];	/* buffer for cut, copy and paste */


/*************************************************************************/
/*                                                                       */
/*                            Time Bindings                              */
/*                                                                       */
/*                              WARNING !!                               */
/*                                                                       */
/*   The functions below make time dependant operating system calls in   */
/* the same format as dosbind.c for GEM software. These bindings are not */
/* included in the dosbindings, AND SO ARE NOT PORTABLE. If this software*/
/* is ported to other operating systems, this software will have to be   */
/* adjusted. They call the dosbinding operating system interface.        */
/*                                                                       */
/*************************************************************************/

/* (from DOS bindings) */

extern dos_func ();
extern UWORD DOS_AX, DOS_CX, DOS_DX, DOS_ERR;


/*************************************************************************/
/*                                                                       */
/*                             Dos_date                                  */
/*                                                                       */
/* Gets the current day, month and year from DOS+.                       */
/* Returns day, month and year; three UWORD pointers.                    */
/*                                                                       */
/*************************************************************************/

VOID dos_date (day, month, year)
UWORD *day, *month, *year;

{

  dos_func (0x2a00, 0, 0);
  *year = DOS_CX;
  *month = LHIBT (DOS_DX);
  *day = LLOBT (DOS_DX);

}



/*************************************************************************/
/*                                                                       */
/*                             Dos_time                                  */
/*                                                                       */
/* Gets the current hour and minute from DOS+, and puts them in the      */
/* strangely named parameters hour and minute.                           */
/*                                                                       */
/*************************************************************************/

VOID dos_time (hour, minute)
UWORD *hour, *minute;

{

  dos_func (0x2c00, 0, 0);
  *hour = LHIBT (DOS_CX);
  *minute = LLOBT (DOS_CX);

}



/*************************************************************************/
/*                                                                       */
/*                            Get_format                                 */
/*                                                                       */
/* Gets the date format (and, for that matter, the time format)into the  */
/* global variables date_mode and time_mode. Date_mode has the following */
/* values:                                                               */
/*     0 American     1 European     2 Japanese                          */
/* Time_mode has the following values:                                   */
/*     0 24 hour      1 12 hour                                          */
/* Note this program uses 1 to mean AM, and 2 for PM.                    */
/*                                                                       */
/*************************************************************************/

VOID get_format ()

{ UBYTE os_buffer [32]; /* see the DOS manual for details of this array 
			   function 38H get date format.  */
  LONG os_addr;

  os_addr = ADDR (os_buffer);
  dos_func (0x3800, LLOWD (os_addr), LHIWD (os_addr));
  date_mode = *((UWORD *) &os_buffer[0]);
  time_mode = os_buffer [17];

}

/* END OF TIME BINDINGS */



/*************************************************************************/
/*                                                                       */
/*                              Strcmp                                   */
/*                                                                       */
/* With the unknowningly given complements of Kernighie and Ritchie's    */
/* infamous book, here's the star of the show, "strcmp"; a big round of  */
/* applause please as this incomparable function will tell you exactly   */
/* how disimiliar two strings are. Strcmp can handle not just one or two */
/* pairs of strings, not just a few pair of strings, but any pairs of    */
/* strings. Yes, ladies and gentlemen, strcmp is the most flexible ..... */
/*                                                                       */
/* (sorry, I got carried away)                                           */
/*                                                                       */
/*************************************************************************/

WORD strcmp (a, b)
BYTE *a, *b;

{

  while (*a == *b) {
  
    if (*a++ == '\0')
      return (0);
    
    b++;
  
  }
  
  return (*a - *b);

}



/*************************************************************************/
/*                                                                       */
/*                              Strpsn                                   */
/*                                                                       */
/* Strpsn looks for a character in string. It returns either a pointer   */
/* to the character following an occurence in the string, or NULL. It is */
/* probably utterly different to that defined in the book.               */
/*                                                                       */
/*************************************************************************/

BYTE *strpsn (c, s)
BYTE c, *s;

{ 

  while (*s != '\0')
    if (*(s++) == c)
      return (s);
  
  return (FALSE);

}



WORD smallest (a, b)
WORD a, b;

{

  return (a < b ? a : b);

}



WORD largest (a, b)
WORD a, b;

{

  return (a > b ? a : b);

}



/*************************************************************************/
/*                                                                       */
/*                           Wait_mouse                                  */
/*                                                                       */
/* Wait mouse changes the mouse icon to a cup of tea.                    */
/*                                                                       */
/*************************************************************************/

#ifdef TEA
wait_mouse ()

{ static tea [] = {

  0x0000, 0x0000, 0x0001, 0x0000, BLACK,

  0x0FE0, 0x0FE0, 0x0FE0, 0x0FE0, 
  0x0FF0, 0x3FFE, 0x7FFF, 0x7FFF, 
  0x7FFF, 0x3FFF, 0x3FFF, 0x7FFE, 
  0xFFFC, 0xFFFC, 0xEFF0, 0x0000,

  0x0480, 0x0480, 0x0240, 0x0240, 
  0x0480, 0x07C0, 0x1A74, 0x224A, 
  0x1012, 0x0FEC, 0x17D0, 0x2B88, 
  0x3830, 0xC7C0, 0x0000, 0x0000

  }; /* this is a stripped version of the output of the Icon Editor. See
        the change mouse form, in the VDI manual section 7 for details of this
	data organisation. It directly reflects the specified order of the
	intin parameters. */

  graf_mouse (255, ADDR (tea));

}
#else
#define wait_mouse() graf_mouse (2, 0x0L)
#endif



/*************************************************************************/
/*                                                                       */
/*                          Normal_mouse                                 */
/*                                                                       */
/* Normal mouse changes the mouse icon to the traditional arrow.         */
/*                                                                       */
/*************************************************************************/

normal_mouse ()

{

  graf_mouse (0, 0x0L);

}




/*************************************************************************/
/*                                                                       */
/*                          Do_alert                                     */
/*                                                                       */
/* Do_alert displays an alert. The first parameter is the default alert  */
/* button, and is fed straight to form_alert. The second is the alert    */
/* identifier, which is used to dig the alert's address out of the       */
/* resource file for subsequent display. It returns the button selected  */
/* by the user.                                                          */
/*                                                                       */
/*************************************************************************/

WORD do_alert (button, which)
WORD button,	/* which button is the default */
     which; 	/* the resource file alert in question */

{ LONG alert;

  rsrc_gaddr (R_STRING, which, &alert);
  return (form_alert (button, alert));

}




/*************************************************************************/
/*                                                                       */
/*                          Deblank                                      */
/*                                                                       */
/* Takes a pointer to a string, and returns a pointer to that string     */
/* excluding any initial white space.                                    */
/*                                                                       */
/*************************************************************************/

BYTE *deblank (s)
BYTE *s;				/* starting address of scan */

{

  while ((*s == ' ') ||		/* while there are more spaces */
         (*s == '\t'))		/*   or tab characters ahead */
    s ++;			/*   skip them */

  return (s);			/* return deblanked string */

}




/*************************************************************************/
/*                                                                       */
/*                         Access_file                                   */
/*                                                                       */
/* Access_file carries out all of this program's simple file access      */
/* requirements. Identity is the GEM address of a BYTE string holding    */
/* the filename; access is zero for file read, and one for a write;      */
/* io_funct is a reference to either read_piece or write_piece (two      */
/* dosbind functions externally referenced here); space is the buffer;   */
/* and size is the buffer length.                                        */
/*                                                                       */
/*************************************************************************/

extern read_piece (), write_piece ();

BOOLEAN access_file (identity, access, io_funct, store, size)
LONG identity;
BYTE *store;
WORD access, (*io_funct)(), size; 

{ UWORD i;		/* used as loop counter */
  WORD  dos_file,	/* File handler (note I use the DOSbindings) */
        kaputt,		/* Button chosen by user on error (1 = Give up,
			   2 = Retry) */ 
	ax;		/* AX register returned by DOS with errors in */

  /* first stage ... try and open the file: if read, exit on failure;
     if write, try and create then, if still an error, loop until no error or 
     the user gives up on the retries */	   
  
  dos_file = dos_open (identity, access);

  if (DOS_ERR && access == 0)
    return (FALSE);
  
  kaputt = 2;

  while (DOS_ERR && access == 1 && kaputt == 2) {

    /* if it's a write, the error might be because the file isn't
       there, in which case we should create it */

    dos_file = dos_create (identity, 0);

    if (DOS_ERR) {

      normal_mouse ();

      if ((kaputt = form_error (dos_file)) != 2)
        return (FALSE);

      wait_mouse ();

    }

  } 

  /* right, now try and read/write: again, loop until the data is accessed
     sucessfully or the user gives up and stops retrying. */
      
  do {

    kaputt = 0;
    ax = (*io_funct) (dos_file, sizeof (BYTE) * size, ADDR (store));
    
    if (DOS_ERR) {

      normal_mouse ();

      if ((kaputt = form_error (ax)) != 2) {

        dos_close (dos_file);
        return (FALSE);

      }

      dos_lseek (dos_file, 0, 0x0L); /* make sure retry access starts at the
                                        beginning of file. */
      wait_mouse ();

    }

  } while (kaputt == 2);

  /* it doesn't really matter if dos_close fails for a read, but it
     does following a write! */

  if (access == 0)
    dos_close (dos_file);

  else
    do {
  
      kaputt = 0;
      ax = dos_close (dos_file);
    
      if (DOS_ERR) {
    
        normal_mouse ();

        if ((kaputt = form_error (ax)) == 1)
          return (FALSE);
	
        wait_mouse ();	

      }
	
    } while (kaputt == 2);
       
  normal_mouse ();  
  return (TRUE);

} 




/*************************************************************************/
/*                                                                       */
/*                        Get_alarm_dates                                */
/*                                                                       */
/* This function takes a pointer to a character buffer, and details      */
/* about its size, and tries to load the complete alarm file into that   */
/* buffer. Normally, ALARM.DAT should be found in the root directory of  */
/* the default disk, although the user can specify another area (see     */
/* change_alarms). The actual filename is found at the address refered   */
/* to be the global GEM pointer filename_address. Note this function has */
/* been modified to return TRUE on success, and FALSE on failure.        */
/*                                                                       */
/*************************************************************************/

BOOLEAN	 get_alarm_dates (b, size)
BYTE    *b;				/* address of data buffer */
UWORD    size;				/* number of byte to read */

{ UWORD i;		/* used as loop counter */

  /* first stage ... do the I/O */

  if (! access_file (filename_address, 0, read_piece, b, size))
    return (FALSE);

  /* make sure there's an EOF at the and of the buffer */  

  for (i = 1; i < size; i++) {	

    if (*b == 0x1A)
      break;

    b++;

  }

  *(b) = 0x1A;
  return (TRUE);

} 



/*************************************************************************/
/*                                                                       */
/*                          Write_file                                   */
/*                                                                       */
/* Outputs the current data to the file ALARM.DAT. Note that this        */
/* function, has been modified to return TRUE on success. It stores the  */
/* data in one standard date format, no matter what the user thinks      */
/* (s)he's working in. It takes the address of the write buffer.         */
/*                                                                       */
/*************************************************************************/

WORD write_file (b)
BYTE *b;

{ UWORD	 size;		/* the size of the data buffer */
  BYTE  *p;		/* a working pointer for the buffer */

  /* suss the size of the data, and make sure it ends in a 1A (end of
     file character) */
     
  p = b;
  size = 0;

  while (*p && size < (BUF_SIZE - 1)) {

    p++;
    size++;

  }

  *p = 0x1A;

  /* delete the old file */

  dos_delete (filename_address);

  /* do the I/O (you stick your left leg out, shake it all about, and
     y'all do the I O, whoa, .....) (Sorry.) */

  return (access_file (filename_address, 1, write_piece, b, size));

}



/*************************************************************************/
/*                                                                       */
/*                           Get_item                                    */
/*                                                                       */
/* Copies the next string from buffer p into s, with a maximum of max    */
/* characters actually copied.                                           */
/*                                                                       */
/*************************************************************************/

BYTE *get_item (p, s, max)
BYTE *p, *s;
WORD max;

{

  p = deblank (p);

  while (max-- &&
         (*p != ' ') && 
	 (*p != '\t') && 
	 (*p != '\n') &&
	 (*p != '\r') &&
	 (*p != 0x1A))
           *s++ = *p++;

  *s = '\0';
  return (p);

}



/*************************************************************************/
/*                                                                       */
/*                           Get_item                                    */
/*                                                                       */
/* Copies everything (excluding initial blanks) from s into p, until the */
/* end of line is reached, with a maximum of max characters.             */
/*                                                                       */
/*************************************************************************/

BYTE *get_eoln (p, m, max)
BYTE *m, *p;
WORD max;

{ WORD i;

  p = deblank (p);
					/* skip until EOLN or EOF */
  i = 1;

  while ((*p != '\r') && (*p != '\n') && (*p != 0x1A) && (i++ < max))
    *m++ = *p++;

  *m = '\0';
					/* skip rest of EOLN's */
  while (((*p == '\r') || (*p == '\n')) && (*p != 0x1A))
    p++;

  return (p);

}




/*************************************************************************/
/*                                                                       */
/*                            Before                                     */
/*                                                                       */
/* Compares two dates to see if the first precedes the second.           */
/*                                                                       */
/*************************************************************************/

BOOLEAN	before (d1, d2)
struct MYTIME *d1, *d2;

{

  return (  (d1 -> day < d2 -> day) || 
           ((d1 -> day == d2 -> day) && (d1 -> hour < d2 -> hour)) ||
           ((d1 -> day == d2 -> day) && (d1 -> hour == d2 -> hour) &&
                                        (d1 -> min <= d2 -> min)));

}




/*************************************************************************/
/*                                                                       */
/*                            Rolander                                   */
/*                                                                       */
/* Rolander converts a day, month and year into one number. This is the  */
/* number of days since some obscure date in forgotton prehistory, so    */
/* if you output the number and it means something to you, you are       */
/* either a mathematician or very old. I don't know why this particular  */
/* day was chosen, although I gather it might have been the day fire     */
/* was invented. Perhaps not. Anyway, the function takes the three       */
/* numbers (day in month, month in year, and year A.D., and returns      */
/* the rolander number.                                                  */
/*                                                                       */
/*************************************************************************/

WORD days_so_far [] = {0, 31, 59, 90, 120, 151, 181, 
		          212, 243, 273, 304, 334, 365 };
   
WORD rolander (d, m, y)
UWORD d, m, y;

{ WORD x, 	/* years since 1978 (told you it was a long time ago. */
       days;	/* running total of days. */

  if ((x = y - 1978) < 0)
    return (FALSE);

  /* calculate the number of days in x years, including tweaking for
     leap years, and add in the number of days in the months past and
     so far this month. */
         
  days = x * 365;
  days += (x + 1) / 4;
  days += days_so_far [m-1];

  if (! (y % 4) && (m > 2))
    days += 1; /* (this year a leap year?) */

  days += d;
  return (days);

}




/*************************************************************************/
/*                                                                       */
/*                            Get_date                                   */
/*                                                                       */
/* Get date returns what the local operating system thinks is today's    */
/* date at the address referenced by it's only parameter.                */
/*                                                                       */
/*************************************************************************/  

VOID get_date (d)
struct MYTIME *d;

{ UWORD dy, m, y,  	/* today's day, month and year ... */
        h /*, m */;	/* ... hour and minute */

  dos_date (&dy, &m, &y);
  d -> day = rolander (dy, m, y);
  dos_time (&h, &m);
  d -> hour = h; /* (h / 16) * 10 + (h % 16);	 BCD hours */
  d -> min = m; /* (m / 16) * 10 + (m % 16); 	 BCD minutes */
  		    	
}    




/*************************************************************************/
/*                                                                       */
/*                              A2toi                                    */
/*                                                                       */
/* This is a shrunken version of the infamous atoi, which takes the      */
/* next two characters from a string and tries to convert them into an   */
/* integer.                                                              */
/*                                                                       */
/*************************************************************************/  
 
WORD a2toi (s)
BYTE *s;

{ WORD result;	/* final proof that the moon is made of cheese. */

  result = (is_dig(*s) ? *s - '0' : 0);

  s++;
  
  if (is_dig (*s))
    result = result * 10 + *s - '0';

  return (result);

}




/*************************************************************************/
/*                                                                       */
/*                            Getdigit                                   */
/*                                                                       */
/* It finds the next numeric like part of a string, and tries to build   */
/* an integer out of it. It does not understand advanced concepts like   */
/* negatives. The first parameter is a pointer to the WORD to receive    */
/* the number, and the second is a pointer to the source string. It      */
/* returns TRUE if it finds something, FALSE otherwise.                  */
/*                                                                       */
/*************************************************************************/  
 
BOOLEAN getdigit (n, s)
WORD *n;			/* Pointer to the word number to save */
BYTE **s;			/* String to Process */

{

  *n = 0;				/* Zero the number */
  
  while (! is_dig (**s) && **s)	/* Skip all non digits */
    (*s)++;

  if (**s) {

    while (is_dig (**s)) {	/* Add all the digits in */

      *n = (**s - '0') + (*n * 10);
      (*s)++;

    }

    return (TRUE);		/* and return success */

  } else
    return (FALSE);

}





/*************************************************************************/
/*                                                                       */
/*                           Check_date                                  */
/*                                                                       */
/* Given a string s, check_date converts it into a rolander number, or   */
/* returns zero when the date string is bad for some reason. It also     */
/* requires a second parameter, a boolean, since ALARM.DAT will be in    */
/* european format always, whereas scrap data should be in the local     */
/* date format. The is TRUE for ALARM.DAT.                               */
/*                                                                       */
/*************************************************************************/  
 
BYTE month_count[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
BYTE date_sep[] = "/.-";

WORD check_date (s, isfile)
BYTE *s;
BOOLEAN isfile;

{ WORD p1, p2, p3;		/* three numbers found in string */
  UWORD day, month, year;	/* numbers after checking local date mode */
  WORD days_this_month;		/* go on, have a guess .... */

  /* make sure we have a string in the right format, with digits in the
     expected place. */

  s = deblank (s);
  
  if (! getdigit (&p1, &s) ||
      ! strpsn (*s++, date_sep) ||
      ! getdigit (&p2, &s) ||
      ! strpsn (*s++, date_sep) ||
      ! getdigit (&p3, &s))      
    return (0);

  /* apply meaning to the numbers, using the global date_mode 
     (see get_format ()) */
  
  switch (isfile ? 1 : date_mode) {

    case 1:	/* European Format dd/mm/yy */
      day = p1;
      month = p2;
      year = p3;
      break;

    case 2:	/* Japanese Format yy/mm/dd */
      day = p3;
      month = p2;
      year = p1;
      break;

    default:	/* US Format mm/dd/yy */
      day = p2;
      month = p1;
      year = p3;
      break;
  }

  /* convert years to include centuries */
  
  if (year >= 78 && year <= 99)
    year += 1900;
	
  if (year < 1978 || year > 2099 ||
      month < 1 || month > 12)
    return (0);

  /* calculate days (& months), taking into account leap years */

  days_this_month = month_count [month];

  if (! (year % 4) && (month >= 2))
    days_this_month++; 

  if ((day < 1) || (day > days_this_month))
    return (0);

  return (rolander (day, month, year));

}



/*************************************************************************/
/*                                                                       */
/*                          Debug functions                              */
/*                                                                       */
/* Here are some simple debugging functions. I've left them in this      */
/* code in case you find them useful.                                    */
/*                                                                       */
/*************************************************************************/  

/*************************************************************************/
/*                                                                       */
/*                              Itoa                                     */
/*                                                                       */
/* Itoa is a great deal of fun. It takes a string and a number (a LONG)  */
/* and converts the number in to the string. It returns the a pointer    */
/* to the new end of the string.                                         */
/*                                                                       */
/*************************************************************************/  

BYTE *itoa (i, s)
LONG i;
BYTE *s;

{ WORD p,		/* current element in build string t */ 
       q, 		/* ditto for object string */
       negative;	/* do I have to? */
  BYTE t [20];		/* used to build the number in reverse order */

  /* start off and check the sign */

  p = 0;

  if (negative = i < 0)
    i = 0 - i;

  /* zero is a special case */

  if (i == 0)
    t [p++] = '0';

  /* otherwise, build the number */

  else
  while (i > 0) {

    t [p++] = i % 10 + '0';
    i /= 10;

  }

  if (negative)
    t [p++] = '-';

  /* copy it to the object string */

  for (q = 0; (--p >= 0); s [q++] = t [p]);

  s [q] = '\0';
  return (s + q);

}



/*************************************************************************/
/*                                                                       */
/*                          alert_show                                   */
/*                                                                       */
/* Alert show takes two string arguments, and a boolean. It builds an    */
/* alert using the strings, putting angular brackets around the second   */
/* if the boolean is true.                                               */
/*                                                                       */
/*************************************************************************/  

/* purely for debugging purposes, bung a couple of strings into an alert */

alert_show (text, text2, brackets)
BYTE *text, *text2;
WORD brackets;

{ BYTE s [256];		/* used to build the alert: for details on the
			   internal format of an alert, see the AES
			   manual, section 7-1-4. */

  /* install the icon and the first piece of text */

  strcpy (s, "[1][");
  strcat (s, text);
  strcat (s, "|");
  
  /* install the second text, and the brackets if necessary */

  if (brackets)
    strcat (s, ">");
    
  strcat (s, text2);
  
  if (brackets)
    strcat (s, "<");
    
  /* add the button and display the alert */

  strcat (s, "][Ok]");
    
  form_alert (1, ADDR (s));

}



/*************************************************************************/
/*                                                                       */
/*                          alert_gstring                                */
/*                                                                       */
/* Carries out a similiar function that above, except it displays a      */
/* string referenced using a GEM address.                                */
/*                                                                       */
/*************************************************************************/  

alert_gstring (info, gstring, brackets)
BYTE *info;
LONG  gstring;
BOOLEAN brackets;

{ BYTE t [64];

  /* copy the string into the local data segment */

  LBCOPY (ADDR (t), gstring, 63);
  t [63] = '\0';

  /* and pass the arguments to alert_show */

  alert_show (info, t, brackets);
  
} 



/*************************************************************************/
/*                                                                       */
/*                           alert_display                               */
/*                                                                       */
/* Alert_display builds an alert consisting of some text and a LONG      */
/* number. Note the long: if you want to display an integer you must     */
/* convert it to a long first. I wrote the routine, so I don't get       */
/* caught (oh, look, a flying pig).                                      */
/*                                                                       */
/*************************************************************************/  

alert_display (text, number)
BYTE *text;
LONG number;

{ BYTE t [20];		/* used for the string version of the number */

  /* build and display alert */

  itoa (number, t);
  alert_show (text, t, FALSE);
  
}




/*************************************************************************/
/*                                                                       */
/*                              Num                                      */
/*                                                                       */
/* Num takes three arguments, including a string and a number, and       */
/* converts the string into the number. It is used for user input, so    */
/* it handles all the usual sillies. The final parameter is the number   */
/* of digits wanted in the string. It returns the new end of the string. */
/*                                                                       */
/*************************************************************************/  

UWORD ten[] = { 1, 10, 100, 1000 };

BYTE *num (d, s, l)
WORD  d;
BYTE *s;
WORD  l;

{

  /* nice and simple, really. */

  while (l--)
    *s++ = (char) ((d / ten [l]) % 10 ) + '0';

  return (s);

}



/*************************************************************************/
/*                                                                       */
/*                          Rol_to_ascii                                 */
/*                                                                       */
/* This function takes a rolander date, and converts it into an ASCII    */
/* string. The first parameter is the number, the second the object      */
/* string, and the final one controls the exact format of the string:    */
/* when zero, it puts it in European date format, one is local date      */
/* without slashes (for GEM TEDINFO structures), and two is local date   */
/* format with slashes (for alarm displays and scrap files).             */
/*                                                                       */
/*************************************************************************/  

BYTE *rol_to_ascii (days, s, date_status)
WORD  days;
BYTE *s;
WORD  date_status;

{ WORD year_days;
  WORD year, month, month_days;

  year = 1978;

  /* work out year from 0 AD (don't forget a rolander number is the number
     of days since some god forsaken day way back in medieval history) */
  
  FOREVER {

    if (year % 4)
      year_days = 365;

    else
      year_days = 366;

    if (days <= year_days)
      break;

    days -= year_days;
    year++;

  }

  /* now suss wot month it is, and the left overs is the day */
  
  month = 1;

  FOREVER {

    month_days = month_count [month];

    if (! (year % 4) && (month == 2))
      month_days++;

    if (days <= month_days)
      break;

    days -= month_days;
    month++;

  }

  /* the skinhead's delight here, with slashes being thrown around all
     over the place. This is for anything but GEM, so had to handle all
     supported date formats. Note that if we're preparing strings for
     ALARM.DAT, then this forces European date mode. */
			   
  if (date_status != 1) {
  
    switch (date_status ? date_mode : 1) {

      case 1 :
        s = num (days, s, 2 );
        *s++ = '/';
        s = num (month, s, 2 );
        *s++ = '/';
        s = num (year, s, 4 );
        break;
	
      case 2 :
        s = num (year, s, 4);
	*s++ = '/';
	s = num (month, s, 2);
	*s++ = '/';
	s = num (days, s, 2);
	break;	
      
      default :
        s = num (month, s, 2);
	*s++ = '/';
	s = num (days, s, 2);
	*s++ = '/';
	s = num (year, s, 4);
	break;
	
    }
    
  } else {

    /* otherwise GEM will sort out the slashes and things like that, but
       it handles European, Japanese (I swear that's actually German), and
       American format and it needs the digits in the string in the right
       order, so thats sorted out here */
       
    year -= 1900;
      
    switch (date_mode) {

      case 1 :
        s = num (days, s, 2);
        s = num (month, s, 2);
        s = num (year, s, 2);
        break;

      case 2 :
        s = num (year, s, 2);
        s = num (month, s, 2);
        s = num (days, s, 2);
        break;

      default :
        s = num (month, s, 2);
        s = num (days, s, 2);
        s = num (year, s, 2);

    }
    
  }

  *s = '\0';
  return (s);

}




/*************************************************************************/
/*                                                                       */
/*                           Check_time                                  */
/*                                                                       */
/* Check_time takes a string, and converts them into hours and minutes.  */
/* It also makes sure the number in the string do actually make sense.   */
/*                                                                       */
/*************************************************************************/  

BYTE	hour_sep[] = ":.";
BYTE	sec_sep[]  = ".,";


BOOLEAN check_time (s, h, m)
BYTE *s;
WORD *h, *m;

{ WORD hour, min, sec, hsec;

  /* this function also checks for the optional seconds and hundredths
     of a second, which not only default to zero when they're omitted,
     but also are ignored utterly when they're not. */

  min = sec = hsec = 0;
  s = deblank (s);

  /* look for the hour */

  if (! getdigit (&hour, &s))
    return (FALSE);

  /* if its there, check for the minute (find it first!) */

  while (*s) {

    /* minute */

    if (! strpsn (*s++, hour_sep) ||
        ! getdigit (&min, &s))
      return (FALSE);

    if (! *s)
      break;

    /* seconds and hundredths */

    if (! strpsn (*s++, hour_sep) ||
	! getdigit (&sec, &s))
      return (FALSE);

    if (! *s)
      break;

    if (! strpsn (*s++, sec_sep) ||
	! getdigit (&hsec, &s))
      return (FALSE);

    if (! *s)
      break;

    else
      return (FALSE);

  }

  /* make sure the numbers aren't daft */

  if (hour < 0  ||
      hour > 23 ||
      min < 0   ||
      min > 59  ||
      sec < 0   ||
      sec > 59  ||
      hsec < 0  ||
      hsec > 99)
    return (FALSE);

  *h = hour;
  *m = min;
  return (TRUE);

}



/*************************************************************************/
/*                                                                       */
/*                         Get_an_alarm                                  */
/*                                                                       */
/* Get_an_alarm gets the next alarm out of the inputted file buffer. P   */
/* is the string, i is the alarm being worked on, finished points to     */
/* a boolean which is set to TRUE or FALSE depending on whether the end  */
/* of file has been reached, and is_scrap is a received boolean which    */
/* is TRUE if the data is being read from a scrap file (and so will be   */
/* in the local, as opposed to global, data format).                     */
/*                                                                       */
/*************************************************************************/  
   
BYTE *get_an_alarm (p, i, finished, is_scrap)
BYTE *p;
WORD i, *finished, is_scrap;

{ BYTE s[100];	/* stores next string to be processed */
  WORD h, m;	/* hour and minute */
    
  /* sort out the date */

  p = get_item (p, s, 95);
  
  if (! (alarm [i].day = check_date (s, ! is_scrap))) {

    *finished = TRUE;
    return (p);
      
  }

  /* the time */

  p = get_item (p, s, 99);

  if (! check_time (s, &h, &m)) {

    *finished = TRUE;
    return (p);
      
  }  

  alarm [i].hour = h;
  alarm [i].min = m;

  /* and the text */

  p = get_eoln (p, msgs [i], MSG_SIZE);
  *finished = (*p == 0x1a);
  return (p);
  
}



/*************************************************************************/
/*                                                                       */
/*                            Getdates                                   */
/*                                                                       */
/* This function fishes all the alarms out of the standard inputted      */
/* file buffer.                                                          */
/*                                                                       */
/*************************************************************************/  

VOID getdates ()

{ WORD i, j, 		/* counters */
       finished;	/* TRUE when get_an_alarm thinks its finished */
  BYTE *p;		/* current position in buffer */
  
  p = buf;
  finished = FALSE;
  
  /* get as much data as possible */

  for (i = 0; ! finished && i < NUM_ALARMS; i++) 
    p = get_an_alarm (p, i, &finished, FALSE);
    
  /* say the file is bad if something went wrong */
      
  if (finished && *p != '\0' && *p != 0x1a)
    do_alert (1, BADDATA);
     
  /* and zero the remaining records */
        
  for (j = i; j < NUM_ALARMS; j++)
    alarm [j].day = 0;

}



/*************************************************************************/
/*                                                                       */
/*                           Load_alarms                                 */
/*                                                                       */
/* Loads the alarm file into memory, and uses it to set up the alarm     */
/* array. Note this version of the function has been modified to return  */
/* TRUE or FALSE, not 0 or 1.                                            */
/*                                                                       */
/*************************************************************************/  

WORD load_alarms ()

{ WORD i;

  /* clear alarms and messages */

  for (i = 0; i < NUM_ALARMS; i++) {

    alarm [i].day = 0;
    msgs [i] [0] = '\0';

  }

  /* read data file into buf */
  
  if (! get_alarm_dates (buf, BUF_SIZE))
    return (FALSE);
  
  /* extract dates and messages */ 

  getdates ();
  get_date (&now);

  q_alarms = 0;

  /* if the alarm is for some time before now, zap it. */

  for (i = 0; i < NUM_ALARMS; i++)
    if (alarm [i].day && before (&alarm [i], &now))
      alarm [i].day = 0;

    else
      q_alarms++;

  return (TRUE);

}



/*************************************************************************/
/*                                                                       */
/*                           Make_line                                   */
/*                                                                       */
/* Check_time takes a string, and converts them into hours and minutes.  */
/* It also makes sure the number in the string do actually make sense.   */
/* P is the string being hit, i is the source alarm record index, and    */
/* infile is TRUE if the line is to go to ALARM.DAT, and FALSE for       */
/* scrap data (determines date format). The function returns the new     */
/* end of the string.                                                    */
/*                                                                       */
/*************************************************************************/  

BYTE *make_line (p, i, infile)
BYTE *p;
WORD  i, infile;

{ BYTE *m;	/* sourec character address in message */

  if (alarm [i].day) {

    /* build date, time and message string */

    p = rol_to_ascii ((WORD) alarm [i].day, p, infile ? 0 : 2);
    *p++ = ' ';
    p = num ((WORD) alarm [i].hour, p, 2);
    *p++ = ':';
    p = num ((WORD) alarm [i].min, p, 2);
    *p++ = ' ';
    m = msgs [i];

    while (*m)
      *p++ = *m++;

    /* if going to file, add in \r */

    if (infile)
      *p++ = '\r';

    *p++ = '\n';

  }
 
  *p = '\0';
  return (p);
  
}




/*************************************************************************/
/*                                                                       */
/*                           Save_alarms                                 */
/*                                                                       */
/* Save alarms builds up the ALARM.DAT data buffer, and writes it to     */
/* disk.                                                                 */
/*                                                                       */
/*************************************************************************/  

BOOLEAN	save_alarms ()

{ WORD i;	/* loop counter to index alarm records */
  BYTE *p;	/* pointer to current position in buffer */

  p = buf;

  for (i = 0; i < NUM_ALARMS; i++)
    p = make_line (p, i, TRUE);

  return (write_file (buf));

}




WORD fix_date (s, days)
BYTE *s; /* from check_date */
WORD *days;

{ WORD	p1, p2, p3;		/* Input Parameters */
  UWORD	day, month, year;
  WORD	days_this_month;

  p1 = a2toi (s);
  p2 = a2toi (s+2);
  p3 = a2toi (s+4);

  switch (date_mode) {

    case 1:			/* European Format dd/mm/yy */
      day = p1;
      month = p2;
      year = p3;
      break;

    case 2:			/* Japanese Format yy/mm/dd */
      day = p3;
      month = p2;
      year = p1;
      break;

    default:			/* US Format mm/dd/yy */
      day = p2;
      month = p1;
      year = p3;
      break;

  }

  if (month < 1 || month > 12)
    return (BADMONTH);
    
  if (year < 78)
    return (BADYEAR);
    
  year += 1900;			/* (0.03) are allowed */ 
  days_this_month = month_count [month];

  if (! (year % 4) && (month == 2))
    days_this_month++; 

  if ((day < 1) || (day > days_this_month)) /* Range check the day */
    return (BADDAY);
    
  *days = rolander (day, month, year);
  return (0);
  
}



WORD fix_time(s, h, m)		/* (0.03) changed extensively */
BYTE *s;				/* by jc to allow hour specifaction */
WORD *h, *m;				/* modified for te_ptext by DJH */

{ WORD	hour, min, sec, hsec;

  hour = a2toi (s);
  min = a2toi (s+2);

  if (hour < 0 || hour > 23)
    return (BADHOUR);
  
  if (min < 0 || min > 59)
    return (BADMIN);
    
  *h = hour;
  *m = min;
  return (0);

}





BOOLEAN check_background ()

{ 

  if (is_dosplus && bg_alarm ()) {

    data_segment = get_ds ();
    return (TRUE);

  } else
    return (FALSE);

}




BYTE *centre (ptr, text, text_len, max_len, add_bar)
BYTE *ptr;
LONG  text;
WORD  text_len, max_len;
BOOLEAN add_bar;

{ WORD extra_spaces;

  extra_spaces = (max_len - text_len)/2 + 2;
  
  while (extra_spaces--)
    *ptr++ = ' ';
 
  LBCOPY (ADDR (ptr), text, text_len);
  ptr += text_len;

  if (text_len == max_len) {

    *ptr++ = ' ';
    *ptr++ = ' ';

  }

  if (add_bar)
    *ptr++ = '|';

  return (ptr);

}
  
  



/***************************************************************/
/*                                                             */
/*  Display_message displays the message from the alarm        */
/*  process. It displays the message in an alert.              */
/*                                                             */
/*  The only parameter is the message.                         */
/*                                                             */
/***************************************************************/

display_message (message)
char *message;

{ WORD date_length, message_length, max_length;
  BYTE text [256], today [32], *ptr;
  struct MYTIME now;
  
  /* make date string */
  
  get_date (&now);
  ptr = today;
  ptr = rol_to_ascii (now.day, ptr, 2);
  *ptr++ = ' ';
  ptr = num (now.hour, ptr, 2);
  *ptr++ = ':';
  ptr = num (now.min, ptr, 2);
  *ptr = '\0';

  /* suss lengths of components, and largest length */

  date_length = strlen (today);
  message_length = strlen (message);
  max_length = largest (date_length, message_length);
  max_length = largest (max_length, length_alarm);

  /* bung in the icon */

  strcpy (text, "[1][");
  ptr = text + 4;

  /* build the alert */

  ptr = centre (ptr, alarm_string, length_alarm, max_length, TRUE);
  ptr = centre (ptr, ADDR (today), date_length, max_length, TRUE);
  ptr = centre (ptr, ADDR (message), message_length, max_length, FALSE);

  /* and the button */

  *ptr++ = ']';
  *ptr++ = '[';
  LBCOPY (ADDR (ptr), ok_string, length_ok);
  ptr += length_ok;
  *ptr++ = ']';
  *ptr = '\0';

  /* Display it */

  form_alert (1, ADDR (text));

}


/* this function must only be called after the semaphore has been claimed */ 
VOID	check_file ()
{
  if (tell_background >= 0)
  {
    put_byte (data_segment, ALARM_DRIVE, tell_background);
    put_byte (data_segment, ALARM_FLAG, 2);
    tell_background = -1;
  }
}



poll ()

{ LONG text_address, mes_addr;
  BYTE message [MSG_SIZE + 1];

  if (check_background ()) {

    get_sem (data_segment);

    switch ( get_byte (data_segment, ALARM_FLAG) ) {

      case 0 :  /* nowt happenin' */
	check_file ();
	break;

      case 1 : /* an alarm to display! */
	copy_str( data_segment, ALARM_TEXT, message ); 
	display_message ( message );
	put_byte (data_segment, ALARM_FLAG, 0);
	check_file ();
	break;

      case 2 : /* ALARM still not read new file */
	break;

      case 3 : /* ALARM had error in reading file */
	put_byte (data_segment, ALARM_FLAG, 0);
        check_file ();
	if (resource_file_loaded)
	  do_alert (1, BACKREAD);
	break;

      default :	/* Unexpected flag state */
	if (resource_file_loaded)
          do_alert (1, DISASTER);
	break;
    }
    free_sem (data_segment);
  }
}




get_position (tree, object, x, y, w, h)
LONG tree;
WORD object, *x, *y, *w, *h;

{

  objc_offset (tree, object, x, y);
  *w = LWGET (OB_WIDTH (object));
  *h = LWGET (OB_HEIGHT (object));

}


set_state (tree, object, state)
LONG tree;
WORD object, state;

{ WORD current;
  LONG ob_state;

  ob_state = OB_STATE (object);
  current = LWGET (ob_state) | state;
  LWSET (ob_state, current);
  return (current);
 
}


reset_state (tree, object, state)
LONG tree;
WORD object, state;

{ WORD current;
  LONG ob_state;

  ob_state = OB_STATE (object);
  current = LWGET (ob_state) & ~ state;
  LWSET (ob_state, current);
  return (current);

}



deselect_object (tree, object, x, y, w, h)
LONG tree;
WORD object, *x, *y, *w, *h;

{ 

  reset_state (tree, object, SELECTED);
  get_position (tree, object, x, y, w, h);

}



WORD union_rectangle (x, y, w, h, tree, item)
WORD *x, *y, *w, *h, item;
LONG tree;

{ WORD ox, oy, ax, ay, aw, ah;

  get_position (tree, item, &ax, &ay, &aw, &ah);
  ox = smallest (*x, ax);
  oy = smallest (*y, ay);
  *w = largest (*x + *w, ax + aw) - ox;
  *h = largest (*y + *h, ay + ah) - oy;
  *x = ox;
  *y = oy;

}




position_slider_box (tree, current_message, number_messages)
LONG tree;
WORD current_message,
     number_messages;

{ LONG maximum_distance,
       extra_position;

  maximum_distance = LWGET (OB_HEIGHT (BAR)) - LWGET (OB_HEIGHT (BOX));
  extra_position = maximum_distance * (LONG) current_message / 
                                      ((LONG) number_messages - 1);
  LWSET (OB_Y (BOX), (WORD) extra_position);

}



get_sname (s) /* gets scrap directory and name */
BYTE s[];

{ LONG saddr, m;
  BYTE t [80];
  WORD l;
  
  saddr = ADDR (s);

  if (! scrp_read (saddr) || s [0] == '\0') { 

    strcpy (t, "SCRAP=");
    shel_envrn (ADDR (&m), ADDR (t));
    
    if (m != 0x0L) {

      l = LSTRLEN (m);
      LBCOPY (saddr, m, l+1);
      
    } else {
        
      dos_gdir (0, saddr); 

      if (s [1] != ':') {

        t [0] = dos_gdrv () + 'A';
        t [1] = ':';
        t [2] = '\\';
        strcpy (&t [3], s);
        strcpy (s, t);

      }

    }
    
    scrp_write (saddr);

  }

  strcat (s, "\\SCRAP.TXT");
  
}




BOOLEAN load_scrap ()     /* loads SCRAP.TXT into cut buffer */

{ BYTE spath [256];

  wait_mouse ();
  get_sname (spath);
  return (access_file (ADDR (spath), 0, read_piece, scrap_buffer, 80));
  
}



BOOLEAN save_scrap()     /* saves cut buffer to SCRAP.TXT */

{ BYTE spath [256];

  wait_mouse ();
  get_sname (spath);

  if (! access_file (ADDR (spath), 1, write_piece, scrap_buffer, 80))
    return (FALSE);

  /* make sure there's a NULL at the end of the scrap buffer */

  scrap_buffer [79] = '\0';
  return (TRUE);
  
}





copy (back)
WORD back;

{ WORD mes;

  if (back < 0) {
  
    do_alert (1, HOWTO);
    return (FALSE);
    
  }

  mes = (back - BACK1) / 6;
  make_line (scrap_buffer, mes, FALSE);
  return (save_scrap ());
  
}



cut (back)
WORD back;

{

  if (copy (back)) {

    alarm [(back - BACK1)/6].day = 0;
    return (TRUE);
  
  }
  
  return (FALSE);
  
}



paste (back)
WORD back;

{ BYTE *s;
  WORD mes, fault;

  if (back < 0) {

    do_alert (1, HOWTO);
    return (FALSE);
    
  }
    
  if (load_scrap ()) {

    mes = (back - BACK1)/6;
    s = get_an_alarm (scrap_buffer, mes, &fault, TRUE);
    
    if (fault)
      alarm [mes].day = 0;
    
    return (TRUE);
    
  }
  
  return (FALSE);
  
}



WORD check_input (tree, old_obj, new_obj, bad_obj)
LONG tree;
WORD old_obj, new_obj, *bad_obj;

{ WORD old_parent, new_parent, h, m, d, alert, x, got_time, got_date, got_mes;
  BYTE string [10];
  LONG str_addr;
    
  if (new_obj == UNDO)
    return (0);
    
  switch (old_obj) {
  
    case DATE1 :
    case TIME1 :
    case AM1 :		
    case MESSAGE1 :
      old_parent = 0;
      break;
      	
    case DATE2 :
    case TIME2 :
    case AM2 :		
    case MESSAGE2 :
      old_parent = 1;
      break;
      
    case DATE3 :
    case TIME3 :
    case AM3 :		
    case MESSAGE3 :
      old_parent = 2;
      break;

    case DATE4 :
    case TIME4 :
    case AM4 :
    case MESSAGE4 :
      old_parent = 3;
      break;

    case DATE5 :
    case TIME5 :
    case AM5 :
    case MESSAGE5 :
      old_parent = 4;
      break;

    case DATE6 :
    case TIME6 :
    case AM6 :
    case MESSAGE6 :
      old_parent = 5;
      break;

    default :
      return (0);

  }

  switch (new_obj) {
  
    case DATE1 :
    case TIME1 :
    case AM1 :
    case MESSAGE1 :
      new_parent = 0;
      break;

    case DATE2 :
    case TIME2 :
    case AM2 :
    case MESSAGE2 :
      new_parent = 1;
      break;

    case DATE3 :
    case TIME3 :
    case AM3 :
    case MESSAGE3 :
      new_parent = 2;
      break;

    case DATE4 :
    case TIME4 :
    case AM4 :
    case MESSAGE4 :
      new_parent = 3;
      break;

    case DATE5 :
    case TIME5 :
    case AM5 :
    case MESSAGE5 :
      new_parent = 4;
      break;
      
    case DATE6 :
    case TIME6 :
    case AM6 :
    case MESSAGE6 :
      new_parent = 5;
      break;
      
    default :
      new_parent = -1;
      
  }

  if (old_parent == new_parent)
    return (0);  

  /* if (! ((got_time = LBGET (times [old_parent])) ||
         (got_date = LBGET (dates [old_parent])) ||
	 (got_mes = LBGET (messes [old_parent]))))
    return (0); */

  got_time = LBGET (times [old_parent]);
  got_date = LBGET (dates [old_parent]);
  got_mes = LBGET (messes [old_parent]);

  if (! got_time && ! got_date && ! got_mes)
    return (0);
  
  str_addr = ADDR (string);
  
  if (got_time) {

    LBCOPY (str_addr, times [old_parent], 4);
    string [4] = '\0';
    
    if ((alert = fix_time (string, &h, &m)) > 0) {

      *bad_obj = TIME1 + old_parent*6;
      return (alert);

    }

    if (time_mode > 0 && h > 12) {

      *bad_obj = TIME1 + old_parent*6;
      return (BADMERID);

    }
 
    if (LLGET (am_obspec [old_parent]) == pm_addr)
      h += 12;
      
  } else {
  
    h = 0;
    m = 0;
    
  }
  
  if (got_date) {
  
    LBCOPY (str_addr, dates [old_parent], 6);
    string [6] = '\0';
  
    if ((alert = fix_date (string, &d)) > 0) {

      *bad_obj = DATE1 + old_parent * 6;
      return (alert);

    }
    
  } else
    d = now.day;
  
  x = current_message + old_parent;

  if (got_mes) {

    LBCOPY (ADDR (&(msgs [x][0])), messes [old_parent], MSG_SIZE - 3);
    msgs [x][MSG_SIZE - 4] = '\0';
    
  } else
    msgs [x][0] = '\0';

  alarm [x].day = d;
  alarm [x].hour = h;
  alarm [x].min = m;
  return (0);
      
}




/* the next section of code is a modified version of form_do for the
   change alarms dialogue. It supports double clicking to select
   a time, and it checks inputted times */
   

WORD find_obj (tree, start_obj, which)       /* routine to find the next editable */
REG LONG tree;          /* text field, or a field that is as */
WORD start_obj;     /* marked as a default return field. */
WORD which;

{ REG WORD obj, flag, theflag, inc;

  obj = 0;
  flag = EDITABLE;
  inc = 1;

  switch (which) {
  
    case FMD_BACKWARD :
      inc = -1;
						/* fall thru		*/
    case FMD_FORWARD :
      obj = start_obj + inc;
      break;
      
    case FMD_DEFLT :
      flag = DEFAULT;
      break;
      
  }

  while (obj >= 0) {
  
    theflag = LWGET (OB_FLAGS (obj));

    if ((theflag & flag) && ! (theflag & HIDETREE))
      return (obj);
      
    if (theflag & LASTOB)
      obj = -1;
      
    else
      obj += inc;
      
  }

  return (start_obj);

}


BOOLEAN find_3_obj (tree, start_obj, finish_obj, which)
LONG tree;
WORD start_obj, *finish_obj, which;

{ WORD s, sid;

  if ((sid = find_obj (tree, start_obj, which)) == start_obj)
     return (FALSE);

  if ((s = find_obj (tree, sid, which)) == sid)
     return (FALSE);

  if ((sid = find_obj (tree, s, which)) == s)
     return (FALSE);
  
  *finish_obj = sid;
  return(TRUE);

}



WORD find_15_obj (tree, start_obj, which)
LONG tree;
WORD start_obj, which;

{ WORD i;

  for (i = 0; i < 15; i++)
    start_obj = find_obj (tree, start_obj, which);

  return (start_obj);

}


WORD fm_inifld (tree, start_fld)
LONG tree;
WORD start_fld;

{
						/* position cursor on	*/
						/*   the starting field	*/
  if (start_fld == 0)
    start_fld = find_obj (tree, 0, FMD_FORWARD);
    
  return (start_fld);
  
}


WORD a_form_do (tree, start_fld, sel_back)
REG LONG tree;
WORD	*start_fld, *sel_back;

{ REG WORD edit_obj;
  WORD	   next_obj;
  WORD	   which, cont;
  WORD	   idx;
  WORD	   mx, my, mb, ks, kr, br;
  WORD	   is_back, bad_obj, alert, first;
  WORD	   x, y, w, h, s;
  
  wind_update(1);
  wind_update(3);
						/* set starting field	*/
						/*   to edit, if want	*/
						/*   first editing field*/
						/*   then walk tree	*/
  next_obj = fm_inifld (tree, *start_fld);
  edit_obj = 0;
						/* interact with user	*/
  first = cont = TRUE;
  bad_obj = -1;
  
  while (cont) {
						/* position cursor on	*/
						/*   the selected 	*/
						/*   editting field	*/
    if ((next_obj != 0) &&
	(edit_obj != next_obj)) {

      if (! first &&
	  (alert = check_input (tree, edit_obj, next_obj, &bad_obj))) {

	get_position (tree, bad_obj, &x, &y, &w, &h);
	set_state (tree, bad_obj, SELECTED);
	objc_draw (tree, ROOT, MAX_DEPTH, x, y, w, h);
	next_obj = bad_obj;
	do_alert (1, alert);

      }	      

      edit_obj = next_obj;
      next_obj = 0;
      first = FALSE;
      objc_edit (tree, edit_obj, 0, &idx, EDINIT);

    }
						/* wait for mouse or key */
    which = evnt_multi (MU_KEYBD | MU_BUTTON, 
			0x02, 0x01, 0x01, 
			0, 0, 0, 0, 0,
			0, 0, 0, 0, 0,
			0x0L,
			0, 0,
			&mx, &my, &mb, &ks, &kr, &br);

    if (bad_obj >= 0) {

      deselect_object (tree, bad_obj, &x, &y, &w, &h);
      objc_draw (tree, ROOT, MAX_DEPTH, x, y, w, h);
      bad_obj = -1;
      
    }     
						/* handle keyboard event*/
    if (which & MU_KEYBD) {

      /* filter out cut, copy and paste */

      switch (kr) {
      
        case F1 :
	  next_obj = CUT;
	  cont = FALSE;
	  break;

        case F2 :
	  next_obj = COPY;
	  cont = FALSE;
	  break;
	  
	case F3 :
	  next_obj = PASTE;
	  cont = FALSE;
	  break;

        case TAB :
	case CTRL_I :
	  next_obj = find_obj (tree, edit_obj, FMD_FORWARD);
	  
	  if (next_obj == edit_obj)
	    next_obj = DATE1;

          cont = TRUE;	    
	  break;
 
	case DOWN_ARROW :
	  
	  if (! find_3_obj (tree, edit_obj, &next_obj, FMD_FORWARD))
            next_obj = find_15_obj (tree, edit_obj, FMD_BACKWARD);
	 
	  cont = TRUE;
	  break;
	    	
	case BACKTAB :
	  next_obj = find_obj (tree, edit_obj, FMD_BACKWARD);
	  
	  if (next_obj == edit_obj)
	    next_obj = MESSAGE6;
	  
	  cont = TRUE;  
	  break;

	case UP_ARROW :

	  if (! find_3_obj (tree, edit_obj, &next_obj, FMD_BACKWARD))
	    next_obj = find_15_obj (tree, edit_obj, FMD_FORWARD);

          cont = TRUE;
	  break;

	case HOME :
	  next_obj = DATE1;
	  break;
	  
	case END :
	  next_obj = MESSAGE6;
	  break;
	  
	case PAGEUP :
	  next_obj = UP;
	  break;
	  
	case PAGEDOWN :
	  next_obj = DOWN;
	  break;
    
	case HELP_KEY :
	  do_alert (1, HELP);
          cont = TRUE;
	  break;
       	    	  
	default :
      
          cont = form_keybd (tree, edit_obj, next_obj, kr, &next_obj, &kr);

          if (kr)
            objc_edit (tree, edit_obj, kr, &idx, EDCHAR);

      }
            	
    }
						/* handle button event	*/
    if (which & MU_BUTTON) {

      next_obj = objc_find (tree, ROOT, MAX_DEPTH, mx, my);

      if (((next_obj == NIL) || (next_obj == 0)) && (*sel_back > 0)) {

	get_position (tree, *sel_back, &x, &y, &w, &h);
	reset_state (tree, *sel_back, OUTLINED);
	x -= 3; y -= 3; w += 6; h += 6;
	objc_draw (tree, ROOT, MAX_DEPTH, x, y, w, h);
	*sel_back = -1;

      }

      if (next_obj == NIL)
        next_obj = 0;

      else {
      
        if (br == 2) {
	
	  cont = FALSE;
	  
	  switch (next_obj) {
	  
	    case DATE1 :
	    case TIME1 :
	    case AM1 :
	    case MESSAGE1 :
	    case BACK1 :
	      next_obj = BACK1;
	      break;
	      
	    case DATE2 :
	    case TIME2 :
	    case AM2 :
	    case MESSAGE2 :
	    case BACK2 :
	      next_obj = BACK2;
	      break;
	      
	    case DATE3 :
	    case TIME3 :
	    case AM3 :
	    case MESSAGE3 :
	    case BACK3 :
	      next_obj = BACK3;
	      break;
	      
	    case DATE4 :
	    case TIME4 :
	    case AM4 :
	    case MESSAGE4 :
	    case BACK4 :
	      next_obj = BACK4;
	      break;
	      
	    case DATE5 :
	    case TIME5 :
	    case AM5 :
	    case MESSAGE5 :
	    case BACK5 :
	      next_obj = BACK5;
	      break;
	      
	    case DATE6 :
	    case TIME6 :
	    case AM6 :
	    case MESSAGE6 :
	    case BACK6 :
	      next_obj = BACK6;
	      break;

            default :
	      cont = TRUE;

          }

        }
	
      } 
      
      if (cont)
        cont = form_button (tree, next_obj, br, &next_obj);
      	  	
    }
 
    if ((! cont) ||
	((next_obj != 0) && 
	 (next_obj != edit_obj)))
      objc_edit (tree, edit_obj, 0, &idx, EDEND);
 						/* handle end of field	*/
						/*   clean up		*/
    if (! cont && (alert = check_input (tree, edit_obj, next_obj, &bad_obj))) {
    
      if ((next_obj != COMMIT) ||
          (do_alert (2, WARNBAD) == 2)) {
	
	get_position (tree, next_obj, &x, &y, &w, &h);
	reset_state (tree, next_obj, SELECTED);
        objc_draw (tree, ROOT, MAX_DEPTH, x, y, w, h);
	get_position (tree, bad_obj, &x, &y, &w, &h);
	set_state (tree, bad_obj, SELECTED);
	objc_draw (tree, ROOT, MAX_DEPTH, x, y, w, h);
        next_obj = bad_obj;
        edit_obj = 0;
        cont = TRUE; 
      	do_alert (1, alert);

      }
    
    }
        
  }

  wind_update(2);
  wind_update(0);
						/* return exit object	*/
						/*   hi bit may be set	*/
						/*   if exit obj. was	*/
						/*   double-clicked	*/
  *start_fld = edit_obj;
  return (next_obj);

}




load_file ()

{ 

  wait_mouse ();
  alarm_file_loaded = load_alarms ();
  normal_mouse ();
    
}



add_file_name (dname, fname)	/* replace name at end of input file spec*/
BYTE *dname, *fname;

{ BYTE	c;
  WORD	ii;

  ii = strlen (dname);

  while (ii && (((c = dname [ii-1])  != '\\') && (c != ':')))
    ii--;

  dname [ii] = '\0';
  strcat (dname, fname);

}



WORD get_fsel ()			/* use file selector to get input file	*/

{ WORD	fs_iexbutton, after_drive;
  BYTE	fs_iinsel [13];

  while (TRUE) {

    strcpy (fs_iinsel, "ALARM.DAT");
    fsel_input (filename_address, ADDR (fs_iinsel), &fs_iexbutton);
    evnt_timer (200, 0);
	
    if (fs_iexbutton) {
 
      add_file_name (alarm_fn, fs_iinsel);
      after_drive = (alarm_fn [1] == ':' ? 2 : 0);
      dosplus_alarm_file = ! strcmp (alarm_fn + after_drive, "\\ALARM.DAT");

      switch (dosplus_alarm_file ? 1 : do_alert (1, WARNNAME)) {

	case 1 :
          alarm_file_loaded = TRUE;
	  load_file ();
	  return (TRUE);

	case 2 :
	  break;

        case 3 :
	  return (FALSE);

      }

    } else
      return (FALSE);

  }

} 




unsel_back (ox, oy, ow, oh, tree, box)
WORD *ox, *oy, *ow, *oh, *box;
LONG tree;

{ WORD sel_state;

  if (*box >= 0) {

    reset_state (tree, *box, OUTLINED);
    
    if (*ow >= 0)
      union_rectangle (ox, oy, ow, oh, tree, *box);
		 
    else
      get_position (tree, *box, ox, oy, ow, oh);
  
    *ox -= 3; *oy -= 3; *ow += 6; *oh += 6;
    *box = -1;
  
  }

}




change_times (which_id)
WORD which_id;

{ WORD x, y, w, h,	/* dimension of dialogue */
       ox, oy, ow, oh,	/* dimension of area within dialogue to redraw */
       bx, by, bw, bh,  /* dimension of slider bar */
       mx, my,		/* mouse position */
       quantity,	/* quantity alarms to be displayed */
       which_am,	/* which am, if one chosen by user */
       hour_shown,	/* when showing meridian, the hour displayed */
       different,	/* TRUE if different message being displayed */
       edit_box,        /* current edit box */
       exit_box,	/* exit box chosen by user */
       state,		/* copy of ob_state for various objects */
       sel_back,	/* current selected background */
       sel_mes,		/* current selected message */
       sm,		/* used to calculate sel_mes */
       sel_state,	/* state of background box */
       xx,
       count,		/* whats a loop between friends */
       finished = FALSE;/* TRUE if use selects OK or CANCEL */
  LONG box_height,	/* relative size of box to bar (times 1000) */
       tedinfo_addr,	/* address of TEDINFO for TIME, DATE and MESSAGE */
       text_addr,	/* address of answer text for same data */
       str_addr,        /* address of a_string */
       ms_addr,		/* address of a message */
       pmam,		/* address of AM/PM object's OB_SPEC field */
       slide_distance,	/* returned by graf_slidebox; range 0 to 1000 */
       tree;		/* address of dialogue root */
  BYTE a_string [128],  /* guess ... */
       *astr_ptr;	/* pointer to above */

  /* check we're in dos plus */
  
  if (is_dosplus) {

    if (! bg_alarm ())
      do_alert (1, NOBACK);

  } else
    if (do_alert (1, NOTPLUS) == 1)
      return (FALSE);
      
  /* load the alarm file */

  if ((which_id == new_id) || ! alarm_file_loaded)
    if (! get_fsel ())
      return (FALSE);

  /* prepare dialogue for drawing */

  rsrc_gaddr (R_TREE, CHANGE, &tree);
  form_center (tree, &x, &y, &w, &h);

  /* calculate visual position of slider bar for any redrawing requirements */

  get_position (tree, BAR, &bx, &by, &bw, &bh);

  /* prepare the slider bar; last entry is empty unless there are thirty
     two alarms already */

  quantity = 32;
  box_height = 6000 / quantity;
  box_height = (bh * box_height) / 1000;
  LWSET (OB_HEIGHT (BOX), (WORD) box_height);
  current_message = 0;
  position_slider_box (tree, current_message, quantity);

  /* position and prepare the dialogue */

  form_dial (FMD_START, x, y, w, h, x, y, w, h);
  ox = x; oy = y; ow = w; oh = h;
  edit_box = MESSAGE1;
  sel_back = -1;
  sel_mes = -1;
  str_addr = ADDR (a_string);
  different = TRUE;
    
  while (! finished) {

    if (different) {

      for (count = 0; count < 6; count++) {

        if (alarm [count+current_message].day > 0) {

          /* take contents of current record */
	  	
          rol_to_ascii ((WORD) alarm [count+current_message].day,a_string,1);
          LBCOPY (dates [count], str_addr, 6);
          hour_shown = alarm [count+current_message].hour;
	  
	  if (time_mode)
	    if (hour_shown > 12) {
	  
	      hour_shown -= 12;
	      LLSET (am_obspec [count], pm_addr);
	      
	    } else
	      LLSET (am_obspec [count], am_addr);

	  astr_ptr = &(a_string [0]);
	  astr_ptr = num (hour_shown, astr_ptr, 2);
	  astr_ptr = num ((WORD) alarm [count+current_message].min, astr_ptr, 2);
	  *astr_ptr = '\0';
	  LBCOPY (times [count], str_addr, 4);
	  ms_addr = ADDR (&(msgs [count+current_message][0]));
	  LBCOPY (messes [count], ms_addr, MSG_SIZE - 3);
		   
        } else {

          /* new item; empty fields */

          LBSET (messes [count], '\0');
          LBSET (times [count], '\0');
	  LBSET (dates [count], '\0');
     	  LLSET (am_obspec [count], am_addr);
	  
        }

      }
      
      different = FALSE;

    }
    
    if ((ow > 0) && (oh > 0))
      objc_draw (tree, ROOT, MAX_DEPTH, ox, oy, ow, oh);

    ow = -1;
    exit_box = a_form_do (tree, &edit_box, &sel_back);
    state = TRUE;
    sm = 0;
    
    switch (exit_box) {

      case BACK6 :
        sm++;
	
      case BACK5 :
        sm++;
	
      case BACK4 :
        sm++;
	
      case BACK3 :
        sm++;
	
      case BACK2 :
        sm++;
	
      case BACK1 :

	set_state (tree, exit_box, OUTLINED);
	get_position (tree, exit_box, &ox, &oy, &ow, &oh);
        sel_mes = current_message + sm;

        if (sel_back >= 0)
	  unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);

        ox -= 3; oy -= 3;
	ow += 6; oh += 6;
	sel_back = exit_box;
	break;

      case CUT :
        different = cut (sel_back);
	unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
	break;
	
      case COPY :
        different = copy (sel_back);
	unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
	break;
	
      case PASTE :
      	different = paste (sel_back);
	unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
	break;
	
      case COMMIT :
	wait_mouse ();
	state = save_alarms ();
	normal_mouse ();

	if (dosplus_alarm_file)	{

	  tell_background = alarm_fn [0] - 'A';
	  poll ();

	}
					/* drops through */
      case UNDO :
        deselect_object (tree, exit_box, &ox, &oy, &ow, &oh);
        finished = state;
        break;

      case UP :
      
        if (current_message > 0) {

	  current_message--;
          position_slider_box (tree, current_message, quantity);
	  ox = bx; oy = by; ow = bw; oh = bh;
	  unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
	  different = TRUE;
     
	}
	
        break;

      case DOWN :

        if (current_message < quantity - 6) {
	
	  current_message++;        
          position_slider_box (tree, current_message, quantity);
	  different = TRUE;
          ox = bx; oy = by; ow = bw; oh = bh;
	  unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
	  
	}
	
        break;

      case BAR :
	graf_mkstate (&mx, &my, &unwanted, &unwanted);
	objc_offset (tree, BOX, &ox, &oy);

	if (my > oy) {

          if (current_message < quantity)
	    current_message = smallest (quantity - 1, current_message + 6);

        } else {
	
	  if (current_message > 0)
	    current_message = largest (0, current_message - 6);
	  
	}
	
        position_slider_box (tree, current_message, quantity);
	different = TRUE;
        ox = bx; oy = by; ow = bw; oh = bh;
	unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
        break;

      case BOX :
        slide_distance = graf_slidebox (tree, BAR, BOX, TRUE);
	current_message = (WORD) ((LONG) slide_distance * 
                                 ((LONG) quantity - 1) / 1000L);
	position_slider_box (tree, current_message, quantity);
	different = TRUE;
        ox = bx; oy = by; ow = bw; oh = bh;
	unsel_back (&ox, &oy, &ow, &oh, tree, &sel_back);
        break;

      case AM6 :
	sm++;

      case AM5 :
	sm++;

      case AM4 :
	sm++;

      case AM3 :
	sm++;

      case AM2 :
	sm++;

      case AM1 :
	
	if (LLGET (am_obspec [sm]) == pm_addr)
	  LLSET (am_obspec [sm], am_addr);

	else
	  LLSET (am_obspec [sm], pm_addr);

	deselect_object (tree, exit_box, &ox, &oy, &ow, &oh);
        break;

    }

    /* if message has changed, lots of things to do */

    if (different) {

      if (ow <= 0)
	get_position (tree, BACK1, &ox, &oy, &ow, &oh);

      else
        union_rectangle (&ox, &oy, &ow, &oh, tree, BACK1);

      union_rectangle (&ox, &oy, &ow, &oh, tree, BACK2);
      union_rectangle (&ox, &oy, &ow, &oh, tree, BACK3);
      union_rectangle (&ox, &oy, &ow, &oh, tree, BACK4);
      union_rectangle (&ox, &oy, &ow, &oh, tree, BACK5);
      union_rectangle (&ox, &oy, &ow, &oh, tree, BACK6);

    }
      
  }

  form_dial (FMD_FINISH, x, y, w, h, x, y, w, h);

}



again_and_again ()

{ WORD x, y, key, wot;

  FOREVER {

    wot = evnt_multi (MU_TIMER | MU_MESAG, 
                      1, 1, 1,
                      0, 0, 0, 0, 0,
                      0, 0, 0, 0, 0,
                      buffer_address, low_delay, high_delay,
                      &unwanted, &unwanted,
                      &unwanted, &unwanted, &key, &unwanted);

    if (wot & MU_TIMER)
      poll ();

    if (wot & MU_MESAG)
      switch (buffer [0]) {

        case AC_OPEN : 
          change_times (buffer [4]);
          break;

        case AC_CLOSE :
          break;

      }

  }

}



/********************************************************************/
/*                                                                  */
/*  Init_alarm initialises things, like windows and GEM and the     */
/*  weather forecaster. It takes no parameters, but returns         */
/*  FALSE if something is a bit off.                                */
/*                                                                  */
/********************************************************************/

WORD  init_alarm ()

/* um, initialises things */

{ LONG  full_path;	/* address of path_string (below) */
  LONG  tree;		/* address of change dialogue */
  LONG  japan;		/* used to swap tedinfos for Japan date format */ 
  BYTE  path_string [256]; /* path of resource file */
  BYTE  os [9];		/* result of search for "OS" */
  WORD  state;		/* ob state of various objects */
  WORD  count;		/* um ... er ... um ... er ... */
  LONG  registration;	/* address of entry for accessory menu */
  LONG  new_file;	/* address of new file string */
  LONG  l,
        search_for,
        contents,
	os_addr;
	
  /* attach to GEM */

  if (! (ap_id = appl_init ()))
    return (1);

  /* make sure we're running under DOS+ (which sets the environment string
     OS=DOSPLUS, so we'll look for that). */

  contents = 0x0L;
  search_for = ADDR (path_string);
  strcpy (path_string, "OS=");
  shel_envrn (ADDR (&contents), search_for);

  /* if we find an environment string for "OS=" see if it's "DOSPLUS". */

  if (contents != 0x0L) {
  
    os_addr = ADDR (os);      
    LBCOPY (os_addr, contents, 9);
    os [8] = 0;
    is_dosplus = ! strcmp (os, "DOSPLUS");
      
  } else
    is_dosplus = FALSE;
  
  dosplus_alarm_file = alarm_file_loaded = FALSE;
  tell_background = -1;

  /* try and load the resource file and find address of free strings.
     Since displaying alarms does not depend on the presence of the
     resource file, I took the decision that if the file is absent,
     alarms can still be displayed, although no updates can occur.
     Dummy strings are substituted for "ok", and the window title. */

  strcpy (path_string, "ALARM.RSC");
  full_path = search_for; 
  graf_handle (&cell_width, &unwanted, &unwanted, &unwanted);
  get_format ();

  if (resource_file_loaded = (shel_find (full_path) && 
                              rsrc_load (full_path))) {

    rsrc_gaddr (R_FRSTR, OK, &ok_string);
    ok_string = LLGET (ok_string);
    rsrc_gaddr (R_FRSTR, ALARM, &alarm_string);
    alarm_string = LLGET (alarm_string);
    rsrc_gaddr (R_FRSTR, REGISTER, &registration);
    registration = LLGET (registration);

    if ((change_id = menu_register (ap_id, registration)) >= 0) {

      rsrc_gaddr (R_FRSTR, NEWFILE, &new_file);
      new_file = LLGET (new_file);
      new_id = menu_register (ap_id, new_file);
      rsrc_gaddr (R_TREE, CHANGE, &tree); 

      /* Japan date format uses different TEDINFO structure */
      
      if (date_mode == 2) {

#define jset(x,y) japan=LLGET(OB_SPEC(x));LLSET(OB_SPEC(y),japan)
        jset (JAPAN1, DATE1);
	jset (JAPAN2, DATE2);
	jset (JAPAN3, DATE3);
	jset (JAPAN4, DATE4);
	jset (JAPAN5, DATE5);
	jset (JAPAN6, DATE6);

      }

      /* set up arrays of date, time, am and message addresses */

#define FIND_ADDR(x,y) y=LLGET (LLGET (OB_SPEC (x)))

      FIND_ADDR (DATE1,dates[0]);
      FIND_ADDR (DATE2,dates[1]);
      FIND_ADDR (DATE3,dates[2]);
      FIND_ADDR (DATE4,dates[3]);
      FIND_ADDR (DATE5,dates[4]);
      FIND_ADDR (DATE6,dates[5]);

      FIND_ADDR (TIME1,times[0]);
      FIND_ADDR (TIME2,times[1]);
      FIND_ADDR (TIME3,times[2]);
      FIND_ADDR (TIME4,times[3]);
      FIND_ADDR (TIME5,times[4]);
      FIND_ADDR (TIME6,times[5]);

      am_obspec [0] = OB_SPEC (AM1);
      am_obspec [1] = OB_SPEC (AM2);
      am_obspec [2] = OB_SPEC (AM3);
      am_obspec [3] = OB_SPEC (AM4);
      am_obspec [4] = OB_SPEC (AM5);
      am_obspec [5] = OB_SPEC (AM6);

      am_addr = LLGET (am_obspec [0]);
      rsrc_gaddr (R_FRSTR, PM, &pm_addr);
      pm_addr = LLGET (pm_addr);

      FIND_ADDR (MESSAGE1, messes [0]);
      FIND_ADDR (MESSAGE2, messes [1]);
      FIND_ADDR (MESSAGE3, messes [2]);
      FIND_ADDR (MESSAGE4, messes [3]);
      FIND_ADDR (MESSAGE5, messes [4]);
      FIND_ADDR (MESSAGE6, messes [5]);

      /* in 24 hours, hide meridian and move time title and fields */

      if (time_mode == 0) {

#define NEWSTATE(x,s) state=LWGET(OB_FLAGS(x));LWSET(OB_FLAGS(x),state|s)
        NEWSTATE (AM1, HIDETREE);
        NEWSTATE (AM2, HIDETREE);
        NEWSTATE (AM3, HIDETREE);
        NEWSTATE (AM4, HIDETREE);
        NEWSTATE (AM5, HIDETREE);
        NEWSTATE (AM6, HIDETREE);

#define WIDEN(x) state=LWGET(OB_X(x));LWSET(OB_X(x),state+cell_width)
	WIDEN (TIME1);
	WIDEN (TIME2);
	WIDEN (TIME3);
	WIDEN (TIME4);
	WIDEN (TIME5);
	WIDEN (TIME6);
	WIDEN (TIMETEXT);

      }

      /* various change dialogue initialiations */

      q_alarms = 0;
      strcpy (alarm_fn, "C:\\ALARM.DAT");
      filename_address = ADDR (alarm_fn);

      /* Try and open the alarm file */

      if (check_background ()) {

	get_sem (data_segment);
	alarm_fn [0] = get_byte (data_segment, ALARM_DRIVE) + 'A';
	free_sem (data_segment);
        load_file ();
        dosplus_alarm_file = alarm_file_loaded;

      } else {

        alarm_fn [0] = dos_gdrv () + 'A';
	load_file ();
	dosplus_alarm_file = FALSE;

      }
 
    }

  } else {

    ok_string = ADDR (spare_ok);
    alarm_string = ADDR (spare_alarm);

  }

  /* various initialisations */

  buffer_address = ADDR (buffer);
  low_delay = LLOWD (delay);
  high_delay = LHIWD (delay);
  length_ok = LSTRLEN (ok_string);
  length_alarm = LSTRLEN (alarm_string);

  /* bye bye with all okay, the program'll crash some other way. */

  return (0);

}




GEMAIN ()

{ WORD code;

  if (init_alarm () == 0)
    again_and_again ();

  appl_exit ();

}

