

/************************************************************************/
/*                                                                      */
/*                   ****   ***  *   *  ***  *****                      */
/*                   *   *   *   **  *   *     *                        */
/*                   ****    *   * * *   *     *                        */
/*                   *   *   *   *  **   *     *                        */
/*                   ****   ***  *   *  ***    *                        */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*          Initialisation, termination and general functions           */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#define READ_ERROR 1

#include "btype.h"       /* GEM and workbench bindings */

/* GEM globals */

WORD contrl [11], intin [80], ptsin [256], intout [45], ptsout [12];

/* workbench globals */

window_struct __window [QUANTITY_WINDOWS];   /* window details        */

GRECT __drag_start,        /* start of drag rectangle */
      __drag_finish;       /* finish drag rectangle   */
WORD  __curwin,            /* current window          */
      __wb_flags,          /* flags  - see bench.h    */
      __vdi_handle,        /* AES's VDI handler       */
      __event,             /* events which occured    */
      __cellw, __cellh,    /* character cell w & h    */
      __mousex, __mousey;  /* mouse position          */
LONG  __menuaddr;          /* menu address            */




/***************************************************************************/
/*                                                                         */
/*               __min   and __max   - two exciting                        */
/*              functions to find ... need I say it?                       */
/*                                                                         */
/***************************************************************************/

WORD __min (a, b)
WORD a, b;

{
  return( (a < b) ? a : b );
}



WORD __max (a, b)
WORD a, b;

{
  return( (a > b) ? a : b );
}




/***************************************************************************/
/*                                                                         */
/*                        Raster transformation                            */
/*                                                                         */
/* These next few routines are partially filched from Doodle, the example  */
/*                program wot comes with the GEM toolkit.                  */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*                                                                         */
/*                        __makeMFDB (was vdifix)                          */
/*                                                                         */
/*         Converts information about the icon into the                    */
/*          format required by the VDI library routines                    */
/*                  (the MFDB structure)                                   */
/*                                                                         */
/***************************************************************************/

__makeMFDB (memory_definition, theaddr, width_bytes, height, is_ndc)
MFDB *memory_definition; /* record to be filled */
LONG theaddr;            /* address of icon bit pattern structure */
WORD width_bytes,        /* width size of structure in bytes */
     height;             /* height of structure */
BOOLEAN is_ndc;          /* TRUE if dealing with NDC co-ordinates */

{

  /* if you look at section six of the VDI manual, and in particular the
     format of the MFDB structure, you should understand wots going on 'ere */

  memory_definition -> fww = width_bytes >> 1;
  memory_definition -> fwp = width_bytes << 3;
  memory_definition -> fh = height;
  memory_definition -> np = 1;
  memory_definition -> mp = theaddr;
  memory_definition -> ff = is_ndc;

}



/***************************************************************************/
/*                                                                         */
/*                      __transform (was vditrns)                          */
/*                                                                         */
/*         Transforms a source icon into a target icon.                    */
/*                                                                         */
/***************************************************************************/

WORD __transform (pattern_addr, width_bytes, height)
LONG pattern_addr;    /* address of source icon's image */
UWORD width_bytes,    /* width of icon */
      height;         /* height of icon */

{ MFDB source, destination; /* MFDB structures for VDI transformation */

  /* setting up the MFDB structures is identical for source and object icons,
     except to say that one is in NDC co-ordinates, and the other is in the
     local raster co-ordinates. */

  __makeMFDB (&source, pattern_addr, width_bytes, height, TRUE);
  __makeMFDB (&destination, pattern_addr, width_bytes, height, FALSE);
  vr_trnfm (__vdi_handle, &source, &destination);

}



/***************************************************************************/
/*                                                                         */
/*                           __image                                       */
/*                                                                         */
/*         Gets information from image structure, for a call to            */
/*             transform that structure into local coordinates             */
/*                                                                         */
/***************************************************************************/

__image (tree, obj)
LONG tree;       /* identifies the image to be changed */
WORD obj;        /* ditto */

{ LONG taddr,       /* address of icon's actual image */
       obspec;      /* address of BITBLK structure */
  WORD width_bytes, /* width of icon in bytes */
       height;      /* height of icon */

  obspec = LLGET (OB_SPEC (obj));

  taddr = LLGET (obspec);             /* bi_pdata */
  width_bytes = LWGET (obspec + 4);   /* bi_wb    */
  height = LWGET (obspec + 6);        /* bi_hl    */

  __transform (taddr, width_bytes, height);

}



/***************************************************************************/
/*                                                                         */
/*                            __icon                                       */
/*                                                                         */
/*         Gets information from icon  structure, for a call to            */
/*             transform that structure into local coordinates             */
/*                                                                         */
/***************************************************************************/

__icon (tree, obj)
LONG tree;        /* identifies the image to be changed */
WORD obj;         /* ditto */

{ LONG taddr,       /* address of icon's actual image */
       obspec;      /* address of IMAGBLK structure */
  WORD width_bytes, /* width of icon in bytes */
       height;      /* height of icon */

  obspec = LLGET (OB_SPEC (obj));

  taddr = LLGET (obspec);                 /* ib_pmask */
  width_bytes = LWGET (obspec + 22) >> 3; /* ib_wicon */
  height = LWGET (obspec + 24);           /* ib_hicon */

  __transform (taddr, width_bytes, height);

  taddr = LLGET (obspec + 4);             /* ib_pdata */

  __transform (taddr, width_bytes, height);

}


/**********************************************************************/
/*                                                                    */
/*                            Wb_Start                                */
/*                                                                    */
/*   This functions prepares GEM for use. It takes the following      */
/* parameters:                                                        */
/*                                                                    */
/*        char *resourcefile    the name of the resource file         */
/*        LONG *menu            set to the menu constant; returned    */
/*                              as menu root address (NULL = no menu, */
/*                              so don't display menu bar!)           */
/*                                                                    */
/*        WORD *icons           a two dimensional array, listing icons*/
/*                              to be converted. formatted as follows */
/*                              { tree_name1, icon1,                  */
/*                                tree_name2, image1,                 */
/*                                       . . .                        */
/*                                tree_namen, iconn,                  */
/*                                -1 };                               */
/*                                                                    */
/*   The function returns the application id if it succeeds, other-   */
/* a negative number. The result must be fed to wb_finish when the    */
/* program terminates. The Doodle init routine started this off.      */
/*                                                                    */
/**********************************************************************/

WORD wb_start (resourcefile, menu, icons)
char *resourcefile;
WORD *icons;
LONG *menu;

{ WORD ap_id,     /* application id (as returned by appl_init, hopefully) */
       vdi,       /* vdi handler */
       work_in [11],  /* virtual screen input ... */
       work_out [57], /* ... and output */
       cw, ch,    /* character width and height (thrown away) */
       last_tree, /* last tree's number */
       tree_name, /* current tree */
       subject,   /* icon or image object number */
       *current,  /* address of icon array (icons) being considered */
       x;         /* temporary variable */
  LONG tree;      /* various plants */ 

  /* initialise the GEM variables etc., if possible */

  if ((ap_id = appl_init ()) == -1)
    return (WB_APPL_ERROR);

  /* get the VDI handler, and the cell sizes. Return the former if wanted. */

  __vdi_handle = graf_handle (&__cellw, &__cellh, &cw, &ch);
  __menuaddr = NULL;

  if (resourcefile != NULL) {
  
    /* try and load the resource file */

    while (! rsrc_load (ADDR (resourcefile))) {

      /* can't load the resource file; display FILE READ ERROR */

      graf_mouse (0, GEM_NULL);

      if (form_error (READ_ERROR) != 1)
        return (WB_RESOURCE_ERROR);

      graf_mouse (2, GEM_NULL);

    }

    graf_mouse (0, GEM_NULL);

    /* convert all the images and icons */

    if (icons != NULL)
      for (current = icons, last_tree = -1; *current >= 0; ) {

        tree_name = *(current++);

        if (last_tree != tree_name)
          rsrc_gaddr (R_TREE, tree_name, &tree);

        subject = *(current++);

        if (LWGET (OB_TYPE (subject)) == G_ICON)
          __icon (tree, subject);

        else
          __image (tree, subject);

      }

    /* display the menu bar */

    if (menu != NULL) {

      rsrc_gaddr (R_TREE, (WORD) *menu, menu);
      menu_bar (*menu, TRUE);
      __menuaddr = *menu;

    } 

  }

  /* open virtual screen workstation */

  for (x = 0; x < 10; work_in [x++] = 1);

  work_in [10] = 2;
  v_opnvwk (work_in, &__vdi_handle, work_out);

  /* 'zero' the window records */

  for (x = 0; x < QUANTITY_WINDOWS; __window [x++]._handler = -1) {

    __window [x]._which_rectangle [0] = -1;
    __window [x]._which_rectangle [1] = -1;
    __window [x]._mouseform [0] = 0;
    __window [x]._mouseform [1] = 0;
    __window [x]._control = 0;

  }

  __window [0]._handler = 0;
  __wb_flags = 0;
  return (ap_id);

}



/**********************************************************************/
/*                                                                    */
/*                            Wb_finish                               */
/*                                                                    */
/*   This functions terminates GEM AES activity. It takes one         */
/* parameter:                                                         */
/*                                                                    */
/*        WORD start_result     the result of the call to wb_start    */
/*                                                                    */
/**********************************************************************/

wb_finish (start_result)
int start_result;   /* the WORD returned by wb_start */

{ int x;

  switch (start_result) {

    /* no resource file */

    case WB_RESOURCE_ERROR :
      appl_exit ();

    /* not even an application id */

    case WB_APPL_ERROR :
      break;

    /* normal exit */

    default :

      v_clsvwk (__vdi_handle);
      
      for (x = 1; x < QUANTITY_WINDOWS; x++)
        wb_close (x); 

      if (__menuaddr != NULL)
        menu_bar (__menuaddr, FALSE);

      rsrc_free ();
      appl_exit ();

  }

}


