

/************************************************************************/
/*                                                                      */
/*               ****   *   *   ***   *   *   ***  ****                 */
/*               *   *  ** **  *   *  *   *  *     *                    */
/*               ****   * * *  *   *  *   *   **   ***                  */
/*               *   *  *   *  *   *  *   *     *  *                    */
/*               ****   *   *   ***    ***   ***   ****                 */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                           Mouse functions                            */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "bench.h"       /* GEM and workbench bindings */




/***************************************************************************/
/*                                                                         */
/*                               __itemrelease                             */
/*                                                                         */
/*        This function deselects all items in the current window          */
/*                                                                         */
/***************************************************************************/

__itemrelease (which, reply)
WORD which, *reply;

{ WORD i,                  /* loop counter */
       s;                  /* object state */
  BOOLEAN changed = FALSE; /* TRUE if redraw is necessary */
  LONG tree;               /* an inconvientantly placed oak */

  /* look at each item in turn */

  if (! (__window [which]._control & WB_SELECT))
    return;
 
  tree = __window [which]._contents;

  for (i = LWGET (OB_HEAD (0)); i != 0; i = LWGET (OB_NEXT (i)))
    if ((s = LWGET (OB_STATE (i))) & SELECTED) {

      *reply |= WB_DESELECT;
      wb_dstate (WB_NEXT, which, i, SELECTED, WB_RESET); 

    }

  /* if need be, redraw the window */

  wb_dstate (WB_FINISH, which, 0, 0, 0);

}




/***************************************************************************/
/*                                                                         */
/*                               __rubberbox                               */
/*                                                                         */
/*        This function allows the user to select a number of items        */
/*                            using a rubber box                           */
/*                                                                         */
/***************************************************************************/

__rubberbox (which, mousex, mousey, shift, reply)
WORD which, mousex, mousey, shift, *reply;

{ GRECT window_area,   /* window's work area */
        object_area;   /* area of object's in trees */
  WORD  i,             /* loop counter */
        width, height; /* rubber box results */
  LONG  tree;          /* window's visible contents */

  tree = __window [which]._contents;

  /* if not shift click, deselect anything already selected */

  if ((shift & 3) == 0)
    __itemrelease (which, reply);

  /* let user draw box, starting from current mouse position */

  graf_rubberbox (mousex, mousey, 0, 0, &width, &height);

  /* make sure they're in the window */

  __get_window (which, WF_WXYWH, &window_area);

  if (mousex + width > window_area.g_x + window_area.g_w)
    width = window_area.g_x + window_area.g_w - mousex;

  if (mousey + height > window_area.g_y + window_area.g_h)
    height = window_area.g_y + window_area.g_h - mousey;

  /* find which items in the object tree are under the box */

  for (i = LWGET (OB_HEAD (0)); i != 0; i = LWGET (OB_NEXT (i))) {

    __getarea (tree, i, &object_area);

    if (object_area.g_x >= mousex &&
        object_area.g_y >= mousey &&
        object_area.g_x + object_area.g_w <= mousex + width &&
        object_area.g_y + object_area.g_h <= mousey + height) {

      *reply |= WB_SELECT;
      wb_dstate (WB_NEXT, which, i, SELECTED, WB_SET); 

    }

  }

  /* and redraw the window (no need to touch the sliders) */

  wb_dstate (WB_FINISH, which, 0, 0, 0);

}




/***************************************************************************/
/*                                                                         */
/*                               __choose                                  */
/*                                                                         */
/*        This function is called when the user clicks on an item          */
/*                                                                         */
/***************************************************************************/

__choose (which, child, shift, reply)
WORD which, child, shift, *reply;

{ BOOLEAN shiftclick; /* TRUE if shift pressed */
  LONG tree;

  /* only choose if choosing acceptable */

  if (! (__window [which]._control & WB_SELECT))
    return;

  /* if not shift click, deselect everything */

  if (! (shiftclick = (shift & 3)))
    __itemrelease (which, reply);

  /* and select the relevent item */

  if (child > 0) {

    tree = __window [which]._contents;

    if (LWGET (OB_FLAGS (child)) & SELECTABLE) {

      *reply |= WB_SELECT;
      wb_dstate (WB_DISPLAY, which, child, SELECTED, 
                 (shiftclick ? WB_TOGGLE : WB_SET));

    }

  }

}



/***************************************************************************/
/*                                                                         */
/*                                 __drag                                  */
/*                                                                         */
/*        This function is called when the user wants to drag some         */
/*                                 items                                   */
/*                                                                         */
/***************************************************************************/

__drag (which, child, target_window, target_object, mousex, mousey, 
        shift, reply)
WORD which, child, *target_window, *target_object, mousex, mousey, 
     shift, *reply;

{

  /* if nothing selectable, there can't be anything to drag! */

  if (! (__window [which]._control & WB_SELECT))
    return;

  /* if there is nothing under the mouse, then the user is trying */
  /* to select items using a rubber box.                          */

  if (child == 0)
    __rubberbox (which, mousex, mousey, shift, reply);

  /* otherwise, a drag is wanted */

  else {
    GRECT   full_area,     /* full area for dragging */
            object_area,   /* size of selected object */
            window_area,   /* window's work area */
            second_area;   /* second window's work area */
    WORD    tox, toy,      /* top left of result */
            i, j, k,       /* object number */
            windchsn;      /* window underneath result of drag */
    LONG    tree;          /* window's object tree */
    BOOLEAN first = TRUE;  /* flag used in sizing drag box */


    if (! (__window [which]._control & (WB_DRAGSELF | WB_DRAGANY)))
      return;

    tree = __window [which]._contents;

    /* ensure item underneath mouse is selected */

    if (! wb_switch (tree, child, SELECTED))
      wb_dstate (WB_DISPLAY, which, child, SELECTED, WB_SET);

    /* calculate the size of the drag box by looking at all selected */
    /* items, and producing a rectangle which includes them all      */

    for (i = LWGET (OB_HEAD (0)); i != 0; i = LWGET (OB_NEXT (i)))
      if (LWGET (OB_STATE (i)) & SELECTED) {

        /* find absolute position of item */

        __getarea (tree, i, &object_area);

        if (first) {

          /* if its the first item, then the drag box is the size of */
          /* the item                                                */

          first = FALSE;
          __grect_assign (&__drag_start, &object_area);

        } else
          __union (&__drag_start, &object_area);

      }

    /* if no items selected, then no drag possible, so exit */

    if (first)
      return;

    /* in multiple windowing environments, the _max drag is the */
    /* work area of the screen, so work that out                */

    __get_window (0, WF_WXYWH, &window_area);
    __calc_window (1, __window [which]._components, &window_area, &full_area);

    /* and do the drag (sounds like a 1910 dance) */

    graf_dragbox (__drag_start.g_w, __drag_start.g_h, __drag_start.g_x, 
                  __drag_start.g_y, full_area.g_x, full_area.g_y,
                  full_area.g_w, full_area.g_h, &__drag_finish.g_x,
                  &__drag_finish.g_y);

    __drag_finish.g_w = __drag_start.g_w;
    __drag_finish.g_h = __drag_start.g_h;
    graf_mkstate (&tox, &toy, &i, &j);
    windchsn = wind_find (tox, toy);
    *target_window = __aesbench (windchsn);

    if (*target_window >= 0) {

      if ((*target_window == which) &&
          (__window [which]._control & WB_DRAGSELF))
        *reply |= WB_DRAG;

      else
      if (__window [which]._control & __window [*target_window]._control &
          WB_DRAGANY)
        *reply |= WB_DRAG;

      *target_object = objc_find (__window [*target_window]._contents, ROOT, 
                                  MAX_DEPTH, tox, toy);

    }

  }

}


