**********************************************************
**********************************************************
 
 
        THIS IS THE BEGINNING OF "INSTAL.C"
 
 
**********************************************************
**********************************************************
 
 
NOTE:   Please review READ_BAT in GIMAIN.C before using this code.
        That piece of code will go out and read any piece of TEXT 
        that you designate as the source for the installation per
        the instructions contained in INSTALL.DOC.
 
 
 
UPLOADED:  September 17, 1985
 
                                        Jim Needham
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "INSTALL.DOC"
 
 
**********************************************************
 
 
 
                             GEM INSTALL
 
GEM INSTALL is a GEM application which reads and processes a "batch"
file named INSTALL.TXT containing DOS-like commands. With those
commands you can create "programs" to automate the installation of GEM
applications.
                      
                     Section 1: Command Summary
 
:<identifier>       - defines a <label>.
    
ALERT <string>      - <string> defines a GEM Alert; when the ALERT
statement is encountered, the Alert is displayed.
 
CHECKVER <number>   - Check for GEM AES version <number>.
 
COPY <source> <dest>- copies <src file> to <dest file>. Both <source>
and <dest> may contain path information and wild cards. 
    
DOS                 - terminates the batch file; control returns to
the GEM DESKTOP.
    
GOTO <label>        - transfer control to <label>.
    
IF1BUTN <label>     - transfer control to <label> if button 1 was used
to exit the Alert defined in the last ALERT statement; also set by
CHECKVER.
    
IF2BUTN <label>     - transfer control to <label> if button 2 was used
to exit the Alert defined in the last ALERT statement; also set by
CHECKVER.
    
IF3BUTN <label>     - transfer control to <label> if button 3 was used
to exit the Alert defined in the last ALERT statement; also set by
CHECKVER.
    
IFFD <label>        - transfer control to <label> if the Desktop is
running on a floppy-disk based system.
    
IFHD <label>        - transfer control to <label> if the Desktop is
running on a hard-disk based system.
    
MD <dir name>       - create directory specified by <dir name>. <dir
name> is in the DOS format.
    
RUN <shell command> - <shell command> contains the information
necessary to do a GEM SHEL_WRITE.
    
SRCMSG <string>     - <string> defines a GEM Alert to be displayed if
an error occurs during a COPY.
             
Section 2: Detailed Explanation of Commands
 
2.1 LABEL command
Syntax:           :<identifier> 
The identifier may be up to eight characters long. The label must be
the only statement on a line.
 
2.2 ALERT command
Syntax:           ALERT <string>
The Alert definition follows the GEM AES format for Alerts, with one
exception. The description may be preceded by a number 1, 2, or 3,
indicating which button is to be the DEFAULT button when the Alert is
displayed. The description may be split across lines if necessary;
however, it may only be split following a | or ]. After splitting a
line, you may insert tabs and/or spaces as desired to align the text
of the Alert. This will have no effect when the Alert is displayed; it
is only to make it easier to visualize how the Alert will look when it
is displayed.
 
For example, consider this GEM AES format Alert description: [1][This
is an example of a large GEM AES|Alert. Notice that it uses the NOTE|
icon, and consists of three lines.][   OK   | Cancel ]
To be used with GEM INSTALL, the above Alert would be defined like
this:
    1[1][This is an example of a large GEM AES|
    Alert. Notice that is uses the NOTE|
    icon, and consists of three lines.][   OK | Cancel ]
Note the 1 preceding the description. This indicates that the OK
button will be the default button when the Alert is displayed. Also
note that the description is broken across lines only after a | or ],
and spaces were inserted to align the text.
    
2.3 CHECKVER Command
Syntax:           CHECKVER <number>
This command is used to compare <number> to the version number of the
GEM AES which is currently running the INSTALL program. Based on that
comparison, one of the IFnBUTN flags is set to TRUE. If the version
number is less than <number>, IF1BUTN is set to TRUE. If the version
number is equal to <number>, IF2BUTN is set to TRUE. If the version
number is greater than <number>, IF3BUTN is set to TRUE. <number> must
be a four-digit hexadecimal number in the same format as the version
number in the GEM AES. For more information about the GEM AES version
number, see the GEM AES manual, section 3.3.
Example:
     CHECKVER 0200
This command checks the current GEM AES version number to see if it is
less than, equal to, or greater than version 2.0. For another example,
see the detailed example in Section 3.2 below.
 
2.4 COPY Command
Syntax:           COPY <source> <dest>
This command is like the DOS COPY command. Both <source> and <dest>
may contain path information and wild cards. For example,
    COPY a:paint.app c:\gemapps\paint.app
 
2.5 DOS command
Syntax:           DOS
This command is required at the end of the batch file. It causes
control to return to the GEM DESKTOP.
 
2.6 GOTO command
Syntax:           GOTO <label>
This command transfers control the <label>. <label> does not contain
the :. See Section 2.1, the LABEL command.
    
2.7 IF1BUTN command
Syntax:           IF1BUTN <label>
This command checks a flag internal to the INSTALL program and if that
flag is TRUE, control transfers to <label>. If the flag is FALSE, no
action is taken. The internal flag is set by ALERT commands and
CHECKVER commands. In the case of ALERTs, the flag is set to TRUE if
the user clicked on button 1 in the most recently processed ALERT.
For CHECKVER commands, the flag is TRUE if the GEM AES version number
is less than the number given in the most recent CHECKVER command.
 
2.8 IF2BUTN command
Syntax:           IF2BUTN <label>
This command is identical to IF1BUTN, except that the flag is TRUE if
either the user clicked on button 2 in the most recently processed
ALERT or if the GEM AES version number is equal to the number given in
the most recent CHECKVER command. 
 
2.9 IF3BUTN command
Syntax:           IF3BUTN <label>
This command is also identical to IF1BUTN, except that the flag is
TRUE if either the user clicked on button 3 in the most recently
processed ALERT or if the GEM AES version number is greater than the
number given in the most recent CHECKVER command. 
 
2.10 IFFD command
Syntax:           IFFD <label>
This command is similar to IF1BUTN in that it also checks a flag
internal to the INSTALL program and if that flag is TRUE, control
transfers to <label>. If the flag is FALSE, no action is taken. Unlike
the IF1BUTN command however, this flag is set only once by the INSTALL
program and remains the same throughout the execution of the program.
The flag is set to TRUE if the INSTALL program finds itself running on
a floppy disk-based system; it is set to FALSE otherwise.
 
2.11 IFHD command
Syntax:           IFHD <label>
This command is similar to the IFFD command; however, the flag is set
to TRUE if INSTALL is running on a hard disk-based system.
 
2.12 MD command
Syntax:           MD <dir name>
Creates the directory specified by <dir name>. <dir name> is in the
DOS format. If the directory already exists, no action is taken.
Example:
    MD c:\gemapps\patterns
 
2.14 RUN Command
Syntax:           RUN <shell command>
This command performs a GEM AES SHEL_WRITE. The <shell command> string
must be in the format specified in the GEM AES manual.
The following example will transfer control to GEM PAINT:
    RUN 1,1,1, paint
 
2.15 SRCMSG command
Syntax:           SRCMSG <string>
<string> defines a GEM Alert to be displayed if an error occurs during
a COPY.
Example:
    SRCMSG 1[3][Can't find the file WYSIWYG.APP][ Cancel ]
 
               Section 3: Examples of INSTALL.TXT files
Sample 3.1
 
ALERT 1[0][Here's a little GEM install "program"!]
[   OK   ]
ALERT 2[1][This "program" will tell you|
           whether we're running on a floppy|
           or hard disk based system.][   OK   | Cancel ]
IF2BUTN END
IFFD FLOPSYS
ALERT 1[1][Seems we're running on a hard|
disk based system.][   OK   ]
GOTO END
:FLOPSYS
ALERT 1[1][Looks to me like we're running on|
a floppy disk based system.][   OK   ]
:END
DOS
 
Sample 3.2
CHECKVER 0200
IF1BUTN OLDGEM
IFFD FDSYS
ALERT 1[0][GEM WYSIWYG will be installed on your|
           hard disk. Click on OK when ready, or|
           Cancel to return to the Desktop.][   OK   | Cancel ]
IF2BUTN EXIT
PATBAT C:
COPY A:\GEMAPPS\WYSIWYG*.* C:\GEMAPPS
GOTO CONTHD
:FDSYS
ALERT 1[0][Make sure you have a formatted floppy|
           disk. It should be labelled GEM WYSIWYG|
           Application Disk. When you are ready,|
           click on OK.][   OK   | Cancel ]
IF2BUTN EXIT
ALERT 1[0][Insert your GEM WYSIWYG Application|
           Disk into drive B.][   OK   ]
MD B:\GEMAPPS
COPY A:\GEMAPPS\WYSIWYG*.* B:\GEMAPPS
ALERT 1[0][Insert your GEM Desktop Disk|into drive A.][   OK   ]
ALERT 1[0][Insert your GEM WYSIWYG Application|Disk into drive B.]
[   OK   ]
MD B:\GEMSYS
COPY A:\COMMAND.COM B:\COMMAND.COM
COPY A:\GEMSYS\OUTPUT.APP B:\GEMSYS
COPY A:\GEMSYS\OUTPUT.RSC B:\GEMSYS
COPY A:\GEMSYS\*.SYS B:\GEMSYS
COPY A:\GEMSYS\*.FNT B:\GEMSYS
ALERT 1[0][You have finished installing GEM WYSIWYG.|
           GEM WYSIWYG is in the GEMAPPS folder on|
           the GEM WYSIWYG Application Disk.][   OK   ]
GOTO EXIT
:CONTHD
ALERT 1[0][You have finished installing GEM WYSIWYG.|
           It is in the GEMAPPS folder.][   OK   ]
GOTO EXIT
:OLDGEM
ALERT 1[3][Sorry-- you're version of GEM|
           is too old to support the features|
           of GEM WYSIWYG. Install the newest|
           GEM and try again.][   OK   ]   
:EXIT
DOS
 
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "BLDINST.BAT"
 
 
**********************************************************
 
 
 
REM ******************************
REM * Build GEM INSTALL 08/01/85 *
REM ******************************
 
rasm86 DOSASM $pzsz
rasm86 GEMASM $pzsz
rasm86 PROEND $pzsz
rasm86 LONGASM $pzsz
rasm86 PROSTART $pzsz
rasm86 TCRTLASM $pzsz
rasm86 PATTXT $pzsz
 
lc1 GIMAIN -s
lc2 GIMAIN -sCODE -v
lc1 GIUTILS -s
lc2 GIUTILS -sCODE -v
lc1 TCRTL -s
lc2 TCRTL -sCODE -v
lc1 DOSBIND -s
lc2 DOSBIND -sCODE -v
lc1 GEMBIND -s
lc2 GEMBIND -sCODE -v
link86 install[i]
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "INSTALL.INP"
 
 
**********************************************************
 
 
 
install.app=prostart,
gimain,
giutils,
pattxt,
gembind,
gemasm,
dosbind,
dosasm,
tcrtl,
tcrtlasm,
longasm,
proend[nop,data[max[0
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "BLDINSTM.BAT"
 
 
**********************************************************
 
 
 
 
 
REM ******************************
REM * Build GEM INSTALL 08/01/85 *
REM ******************************
 
masm tcs ;
masm prostart ;
masm gemasm ;
masm dosasm ;
masm longasm ;
masm tcrtlasm ;
masm pattxt ;
masm proend ;
 
lc1 GIMAIN 
lc2 GIMAIN -v
lc1 GIUTILS 
lc2 GIUTILS -v
lc1 TCRTL 
lc2 TCRTL -v
lc1 DOSBIND 
lc2 DOSBIND -v
lc1 GEMBIND 
lc2 GEMBIND -v
 
link tcs+prostart+gimain+giutils+pattxt+gembind+gemasm+dosbind+dosasm+tcrtl+tcrt
lasm+longasm+proend,install,install/map,,
rename install.exe install.app 
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GIMAIN.C"
 
 
**********************************************************
 
 
 
 
 
 
/*      GIMAIN.C        06/10/85 -- 09/12/85            Gregg Morris    */
/* GEM INSTALL program, based on GEMPREP.C by Don Heiskell              */
/*      Modified        09/10/85 -- 09/17/85            Mitch Smith     */
 
#include "portab.h"
#include "machine.h"
#include "dosbind.h"
 
#define debug    1
#define NUMCMDS  15
#define BUF_SIZE 4096 
 
EXTERN LONG     dos_alloc();
EXTERN UWORD    global[];               /* declared in CRYSIF.C         */
EXTERN WORD     QUIT();
EXTERN WORD     DOS_ERR;
EXTERN BYTE     *cp_alert();
 
GLOBAL WORD     gl_apid;
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     gl_smsg[8];
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     ad_smsg;
GLOBAL LONG     four_k = 4096;
GLOBAL LONG     copy_base;
GLOBAL LONG     dummy;
 
GLOBAL WORD     gl_flags, gl_button, gl_out, gl_spacerr;
GLOBAL WORD     yes, butn1, butn2, butn3, hd_sys, vernum;
GLOBAL WORD     gpatsts;
GLOBAL WORD     SRCBUTN;        /* default exit button for SRCMSG       */
 
GLOBAL BYTE     *bat_base;      /* ptr to base of batch file in memory  */
GLOBAL BYTE     *bat_pc;        /* ptr to current position in batch file*/
GLOBAL BYTE     *batptr;
GLOBAL BYTE     DTA[50]; 
GLOBAL BYTE     bat_buf[BUF_SIZE];
 
GLOBAL BYTE     gpatstr[20];
GLOBAL BYTE     newbyte;        /* hard disk drive letter               */
GLOBAL BYTE     SRCMSG[384];            /* error message for src dsk    */
GLOBAL BYTE     alrt_str[384];          /* space for current alert      */
GLOBAL BYTE     gl_cmd[80], gl_tail[80];
MLOCAL BYTE     *commands[] = { "DOS","ALERT","SRCMSG","PATBAT","COPY","MD",
                                "IF1BUTN","IF2BUTN","IF3BUTN","IFHD","IFFD",
                                "GOTO",":","RUN","CHECKVER" };
 
/************************************************************************/
/* p a r s _ b a t                                                      */
/************************************************************************/
        WORD
pars_bat()
{
/* parse the batch file for a match of the string; return index into    */
/* jump table of matching command.                                      */
        WORD            ii;
        BYTE            *pbat, *matptr;
 
        matptr = commands[0];
        for ( ii = 0; ii < NUMCMDS; ii++ )
        {
          pbat = bat_pc;
          while ( (*matptr) && (*matptr == *pbat) )
          {
            matptr++;
            pbat++;
          } /* while */
          if ( !(*matptr) )
          {
            bat_pc = pbat;
            return(ii);
          } /* if */
          while (*matptr)
            matptr++;
          matptr++;
        } /* for */
        return(ii);
} /* pars_bat */
 
/************************************************************************/
/* c _ r u n                                                            */
/************************************************************************/
        VOID
c_run()
{
        WORD            doex, isgr, isgem;
 
        get_shparms(batptr, &doex, &isgr, &isgem, &gl_cmd[0], &gl_tail[0]);
        shel_write(doex, isgr, isgem, ADDR(&gl_cmd[0]), ADDR(&gl_tail[0]));
} /* c_run */
 
/************************************************************************/
/* c _ a l e r t                                                        */
/************************************************************************/
        BYTE *
c_alert()
{
/* display an alert of made from the given string; return ptr to char   */
/* past end of alert                                                    */
        WORD            ret, def_butn;
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, alrt_str, TRUE, &def_butn );
        ret = form_alert(def_butn, ADDR(alrt_str));
        butn1 = butn2 = butn3 = FALSE;
        if (ret == 1)
          butn1 = TRUE;
        if (ret == 2)
          butn2 = TRUE;
        if (ret == 3)
          butn3 = TRUE;
        return(new_ptr);
} /* c_alert */
 
/************************************************************************/
/* c _ c o p y                                                          */
/************************************************************************/
        VOID
c_copy()
{
        WORD            ii, jj, ambigfn, ret;
        BYTE            srcpth[80];
        BYTE            srcstr[80];
        BYTE            desstr[80];
        BYTE            tmpst1[80];
        BYTE            tmpst2[80];
        BYTE            *ps, *pd;
        static BYTE     slash[] =  "\\"; 
 
        graf_mouse(2, 0x0L);                    /* hourglass            */
        ps = batptr;
        while ( *ps == ' ' )
          ps++;
        ii = 0;
        ambigfn = FALSE;
        pd = srcstr;
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
        {
          *pd = *ps;
          if ( (*pd == '*') || (*pd == '?') )
            ambigfn = TRUE;
          pd++;
          ps++;
          ii++;
        } /* while */
        *pd = NULL;
        if ( ii > 0 )
        {
          pd = desstr;
          while ( *ps == ' ' )
            ps++;
          jj = 0;
          while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          {
            *pd++ = *ps++;
            jj++;
          } /* while */
          *pd = NULL;
          --pd;
          if ( ambigfn )
          {
            expath( srcstr, srcpth );
            dos_sfirst( ADDR( srcstr ), 0x0000 );
            while ( !DOS_ERR )
            {
              tmpst1[0] = NULL;
              tmpst2[0] = NULL;
              strcat(tmpst1, srcpth);
              strcat( tmpst1, &DTA[30] );
              strcat( tmpst2, desstr );
              if ( (jj == 0) || (*pd == ':') )
                strcat( tmpst2, &DTA[30] ); 
              else 
              {
                strcat( tmpst2, &slash[0] );    /* add required slash   */
                strcat( tmpst2, &DTA[30] );     /* add fname from src   */
              }
              ret = fcopy( tmpst1, tmpst2 );
              if (!ret)
              {
                if (gl_spacerr)
                  form_alert(1, ADDR("[3][There is not enough free space on the|
\
disk to complete this copy. Your|installation may not be complete.][   OK   ]"))
;
                gl_spacerr = FALSE;
                return;
              } /* if !ret */
              dos_snext();
            } /* while !DOS_ERR */
          } /* if ambigfn */
          else
          {
            exfname( srcstr, tmpst1 );
            if ( (jj == 0) || *pd == ':' )
              strcat( desstr, tmpst1 ); 
            else if ( valpath( desstr ) )
            {
              strcat( desstr, &slash[0] );      /* add required slash   */
              strcat( desstr, tmpst1 );         /* add fname from src   */
            } /* else if */
            ret = fcopy( srcstr, desstr );
            if (!ret)
            {
              if (gl_spacerr)
                form_alert(1, ADDR("[3][There is not enough free space on the|\
disk to complete this copy. Your|installation may not be complete.][   OK   ]"))
;
              gl_spacerr = FALSE;
              return;
            } /* if !ret */
          } /* else */
        } /* if ii > 0 */
        graf_mouse(0, 0x0L);
#if debug
        form_alert(1, ADDR("[0][A copy command was encountered.][   OK   ]"));
#endif
} /* c_copy */
 
/************************************************************************/
/* c _ m d                                                              */
/************************************************************************/
        VOID
c_md()
{
/* make a directory                                                     */
        LONG            plong;
        BYTE            chars[80];
 
        mov_wstr( batptr, chars );
        plong = ADDR( chars );
        dos_mkdir( plong );
#if debug
        form_alert(1, ADDR("[0][Made a directory][   OK   ]"));
#endif
} /* c_md */
 
/************************************************************************/
/* c _ g e t d r v                                                      */
/************************************************************************/
        VOID
c_getdrv()
{
        UWORD           drives, hd_flop, mask;
        WORD            ii;
 
        drives = global[13];
        hd_flop = global[14];
        if (hd_flop)                    /* must be a hard-disk system   */
        {
          hd_sys = TRUE;
          mask = 0x0001;
                                /* get the lowest lettered hard disk    */
          for (ii = 15; ii >= 0; ii--)
          {
            if (mask & drives)
            {
              if (mask & hd_flop)
                newbyte = ii + 'A';
            } /* if mask & drives */
            mask <<= 1;
          } /* for */
        } /* if hd_flop */
        else
          hd_sys = FALSE;
} /* c_getdrv */
 
/************************************************************************/
/* c _ p a t b a t                                                      */
/************************************************************************/
        VOID
c_patbat()
{
        BYTE            oldstr[20];
        BYTE            *tmpptr, *ptxt, *matptr;
 
        matptr = bat_pc;
        ptxt = bat_pc;
        mov_wstr( bat_pc, oldstr );
        tmpptr = oldstr;
        while (*ptxt != 0x1A)
        {
          if ( *tmpptr != *ptxt )
          {
            tmpptr = oldstr;
            ptxt++;
            matptr = ptxt;
          }
          else
          {
            while ( (*tmpptr == *ptxt) && (*tmpptr) )
            {
              ptxt++;
              tmpptr++;
            } /* while */
            if (*tmpptr)
              matptr = ptxt;
            else
            {
              tmpptr = oldstr;
              *matptr = newbyte;
            } /* else */
          } /* else */
        } /* while */
} /* c_patbat */
 
/************************************************************************/
/* c _ i f 1 b u t n                                                    */
/************************************************************************/
        VOID
c_if1butn()
{
        if (butn1)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF1BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if1butn */
 
/************************************************************************/
/* c _ i f 2 b u t n                                                    */
/************************************************************************/
        VOID
c_if2butn()
{
        if (butn2)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF2BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if2butn */
 
/************************************************************************/
/* c _ i f 3 b u t n                                                    */
/************************************************************************/
        VOID
c_if3butn()
{
        if (butn3)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF3BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if3butn */
 
/************************************************************************/
/* c _ i f h d                                                          */
/************************************************************************/
        VOID
c_ifhd()
{
        if (hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFHD statement was encountered.][   OK   ]"))
;
#endif
} /* c_ifhd */
 
/************************************************************************/
/* c _ i f f d                                                          */
/************************************************************************/
        VOID
c_iffd()
{
        if (!hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFFD statement was encountered.][   OK   ]"))
;
#endif
} /* c_iffd */
 
/************************************************************************/
/* c _ g o t o                                                          */
/************************************************************************/
        VOID
c_goto()
{
        gotob();
#if debug
        form_alert(1, ADDR("[0][A GOTO statement was encountered.][   OK   ]"));
#endif
} /* c_goto */
 
/************************************************************************/
/* c _ l a b e l                                                        */
/************************************************************************/
        VOID
c_label()
{
#if debug
        form_alert(1, ADDR("[0][A LABEL was encountered.][   OK   ]"));
#endif
} /* c_label */
 
/************************************************************************/
/* c _ s r c m s g                                                      */
/************************************************************************/
        BYTE *
c_srcmsg()
{
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, SRCMSG, TRUE, &SRCBUTN );
#if debug
        form_alert(1, ADDR("[0][A SRCMSG definition was encountered.][   OK   ]"
));
#endif
        return(new_ptr);
} /* c_srcmsg */
 
/************************************************************************/
/* c _ c h k v e r                                                      */
/************************************************************************/
        VOID
c_chkver()
{
        UWORD           testnum;
        BYTE            *ps;
 
        ps = batptr;
        while ( *ps == ' ' )                    /* skip spaces          */
          ps++;
        testnum = make_hnum(ps);
        butn1 = butn2 = butn3 = FALSE;
        if (vernum < testnum)
          butn1 = TRUE;
        else if (vernum == testnum)
          butn2 = TRUE;
        else if (vernum > testnum)
          butn3 = TRUE;
#if debug
        form_alert(1, ADDR("[0][A CHECKVER statement was encountered.][   OK   ]
"));
#endif
} /* c_chkver */
 
/************************************************************************/
/* r e a d _ b a t                                                      */
/************************************************************************/
        VOID
read_bat()
{
        LONG            plong;
        LONG            count;
        WORD            handle, ret;
        static BYTE             no_txt[] = 
"[3][INSTALL can't find the INSTALL.TXT|file. Insert the disk containing|\
INSTALL.TXT and try again.][ Cancel ]";
 
        static BYTE     *APATH = { "A:\\" };
        static BYTE     *BATCH = { "INSTALL.TXT" };
 
        dos_sdrv( 0 );                          /* select drive A       */
        plong = ADDR( APATH );
        dos_chdir( plong );
        plong = ADDR( BATCH );
 
        handle = dos_open( ADDR("A:\\INSTALL.TXT"), 0 );
        if ( DOS_ERR )
        {
          form_alert(1, ADDR(no_txt)); 
          dos_free( dummy );
          ret = appl_exit(); 
          QUIT();
        } /* if DOS_ERR */
 
        bat_base = &bat_buf[0];
        bat_pc = bat_base;
        count = read_piece( handle, BUF_SIZE, ADDR(&bat_buf[0]) );
        dos_close( handle );
} /* read_bat */
 
/************************************************************************/
/* g o t o b                                                            */
/************************************************************************/
        VOID
gotob()
{
        WORD            status, advance;
        BYTE            matstr[80];
        BYTE            labstr[80];
        BYTE            *ptr;
 
        mov_wstr( batptr, matstr );             /* get the label        */
        if ( matstr[0] )
        {
          status = FALSE;
          advance = FALSE;
          ptr = bat_base;
          while (!status)
          {
            if ( *ptr == 0x1A )
            {
              status = TRUE;
              ptr = batptr;
            } /* if */   
            else if ( *ptr++ == ':' )
            {
              mov_wstr( ptr, labstr );
              status = cmp_str( labstr, matstr );
            } /* else if */
          } /* while */
          ptr += 2;
          bat_pc = ptr;     
        } /* if */
} /* gotob */
 
/************************************************************************/
/* G E M A I N                                                          */
/************************************************************************/
        VOID
GEMAIN()
{
        WORD            notend, ret, advance;
                                                /* initialize libraries */
        gl_apid = appl_init();
        vernum = global[0];                     /* get version number   */
                                /* find out what drives we've got       */
        hd_sys = FALSE;                 /* default is floppy system     */
        c_getdrv();
        
        ad_rmsg = ADDR(&gl_rmsg[0]);
        ad_smsg = ADDR(&gl_smsg[0]);
                                                /* initialize mouse     */
        graf_mouse(0, 0x0L);
 
        gpatsts = FALSE;
        dummy = dos_alloc( four_k );
        dos_sdta( ADDR( DTA ) );
        read_bat();
#if debug
        form_alert(1, ADDR("[0][Read the bat file ok.][   OK   ]"));
#endif
                                                /* init alert buttons   */
        butn1 = butn2 = butn3 = FALSE;
        advance = FALSE;
        notend = gl_spacerr = TRUE;
        while ( notend )
        {
          dos_sdta( ADDR( DTA ) );
          notend = pars_bat();
          batptr = bat_pc;
          switch(notend)
          {
            case 0:                     /* formerly c_dos();            */
                notend = FALSE;
                advance = FALSE;
                break;
            case 1:
                bat_pc = c_alert();
                advance = FALSE;
                break;
            case 2:
                bat_pc = c_srcmsg();
                advance = FALSE;
                break;
            case 3:
                c_patbat();
                advance = TRUE;
                break;
            case 4:
                c_copy();
                advance = TRUE;
                break;
            case 5:
                c_md();
                advance = TRUE;
                break;
            case 6:
                c_if1butn();
                advance = TRUE;
                break;
            case 7:
                c_if2butn();
                advance = TRUE;
                break;
            case 8:
                c_if3butn();
                advance = TRUE;
                break;
            case 9:
                c_ifhd();
                advance = TRUE;
                break;
            case 10:
                c_iffd();
                advance = TRUE;
                break;
            case 11:
                c_goto();
                advance = TRUE;
                break;
            case 12:
                c_label();
                advance = TRUE;
                break;
            case 13:
                c_run();
                advance = FALSE;
                notend = FALSE;
                break;
            case 14:
                c_chkver();
                advance = TRUE;
                break;
          } /* switch */
          if (advance)
            notend = nextline();
        } /* while */
        dos_free( dummy ); 
        ret = appl_exit();
        QUIT(); 
 
} /* GEMAIN */
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GIUTILS.C"
 
 
**********************************************************
 
 
 
 
 
 
/*      GIUTILS.C       06/10/85 -- 09/12/85            Gregg Morris    */
/* Utility routines for GEM INSTALL                                     */
 
#include "portab.h"
#include "machine.h"
#include "dosbind.h"
 
#define CR 0x0D
#define TAB 0x09
 
EXTERN LONG     dos_avail();
EXTERN LONG     dos_alloc();
EXTERN WORD     DOS_ERR;
 
EXTERN WORD     yes, butn1, butn2, butn3;
EXTERN WORD     gpatsts;
EXTERN WORD     SRCBUTN;
EXTERN BYTE     *bat_base;
EXTERN BYTE     *bat_pc;
EXTERN BYTE     *batptr;
EXTERN BYTE     DTA[50];
EXTERN BYTE     err_ret;
EXTERN BYTE     newbyte;
EXTERN BYTE     SRCMSG[255];            /* error message for src dsk    */
 
LONG            gl_xbuf;                /* data xfer buffer     */
UWORD           gl_xlen;
 
/************************************************************************/
/* g e t _ s h p a r m s                                                */
/************************************************************************/
        VOID
get_shparms(pstr, pdoex, pisgr, pisgem, pcmd, ptail)
        BYTE            *pstr;
        WORD            *pdoex, *pisgr, *pisgem;
        BYTE            *pcmd, *ptail;
{
        WORD            ii, jj;
        BYTE            *ps;
 
        ps = batptr;
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* get the codes        */
        *pdoex = *ps++ - '0';
        ps++;
        *pisgr = *ps++ - '0';
        ps++;
        *pisgem = *ps++ - '0';
        ps++;
                                                /* get the command      */
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          *pcmd++ = *ps++;
        *pcmd = NULL;
        if (*ps == 0x0D)
          ps += 2;
        else
          ps++;
                                                /* get the tail         */
        ii = 1;
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          ptail[ii++] = *ps++;
        ptail[ii] = NULL;
                                        /* compute length of tail       */
/*      ii = 1;
        jj = 0;
        while (ptail[ii++])
          jj++;*/
        ptail[0] = strlen(ptail[1]);
} /* get_shparms */
 
/************************************************************************/
/* m o v _ w s t r                                                      */
/************************************************************************/
        BYTE *
mov_wstr(ps, pd)
        BYTE    *ps, *pd;
{
/* given a string terminated by <CR>, <LF>, or <SPACE>, this routine    */
/* strips off leading blanks & returns an ASCII Z terminated string.    */
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* copy the string      */
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          *pd++ = *ps++;
        *pd = NULL;
        return(ps);
} /* mov_wstr */
 
/************************************************************************/
/* n e x t l i n e                                                      */
/************************************************************************/
        WORD
nextline()
{
/* move the batch file pointer to the next line of the file             */
 
        while ( (*bat_pc != 0x0D) && (*bat_pc != 0x1A ) )
          bat_pc++;
        if ( *bat_pc == 0x1A )
          return(FALSE);                                        /* EOF-- exit   
*/
        if (*bat_pc == 0x0D)
          bat_pc += 2;
        return(TRUE);
} /* nextline */
 
/************************************************************************/
/* m o v _ s t r                                                        */
/************************************************************************/
        VOID
mov_str( ps, pd )
        BYTE            *ps, *pd;
{
/* given a string terminated by <CR> or <LF>, this routine strips off   */
/* leading blanks & returns an ASCII Z terminated string.               */
        while ( *ps == ' ' )
          ps++;
        while ( (*ps != 0x0A) && (*ps != 0x0D) )
          *pd++ = *ps++;
        *pd = NULL;
} /* mov_str */
 
/************************************************************************/
/* c p _ a l e r t                                                      */
/************************************************************************/
        BYTE *
cp_alert( ps, pd, butn_flag, pbutn )
        BYTE            *ps, *pd;
        WORD            butn_flag, *pbutn;
{
/* given a pointer to an alert string, this routine strips off leading  */
/* blanks, removes internal <CRLF> & returns a null-terminated string   */
/* in pd. also returns pointer to char. past end of alert.              */
/* note that an alert string may only have <CRLF> after a | or ]        */
        WORD            done;
        BYTE            chr;
                                                /* skip leading blanks  */
        while ( *ps == ' ' )
          ps++;
        *pd = NULL;
 
        if (butn_flag)
        {                       /* pick up default button, if any       */
          *pbutn = 0;
          if (*ps != '[')
            *pbutn = *ps++ - '0';
        } /* if butn_flag */
                                        /* scan string for <CRLF>       */
        done = FALSE;
        while (!done)
        {
          chr = *ps;
          switch(chr)
          {
            case '|':
                *pd++ = *ps++;
                if (*ps == CR)
                {                               /* skip <CRLF>          */
                  ps += 2;
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                } /* if CR */
                break;
            case ']':
                *pd++ = *ps++;
                if (*ps == CR)
                {
                  ps += 2;                      /* skip <CRLF>          */
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                  if (*ps != '[')
                    done = TRUE;
                } /* if */
                break;
            case CR:
                ps += 2;
                done = TRUE;
                break;
            default:
                *pd++ = *ps++;
                break;
          } /* switch */
        } /* while */
        *pd = NULL;
        return(ps);
} /* cp_alert */
 
/************************************************************************/
/* f c o p y                                                            */
/************************************************************************/
        WORD
fcopy( ps, pd )
        BYTE            *ps, *pd;
{
/* copy file ps to file pd                                              */
        LONG            lbase, lavail;
        UWORD           amt_read, amt_wrote;
        UWORD           fsrc, fdst;             /* file handles         */
        WORD            ret;
 
                                        /* allocate memory for buffer   */
        lavail = dos_avail();
        gl_xlen = (lavail > 0x0000FFF0L) ? 0xFFF0 : LLOWD(lavail);
        gl_xlen -= 0x0200;
        gl_xbuf = dos_alloc(LW(gl_xlen));
                                                /* open source file     */
        fsrc = dos_open (ADDR(ps), 0);
        while ( DOS_ERR )
        {
          ret = form_alert(SRCBUTN, ADDR(&SRCMSG[0]));
          if (ret > 1)
            return(FALSE);
          fsrc = dos_open( ADDR(ps), 0 );
        } /* while */
                                        /* create destination file      */
        fdst = dos_create (ADDR (pd), 0);
        if ( DOS_ERR )
        {
          form_alert(0, ADDR("[3][Can't create the file during copy.][ Cancel ]"
) );
          dos_close(fsrc);     
          return(FALSE);
        } /* if DOS_ERR */
                                                /* do the copy          */
        lbase = 0x0L;
        while ( amt_read = read_piece (fsrc, gl_xlen, gl_xbuf) )
        {
          amt_wrote = amt_read;
          if ( amt_wrote != write_piece (fdst, amt_wrote, gl_xbuf) )
          {                                           /* file system error */
            dos_close(fsrc);     
            dos_close(fdst);
            return(FALSE);
          } /* if */
 
          lbase += (LONG) amt_wrote;
          if (amt_read != amt_wrote)
            dos_lseek(fsrc, 0, lbase);
        } /* while */
                                                /* close the files      */      
        dos_close (fsrc);
        dos_close (fdst);
                                                /* free the buffer      */
        dos_free(gl_xbuf, gl_xlen);
        return(TRUE);
} /* fcopy */
 
/************************************************************************/
/* v a l p a t h                                                        */
/************************************************************************/
        WORD
valpath( ptr )
        BYTE    *ptr;
{
/* returns TRUE if path is valid; FALSE otherwise                       */
 
        WORD            ii;
 
        ii = FALSE;
        dos_sfirst( ADDR( ptr ), 0x0010 );
        if ( (DOS_ERR == 0) && (DTA[21] & 0x10) )
          ii = TRUE;
        return( ii );
} /* valpath */
 
/************************************************************************/
/* e x f n a m e                                                        */
/************************************************************************/
        VOID
exfname( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the end of the string past any slashes or colons */
        BYTE            *ptr;
 
        ptr = ps;
        while ( *ptr != NULL )
        {
          if ( (*ptr == ':') || (*ptr == '\\') )
          {
            ptr++;
            ps = ptr;
          } /* if */
          else
            ptr++;
        } /* while */
        while ( *pd++ = *ps++ )
        ;
} /* exfname */
 
/************************************************************************/
/* e x p a t h                                                          */
/************************************************************************/
        VOID
expath( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the head of the path minus filename */
        BYTE            *ptr;
        WORD            ii;
 
        ii = FALSE;
        while ( *ps != NULL )
        {
          if ( (*ps == ':') || (*ps == '\\') )
          {
            ptr = pd;
            ptr++;
            ii = TRUE;
          } /* if */
          *pd++ = *ps++;
        } /* while */
        if ( ii )
          *ptr = '\0';
} /* expath */
 
/************************************************************************/
/* c m p _ s t r                                                        */
/************************************************************************/
        WORD
cmp_str( pa, pb )
        BYTE    *pa,*pb;
{
        WORD            ii;
 
        while ( (*pa == *pb) && (*pa) )
        {
          pa++;
          pb++;
        } /* while */
        ii = FALSE;
        if ( (*pa == NULL) && (*pb == NULL) )
          ii = TRUE;
        return(ii);
} /* cmp_str */
 
/*************************************************************/
/* i n i t f c b                                                        */
/************************************************************************/
        VOID
initfcb( ptr )
        BYTE    *ptr;
{
        WORD    ii;
        BYTE    *ptr1;
 
        ptr1 = ptr;
        for ( ii = 0; ii < 37; ii++ )
          *ptr++ = NULL;
        ptr1++;
        for ( ii = 0; ii < 11; ii++ )
        *ptr1++ = ' ';
} /* initfcb */
 
/************************************************************************/
/* m a k e _ h n u m                                                    */
/************************************************************************/
        WORD
make_hnum(pstr)
        BYTE            *pstr;
{
/* take the given 4-char. string & return a hex number: 0-FFFF          */
        WORD            num, factor, idx;
        BYTE            chr;
 
        num = 0;
        if (!pstr)
          return(num);
                                        /* pick off digits              */
        idx = 3;
        factor = 1;
        while (idx >= 0)
        {
          chr = pstr[idx];
          if (chr >= 'A' && chr <= 'F')
            num += (chr - 'A' + 0x0A) * factor;
          else if (chr >= '0' && chr <= '9')
            num += (chr - '0') * factor;
          factor *= 16;
          idx--;
        } /* while */
        return(num);
} /* make_hnum */
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "PATTXT.A86"
 
 
**********************************************************
 
 
 
 
 
;/*     PATTXT.A86                                      */
 
        cseg
;
        PUBLIC  pat_txt , quit
 
 
;es:si = ptxt
;es:di = matptr
;ds:bx = tmpptr
;
pat_txt:
        push    bp                      ;   ptxt = bat_pc                       
        mov     bp, sp
        mov     si, 4[bp]
        mov     ax, 6[bp]
        mov     es, ax
        mov     di, si                                  
                                        ;    matptr = bat_pc
        mov     bx, offset gpatstr      ;    tmpptr = oldstr
 
pat_txt_while:
        cmp     es: byte ptr[si], 1ah   ;    while (*ptxt!= 0x1a)
        jz      pat_txt_while_done      ;    {
 
        mov     al, [bx]                ;       if ( *tmpptr != *ptxt )
        cmp     al, es:[si]
        jz      pat_txt_else
                                        ;       {
        mov     bx, offset gpatstr      ;           tmpptr = oldstr
        inc     si                      ;           ptxt++
        mov     di, si                  ;           matptr = ptxt
        jmps    pat_txt_while           ;       }
 
pat_txt_while_done:
        pop     bp
        ret
 
pat_txt_else:                           ;       else
        mov     al, [bx]                ;       {
                                        ;         while ( (*tmpptr == *ptxt) && 
(*tmpptr != '\0') )
        and     al, al                  ;         {
        jz      pat_txt_else_done       
        cmp     al, es:[si]
        jnz     pat_txt_else_done
        inc     bx
        inc     si                      ;           ptxt++
        jmps    pat_txt_else            ;           tmpptr++
                                        ;         }
pat_txt_else_done:
        mov     al, [bx]                ;         if ( *tmpptr != '\0' )
        and     al, al
        jz      pat_txt_else_done_else
        mov     di, si                  ;           matptr = ptxt
        jmps    pat_txt_while
 
pat_txt_else_done_else:                 ;         else
                                        ;         {
        mov     bx, offset gpatstr      ;           tmpptr = oldstr
        mov     al, newbyte
        mov     es: [di], al            ;           *matptr = newbyte
        jmps    pat_txt_while           ;         }     
                                        ;       }
 
 
quit:
        mov     ax,04c00h
        int     21h
 
 
        dseg
extrn   gpatstr:byte
extrn   newbyte:byte
        end
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "PATTXT.ASM"
 
 
**********************************************************
 
 
 
 
 
 
;/* PATTXT.ASM                                  */
 
PGROUP  GROUP   PROG
DGROUP  GROUP   DATA
;
 
DATA    SEGMENT PARA    PUBLIC  'DATA'
 
extrn   gpatstr:byte
extrn   newbyte:byte
 
DATA    ENDS
 
PROG    SEGMENT BYTE PUBLIC 'PROG'
        ASSUME  CS:PGROUP
;
        PUBLIC  pat_txt , quit
 
 
;es:si = ptxt
;es:di = matptr
;ds:bx = tmpptr
;
pat_txt:
        push    bp                      ;   ptxt = bat_pc                       
        mov     bp, sp
        mov     si, 4[bp]
        mov     ax, 6[bp]
        mov     es, ax
        mov     di, si                                  
                                        ;    matptr = bat_pc
        mov     bx, offset gpatstr      ;    tmpptr = oldstr
 
pat_txt_while:
        cmp     es: byte ptr[si], 1ah   ;    while (*ptxt!= 0x1a)
        jz      pat_txt_while_done      ;    {
 
        mov     al, [bx]                ;       if ( *tmpptr != *ptxt )
        cmp     al, es:[si]
        jz      pat_txt_else
                                        ;       {
        mov     bx, offset gpatstr      ;           tmpptr = oldstr
        inc     si                      ;           ptxt++
        mov     di, si                  ;           matptr = ptxt
        jmp     pat_txt_while           ;       }
 
pat_txt_while_done:
        pop     bp
        ret
 
pat_txt_else:                           ;       else
        mov     al, [bx]                ;       {
                                        ;         while ( (*tmpptr == *ptxt) && 
(*tmpptr != '\0') )
        and     al, al                  ;         {
        jz      pat_txt_else_done       
        cmp     al, es:[si]
        jnz     pat_txt_else_done
        inc     bx
        inc     si                      ;           ptxt++
        jmp     pat_txt_else            ;           tmpptr++
                                        ;         }
pat_txt_else_done:
        mov     al, [bx]                ;         if ( *tmpptr != '\0' )
        and     al, al
        jz      pat_txt_else_done_else
        mov     di, si                  ;           matptr = ptxt
        jmp     pat_txt_while
 
pat_txt_else_done_else:                 ;         else
                                        ;         {
        mov     bx, offset gpatstr      ;           tmpptr = oldstr
        mov     al, ds:newbyte         
        mov     es: [di], al
        jmp     pat_txt_while           ;         }     
                                        ;       }
 
 
quit:
        mov     ax,04c00h
        int     21h
 
PROG    ENDS
        end
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE END OF "INSTAL.C"
 
 
**********************************************************
**********************************************************
