The portion of this code used by the file selector was modified
on September 9th, 1985.
 
This code is provided to you to use and modify as you see fit.
 
 
Uploaded:       September 9, 1985
 
 
                                        Jim Needham
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE BEGINNING OF "RECORD.C"
 
 
**********************************************************
**********************************************************
 
 
 
 
 
                   GEM Tape Recorder Desk Accessory
 
     The Tape Recorder is a GEM Desk Accessory that records and plays
a sequence of GEM events: mouse movement, mouse button clicks,
keyboard characters, and menu selections. The "tapes" thus created are
stored in files for use primarily with the GEM Tutorial accessory.
The Tape Recorder only records events, so it has no knowledge of the
underlying state of the program. This means that context is always
critical when playing a tape. For example, if you make a tape at the
Desktop to double-click on an icon to open it, the icon must always be
in the same place when the tape is played or unpredictable things will
happen.
     To use the Tape Recorder, choose "Tape Recorder" from the Desk
menu.  The Tape Recorder has four buttons: LOAD, TAPE, SAVE, and PLAY.
It also has buttons to choose the playback speed, and an indicator of
playback position.
 
Section 1. The Buttons
 
1.1 LOAD
Clicking on the LOAD button displays the file selector, allowing you
to choose the tape file to load. Tapes have the file type .TAP.
 
1.2 TAPE
Click on TAPE to begin recording. The Tape Recorder closes and all
following events are recorded. The maximum tape length is 1000 events.
This is hard to judge when recording a tape, so when the tape is full,
the Tape Recorder re-opens and the bell sounds. Taping may be halted
at any time by holding the control key and pressing the backslash (\)
key. This allows tapes of any size, up to the maximum, to be created.
 
1.3 SAVE
Clicking on SAVE displays the file selector, allowing you to name the
tape you have just created. Tape files have the file extension .TAP.
 
1.4 PLAY
PLAY closes the Tape Recorder and plays back the current tape.  When
the tape is finished, the bell is sounded and the Tape Recorder is
re-opened.
 
Section 2. The Speed Buttons
 
2.1 0.05 x
This button sets the playback speed to one twentieth of normal
playback speed. 
 
2.2 0.5 x
This button sets the playback speed to one-half of normal playback
speed.
 
2.3 1 x
This button sets the playback speed to normal.
 
2.4 2 x
This button sets the playback speed to twice normal playback speed. 
 
2.5 20 x
This button sets the playback speed to twenty times normal playback
speed. 
 
Section 3. The Position Indicator
 
The position indicator is used to place the tape at any given point
prior to playback. There are two ways to set the position: by moving
the elevator, or clicking in the slider. The counter indicates the
position of the elevator within the slider, relative to the length of
the current tape.
 
Section 4. Using the Tape Recorder
 
The best way to learn to use the Tape Recorder is to play with it.
Here's an example of making a simple tape.
1. At the Desktop, choose the Tape Recorder from the Desk menu.
2. Click on the TAPE button.
3. Move the mouse around. Move up into the menu bar and make a menu
drop down. Then move out of the menu and click, to make the menu go
away.
4. Press the magic STOP keys: CTRL-backslash (\).
5. When the Tape Recorder re-opens, click on the PLAY button and watch
what happens.
 
When finished with the Tape Recorder, click on the close button. Note
that if you open the Tape Recorder, load or make a tape, then close
the Tape Recorder and re-open it, the last tape loaded will still be
available for playback or saving. This is useful when making a tape
and testing it, since you can close the Tape Recorder to return the
application to the state before you made the tape, then re-open the
Tape Recorder and play the tape still in it.
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE BEGINNING OF "RECORD.C"
 
 
**********************************************************
**********************************************************
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPE.BAT"
 
 
**********************************************************
 
 
rasm86 accstart.a86 $pzsz
lc1 tape -s
lc2 tape -scode -v
lc1 tapeutil -s
lc2 tapeutil -scode -v
lc1 gembind -s
lc2 gembind -scode -v
rasm86 gemasm.a86 $pzsz
lc1 vdibind -s
lc2 vdibind -scode -v
rasm86 vdiasm.a86 $pzsz
lc1 dosbind -s
lc2 dosbind -scode -v
rasm86 dosasm.a86 $pzsz
lc1 tcrtl -s
lc2 tcrtl -scode -v
rasm86 tcrtlasm.a86 $pzsz
rasm86 longasm.a86 $pzsz
link86 tape[i]
copy tae.acc \gemboot
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPM.BAT"
 
 
**********************************************************
 
 
masm tcs ;
masm accstart ;
lc1 tape 
lc2 tape -v
lc1 tapeutil
lc2 tapeutil -v
lc1 gembind 
lc2 gembind -v
masm gemasm ;
lc1 vdibind
lc2 vdibind -v
masm vdiasm ;
lc1 dosbind
lc2 dosbind -v
masm dosasm ;
lc1 tcrtl
lc2 tcrtl -v
masm tcrtlasm ;
masm longasm ;
masm proend ;
link tcs+accstart+tape+tapeutil+gembind+gemasm+vdibind+vdiasm+dosbind+dosasm+tcr
tl+tcrtlasm+longasm+proend,tape,tape/map,,
copy tape.exe \gemboot\tape.acc
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPE.INP"
 
 
**********************************************************
 
 
tape.acc = accstart,
tape,
tapeutil,
gembind,
gemasm,
vdibind,
vdiasm,
dosbind,
dosasm,
tcrtl,
tcrtlasm,
longasm[nop,data[max[0 
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPE.C"
 
 
**********************************************************
 
 
/*      TAPE.C          10/18/84 - 03/22/85     ANDREW MUIR     */
/*      modified        07/18/85 - 07/24/85     Gregg Morris    */
/*      modified        09/02/85 - 09/09/85     Mitch Smith     */
 
 
/*------------------------------*/
/*      include files           */
/*------------------------------*/
 
#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <treeaddr.h>
#include <gembind.h>
#include <tapedef.h>
#include <tape.h>
 
/*------------------------------*/
/*      defines                 */
/*------------------------------*/
 
#define debug 0
 
 
/*------------------------------*/
/*      external functions      */
/*------------------------------*/
 
EXTERN LONG     ini_tape();
 
 
/*------------------------------*/
/*      global variables        */
/*------------------------------*/
 
GLOBAL EVENT    gl_evlist[MAX_EVNTS];
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     gl_tape;
 
GLOBAL WORD     gl_apid;
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     wh_tape;
GLOBAL WORD     gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk;
GLOBAL WORD     gl_width, gl_height;
GLOBAL WORD     gl_wchar, gl_hchar;
GLOBAL WORD     gl_wbox, gl_hbox;
GLOBAL WORD     gl_xclip, gl_yclip, gl_wclip, gl_hclip;
GLOBAL WORD     gl_xtape, gl_ytape, gl_wtape, gl_htape;
GLOBAL WORD     gl_handle;
GLOBAL WORD     contrl[11];
GLOBAL WORD     intin[128];
GLOBAL WORD     ptsin[128];
GLOBAL WORD     intout[128];
GLOBAL WORD     ptsout[128];
 
GLOBAL WORD     gl_ittape;
GLOBAL WORD     gl_flags;
GLOBAL WORD     gl_button;
GLOBAL WORD     gl_ignore;
GLOBAL WORD     gl_numevnts;
 
GLOBAL BYTE     def_path[64];
GLOBAL BYTE     gl_pfname[76];
 
/****************************************************************/
/* d o _ r e d r a w                                            */
/****************************************************************/
        WORD
do_redraw(w_handle, xc, yc, wc, hc, which_ob, depth)
        WORD            w_handle;
        WORD            xc, yc, wc, hc;          
        WORD            which_ob;
        WORD            depth;
{
        WORD            x, y, w, h;
 
        graf_mouse(M_OFF, 0x0l);
        wind_update(TRUE);
 
        wind_get(w_handle, WF_FIRSTXYWH, &x, &y, &w, &h);
        while ( w && h )
        {
                if ( rc_intersect( &xc, &x ) )
                        objc_draw(gl_tape, which_ob, depth, x, y, w, h);
                wind_get(w_handle, WF_NEXTXYWH, &x, &y, &w, &h);
        }
        
        wind_update(FALSE);
        graf_mouse(M_ON, 0x0L);
}  /* do_redraw */  
 
/*------------------------------*/
/*      rc_intersect            */
/*------------------------------*/
WORD
rc_intersect(p1, p2)                    /* compute intersect of */
                                        /*  two rectangles      */
GRECT           *p1, *p2;
{
        WORD            tx, ty, tw, th;
 
        tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
        th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
        tx = max(p2->g_x, p1->g_x);
        ty = max(p2->g_y, p1->g_y);
        p2->g_x = tx;
        p2->g_y = ty;
        p2->g_w = tw - tx;
        p2->g_h = th - ty;
        return( (tw > tx) && (th > ty) );
}
 
/*------------------------------*/
/*      min                     */
/*------------------------------*/
WORD
min(a, b)                               /* return min of        */
                                        /* two values           */
WORD            a, b;
{
        return( (a < b) ? a : b );
}
 
/*------------------------------*/
/*      max                     */
/*------------------------------*/
WORD
max(a, b)                               /* return max of        */
                                        /* two values           */
WORD            a, b;
{
        return( (a > b) ? a : b );
}
 
/****************************************************************/
/* h n d l _ m e s a g                                          */
/****************************************************************/
        WORD
hndl_mesag()
{
        LONG            tree;
        WORD            done;
        WORD            x, y, w, h;
 
        done = FALSE;
        switch( gl_rmsg[0] )
        {
          case AC_OPEN:
#if debug
form_alert(1, ADDR("[0][Got an AC_OPEN message][   OK   ]"));
#endif
                if ( gl_rmsg[4] == gl_ittape && !wh_tape)
                  ac_open(gl_tape);
                else
                  wind_set(wh_tape, WF_TOP, 0, 0, 0, 0);
                break;
          case WM_REDRAW:
#if debug
form_alert(1, ADDR("[0][Got a REDRAW message][   OK   ]"));
#endif
                do_redraw(gl_rmsg[3], gl_rmsg[4], gl_rmsg[5], 
                         gl_rmsg[6], gl_rmsg[7], ROOT, MAX_DEPTH);
                break;
          case WM_TOPPED:
                wind_set(gl_rmsg[3], WF_TOP, 0, 0, 0, 0);
                break;
          case WM_CLOSED:
#if debug
form_alert(1, ADDR("[0][Got a WM_CLOSED message][   OK   ]"));
#endif
                do_close(gl_rmsg[3]);
#if debug
form_alert(1, ADDR("[0][In HNDL_MESAG: after do_close][  OK  ]"));
#endif
                wind_delete(wh_tape);
#if debug
form_alert(1, ADDR("[0][In HNDL_MESAG: after wind_delete][ OK ]"));
#endif
                wh_tape = 0;
                break;
          case AC_CLOSE:
                if ( (gl_rmsg[3] == gl_ittape) && (wh_tape) )
                  wh_tape = 0;
                break; 
          case WM_MOVED:
                tree = gl_tape;
                wind_set(gl_rmsg[3], WF_CXYWH, gl_rmsg[4], 
                        gl_rmsg[5], gl_rmsg[6], gl_rmsg[7]);
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                LWSET(OB_X(ROOT), x);
                LWSET(OB_Y(ROOT), y);
                break;
        } /* switch */
        gl_rmsg[0] = 0;
#if debug
form_alert(1, ADDR("[0][End HNDL_MESAG][   OK   ]"));
#endif
        return(done);
} /* hndl_mesag */
 
/****************************************************************/
/* GEM m a i n                                                  */
/****************************************************************/
GEMAIN()
{
        LONG            tree;
        WORD            ev_which, done, ii, num, curr_ob;
        WORD            xd, yd, wd, hd;
        WORD            mx, my, mb, ks, kret, bret;
        WORD            x, y, w, h;
        WORD            no_cancel, counter, evnt_left, speed;
        WORD            junk, xoff, yoff, value;
        WORD            mod_val, add_on, slid_len;
 
                                        /* initialize libraries */
        gl_apid = appl_init();
        gl_handle = graf_handle(&gl_wchar, &gl_hchar, 
                                        &gl_wbox, &gl_hbox);
 
                                        /* register as desk     */
                                        /*   accessory          */
 
        gl_ittape = menu_register(gl_apid, ADDR("  Tape Recorder"));
 
                                        /* init. message address*/
        ad_rmsg = ADDR(&gl_rmsg[0]);
                                        /* get desktop size     */
 
        wind_get(0, WF_WXYWH, &gl_xdesk, &gl_ydesk, 
                                        &gl_wdesk, &gl_hdesk);
 
                                        /* initialize mouse     */
        graf_mouse(0, 0x0L);
                                        /* initialize tape      */
        gl_tape = ini_tape();
        tree = gl_tape;
                                        /* get ready for main   */
                                        /*   loop               */
        gl_flags = MU_BUTTON | MU_MESAG;
        gl_button = 0x01;
        gl_ignore = FALSE;
        def_path[0] = NULL;
 
        done = FALSE;
        counter = 0;
        speed = 500;
        gl_numevnts = MAX_EVNTS;
        value = 0;
        slid_len = 20 * gl_wchar;
                                        /* begin main loop      */
        while (!done)
        {
                                        /* wait for mouse       */
                                        /*   button to go down  */
 
          ev_which = evnt_multi(gl_flags, 0x01, 0x01, gl_button,
                                0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                ad_rmsg, 0, 0, 
                                &mx, &my, &mb, &ks, &kret, &bret);
 
                                        /* handle message       */
          if (ev_which & MU_MESAG)
            if (!(gl_ignore && (gl_rmsg[0] == AC_CLOSE)))
             done = hndl_mesag();
          gl_ignore = FALSE;
 
          if (ev_which & MU_BUTTON)
          {
            if (wh_tape)
            {                           /* input from form      */
 
              wind_get(wh_tape, WF_WXYWH, &xd, &yd, &wd, &hd);
              graf_mkskate(&mx, &my, &junk, &junk);
              curr_ob = objc_find(gl_tape, ROOT, 2, mx, my);
 
              if (curr_ob == SLIDE)
              {
                mod_val = ((gl_numevnts / slid_len) == 0) ? 1 : 
                                        (gl_numevnts / slid_len);
 
                add_on = ((gl_numevnts / slid_len) != 0) ? 1 : 
                                        (slid_len / gl_numevnts);
                objc_offset(tree, ELEVATOR, &xoff, &yoff);
                if (mx <= xoff)
                {
                  counter--;
                  if ((counter % mod_val) == 0)
                    the_tape[ELEVATOR].ob_x -= add_on;
                } /* if mx <= xoff */
                if (mx > xoff)
                {
                  counter++;
                  if ((counter % mod_val) == 0)
                    the_tape[ELEVATOR].ob_x += add_on;
                } /* if */                              
                set_counter(counter, FALSE);
              } /* if SLIDE */
 
              if (curr_ob == ELEVATOR)
              {
                value = graf_slidebox(tree, SLIDE, ELEVATOR, 0);
                counter = MUL_DIV(value, gl_numevnts, 1000);
                value = MUL_DIV(counter, slid_len, gl_numevnts);
                if (value > (slid_len - the_tape[ELEVATOR].ob_width))
                  value = slid_len - the_tape[ELEVATOR].ob_width;
                the_tape[ELEVATOR].ob_x = value;
 
                                        /* this will            */
                                        /* redraw SLIDER        */
 
                set_counter(counter, FALSE);
              } /* if ELEVATOR */
 
              if ((curr_ob >= BUTTON1) && (curr_ob <= BUTTON5))
              {
                for (ii = BUTTON1; ii <= BUTTON5; ii++)      
                {
                  the_tape[ii].ob_state = NORMAL;
                  do_redraw(wh_tape, xd, yd, wd, hd, ii, 0);
                } /* for */
                the_tape[curr_ob].ob_state = SELECTED;
                do_redraw(wh_tape, xd, yd, wd, hd, curr_ob, 0);
                speed = 25;
                switch(curr_ob)
                {
                  case 12:   
                        speed += 9000;
                  case 11:
                        speed += 500;
                  case 10:
                        speed += 225;
                  case 9:
                        break;
                } /* switch */  
              } /* if */
              if ((curr_ob >= BT_LOAD) && (curr_ob <= BT_PLAY))
              {
                the_tape[curr_ob].ob_state = SELECTED;
                do_redraw(wh_tape, xd, yd, wd, hd, curr_ob, 0);
              } /* if */
              if ( curr_ob == BT_TAPE )
              {
                do_close(wh_tape); 
                gl_numevnts = appl_trecord(ADDR(&gl_evlist[0]),
                                                    MAX_EVNTS);
 
                do_open(wh_tape, gl_xtape, gl_ytape, 
                                        gl_wtape, gl_htape);
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                the_tape[ROOT].ob_x = x;
                the_tape[ROOT].ob_y = y;
                the_tape[BT_TAPE].ob_state = NORMAL; 
 
                /*              beep();         */
 
                counter = 0; 
                the_tape[ELEVATOR].ob_x = 0;
                set_counter(0, FALSE);
                set_counter(gl_numevnts, TRUE);
              } /* if BT_TAPE */
              if ( curr_ob == BT_PLAY )
              {
                do_close(wh_tape);
                evnt_left = gl_numevnts - counter;
                appl_tplay(ADDR(&gl_evlist[counter]), 
                                        evnt_left, speed);
 
                do_open(wh_tape, gl_xtape, gl_ytape, 
                                        gl_wtape, gl_htape);
 
                wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
                the_tape[ROOT].ob_x = x;
                the_tape[ROOT].ob_y = y;
                the_tape[BT_PLAY].ob_state = NORMAL;
              } /* if BT_PLAY */
              if ( curr_ob == BT_LOAD )
              {
                no_cancel = get_file(&gl_pfname[0]);
                if (no_cancel)
                { 
                  force_ext(&gl_pfname[0], "TAP");
                  gl_numevnts = read_tape(&gl_pfname[0]);
                  set_counter(gl_numevnts, TRUE);
                } /* if */
                else                                     
                {
                  the_tape[BT_LOAD].ob_state = NORMAL;
                  do_redraw(wh_tape, xd, yd, wd, hd, BT_LOAD, 0);
                } /* else */    
                the_tape[BT_LOAD].ob_state = NORMAL;
                counter = 0;
                value = 0;
                the_tape[ELEVATOR].ob_x = 0;
                set_counter(0, FALSE);
              } /* if BT_LOAD */
              if ( curr_ob == BT_SAVE )
              {
                no_cancel = get_file(&gl_pfname[0]);
                do_redraw(wh_tape, xd, yd, wd, hd, BT_SAVE, 0);
                if (no_cancel) 
                {
                  force_ext(&gl_pfname[0], "TAP");
                  write_tape(gl_numevnts, &gl_pfname[0]);
                }
 
                the_tape[BT_SAVE].ob_state = NORMAL;
              } /* if BT_SAVE */
            } /* if wh_tape */
          } /* if BUTTON */
        } /* while */
}
 
                                        /* since we're a desk   */
                                        /*  accessory we should */
                                        /*  never terminate     */
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPEUTIL.C"
 
 
**********************************************************
 
 
 
 
 
/*      TAPEUTIL.C      07/18/85 - 07/31/85     Gregg Morris            */
/*      modified        09/02/85 - 09/09/85     Mitch Smith             */
/*      utility         routines   for the      tape recorder           */
 
/*** INCLUDE FILES ******************************************************/
 
#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <treeaddr.h>
#include <gembind.h>
#include <tapedef.h>
#include <tape.h>
 
#define debug 0
 
/*** EXTERN VARIABLES ***************************************************/
EXTERN OBJECT   the_tape[NUM_OBS];
EXTERN TEDINFO  the_ted[NUM_TI];
EXTERN BYTE     *the_str[NUM_STRINGS];
EXTERN BYTE     def_path[];
 
EXTERN LONG     gl_tape;
EXTERN WORD     wh_tape;
EXTERN WORD     gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk;
EXTERN WORD     gl_xtape, gl_ytape, gl_wtape, gl_htape;
EXTERN WORD     gl_wchar, gl_hchar;
EXTERN WORD     gl_ignore;
EXTERN WORD     gl_numevnts;
EXTERN EVENT    gl_evlist[MAX_EVNTS];
 
 
/************************************************************************/
/* w i n d _ s i z e                                                    */
/************************************************************************/
        WORD
wind_size()
{
        LONG            tree;
        WORD            tw, th, x, y, w, h, wh;
 
        tree = gl_tape;
        tw = LWGET(OB_WIDTH(ROOT));
        th = LWGET(OB_HEIGHT(ROOT));
                                        /* 0x0B = NAME | CLOSER | MOVER */
        wind_calc(WC_BORDER, 0x000B, 0, 0, tw, th,
                  &gl_xtape, &gl_ytape, &gl_wtape, &gl_htape);
        wh = wind_create(0x000B, gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk);
        wind_set(wh, WF_NAME, ADDR(" Tape Recorder "), 0, 0);
        gl_xtape = (gl_wdesk - gl_wtape) / 2;
        gl_ytape = (gl_hdesk - gl_htape) / 2;
        return(wh);
} /* wind_size */
 
/************************************************************************/
/* f i x _ c h p o s                                                    */
/************************************************************************/
        VOID
fix_chpos(pfix, ifx)
        LONG    pfix;
        WORD    ifx;
{
        WORD    coffset;
        WORD    cpos;
 
        cpos = LWGET(pfix);
        coffset = cpos >> 8 & 0x00ff;
        cpos = cpos & 0x00ff;
        if (ifx)
          cpos *= gl_wchar;
        else
          cpos *= gl_hchar;
        if ( coffset > 128 )                    /* crude        */
          cpos -= (256 - coffset);
        else
          cpos += coffset;
        LWSET(pfix, cpos);
} /* fix_chpos() */
 
/************************************************************************/
/* i n i _ t a p e                                                      */
/************************************************************************/
        LONG
ini_tape()
{
        LONG            tree;
        WORD            ii;
 
        tree = ADDR(&the_tape[0]);
        for(ii = 0; ii < NUM_TI; ii++)
        {
          the_tape[ii+1].ob_spec = ADDR(&the_ted[ii]);
          the_ted[ii].te_ptext = ADDR(the_str[ii]);
        }
        for (ii = 0; ii < NUM_OBS; ii++)
        {
          fix_chpos(OB_X(ii), TRUE);
          fix_chpos(OB_Y(ii), FALSE);
          fix_chpos(OB_WIDTH(ii), TRUE);
          fix_chpos(OB_HEIGHT(ii), FALSE);
        }
        return(tree);
} /* ini_tape */
 
/************************************************************************/
/* d o _ o p e n                                                        */
/************************************************************************/
        VOID
do_open(wh, x, y, w, h)
        WORD            wh, x, y, w, h;
{
        graf_mouse(2, 0x0L);
        graf_growbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
        wind_open(wh, x, y, w, h);
        graf_mouse(0, 0x0L);
} /* do_open */
 
/************************************************************************/
/* d o _ c l o s e                                                      */
/************************************************************************/
        VOID
do_close(wh)
        WORD            wh;
{
        WORD            x, y, w, h;
 
#if debug
form_alert(1, ADDR("[0][begin do_close][   OK   ]"));
#endif
        graf_mouse(2,0x0l);
        wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
#if debug
form_alert(1, ADDR("[0][before wind_close][   OK   ]"));
#endif
        wind_close(wh);
#if debug
form_alert(1, ADDR("[0][after wind_close][   OK   ]"));
#endif
        graf_shrinkbox(2*gl_wchar, 0, 4*gl_wchar, gl_hchar, x, y, w, h);
        graf_mouse(0, 0x0L);
#if debug
form_alert(1, ADDR("[0][End do_close][   OK   ]"));
#endif
} /* do_close */
 
/************************************************************************/
/* a c _ o p e n                                                        */
/************************************************************************/
        VOID
ac_open(tree)
        LONG            tree;
{
        WORD            x, y, w, h;
#if debug
form_alert(1, ADDR("[0][In ac_open][   OK   ]"));
#endif
        wh_tape = wind_size();
        do_open(wh_tape, gl_xtape, gl_ytape, gl_wtape, gl_htape);
        wind_get(wh_tape, WF_WXYWH, &x, &y, &w, &h);
        the_tape[ROOT].ob_x = x;
        the_tape[ROOT].ob_y = y;
#if debug
form_alert(1, ADDR("[0][End AC_OPEN][   OK   ]"));
#endif
} /* ac_open */
 
/************************************************************************/
/* c l o s e _ t a p e                                                  */
/************************************************************************/
        VOID
close_tape()
{       
        do_close(wh_tape);
        wh_tape = 0;
} /* close_tape */
 
/************************************************************************/
/* o p e n _ t a p e                                                    */
/************************************************************************/
        VOID
open_tape()
{
        ac_open(gl_tape, wh_tape);
        gl_ignore = TRUE;
} /* open_tape */
 
/************************************************************************/
/* w r i t e _ t a p e                                                  */
/************************************************************************/
        VOID
write_tape(num_evnts, tape_name)        /* BT_SAVE */
        WORD            num_evnts;
        BYTE            *tape_name;
{
/* write num_evnts * 6 bytes to file tape_name                          */
        WORD            f_handle;
        WORD             nbytes; 
 
        nbytes = num_evnts * 6;
        f_handle = dos_create(ADDR(tape_name), 0);
        write_piece(f_handle, nbytes, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
} /* write_tape */
 
/************************************************************************/
/* r e a d _ t a p e                                                    */
/************************************************************************/
        WORD
read_tape(tape_name)    /* BT_LOAD */
        BYTE            *tape_name;
{
/* read a tape, return number of events (not bytes)                     */
        WORD            f_handle, bytes_read;
 
        f_handle = dos_open(ADDR(tape_name), 2);  
        bytes_read = read_piece( f_handle, MAX_SIZE, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
 
        return (bytes_read / 6);        /*      6 bytes per event       */
 
} /* read_tape */
 
/************************************************************************/
/* s e t _ c o u n t e r                                                */
/************************************************************************/
        VOID
set_counter(cnt_val, total)
        WORD            cnt_val, total;
{
/* counter looks like " nnn/xxx ". if total=TRUE, set xxx; else set nnn */
        WORD            x, y, w, h, offset;
        BYTE            *pctr;
 
        x = the_tape[ROOT].ob_x;
        y = the_tape[ROOT].ob_y;
        w = the_tape[ROOT].ob_width;
        h = the_tape[ROOT].ob_height;
        if (cnt_val >= 1000)
          cnt_val = 999;
        pctr = the_str[6];
        if (total)
          offset = 4;
        else
          offset = 0;
        pctr[1+offset] = '0' + (cnt_val / 100);
        cnt_val = cnt_val % 100;
        pctr[2+offset] = '0' + (cnt_val / 10);
        cnt_val = cnt_val % 10;
        pctr[3+offset] = '0' + cnt_val;
        do_redraw(wh_tape, x, y, w, h, SLIDE, 1);
        do_redraw(wh_tape, x, y, w, h, 7, 0);
} /* set_counter */
 
 
/*------------------------------*/
/*      get_file                */
/*------------------------------*/
WORD
get_file(full_path)
BYTE    *full_path;
{
        WORD            ast_loc, butn, ii, slash_loc;
        WORD            cur_drv;
        BYTE            tmp_name[13], tmp_drv;
 
        full_path[0] = NULL;
        tmp_name[0] = NULL;
        cur_drv = dos_gdrv();
        tmp_drv = cur_drv + 'A';
 
        get_where(&def_path[0]);
        strcpy(full_path, &def_path[0]);
        strcat(full_path, "*.TAP");
 
        if (fsel_input(ADDR(full_path), ADDR(tmp_name), &butn) && butn)
        {   
            /* Find the spot to concatenate the file name to. */
            ii = 0;
            while(full_path[ii])
              ii++;
            while(full_path[ii] != '\\')
              ii--;
            ii++;
            full_path[ii] = NULL;
            strcat(full_path, &tmp_name[0]);
                                                /* update default path  */
            def_path[0] = NULL;
            strcpy(&def_path[0], full_path);
            ii = 0;
            while(def_path[ii])
              ii++;
            while(def_path[ii] != '\\')
              ii--;
            ii++;
            def_path[ii] = NULL;
            return(TRUE);
        }   /* End if:  no error and OKAY selected. */
        else
            return(FALSE);
}  /* End "get_file". */
 
 
/*------------------------------*/
/*      get_where               */
/*------------------------------*/
VOID
get_where(ppath)
BYTE    *ppath;
{
/* Get the default directory path                                       */
        WORD            cur_drv, ii;
        BYTE            tmp_path[64];
 
        cur_drv = dos_gdrv();
        ppath[0] = cur_drv + 'A';
        ppath[1] = ':';
        ppath[2] = '\\';
        ppath[3] = NULL;
        dos_gdir(cur_drv + 1, ADDR(&tmp_path[0]));
        strcat(ppath, &tmp_path[0]);
        ii = 0;
        while(ppath[ii])
          ii++;
        ii--;
        if (ppath[ii] == '\\')
        {
          ii--;
          if (ppath[ii] == '\\')
          {
            ii++;
            ppath[ii] = NULL;
          } /* if */
        } /* if */
        else
        {
          ii++;
          ppath[ii++] = '\\';
          ppath[ii] = NULL;
        } /* else */
} /* get_where */
 
 
/*------------------------------*/
/*      force_ext               */
/*------------------------------*/
VOID
force_ext(pstr, pext)
BYTE    *pstr, *pext;
{
/* put extension pext on pstr                                           */
        BYTE            *pend;
 
        pend = pstr;
                                                /* go to end of string  */
        while(*pend)
          pend++;
        pend--;
                                                /* find the .           */
        while((*pend != '\\') && (*pend != '.') && (pend > pstr))
          pend--;
                                                /* did we find a .?     */
        if ((pend == pstr) || (*pend == '\\'))
        {
          strcat(pstr, ".");                    /* put in a period      */
          strcat(pstr, pext);                   /* no extension at all  */
        } /* if */
        else
        {                                       /* overwrite existing extension 
*/
          pend++;
          *pend = '\0';
          strcat(pstr, pext);
        } /* else */
} /* force_ext */
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPE.H"
 
 
**********************************************************
 
 
/*      TAPE.H          10/18/84 - 2/25/85      ANDREW MUIR             */
/*                               - 07/01/85     Gregg Morris            */
 
OBJECT the_tape[NUM_OBS] = 
{
        -1, 1, 13, G_BOX, NONE, NORMAL, 0x20001100L, 0, 0, 36, 7,
        2, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x1L, 3,1,6,1,
        3, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x2L, 11,1,6,1,
        4, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x3L, 19,1,6,1,
        5, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x4L, 27,1,6,1,
        6, -1, -1, G_BOXTEXT, NONE, NORMAL, 0x5L, 3,3,6,1,
        7, -1, -1, G_BOXTEXT, NONE, NORMAL, 0x6L, 3,5,7,1,
        8, -1, -1, G_BOXTEXT, NONE, NORMAL, 0x7L, 30, 5, 6, 1,
        9, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x8L, 10,3,4,1,
        10, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x9L, 15,3,4,1,
        11, -1, -1, G_BOXTEXT, SELECTABLE, SELECTED, 0x10L, 20,3,4,1,
        12, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x11L, 25,3,4,1,
        13, -1, -1, G_BOXTEXT, SELECTABLE, NORMAL, 0x12L, 30,3,4,1,
        0, 14, 14, G_BOX, SELECTABLE, NORMAL, 0x20022121L, 
                10, 5, 20, 1,
        13, -1, -1,G_BOX, SELECTABLE | LASTOB, NORMAL,0x22021100L, 
                0, 0, 2, 1,
};
 
TEDINFO the_ted[NUM_TI] =
{
        0x0L, -1L, -1L, IBM, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x1L, -1L, -1L, IBM, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x2L, -1L, -1L, IBM, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x3L, -1L, -1L, IBM, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x4L, -1L, -1L, IBM, S_XOR_D, TE_LEFT, 0x1106, WHITE, 0, 0, 0,
        0x5L, -1L, -1L, IBM, S_XOR_D, TE_LEFT, 0x1106, WHITE, 0, 0, 0,
        0x6L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, 0, 0, 0,
        0x7L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x8L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x9L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x10L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
        0x11L, -1L, -1L, SMALL, S_XOR_D, TE_CNTR, 0x1106, WHITE, -1, 0, 0,
};
 
BYTE *the_str[NUM_STRINGS] =
{
        "LOAD",
        "TAPE",
        "SAVE",
        "PLAY",
        "speed:",
        "place:",
        " 000/000 ",
        ".05 x",
        ".5 x",
        "1 x",
        "2 x",
        "20 x",
};
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TAPEDEF.H"
 
 
**********************************************************
 
 
/*      TAPEDEF.H       07/19/85 - 07/24/85     Gregg Morris            */
 
#define MAX_EVNTS 1000                  /* max no. of events per tape   */
#define MAX_SIZE 6000                   /* max file size                */
 
#define NUM_OBS 15
#define NUM_TI 12
#define NUM_STRINGS 12
 
#define BT_LOAD 1
#define BT_TAPE 2
#define BT_SAVE 3 
#define BT_PLAY 4
#define BUTTON1 8
#define BUTTON2 9
#define BUTTON3 10
#define BUTTON4 11
#define BUTTON5 12
#define SLIDE 13
#define ELEVATOR 14
 
#define EVENT struct strevnt
EVENT
{
        WORD            *ev_code;
        LONG            ev_parm;
};
 
 
 
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE END OF "RECORD.C"
 
 
**********************************************************
**********************************************************
