**********************************************************
**********************************************************
 
 
        THIS IS THE BEGINNING OF "TUTOR.C"
 
 
**********************************************************
**********************************************************
 
 
 
NOTE:   This  code  will compile and assemble  but  it  is 
        necessary  to  make  a TUTOR.TXT  file  indicating 
        which  tapes  are to  be  played,  etc.   SEE  THE 
        FOLLOWING  DOCUMENTATION.   These  tapes are  made 
        with the TAPE RECORDER so it is necessary to  have 
        the TAPE RECORDER also.  It is located in DL5 in a 
        file called RECORD.C.   
 
 
UPLOADED:   September 18, 1985
                
                                Jim Needham
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TUTOR.DOC"
 
 
**********************************************************
 
                             GEM TUTORIAL
 
    GEM TUTORIAL is a GEM application which reads and processes a
    "batch" file named TUTOR.TXT containing DOS-like commands. With
    those commands you can create tutorials and self-running
    demonstrations for GEM applications.
 
                      
Section 1: Command Summary
 
 
    :<identifier>       - defines a <label>.
    
    ALERT <string>      - <string> defines a GEM Alert; when the ALERT
    statement is encountered, the Alert is displayed.
    
    COPY <source> <dest>- copies <src file> to <dest file>. Both
    source and dest may contain path information and wild cards. 
    DISPLAY <string>    - <string> defines a specialized GEM Dialog
    Box; when the DISPLAY statement is encountered, the Dialog Box is
    displayed.
    
    DOS                 - terminates the batch file; control returns
    to the GEM DESKTOP.
    
    GOTO <label>        - transfer control to <label>.
    
    IF1BUTN <label>     - transfer control to <label> if button 1 was
    used to exit the Alert defined in the last ALERT statement.
    
    IF2BUTN <label>     - transfer control to <label> if button 2 was
    used to exit the Alert defined in the last ALERT statement.
    
    IF3BUTN <label>     - transfer control to <label> if button 3 was
    used to exit the Alert defined in the last ALERT statement.
    
    IFFD <label>        - transfer control to <label> if the Desktop
    is running on a floppy-disk based system.
    
    IFHD <label>        - transfer control to <label> if the Desktop
    is running on a hard-disk based system.
    
    MD <dir name>       - create directory specified by <dir name>.
    <dir name> is in the DOS format.
    
    PLAY <tapename>     - play Tape Recorder file <tapename>
 
    RUN <shell command> - <shell command> contains the information
    necessary to do a GEM SHEL_WRITE.
    
    SRCMSG <string>     - <string> defines a GEM Alert to be displayed
    if an error occurs during a COPY.
             
Section 2: Detailed Explanation of Commands
 
    2.1 LABEL command
    Syntax:       :<identifier> 
    The identifier may be up to eight characters long. The label must
    be the only statement on a line.
 
    2.2 ALERT command
    Syntax:       ALERT <string>
    The Alert definition follows the GEM AES format for Alerts, WITH
    ONE EXCEPTION. The description may be preceded by a number 1, 2,
    or 3, indicating which button is to be the DEFAULT button when the
    Alert is displayed. The description may be split across lines if
    necessary; however, it may ONLY be split following a | or ]. After
    splitting a line, you may insert tabs and/or spaces as desired to
    align the text of the Alert. This will have no effect when the
    Alert is displayed; it is only to make it easier to visualize how
    the Alert will look when it is displayed.
    For example, consider this GEM AES format Alert description:
    [1][This is an example of a large GEM AES|Alert. Notice that it
    uses the NOTE| icon, and consists of three lines.][ OK   | Cancel
    ]
    To be used with GEM TUTORIAL, the above Alert would be defined
    like this:
    1[1][This is an example of a large GEM AES|
    Alert. Notice that is uses the NOTE|
    icon, and consists of three lines.] [   OK | Cancel ]
    Note the 1 preceding the description. This indicates that the OK
    button will be the default button when the Alert is displayed.
    Also note that the description is broken across lines only after a
    | or ], and spaces were inserted to align the text.
 
    2.3 COPY command
    Syntax:       COPY <source <dest>
    This command is like the DOS COPY command. Both <source> and
    <dest> may contain path information and wild cards. For example,
    COPY a:paint.app c:\gemapps\paint.app
 
    2.4 DISPLAY command
    Syntax:       DISPLAY <string>
    This command is similar to the ALERT command, but instead of
    creating a standard GEM Alert, creates a more specialized Dialog
    Box. This dialog box may contain up to 10 lines of 60 characters
    per line and may have up to three buttons of 20 characters each.
    It may not contain an icon. Additionally, you may specify the
    placement of the box on the screen, and a time limit for it to be
    displayed. You might, for example, want to display a purely
    informational message in the upper left corner of the screen for
    five seconds.
 
    The format of the DISPLAY command is:
    DISPLAY [def_butn][time][col,row][line 1|...|line 10][butn1
    |...|butn3]
    where     def_butn is the default exit button: 1, 2, or 3
              time is the time in seconds for the box to be displayed.
              The maximum value allowed is 999 seconds.  A time of 0
              will display the box forever, or until a button is used
              to exit.
              col,row is the character column and row where the upper
              left corner of the box is to be displayed. 1,1 is the
              upper left hand corner of the screen. Specifying the
              maximum value allowed, 80,25, will cause the box to be
              centered on the screen. 
              lines are the lines of text, up to 60 characters each. 
              butns are the buttons, up to 20 characters each.
    Like the ALERT string, the DISPLAY string may be split across
    lines following a | or ]. Note that unlike the ALERT definition,
    the DISPLAY definition has the default exit button contained in
    square brackets, e.g. [1].
    Examples:
    DISPLAY [1][15][2,2]
    [This will appear in the upper left corner of the screen.|
    If the OK button is not pushed first, it will go away in|
    fifteen seconds.][ OK   ]
    DISPLAY [0][5][80,25]
    [This will sit in the middle of the screen for five seconds.][]
    The first example will appear on the screen like this:
 
    2.5 DOS command
    Syntax:                 DOS
    This command is required at the end of the batch file. It causes
    control to return to the GEM DESKTOP.
 
    2.6 GOTO command
    Syntax:                 GOTO <label>
    This command transfers control the <label>. <label> does not
    contain the :. See Section 2.1, the LABEL command.
    
    2.7 IF1BUTN command
    Syntax:                 IF1BUTN <label>
    This command causes control to transfer to <label> if button 1 was
    used to exit the Alert defined in the last ALERT statement.
 
    2.8 IF2BUTN command
    Syntax:                 IF2BUTN <label>
    This command causes control to transfer to <label> if button 2 was
    used to exit the Alert defined in the last ALERT statement.
 
    2.9 IF3BUTN command
    Syntax:                 IF3BUTN <label>
    This command causes control to transfer to <label> if button 3 was
    used to exit the Alert defined in the last ALERT statement.
 
    2.10 IFFD command
    Syntax:                 IFFD <label>
    This command causes control to transfer to <label> if the Desktop
    is running on a floppy-disk based system.
 
    2.11 IFHD command
    Syntax:                 IFHD <label>
    This command causes control to transfer to <label> if the Desktop
    is running on a hard-disk based system.
 
    2.12 MD command
    Syntax:                 MD <dir name>
    Creates the directory specified by <dir name>. <dir name> is in
    the DOS format. If the directory already exists, no action is
    taken.
    Example:
    MD c:\gemapps\patterns
 
    2.13 PLAY command
    Syntax:                 PLAY <tapename>
    This command loads and plays the specified GEM Tape Recorder tape
    file. The tape file must have been created using the Tape Recorder
    Desk Accessory.
    Example:
    PLAY sizewind.tap
 
    2.14 RUN command
    Syntax:                 RUN <shell command>
    This command performs a GEM AES SHEL_WRITE. The <shell command>
    string must be in the format specified in the GEM AES manual.
    The following example will transfer control to GEM PAINT:
    RUN 1,1,1, paint
 
    2.15 SRCMSG command
    Syntax:                 SRCMSG <string>
    <string> defines a GEM Alert to be displayed if an error occurs
    during a COPY.
    Example:
    SRCMSG 1[3][Can't find the file CARP.APP][ Cancel ]
               
Section 3: Examples of TUTOR.TXT files
 
 
    
Sample 1.
 
    :START DISPLAY [1][5][5,10]
    [Here's a DISPLAY that looks a lot like an ALERT.|
    There is a 20 second time delay defined, but|
    you may click on OK at any time to bag out early.|
    If you click on CANCEL, you'll miss the rest of|
    this demo.][   OK   | Cancel ]
    IF2BUTN END
    :LBL1
    DISPLAY [1][5][80,25]
    [This is an example of a huge, centered DISPLAY. Each line|
    may be up to 60 characters long, and the DISPLAY may have|
    up to 10 such lines. This particular example has a 60|
    second time delay, so click on CONTINUE as soon as you get|
    bored to continue with the demonstration. Note also that|
    the first button is specified as the DEFAULT button.][ Continue ]
    DISPLAY [0][5][2,2]
    [Here's a DISPLAY with no buttons!][]
    DISPLAY [1][5][5,10]
    [Here's another DISPLAY that looks a lot like an ALERT.|
    This time there is NO time delay defined, so you'll have|
    to click on OK to continue. If you click on CANCEL, you'll|
    skip to the end of this demo.][   OK   | Cancel ]
    IF2BUTN END
    :FOO
    DISPLAY [0][4][10,5]
    [So as you can see, the new DISPLAY command in GEM|
    TUTORIAL is mostly working! This box will stay here|
    for 4 seconds...][]
    DISPLAY [1][4][40,15]
    [... but we'll loop forever unless|
    you hit the STOP button!][ Stop ]
    IF1BUTN CONT
    GOTO FOO 
    :CONT
    DISPLAY [0][4][75,24]
    [Whew! Thanks-- I was sure getting tired of that|
    loop! Now the whole thing starts over again!][]
    GOTO START
    :END
    DOS
    
Sample 2.
 
    DISPLAY [1][7][80,25]
    [This is an example of the GEM Tutorial|
    Desk Accessory. We will use the GEM Tutorial|
    as a simple demonstration of GEM Paint.][   OK   | Cancel ]
    IF2BUTN STOP
    PLAY start.tap
    DISPLAY [0][5][5,10]
    [This is an example of the BRUSH SHAPES menu choice.][]
    PLAY bshape.tap
    PLAY bmove.tap
    DISPLAY [0][10][80,25]
    [Now we'll see an example of the Flood Fill Tool.|
    First, we choose a new fill pattern, then we|
    choose the Flood Fill Tool and click anywhere|
    inside the area to fill.][]
    PLAY fill.tap
    :END
    DISPLAY [1][0][80,25]
    [This concludes the GEM Paint Tutorial.|
    If you would like to play with GEM Paint|
    now, click on PAINT. If you would like to|
    return to the Desktop, click on DESKTOP.][ PAINT | DESKTOP ]
    IF1BUTN STOP
    PLAY endit.tap
    :STOP
    DOS
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "BLDTUTR.BAT"
 
 
**********************************************************
 
 
 
 
 
REM *********************************
REM * GEM TUTORIAL Builder 07/31/85 *
REM *********************************
 
rasm86 ACCSTART $pzsz
rasm86 DOSASM $pzsz
rasm86 GEMASM $pzsz
rasm86 LONGASM $pzsz
rasm86 PROEND $pzsz
rasm86 TCRTLASM $pzsz
rasm86 GPRINTF $pzsz 
rasm86 VDIASM $pzsz
 
lc1 DOSBIND -s
lc2 DOSBIND -sCODE -v
 
lc1 GEMBIND -s
lc2 GEMBIND -sCODE -v
 
lc1 GIDISP -s
lc2 GIDISP -sCODE -v
 
lc1 GIUTILS -s
lc2 GIUTILS -sCODE -v
 
lc1 TCRTL -s
lc2 TCRTL -sCODE -v
 
lc1 TUMAIN -s
lc2 TUMAIN -sCODE -v
 
link86 tutor[i]
 
copy tutor.acc \gemboot 
copy tutor.rsc \gemboot 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TUTOR.INP"
 
 
**********************************************************
 
 
 
 
 
 
/*      TUTOR.INP       */
 
tutor.acc=accstart,
tumain,
giutils,
gidisp,
gembind,
gemasm,
dosbind,
dosasm,
vdiasm,
tcrtl,
tcrtlasm,
gprintf,
longasm,
proend[nop,data[max[0
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "BLDTUTRM.BAT"
 
 
**********************************************************
 
 
 
 
 
 
/*      BLDTUTRM.BAT    */
 
masm NEWTCS ;
masm ACCSTART ;
masm DOSASM ;
masm GEMASM ;
masm LONGASM ;
masm PROEND ;
masm TCRTLASM ;
masm GPRINTF ;
masm VDIASM ;
 
lc1 DOSBIND 
lc2 DOSBIND -v
 
lc1 GEMBIND 
lc2 GEMBIND -v 
 
lc1 GIDISP 
lc2 GIDISP -v 
 
lc1 GIUTILS 
lc2 GIUTILS -v 
 
lc1 TCRTL 
lc2 TCRTL -v
 
lc1 TUMAIN 
lc2 TUMAIN -v 
 
link @tutor,tutor,tutor/map,,
copy tutor.exe \gemboot\tutor.acc
copy tutor.rsc \gemboot
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TUTOR"
 
 
**********************************************************
 
 
 
 
/*      TUTOR   */
 
newtcs+accstart+tumain+giutils+
gidisp+gembind+gemasm+dosbind+
dosasm+vdiasm+tcrtl+tcrtlasm+
gprintf+longasm+proend
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TUMAIN.C"
 
 
**********************************************************
 
 
 
 
 
/*      TUMAIN.C        */
 
 
/*      TUMAIN.C        06/10/85 -- 08/02/85            Gregg Morris    */
/* GEM TUTOR program, based on INSTALL.C                                */
 
#include "portab.h"
#include "machine.h"
#include "gembind.h"
#include "dosbind.h"
#include "obdefs.h"
#include "install.h"
#include "tutor.h"
 
#define debug 0
#define NUMCMDS 16
#define BUF_SIZE 16384
#define BEG_UPDATE 1
#define END_UPDATE 0
#define BEG_MCTRL 3
#define END_MCTRL 2
 
EXTERN LONG     dos_alloc();
EXTERN UWORD    global[];               /* declared in CRYSIF.C         */
EXTERN WORD     DOS_ERR;
EXTERN WORD     PROGEND;
EXTERN BYTE     *cp_alert();
EXTERN BYTE     *c_disp();
 
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     gl_smsg[8];
GLOBAL WORD     ctrl_pid;
GLOBAL WORD     gl_handle;
GLOBAL WORD     gl_wchar, gl_hchar;
GLOBAL WORD     gl_wbox, gl_hbox;
GLOBAL WORD     gl_apid;
 
GLOBAL GRECT    gl_desk;
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     ad_smsg;
GLOBAL LONG     copy_base;
GLOBAL LONG     dummy;
GLOBAL LONG     gl_dispbox;
 
GLOBAL WORD     gl_open;                        /* true if acc. is open */
GLOBAL WORD     yes, butn1, butn2, butn3, hd_sys;
GLOBAL WORD     gpatsts;
GLOBAL WORD     SRCBUTN;        /* default exit button for SRCMSG       */
GLOBAL WORD     gl_ittape;
 
GLOBAL BYTE     bat_buf[BUF_SIZE];
GLOBAL BYTE     *bat_base;      /* ptr to base of batch file in memory  */
GLOBAL BYTE     *bat_pc;        /* ptr to current position in batch file*/
GLOBAL BYTE     *batptr;
GLOBAL BYTE     DTA[50];
GLOBAL BYTE     err_ret;
GLOBAL BYTE     gpatstr[20];
GLOBAL BYTE     newbyte;        /* hard disk drive letter               */
GLOBAL BYTE     SRCMSG[384];            /* error message for src dsk    */
GLOBAL BYTE     alrt_str[384];          /* space for current alert      */
GLOBAL BYTE     disp_str[800];          /* space for current dispbox    */
GLOBAL BYTE     gl_cmd[80], gl_tail[80];
MLOCAL BYTE     *commands[] = { "DOS","ALERT","SRCMSG","PATBAT","COPY","MD",
                                "IF1BUTN","IF2BUTN","IF3BUTN","IFHD","IFFD",
                                "GOTO",":","RUN","PLAY","DISPLAY" };
 
GLOBAL EVENT    gl_evlist[MAX_EVNTS];
 
/************************************************************************/
/* p a r s _ b a t                                                      */
/************************************************************************/
        WORD
pars_bat()
{
/* parse the batch file for a match of the string; return index into    */
/* jump table of matching command.                                      */
        WORD            ii;
        BYTE            *pbat, *matptr;
 
        matptr = commands[0];
        for ( ii = 0; ii < NUMCMDS; ii++ )
        {
          pbat = bat_pc;
          while ( (*matptr) && (*matptr == *pbat) )
          {
            matptr++;
            pbat++;
          } /* while */
          if ( !(*matptr) )
          {
            bat_pc = pbat;
            return(ii);
          } /* if */
          while (*matptr)
            matptr++;
          matptr++;
        } /* for */
        return(ii);
} /* pars_bat */
 
/************************************************************************/
/* c _ r u n                                                            */
/************************************************************************/
        VOID
c_run()
{
        WORD            doex, isgr, isgem;
 
        get_shparms(batptr, &doex, &isgr, &isgem, &gl_cmd[0], &gl_tail[0]);
        shel_write(doex, isgr, isgem, ADDR(&gl_cmd[0]), ADDR(&gl_tail[0]));
} /* c_run */
 
/************************************************************************/
/* c _ a l e r t                                                        */
/************************************************************************/
        BYTE *
c_alert()
{
/* display an alert of made from the given string; return ptr to char   */
/* past end of alert                                                    */
        WORD            ret, def_butn;
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, alrt_str, TRUE, &def_butn );
        ret = form_alert(def_butn, ADDR(alrt_str));
        butn1 = butn2 = butn3 = FALSE;
        if (ret == 1)
          butn1 = TRUE;
        if (ret == 2)
          butn2 = TRUE;
        if (ret == 3)
          butn3 = TRUE;
        return(new_ptr);
} /* c_alert */
 
/************************************************************************/
/* c _ c o p y                                                          */
/************************************************************************/
        VOID
c_copy()
{
        WORD            ii, jj, ambigfn;
        BYTE            srcpth[80];
        BYTE            srcstr[80];
        BYTE            desstr[80];
        BYTE            tmpst1[80];
        BYTE            tmpst2[80];
        BYTE            *ps, *pd;
        static BYTE     slash[] =  "\\"; 
 
        ps = batptr;
        while ( *ps == ' ' )
          ps++;
        ii = 0;
        ambigfn = FALSE;
        pd = srcstr;
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
        {
          *pd = *ps;
          if ( (*pd == '*') || (*pd == '?') )
            ambigfn = TRUE;
          pd++;
          ps++;
          ii++;
        } /* while */
        *pd = NULL;
        if ( ii > 0 )
        {
          pd = desstr;
          while ( *ps == ' ' )
            ps++;
          jj = 0;
          while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          {
            *pd++ = *ps++;
            jj++;
          } /* while */
          *pd = NULL;
          --pd;
          if ( ambigfn )
          {
            expath( srcstr, srcpth );
            dos_sfirst( ADDR( srcstr ), 0x0000 );
            while ( !DOS_ERR )
            {
              tmpst1[0] = NULL;
              tmpst2[0] = NULL;
              strcat(tmpst1, srcpth);
              strcat( tmpst1, &DTA[30] );
              strcat( tmpst2, desstr );
              if ( (jj == 0) || (*pd == ':') )
                strcat( tmpst2, &DTA[30] ); 
              else 
              {
                strcat( tmpst2, &slash[0] );    /* add required slash   */
                strcat( tmpst2, &DTA[30] );     /* add fname from src   */
              }
              fcopy( tmpst1, tmpst2 );
              dos_snext();
            } /* while !DOS_ERR */
          } /* if ambigfn */
          else
          {
            exfname( srcstr, tmpst1 );
            if ( (jj == 0) || *pd == ':' )
              strcat( desstr, tmpst1 ); 
            else if ( valpath( desstr ) )
            {
              strcat( desstr, &slash[0] );      /* add required slash   */
              strcat( desstr, tmpst1 );         /* add fname from src   */
            } /* else if */
            fcopy( srcstr, desstr );
          } /* else */
        } /* if ii > 0 */
#if debug
        form_alert(1, ADDR("[0][A copy command was encountered.][   OK   ]"));
#endif
} /* c_copy */
 
/************************************************************************/
/* c _ m d                                                              */
/************************************************************************/
        VOID
c_md()
{
/* make a directory                                                     */
        LONG            plong;
        BYTE            chars[80];
 
        mov_wstr( batptr, chars );
        plong = ADDR( chars );
        dos_mkdir( plong );
#if debug
        form_alert(1, ADDR("[0][Made a directory][   OK   ]"));
#endif
} /* c_md */
 
/************************************************************************/
/* c _ g e t d r v                                                      */
/************************************************************************/
        VOID
c_getdrv()
{
        UWORD           drives, hd_flop, mask;
        WORD            ii;
 
        drives = global[13];
        hd_flop = global[14];
        if (hd_flop)                    /* must be a hard-disk system   */
        {
          hd_sys = TRUE;
          mask = 0x0001;
                                /* get the lowest lettered hard disk    */
          for (ii = 15; ii >= 0; ii--)
          {
            if (mask & drives)
            {
              if (mask & hd_flop)
                newbyte = ii + 'A';
            } /* if mask & drives */
            mask <<= 1;
          } /* for */
        } /* if hd_flop */
        else
          hd_sys = FALSE;
} /* c_getdrv */
 
/************************************************************************/
/* c _ p a t b a t                                                      */
/************************************************************************/
        VOID
c_patbat()
{
        BYTE            oldstr[20];
        BYTE            *tmpptr, *ptxt, *matptr;
 
        matptr = bat_pc;
        ptxt = bat_pc;
        mov_wstr( bat_pc, oldstr );
        tmpptr = oldstr;
        while (*ptxt != 0x1A)
        {
          if ( *tmpptr != *ptxt )
          {
            tmpptr = oldstr;
            ptxt++;
            matptr = ptxt;
          }
          else
          {
            while ( (*tmpptr == *ptxt) && (*tmpptr) )
            {
              ptxt++;
              tmpptr++;
            } /* while */
            if (*tmpptr)
              matptr = ptxt;
            else
            {
              tmpptr = oldstr;
              *matptr = newbyte;
            } /* else */
          } /* else */
        } /* while */
} /* c_patbat */
 
/************************************************************************/
/* c _ i f 1 b u t n                                                    */
/************************************************************************/
        VOID
c_if1butn()
{
        if (butn1)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF1BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if1butn */
 
/************************************************************************/
/* c _ i f 2 b u t n                                                    */
/************************************************************************/
        VOID
c_if2butn()
{
        if (butn2)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF2BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if2butn */
 
/************************************************************************/
/* c _ i f 3 b u t n                                                    */
/************************************************************************/
        VOID
c_if3butn()
{
        if (butn3)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IF3BUTN statement was encountered.][   OK   ]
"));
#endif
} /* c_if3butn */
 
/************************************************************************/
/* c _ i f h d                                                          */
/************************************************************************/
        VOID
c_ifhd()
{
        if (hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFHD statement was encountered.][   OK   ]"))
;
#endif
} /* c_ifhd */
 
/************************************************************************/
/* c _ i f f d                                                          */
/************************************************************************/
        VOID
c_iffd()
{
        if (!hd_sys)
          gotob();
#if debug
        form_alert(1, ADDR("[0][An IFFD statement was encountered.][   OK   ]"))
;
#endif
} /* c_iffd */
 
/************************************************************************/
/* c _ g o t o                                                          */
/************************************************************************/
        VOID
c_goto()
{
        gotob();
#if debug
        form_alert(1, ADDR("[0][A GOTO statement was encountered.][   OK   ]"));
#endif
} /* c_goto */
 
/************************************************************************/
/* c _ l a b e l                                                        */
/************************************************************************/
        VOID
c_label()
{
#if debug
        form_alert(1, ADDR("[0][A LABEL was encountered.][   OK   ]"));
#endif
} /* c_label */
 
/************************************************************************/
/* c _ s r c m s g                                                      */
/************************************************************************/
        BYTE *
c_srcmsg()
{
        BYTE            *new_ptr;
 
        new_ptr = cp_alert( batptr, SRCMSG, TRUE, &SRCBUTN );
#if debug
        form_alert(1, ADDR("[0][A SRCMSG definition was encountered.][   OK   ]"
));
#endif
        return(new_ptr);
} /* c_srcmsg */
 
/************************************************************************/
/* c _ p l a y                                                          */
/************************************************************************/
        VOID
c_play()
{
/* play a tape                                                          */
        WORD            f_handle, num_evnts;
        BYTE            tape_name[13];
 
        tape_name[0] = NULL;
                                        /* get the tape file name       */
        mov_wstr( bat_pc, &tape_name[0] );
        f_handle = dos_open(ADDR(&tape_name[0]), 2);  
        if (DOS_ERR)
        {
          form_alert(1, "[3][Couldn't open the specified TAPE file.][   OK   ]")
;
          return;
        } /* if DOS_ERR */
                                                /* read the tape        */
        num_evnts = read_piece( f_handle, MAX_SIZE, ADDR(&gl_evlist[0]));
        dos_close(f_handle);
        num_evnts = num_evnts / 6;              /* 6 bytes per event    */
                                                /* play it!             */
        appl_tplay(ADDR(&gl_evlist[0]), num_evnts, 500);
} /* c_play */
 
/************************************************************************/
/* r e a d _ b a t                                                      */
/************************************************************************/
        VOID
read_bat()
{
        LONG            plong;
        LONG            count;
        WORD            handle, ret;
        static BYTE             no_txt[] = 
"[3][TUTOR can't find the TUTOR.TXT|file. Insert the disk containing|\
TUTOR.TXT and try again.][ Cancel ]";
 
        static BYTE     *APATH = { "C:\\GEMAPPS\\" };
        static BYTE     *BATCH = { "TUTOR.TXT" };
 
/*      dos_sdrv( 0 );                          /* select drive A       */
        plong = ADDR( APATH );
        dos_chdir( plong );
        plong = ADDR( BATCH );
*/
        handle = dos_open( ADDR("C:\\GEMAPPS\\TUTOR.TXT"), 0 );
        if ( DOS_ERR )
        {
          form_alert(1, ADDR(no_txt));
 
/*        dos_free( dummy );
          ret = appl_exit();
          TERMINATE();
*/
        } /* if DOS_ERR */
        bat_base = &bat_buf[0];
        bat_pc = bat_base;
        count = read_piece( handle, BUF_SIZE, ADDR(&bat_buf[0]) );
        dos_close( handle );
} /* read_bat */
 
/************************************************************************/
/* g o t o b                                                            */
/************************************************************************/
        VOID
gotob()
{
        WORD            status, advance;
        BYTE            matstr[80];
        BYTE            labstr[80];
        BYTE            *ptr;
 
        mov_wstr( batptr, matstr );             /* get the label        */
        if ( matstr[0] )
        {
          status = FALSE;
          advance = FALSE;
          ptr = bat_base;
          while (!status)
          {
            if ( *ptr == 0x1A )
            {
              status = TRUE;
              ptr = batptr;
            } /* if */   
            else if ( *ptr++ == ':' )
            {
              mov_wstr( ptr, labstr );
              status = cmp_str( labstr, matstr );
            } /* else if */
          } /* while */
          ptr += 2;
          bat_pc = ptr;     
        } /* if */
} /* gotob */
 
/************************************************************************/
/* G E M A I N                                                          */
/************************************************************************/
        VOID
GEMAIN()
{
        WORD            notend, ret, advance;
        WORD            done, ev_which, first, cont;
        WORD            mx, my, mb, ks, kret, bret;
                                                /* initialize libraries */
        gl_ab]d = appl_init();
        gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
                                /* find out what drives we've got       */
        hd_sys = FALSE;                 /* default is floppy system     */
        c_getdrv();
#if debug
form_alert(1, ADDR("[0][Passed c_getdrv()][   OK   ]"));
#endif
                                                /* get size of desktop  */
        wind_get(0, WF_WXYWH, &gl_desk.g_x, &gl_desk.g_y,
                 &gl_desk.g_w, &gl_desk.g_h);
                                                /* open resource file   */
        ret = rsrc_load( ADDR("TUTOR.RSC") );
        ret = rsrc_gaddr(R_TREE, DISPBOX, &gl_dispbox);
        gl_ittape = menu_register(gl_apid, ADDR("  Tutorial") );
        
        ad_rmsg = ADDR(&gl_rmsg[0]);
        ad_smsg = ADDR(&gl_smsg[0]);
                                                /* initialize mouse     */
        graf_mouse(0, 0x0L);
        gpatsts = FALSE;
        gl_open = FALSE;
#if debug
form_alert(1, ADDR("[0][Before main while loop][   OK   ]"));
#endif
        done = FALSE;
        while (!done)
        {                               /* wait for accessory to open   */
#if debug
form_alert(1, ADDR("[0][In the main while loop][   OK   ]"));
#endif
          advance = FALSE;
          notend = first = TRUE;
                                                /* init alert buttons   */
          butn1 = butn2 = butn3 = FALSE;
          cont = FALSE;
#if debug
form_alert(1, ADDR("[0][Before ev_multi][   OK   ]"));
#endif
/*        wind_update(BEG_UPDATE);
          wind_update(BEG_MCTRL);*/
          ev_which = evnt_multi(MU_MESAG, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0,
                                ad_rmsg, 0, 0, 
                                &mx, &my, &mb, &ks, &kret, &bret);
                                                /* handle message       */
/*        wind_update(END_MCTRL);
          wind_update(END_UPDATE);
*/
          if (ev_which & MU_MESAG)
          {
#if debug
form_alert(1, ADDR("[0][Event was MU_MESAG][   OK   ]"));
#endif
            if (gl_rmsg[0] == AC_OPEN)
            {
#if debug
form_alert(1, ADDR("[0][Event was AC_OPEN][   OK   ]"));
#endif
              if ( (gl_rmsg[4] == gl_ittape) && (!gl_open) )
              {
#if debug
form_alert(1, ADDR("[0][OPEN conditions met][   OK   ]"));
#endif
                gl_open = TRUE;
                cont = TRUE;
              } /* if */
            } /* if AC_OPEN */
            else if (gl_rmsg[0] == AC_CLOSE)
            {
#if debug
form_alert(1, ADDR("[0][Event was AC_CLOSE][   OK   ]"));
#endif
              if ( (gl_rmsg[4] == gl_ittape) && (gl_open) )
              {
#if debug
form_alert(1, ADDR("[0][CLOSE conditions met][   OK   ]"));
#endif
                gl_open = FALSE;
                cont = FALSE;
              } /* if */
            } /* else if AC_CLOSE */
          } /* if MU_MESAG */
 
          if (cont)
          {
#if debug
form_alert(1, ADDR("[0][CONT was TRUE][   OK   ]"));
#endif
            while (notend)
            {
              if (first)
              {
/*              dummy = dos_alloc( 0x00001000L );
                dos_sdta( ADDR( DTA ) );
*/
 
#if debug
form_alert(1, ADDR("[0][FIRST was TRUE][   OK   ]"));
#endif
                read_bat();
                first = FALSE;
              } /* if */
/*            dos_sdta( ADDR( DTA ) );*/
              notend = pars_bat();
              batptr = bat_pc;
              switch(notend)
              {
                case 0:                 /* formerly c_dos();            */
/*                dos_free( dummy );*/
                  notend = FALSE;
                  advance = FALSE;
                  break;
                case 1:
                  bat_pc = c_alert();
                  advance = FALSE;
                  break;
                case 2:
                  bat_pc = c_srcmsg();
                  advance = FALSE;
                  break;
                case 3:
                  c_patbat();
                  advance = TRUE;
                  break;
                case 4:
                  c_copy();
                  advance = TRUE;
                  break;
                case 5:
                  c_md();
                  advance = TRUE;
                  break;
                case 6:
                  c_if1butn();
                  advance = TRUE;
                  break;
                case 7:
                  c_if2butn();
                  advance = TRUE;
                  break;
                case 8:
                  c_if3butn();
                  advance = TRUE;
                  break;
                case 9:
                  c_ifhd();
                  advance = TRUE;
                  break;
                case 10:
                  c_iffd();
                  advance = TRUE;
                  break;
                case 11:
                  c_goto();
                  advance = TRUE;
                  break;
                case 12:
                  c_label();
                  advance = TRUE;
                  break;
                case 13:
                  c_run();
                  advance = FALSE;
                  notend = FALSE;
                  break;
                case 14:
                  c_play();
                  advance = TRUE;
                  break;
                case 15:
                  bat_pc = c_disp();            /* in GIDISP.C          */
                  advance = FALSE;
                  break;
              } /* switch */
              if (advance)
                notend = nextline();
#if debug
form_alert(1, ADDR("[0][After SWITCH][   OK   ]"));
#endif
            } /* while notend */
#if debug
form_alert(1, ADDR("[0][After WHILE NOTEND][   OK   ]"));
#endif
            cont = FALSE;
            gl_open = FALSE;
          } /* if cont */
#if debug
form_alert(1, ADDR("[0][After IF CONT][   OK   ]"));
#endif
        } /* while !done */
#if debug
form_alert(1, ADDR("[0][At end][   OK   ]"));
#endif
/*      dos_free( dummy );
        ret = appl_exit();
        TERMINATE();
*/
} /* GEMAIN */
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GIDISP.C"
 
 
**********************************************************
 
 
 
 
 
/*      GIDISP.C        */
 
/*      GIDISP.C        07/08/85 -- 07/25/85            Gregg Morris    */
/* this module contains the routines to handle the DISPLAY command      */
/* in GEM INSTALL and TUTORIAL                                          */
 
#include "portab.h"
#include "machine.h"
#include "treeaddr.h"
#include "gembind.h"
#include "dosbind.h"
#include "obdefs.h"
#include "install.h"
#include "tutor.h"
 
#define BEG_UPDATE 1
#define END_UPDATE 0
#define BEG_MCTRL 3
#define END_MCTRL 2
 
#define max(x, y) (x) > (y) ? (x) : (y)
#define N_DISPOBS 13
#define RETURN 0x1C0D                           /* carriage return      */
 
EXTERN BYTE     *cp_alert();
 
EXTERN LONG     gl_dispbox;
EXTERN LONG     ad_rmsg;
EXTERN WORD     gl_handle;
EXTERN WORD     butn1, butn2, butn3;
EXTERN WORD     gl_wchar, gl_hchar;
EXTERN BYTE     *batptr;
EXTERN BYTE     disp_str[];
 
EXTERN GRECT    gl_desk;
 
GLOBAL WORD     wh_disp;
GLOBAL WORD     contrl[11];
GLOBAL WORD     intin[80];
GLOBAL WORD     ptsin[256];
GLOBAL WORD     intout[45];
GLOBAL WORD     ptsout[12];
 
BYTE            nils[6] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };
 
/************************************************************************/
/* s o u n d                                                            */
/************************************************************************/
        VOID
sound(isfreq, freq, duration)
        WORD            isfreq, freq, duration;
{
        WORD            cnt;
 
        contrl[0] = 5;
        contrl[1] = 0;
        contrl[6] = gl_handle;
        intin[0] = freq;
        intin[1] = duration;
        if (isfreq)
        {
          contrl[5] = 61;
          contrl[3] = 2;
        } /* if isfreq */
        else
        {
          contrl[5] = 62;
          contrl[3] = 1;
        }
        vdi();
        return(intout[0]);
} /* sound */
 
/************************************************************************/
/* f i n d _ d e f l t                                                  */
/************************************************************************/
        WORD
find_deflt(tree)
        LONG            tree;
{
        UWORD           flags;
        WORD            obj;
 
        obj = BUTN1;
        while ( obj <= BUTN3 )
        {
          flags = LWGET(OB_FLAGS(obj));
          if (flags & DEFAULT)
            return(obj);
        } /* while */
        return(FALSE);
} /* find_deflt */
 
/************************************************************************/
/* h n d l _ k e y b d                                                  */
/************************************************************************/
        WORD
hndl_keybd(tree, ex_butn)
        LONG            tree;
        WORD            *ex_butn;
{
        WORD            done, def_obj, x, y, w, h;
 
        done = FALSE;
                                /* is there a default exit button?      */
        def_obj = find_deflt(tree);
        if (def_obj)
        {
          objc_offset(gl_dispbox, def_obj, &x, &y);
          w = LWGET(OB_WIDTH(def_obj));
          h = LWGET(OB_HEIGHT(def_obj));
          objc_change(tree, def_obj, 0, x, y, w, h, SELECTED, TRUE);
          done = TRUE;
          *ex_butn = def_obj - BUTN1 + 1;
        } /* if */
        return(done);
} /* hndl_keybd */
 
/************************************************************************/
/* h n d l _ b u t n                                                    */
/************************************************************************/
        WORD
hndl_butn(tree, obj, ex_butn)
        LONG            tree;
        WORD            obj, *ex_butn;
{
        UWORD           flags, state;
        WORD            done, mx, my, mb, ks;
 
        done = FALSE;
        flags = LWGET(OB_FLAGS(obj));
        state = LWGET(OB_STATE(obj));
        if ( flags & SELECTABLE )
        {
          if ( graf_watchbox(tree, obj, state ^ SELECTED, state) )
            state ^= SELECTED;
          if ( flags & SELECTABLE )
            evnt_button(1, 0x01, 0x0, &mx, &my, &mb, &ks);
          if ( (state & SELECTED) && (flags & EXIT) )
          {
            *ex_butn = obj - BUTN1 + 1;
            done = TRUE;
          } /* if */
        } /* if */
        return(done);
} /* hndl_butn */
 
/************************************************************************/
/* c _ d i s p                                                          */
/************************************************************************/
        BYTE *
c_disp()
{
        LONG            tvalue, tree;
        UWORD           flags, ev_which;
        WORD            num_strs, max_len, num_butns, max_butn;
        WORD            def_butn, col, row, tdelay, done;
        WORD            butn, ex_butn, obj, mx, my, mb, ks, kret, bret;
        WORD            x, y, w, h, wx, wy, ww, wh;
        BYTE            *pend;
 
        butn1 = butn2 = butn3 = FALSE;
        tree = gl_dispbox;
                                        /* get the DISPLAY string       */
        pend = cp_alert( batptr, &disp_str[0], FALSE, &def_butn );
                                        /* parse it into pieces         */
        tdelay = pars_disp(&disp_str[0], &num_strs, &max_len, &num_butns,
                           &max_butn, &def_butn, &col, &row);
                                        /* build the displayable object */
        bild_disp(gl_dispbox, num_strs, max_len, num_butns, max_butn,
                  def_butn, col, row);
                                        /* get ready for evnt_multi     */
        flags = 0x0;
        if (tdelay > 0)
        {
          if (num_butns)
            flags = MU_KEYBD | MU_BUNMU_TIMER;
          else
            flags = MU_BUTTON | MU_TIMER;
          tvalue = ((LONG) tdelay) * 1000;
        } /* if tdelay */
        else if (num_butns)
        {
          flags = MU_KEYBD | MU_BUTTON;
          tvalue = 0x0L;
        } /* else */
        else
        {
          flags = MU_BUTTON;
          tvalue = 0x0L;
        } /* else */
 
        form_center(gl_dispbox, &x, &y, &w, &h);
                                        /* compute size of window       */
        wind_calc(WC_BORDER, 0, x, y, w, h, &wx, &wy, &ww, &wh);
        wh_disp = wind_create(0, wx, wy, ww, wh);
        wind_open(wh_disp, wx, wy, ww, wh);
        form_dial(FMD_START, 0, 0, 0, 0, wx - 2, wy - 2, ww + 4, wh + 4);
        objc_draw(gl_dispbox, ROOT, MAX_DEPTH, x, y, w, h);
                                        /* set up for loop              */
        butn = 0x01;
        done = FALSE;
        while (!done)
        {
          ex_butn = 0;
          ev_which = evnt_multi(flags, 0x01, 0x01, butn,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                ad_rmsg, tvalue, &mx, &my, &mb,
                                &ks, &kret, &bret);
          if (ev_which & MU_KEYBD)
          {
            if (kret == RETURN)
              done = hndl_keybd(gl_dispbox, &ex_butn);
          } /* if KEYBD */
 
          if (ev_which & MU_BUTTON)
          {
            if (butn == 0x01)
            {
              obj = objc_find(gl_dispbox, ROOT, MAX_DEPTH, mx, my);
              if (obj == NIL)
              {
                sound(TRUE, 440, 2);
                obj = 0;
              } /* if */
              else
                done = hndl_butn(gl_dispbox, obj, &ex_butn);
              butn = 0x0;
            } /* if */
            else
              butn = 0x01;
          } /* if MU_BUTTON */
          if (ev_which & MU_TIMER)
            done = TRUE;
        } /* while !done */
                                        /* set exit button flags        */
        if (ex_butn == 1)
          butn1 = TRUE;
        if (ex_butn == 2)
          butn2 = TRUE;
        if (ex_butn == 3)
          butn3 = TRUE;
                                        /* to generate a redraw message */
        form_dial(FMD_FINISH, 0, 0, 0, 0, wx - 2, wy - 2, ww + 4, wh + 4);
        wind_close(wh_disp);
        wind_delete(wh_disp);
        return(pend);
} /* c_disp */
 
/************************************************************************/
/* s t r b r k                                                          */
/************************************************************************/
        BYTE *
strbrk(tree, pdisp_str, offset, pnitem, pmaxlen)
        LONG            tree;
        BYTE            *pdisp_str;
        WORD            offset, *pnitem, *pmaxlen;
{
/* break the DISPLAY string into smaller strings after a | or ] is      */
/*   encountered. copy the strings into the DISPBOX strings.            */
        REG LONG        pstr;
        REG WORD        nitem, len, maxlen;
        REG BYTE        tmp, nxttmp;
 
        nitem = maxlen = 0; 
        tmp = NULL;
        while( tmp != ']')
        {
          pstr = LLGET(OB_SPEC(offset + nitem));
          len = 0;
                                        /* get 1st char of new string   */
          do
          {
            tmp = *pdisp_str;
            pdisp_str++;
            nxttmp = *pdisp_str;
            if ( (tmp == ']') || (tmp == '|') )
            {
              if (tmp == nxttmp)
                pdisp_str++;
              else
              {
                nxttmp = tmp;
                tmp = NULL;
              } /* else */
            } /* if */
            LBSET(pstr + len, tmp);
            len++;
          } while ( tmp != NULL );
          tmp = nxttmp;
          maxlen = max(len - 1, maxlen);
          nitem++;
        }
        if (maxlen == 0)
        {
          *pnitem = 0;
          *pmaxlen = 0;
        } /* if */
        else
        {
          *pnitem = nitem;
          *pmaxlen = maxlen;
        } /* else */
        return(pdisp_str);
} /* strbrk */
 
/************************************************************************/
/* p a r s _ d i s p                                                    */
/************************************************************************/
        WORD
pars_disp(pdisp_str, pnum_strs, pmax_len, pnum_butns, pmax_butn, pdef_butn, pcol
, prow)
        BYTE            *pdisp_str;
        WORD            *pnum_strs, *pmax_len, *pnum_butns;
        WORD            *pmax_butn, *pdef_butn, pcol, prow;
{
/* the format of the DISPLAY string is:
   DISPLAY [def_butn][time][col,row][string1| ... |string10][butn1|butn2|butn3]
   where
        def_butn = 0 - no default exit button
                   1, 2, 3 - number of default exit button
        time    = number of seconds to display box (999 max)
        col,row = screen column,row of upper left-hand corner (80x25 max)
        strings = up to 10 lines of up to 60 chars. max
        butns   = up to 3 exit buttons of up to 20 chars. max
   Note: the string may be broken across lines after any ] or |.
   pdisp_str initially points past DISPLAY keyword to the space following,
   for ex.:
   pdisp_str = " [1][10][5,5][This is a display string.|This is line 2.][OK | Ca
ncel]"
*/
        WORD            time_delay;
        BYTE            *ptmp;
                                                /* skip space & first [ */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
                                        /* get default button, if any   */
        *pdef_butn = *pdisp_str - '0';
        if (*pdef_butn < 0 || *pdef_butn > 3)
          *pdef_butn = 0;
                                                /* skip to time delay   */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
        ptmp = pdisp_str;
        while (*pdisp_str != ']')
          pdisp_str++;
        *pdisp_str = NULL;
        time_delay = make_num(ptmp);
                                                /* skip to x,y          */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
        ptmp = pdisp_str;
        while (*pdisp_str != ']')
          pdisp_str++;
        *pdisp_str = NULL;
        make_xy(ptmp, pcol, prow);              /* x = col, y = row     */
                                                /* skip to strings      */
        while (*pdisp_str != '[')
          pdisp_str++;
        pdisp_str++;
                                        /* break up the text lines      */
        pdisp_str = strbrk(gl_dispbox, pdisp_str, LINE1, pnum_strs, pmax_len);
        pdisp_str++;
                                        /* break up the buttons         */
        pdisp_str = strbrk(gl_dispbox, pdisp_str, BUTN1, pnum_butns, pmax_butn);
        return(time_delay);
} /* pars_disp */       
 
/************************************************************************/
/* b i l d _ d i s p                                                    */
/************************************************************************/
        VOID
bild_disp(tree, nummsg, mlenmsg, numbut, mlenbut, def_butn, col, row)
        LONG            tree;
        WORD            nummsg, mlenmsg, numbut, mlenbut, def_butn, col, row;
{
        LONG            plong;
        WORD            ii, kk, wspace;
        GRECT           disp, butn, msg;
 
        disp.g_x = max(gl_desk.g_x, (col * gl_wchar));
        disp.g_y = max(gl_desk.g_y, (row * gl_hchar));
        disp.g_w = (mlenmsg * gl_wchar) + (4 * gl_wchar);
        disp.g_h = (nummsg * gl_hchar) + (2 * gl_hchar);
                                /* check screen placement of dispbox */
        chk_place(&disp);
 
        get_obxywh(tree, LINE1, &msg);
        msg.g_w = mlenmsg * gl_wchar;
        msg.g_h = gl_hchar;
 
        butn.g_x = msg.g_x;
        butn.g_y = disp.g_h;
        butn.g_w = mlenbut * gl_wchar;
        butn.g_h = gl_hchar;
                                                /* any buttons ?        */
        if (numbut)
        {
          wspace = ((mlenbut * numbut) + ((numbut + 1) * 2)) * gl_wchar;
          disp.g_w = max(disp.g_w, wspace);
          disp.g_h += (2 * gl_hchar);
        } /* if */
                                                /* init. root object    */
        set_obxywh(tree, ROOT, &disp);
                                        /* set NEXT,HEAD,TAIL to NIL    */
        for(ii = 0; ii < N_DISPOBS; ii++)
          LBCOPY(OB_NEXT(ii), ADDR(&nils[0]), 6);
                                                /* add msg objects      */
        for(ii = 0; ii < nummsg; ii++)
        {
          set_obxywh(tree, LINE1+ii, &msg);
          msg.g_y += gl_hchar;
          objc_add(tree, ROOT, LINE1+ii);
        } /* for */
                                                /* add button objects   */
        for(ii = 0; ii < numbut; ii++)
        {
          kk = BUTN1 + ii;
          LWSET(OB_FLAGS(kk), SELECTABLE | EXIT);
          LWSET(OB_STATE(kk), NORMAL);
          set_obxywh(tree, kk, &butn);
          butn.g_x += butn.g_w + (2 * gl_wchar);
          objc_add(tree, ROOT, kk);
        } /* for */
                                                /* set last object flag */
        LWSET(OB_FLAGS(BUTN1 + numbut - 1), SELECTABLE | EXIT | LASTOB);
                                        /* set default button, if any   */
        if (def_butn)
        {
          plong = OB_FLAGS(BUTN1 + def_butn - 1);
          LWSET(plong, LWGET(plong) | DEFAULT);
        } /* def_butn */
} /* bild_disp */
 
/************************************************************************/
/* s e t _ o b x y w h                                                  */
/************************************************************************/
        VOID
set_obxywh(tree, obj, prect)
        LONG            tree;
        WORD            obj;
        GRECT           *prect;
{
        LWSET(OB_X(obj), prect->g_x);
        LWSET(OB_Y(obj), prect->g_y);
        LWSET(OB_WIDTH(obj), prect->g_w);
        LWSET(OB_HEIGHT(obj), prect->g_h);
} /* set_obxywh */
 
/************************************************************************/
/* g e t _ o b x y w h                                                  */
/************************************************************************/
        VOID
get_obxywh(tree, obj, prect)
        LONG            tree;
        WORD            obj;
        GRECT           *prect;
{
        prect->g_x = LWGET(OB_X(obj));
        prect->g_y = LWGET(OB_Y(obj));
        prect->g_w = LWGET(OB_WIDTH(obj));
        prect->g_h = LWGET(OB_HEIGHT(obj));
} /* get_obxywh */
 
/************************************************************************/
/* m a k e _ n u m                                                      */
/************************************************************************/
        WORD
make_num(ptime)
        BYTE            *ptime;
{
/* return number of seconds to display: 0-999                           */
        WORD            num, factor;
        BYTE            *ptmp;
 
        ptmp = ptime;
        num = 0;
        if (!ptmp)
          return(num);
                                        /* skip to end of number        */
        while (*ptmp)
          ptmp++;
        ptmp--;
                                        /* pick off digits              */
        factor = 1;
        while (ptmp >= ptime)
        {
          num += (*ptmp - '0') * factor;
          factor *= 10;
          ptmp--;
        } /* while */
        return(num);
} /* make_num */
 
/************************************************************************/
/* m a k e _ x y                                                        */
/************************************************************************/
        VOID
make_xy(pxy, pcol, prow)
        BYTE            *pxy;
        WORD            *pcol, *prow;
{
/* return col,row number of upper left corner of DISPBOX (80x25);       */
/* center on screen if none                                             */
        BYTE            *pc, *pr;
 
        pc = pr = pxy;
        if (!pc)
        {
          *pcol = 0;
          *prow = 0;
          return;
        } /* if */
                                        /* find the comma               */
        while (*pr != ',')
          pr++;
        *pr++ = NULL;                   /* NULL it out                  */
        if (*pr == ' ')
          pr++;                         /* point to number past comma   */
                        /* pc now points to col, pr points to row       */
        *pcol = make_num(pc);
        *prow = make_num(pr);
        if (*pcol > 80)
          *pcol = 80;
        if (*prow > 25)
          *prow = 25;
} /* make_xy */
 
/************************************************************************/
/* c h k _ p l a c e                                                    */
/************************************************************************/
        VOID
chk_place(prect)
        GRECT           *prect;
{
        WORD            adj_lr, adj_tb;
 
        if (prect->g_x + prect->g_w > gl_desk.g_w)
          prect->g_x = (gl_desk.g_w - prect->g_w) / 2;
        if (prect->g_y + prect->g_h > gl_desk.g_h)
          prect->g_y = (gl_desk.g_h - prect->g_h) / 2;
} /* chk_place */
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GIUTILS.C"
 
 
**********************************************************
 
 
 
 
/*      GIUTILS.C       */
 
 
/*      GIUTILS.C       06/10/85 -- 09/12/85            Gregg Morris    */
/* Utility routines for GEM INSTALL                                     */
 
#include "portab.h"
#include "machine.h"
#include "dosbind.h"
 
#define CR 0x0D
#define TAB 0x09
 
EXTERN LONG     dos_avail();
EXTERN LONG     dos_alloc();
EXTERN WORD     DOS_ERR;
 
EXTERN WORD     yes, butn1, butn2, butn3;
EXTERN WORD     gpatsts;
EXTERN WORD     SRCBUTN;
EXTERN BYTE     *bat_base;
EXTERN BYTE     *bat_pc;
EXTERN BYTE     *batptr;
EXTERN BYTE     DTA[50];
EXTERN BYTE     err_ret;
EXTERN BYTE     newbyte;
EXTERN BYTE     SRCMSG[255];            /* error message for src dsk    */
 
LONG            gl_xbuf;                /* data xfer buffer     */
UWORD           gl_xlen;
 
/************************************************************************/
/* g e t _ s h p a r m s                                                */
/************************************************************************/
        VOID
get_shparms(pstr, pdoex, pisgr, pisgem, pcmd, ptail)
        BYTE            *pstr;
        WORD            *pdoex, *pisgr, *pisgem;
        BYTE            *pcmd, *ptail;
{
        WORD            ii, jj;
        BYTE            *ps;
 
        ps = batptr;
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* get the codes        */
        *pdoex = *ps++ - '0';
        ps++;
        *pisgr = *ps++ - '0';
        ps++;
        *pisgem = *ps++ - '0';
        ps++;
                                                /* get the command      */
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          *pcmd++ = *ps++;
        *pcmd = NULL;
        if (*ps == 0x0D)
          ps += 2;
        else
          ps++;
                                                /* get the tail         */
        ii = 1;
        while (*ps != ' ' && *ps != 0x0D && *ps != 0x0A)
          ptail[ii++] = *ps++;
        ptail[ii] = NULL;
                                        /* compute length of tail       */
/*      ii = 1;
        jj = 0;
        while (ptail[ii++])
          jj++;*/
        ptail[0] = strlen(ptail[1]);
} /* get_shparms */
 
/************************************************************************/
/* m o v _ w s t r                                                      */
/************************************************************************/
        BYTE *
mov_wstr(ps, pd)
        BYTE    *ps, *pd;
{
/* given a string terminated by <CR>, <LF>, or <SPACE>, this routine    */
/* strips off leading blanks & returns an ASCII Z terminated string.    */
                                                /* skip leading blanks  */
        while (*ps == ' ')
          ps++;
                                                /* copy the string      */
        while ( (*ps != 0x0A) && (*ps != 0x0D) && (*ps != ' ') )
          *pd++ = *ps++;
        *pd = NULL;
        return(ps);
} /* mov_wstr */
 
/************************************************************************/
/* n e x t l i n e                                                      */
/************************************************************************/
        WORD
nextline()
{
/* move the batch file pointer to the next line of the file             */
 
        while ( (*bat_pc != 0x0D) && (*bat_pc != 0x1A ) )
          bat_pc++;
        if ( *bat_pc == 0x1A )
          return(FALSE);                                        /* EOF-- exit   
*/
        if (*bat_pc == 0x0D)
          bat_pc += 2;
        return(TRUE);
} /* nextline */
 
/************************************************************************/
/* m o v _ s t r                                                        */
/************************************************************************/
        VOID
mov_str( ps, pd )
        BYTE            *ps, *pd;
{
/* given a string terminated by <CR> or <LF>, this routine strips off   */
/* leading blanks & returns an ASCII Z terminated string.               */
        while ( *ps == ' ' )
          ps++;
        while ( (*ps != 0x0A) && (*ps != 0x0D) )
          *pd++ = *ps++;
        *pd = NULL;
} /* mov_str */
 
/************************************************************************/
/* c p _ a l e r t                                                      */
/************************************************************************/
        BYTE *
cp_alert( ps, pd, butn_flag, pbutn )
        BYTE            *ps, *pd;
        WORD            butn_flag, *pbutn;
{
/* given a pointer to an alert string, this routine strips off leading  */
/* blanks, removes internal <CRLF> & returns a null-terminated string   */
/* in pd. also returns pointer to char. past end of alert.              */
/* note that an alert string may only have <CRLF> after a | or ]        */
        WORD            done;
        BYTE            chr;
                                                /* skip leading blanks  */
        while ( *ps == ' ' )
          ps++;
        *pd = NULL;
 
        if (butn_flag)
        {                       /* pick up default button, if any       */
          *pbutn = 0;
          if (*ps != '[')
            *pbutn = *ps++ - '0';
        } /* if butn_flag */
                                        /* scan string for <CRLF>       */
        done = FALSE;
        while (!done)
        {
          chr = *ps;
          switch(chr)
          {
            case '|':
                *pd++ = *ps++;
                if (*ps == CR)
                {                               /* skip <CRLF>          */
                  ps += 2;
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                } /* if CR */
                break;
            case ']':
                *pd++ = *ps++;
                if (*ps == CR)
                {
                  ps += 2;                      /* skip <CRLF>          */
                  while (*ps == TAB || *ps == ' ')
                    ps++;                       /* skip spaces & tabs   */
                  if (*ps != '[')
                    done = TRUE;
                } /* if */
                break;
            case CR:
                ps += 2;
                done = TRUE;
                break;
            default:
                *pd++ = *ps++;
                break;
          } /* switch */
        } /* while */
        *pd = NULL;
        return(ps);
} /* cp_alert */
 
/************************************************************************/
/* f c o p y                                                            */
/************************************************************************/
        WORD
fcopy( ps, pd )
        BYTE            *ps, *pd;
{
/* copy file ps to file pd                                              */
        LONG            lbase, lavail;
        UWORD           amt_read, amt_wrote;
        UWORD           fsrc, fdst;             /* file handles         */
        WORD            ret;
 
                                        /* allocate memory for buffer   */
        lavail = dos_avail();
        gl_xlen = (lavail > 0x0000FFF0L) ? 0xFFF0 : LLOWD(lavail);
        gl_xlen -= 0x0200;
        gl_xbuf = dos_alloc(LW(gl_xlen));
                                                /* open source file     */
        fsrc = dos_open (ADDR(ps), 0);
        while ( DOS_ERR )
        {
          ret = form_alert(SRCBUTN, ADDR(&SRCMSG[0]));
          if (ret > 1)
            return(FALSE);
          fsrc = dos_open( ADDR(ps), 0 );
        } /* while */
                                        /* create destination file      */
        fdst = dos_create (ADDR (pd), 0);
        if ( DOS_ERR )
        {
          form_alert(0, ADDR("[3][Can't create the file during copy.][ Cancel ]"
) );
          dos_close(fsrc);     
          return(FALSE);
        } /* if DOS_ERR */
                                                /* do the copy          */
        lbase = 0x0L;
        while ( amt_read = read_piece (fsrc, gl_xlen, gl_xbuf) )
        {
          amt_wrote = amt_read;
          if ( amt_wrote != write_piece (fdst, amt_wrote, gl_xbuf) )
          {                                           /* file system error */
            dos_close(fsrc);     
            dos_close(fdst);
            return(FALSE);
          } /* if */
 
          lbase += (LONG) amt_wrote;
          if (amt_read != amt_wrote)
            dos_lseek(fsrc, 0, lbase);
        } /* while */
                                                /* close the files      */      
        dos_close (fsrc);
        dos_close (fdst);
                                                /* free the buffer      */
        dos_free(gl_xbuf, gl_xlen);
        return(TRUE);
} /* fcopy */
 
/************************************************************************/
/* v a l p a t h                                                        */
/************************************************************************/
        WORD
valpath( ptr )
        BYTE    *ptr;
{
/* returns TRUE if path is valid; FALSE otherwise                       */
 
        WORD            ii;
 
        ii = FALSE;
        dos_sfirst( ADDR( ptr ), 0x0010 );
        if ( (DOS_ERR == 0) && (DTA[21] & 0x10) )
          ii = TRUE;
        return( ii );
} /* valpath */
 
/************************************************************************/
/* e x f n a m e                                                        */
/************************************************************************/
        VOID
exfname( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the end of the string past any slashes or colons */
        BYTE            *ptr;
 
        ptr = ps;
        while ( *ptr != NULL )
        {
          if ( (*ptr == ':') || (*ptr == '\\') )
          {
            ptr++;
            ps = ptr;
          } /* if */
          else
            ptr++;
        } /* while */
        while ( *pd++ = *ps++ )
        ;
} /* exfname */
 
/************************************************************************/
/* e x p a t h                                                          */
/************************************************************************/
        VOID
expath( ps, pd )
        BYTE            *ps, *pd;
{
/* returns the head of the path minus filename */
        BYTE            *ptr;
        WORD            ii;
 
        ii = FALSE;
        while ( *ps != NULL )
        {
          if ( (*ps == ':') || (*ps == '\\') )
          {
            ptr = pd;
            ptr++;
            ii = TRUE;
          } /* if */
          *pd++ = *ps++;
        } /* while */
        if ( ii )
          *ptr = '\0';
} /* expath */
 
/************************************************************************/
/* c m p _ s t r                                                        */
/************************************************************************/
        WORD
cmp_str( pa, pb )
        BYTE    *pa,*pb;
{
        WORD            ii;
 
        while ( (*pa == *pb) && (*pa) )
        {
          pa++;
          pb++;
        } /* while */
        ii = FALSE;
        if ( (*pa == NULL) && (*pb == NULL) )
          ii = TRUE;
        return(ii);
} /* cmp_str */
 
/************************************************************************/
/* i n i t f c b                                                        */
/************************************************************************/
        VOID
initfcb( ptr )
        BYTE    *ptr;
{
        WORD    ii;
        BYTE    *ptr1;
 
        ptr1 = ptr;
        for ( ii = 0; ii < 37; ii++ )
          *ptr++ = NULL;
        ptr1++;
        for ( ii = 0; ii < 11; ii++ )
        *ptr1++ = ' ';
} /* initfcb */
 
/************************************************************************/
/* m a k e _ h n u m                                                    */
/************************************************************************/
        WORD
make_hnum(pstr)
        BYTE            *pstr;
{
/* take the given 4-char. string & return a hex number: 0-FFFF          */
        WORD            num, factor, idx;
        BYTE            chr;
 
        num = 0;
        if (!pstr)
          return(num);
                                        /* pick off digits              */
        idx = 3;
        factor = 1;
        while (idx >= 0)
        {
          chr = pstr[idx];
          if (chr >= 'A' && chr <= 'F')
            num += (chr - 'A' + 0x0A) * factor;
          else if (chr >= '0' && chr <= '9')
            num += (chr - '0') * factor;
          factor *= 16;
          idx--;
        } /* while */
        return(num);
} /* make_hnum */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "INSTALL.H"
 
 
**********************************************************
 
 
 
 
 
/*      INSTALL.H       */
 
/*      INSTALL.H       06/25/85 - 07/24/85     Gregg Morris            */
 
#define MAX_EVNTS 1000
#define MAX_SIZE 6000
 
#define EVENT struct strevnt
 
EVENT
{
        WORD            *ev_code;
        LONG            ev_parm;
};
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TUTOR.H"
 
 
**********************************************************
 
 
 
 
 
/*      TUTOR.H         */
 
#define DISPBOX 0       /* TREE */
#define LINE1 1         /* OBJECT in TREE #0 */
#define LINE10 10       /* OBJECT in TREE #0 */
#define BUTN1 11        /* OBJECT in TREE #0 */
#define BUTN2 12        /* OBJECT in TREE #0 */
#define BUTN3 13        /* OBJECT in TREE #0 */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "NEWTCS.ASM" 
 
 
**********************************************************
 
 
 
 
 
/*      NEWTCS.ASM      */
 
;/*     TCS.ASM         01/30/85 -  01/30/85    Tom Rolander            */
;/*     Tiny CS                                                         */
;/*     Modified        09/10/85 -  09/10/85    Mitch Smith             */
;/*     Increased       Stack / Data Size                               */
 
PGROUP  GROUP   BASE,PROG
 
BASE    SEGMENT WORD PUBLIC 'PROG'
BASE    ENDS
 
DGROUP  GROUP   DATA,STACK
 
DATA    SEGMENT PARA PUBLIC 'DATA'
        PUBLIC  _PSP
_PSP    dw      0
        dw      0
        PUBLIC  _VER
_VER    db      "xxxxxxxxxx1.0"
        db      1280 dup(?)  ;/* Changed From 1024 */
stk     dw      0
DATA    ENDS
 
STKRSV  EQU     64
STACK   SEGMENT STACK 'DATA'
SBASE   DB      STKRSV DUP (?)
STACK   ENDS
 
PROG    SEGMENT BYTE PUBLIC 'PROG'
 
        ASSUME  CS:PGROUP
        ASSUME  DS:DGROUP
;
;
        EXTRN   MAIN:NEAR
;
        cli
        mov     ax,dgroup
        mov     ds,ax
        mov     ss,ax
        mov     sp,offset dgroup:stk
        sti
;
        mov     ax,es                   ;es has our psp
        mov     _PSP+2,ax               ;save for use by prostart
                                        ;when it free's memory
        call    MAIN
 
        mov     ax,04c00h
        int     21h                     ;terminate
PROG    ENDS
;
        END
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GPRINTF.ASM"
 
 
**********************************************************
 
 
 
 
/*      GPRINTF.ASM     */
 
 
;/*     GPRINTF.ASM                                     */
;     
PGROUP  GROUP   PROG
 
PROG    SEGMENT BYTE PUBLIC 'PROG'
 
        ASSUME  CS:PGROUP
        PUBLIC  CLS,printf 
 
;this routine clears the character display
CLS:
        mov     ah,2                            ;set cursor position 0,0
        xor     dx, dx
        mov     bh, dh
        int     10h
        mov     ah, 9
        xor     bh, bh
        mov     cx, 2000
        mov     al, 20h
        mov     bl, 7
        int     10h
        ret
 
;this routine emulates the C printf routine
printf:
        push    bp
        mov     bp, sp
        mov     si, 4[bp]       ;get the string pointer
printf_lp:
        mov     al, [si]
        and     al, al          ;is the the end of the string
        jz      printf_done
        cmp     al, 0ah         ; is this an lf
        jz      printf_crlf
printf_ok:
        push    si
        mov     ah, 14
        int     10h
        pop     si
        inc     si
        jmp     printf_lp
printf_done:
        pop     bp
        ret
printf_crlf:
        inc     si
        push    si
        mov     ah, 14
        mov     al, 0ah
        int     10h
        mov     ah, 14
        mov     al, 0dh
        int     10h
        pop     si
        jmp     printf_lp
 
PROG    ENDS    
        END
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "GPRINTF.A86"
 
 
**********************************************************
 
 
 
/*      GPRINTF.A86     */
 
;/*     GPRINTF.A86                             */
;
;
        cseg
        PUBLIC  CLS,printf 
 
;this routine clears the character display
CLS:
        mov     ah,2                            ;set cursor position 0,0
        xor     dx, dx
        mov     bh, dh
        int     10h
        mov     ah, 9
        xor     bh, bh
        mov     cx, 2000
        mov     al, 20h
        mov     bl, 7
        int     10h
        ret
 
;this routine emulates the C printf routine
printf:
        push    bp
        mov     bp, sp
        mov     si, 4[bp]       ;get the string pointer
printf_lp:
        mov     al, [si]
        and     al, al          ;is the the end of the string
        jz      printf_done
        cmp     al, 0ah         ; is this an lf
        jz      printf_crlf
printf_ok:
        push    si
        mov     ah, 14
        int     10h
        pop     si
        inc     si
        jmps    printf_lp
printf_done:
        pop     bp
        ret
printf_crlf:
        inc     si
        push    si
        mov     ah, 14
        mov     al, 0ah
        int     10h
        mov     ah, 14
        mov     al, 0dh
        int     10h
        pop     si
        jmps    printf_lp
;
        end
 
 
 
 
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE END OF "TUTOR.C"
 
 
**********************************************************
**********************************************************
