**********************************************************
**********************************************************
 
 
        THIS IS THE BEGINING OF CODE CONTAINING
 
        A COLLECTION OF IMG & GEM FILE ROUTINES
 
 
**********************************************************
**********************************************************
 
 
WITH RESPECT TO ANY DATA, INFORMATION, OR PROGRAMMING SUGGESTIONS 
PROVIDED BY DIGITAL RESEARCH INC.  (DRI) ON COMPUSERVE, DRI MAKES 
NO WARRANTIES,  EXPRESS OR IMPLIED,  INCLUDING BUT NOT LIMITED TO 
THE  IMPLIED  WARRANTIES OF FITNESS FOR A PARTICULAR PURPOSE  AND 
MERCHANTABILITY.
 
     This file requires the use of TADDR.H.  The code provided here
       is meant to demonstrate some code writing techniques for
       use with IMG and GEM files.  You may use or modify this
       code as you see fit for inclusion in your application
       
                                                        
                JJN/MS           07/29/85
 
This file was previously part of SNAP.C.
 
modified :      09/03/85        Jim Needham
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "O_IMAGE.C"
 
 
**********************************************************
 
 
/* Display bit image files : Susan Bancroft  5-30-85 */
 
#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "taddr.h"
#include "gembind.h"
#include "dos.h"
#include "o_defs.h" 
#include "o_var.h"  
 
EXTERN UWORD DOS_ERR ;          
 
EXTERN BOOLEAN  decode() ;      /* oimagutl.c */
 
/*-----------------------------------------------------------------*/
    VOID
OUTIMAG() 
{
    dsp_img() ;
} /* OUTIMAG */
 
 
/*-----------------------------------------------------------------*/
    VOID
dsp_img()
{
BYTE    image_name[ FNAME_LENGTH ], *pi ;
WORD    i, f_hndl ;
 
    strcpy( lis_dir, image_name ) ;
    pi = &image_name[ strlen( image_name ) ] ;
    for ( i = 5 ; i < contrl[ 3 ] ; i++, pi++ )
        {
        *pi = LLOBT( intin[ i ] ) ;     /* repack characters into bytes */
        }
    *pi = NULL ;
    f_hndl = dos_open( ADDR( image_name ), 0 ) ;
    if ( DOS_ERR )
        return ;
    if ( ! decode( cur_hndl, f_hndl, org_nxpixel, org_nypixel,
                        org_wpixel, org_hpixel, num_planes ) )
        {
        /* alert: memory allocation error. Probably not enough */
        } 
    dos_close( f_hndl ) ;
} /* dsp_img */
 
 
/* end of oimagutl.c */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "DOS.H"
 
 
**********************************************************
 
 
/**
*
* This header file supplies information needed to interface with the
* particular operating system and C compiler being used.
*
**/
 
 
/**
*
* The following symbols define which processor is being used.
*
*       I8080           Intel 8080
*       I8085           Intel 8085
*       Z80             Zilog Z80
*       I8086           Intel 8086 or 8088
*       M68000          Motorola 68000
*       GA16            General Automation 16-bit mini
*       IBMPC           IBM Personal Computer (also sets I8086)
*/
 
 
/**
*
* The following symbols specify which operating system is being used.
*
*       CPM             Any CP/M OS
*       CPM80           CP/M for Intel 8080 or Zilog Z80
*       CPM86           CP/M for Intel 8086
*       CPM68           CP/M for Motorola 68000
*       MSDOS           Microsoft's MSDOS
*
* Note: CPM will be set to 1 for any of the above.
*
*       UNIX            "Standard" UNIX
*       QUNIX           Quantum's QUNIX OS
*       MIBS            General Automation's MIBS OS
*       OASIS           OASIS OS
*       PICK            PICK OS
*
*/
 
#if CPM80
#define CPM 1
#endif
#if CPM86
#define CPM 1
#endif
#if CPM68
#define CPM 1
#endif
 
/**
*
* The following definitions specify the particular C compiler being used.
*
*       LATTICE         Lattice C compiler
*       BDS             BDS C compiler
*       BTL             Bell Labs C compiler or equivalent
*       MANX            MANX Aztec C compiler
*
*/
#define LATTICE 1
 
 
 
/**
*
* The following type definitions take care of the particularly nasty
* machine dependency caused by the unspecified handling of sign extension
* in the C language.  When converting "char" to "int" some compilers
* will extend the sign, while others will not.  Both are correct, and
* the unsuspecting programmer is the loser.  For situations where it
* matters, the new type "byte" is equivalent to "unsigned char".
*
*/
#if LATTICE
typedef char byte;
#endif
 
#if BDS
#define byte char
#endif
 
#if BTL
typedef unsigned char byte;
#endif
 
#if MANX
#define byte char
#endif
 
/**
*
* Miscellaneous definitions
*
*/
#define SECSIZ 128              /* disk sector size */
#if CPM
#define DMA (char *)0x80        /* disk buffer address */
#endif
 
/**
*
* The following structure is a File Control Block.  Operating systems
* with CPM-like characteristics use the FCB to store information about
* a file while it is open.
*
*/
struct FCB
        {
        char fcbdrv;            /* drive code */
        char fcbnam[8];         /* file name */
        char fcbext[3];         /* file name extension */
#if MSDOS
        short fcbcb;            /* current block number */
        short fcblrs;           /* logical record size */
        long fcblfs;            /* logical file size */
        short fcbdat;           /* create/change date */
        char fcbsys[10];        /* reserved */
        char fcbcr;             /* current record number */
        long fcbrec;            /* random record number */
#else
        char fcbexn;            /* extent number */
        char fcbs1;             /* reserved */
        char fcbs2;             /* reserved */
        char fcbrc;             /* record count */
        char fcbsys[16];        /* reserved */
        char fcbcr;             /* current record number */
        short fcbrec;           /* random record number */
        char fcbovf;            /* random record overflow */
#endif
        };
 
#define FCBSIZ sizeof(struct FCB)
 
/**
*
* The following symbols define the sizes of file names and node names.
*
*/
#if CPM
#if MSDOS
#define FNSIZE 16
#define FMSIZE 64
#else
#define FNSIZE 16       /* maximum file node name size */
#define FMSIZE 16       /* maximum file name size */
#endif
#endif
 
#if UNIX
#define FNSIZE 16       
#define FMSIZE 64
#endif
 
 
/**
*
* The following structures define the 8086 registers that are passed to
* various low-level operating system service functions.
*
*/
#if I8086
struct XREG
        {
        short ax,bx,cx,dx,si,di;
        };
 
struct HREG
        {
        byte al,ah,bl,bh,cl,ch,dl,dh;
        };
 
union REGS
        {
        struct XREG x;
        struct HREG h;
        };
 
struct SREGS
        {
        short es,cs,ss,ds;
        };
#endif
 
/**
*
* The following symbols define the code numbers for the various service
* functions.
*
*/
#if MSDOS
#define SVC_DATE 0x2a           /* get date */
#define SVC_TIME 0x2c           /* get time */
#endif
 
/**
*
* The following codes are used to open files in various modes.
*
*/
#if LATTICE
#define OPENR 0x8000            /* open for reading */
#define OPENW 0x8001            /* open for writing */
#define OPENU 0x8002            /* open for read/write */
#define OPENC 0x8001            /* create and open for writing */
#else 
#define OPENR 0
#define OPENW 1
#define OPENU 2
#endif
 
/**
*
* The following codes are returned by the low-level operating system service
* calls.  They are usually placed into _oserr by the OS interface functions.
*
*/
#if MSDOS
#define E_FUNC 1                /* invalid function code */
#define E_FNF 2                 /* file not found */
#define E_PNF 3                 /* path not found */
#define E_NMH 4                 /* no more file handles */
#define E_ACC 5                 /* access denied */
#define E_IFH 6                 /* invalid file handle */
#define E_MCB 7                 /* memory control block problem */
#define E_MEM 8                 /* insufficient memory */
#define E_MBA 9                 /* invalid memory block address */
#define E_ENV 10                /* invalid environment */
#define E_FMT 11                /* invalid format */
#define E_IAC 12                /* invalid access code */
#define E_DATA 13               /* invalid data */
#define E_DRV 15                /* invalid drive code */
#define E_RMV 16                /* remove denied */
#define E_DEV 17                /* invalid device */
#define E_NMF 18                /* no more files */
#endif
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "O_DEFS.H"
 
 
**********************************************************
 
 
 
#define         STDIN           0x0000
#define         STDOUT          0x0001
#define         STDERR          0x0002
#define         STDAUX          0x0003
#define         STDPRN          0x0004
#define         DUPOUT          0x0005
 
#define         K_RSHIFT        0x0001
#define         K_LSHIFT        0x0002
#define         K_CTRL          0x0004
#define         K_ALT           0x0008
 
                                        /* masks for flag word in metafile */
#define         IMG_FLAG        0x0001  /* mfile contains image escape cmd */
 
#define         GEM_FILE        1
#define         TXT_FILE        2
#define         PCL_FILE        3
#define         IMG_FILE        4
 
#define         UARROW          0x4800
#define         RARROW          0x4D00
#define         DARROW          0x5000
#define         LARROW          0x4B00
#define         ESCAPE          0x011B
 
#define         PRT_MSG         200
#define         STRT_MSG        201
 
#define         OK              1
#define         CANCEL          0
 
#define         MO_ARROW        0 
#define         MO_HGLASS       2
#define         MOUSE_OFF       256
#define         MOUSE_ON        257
 
#define         COL_WIDTH       14
#define         COL_LGTH        12
#define         NUM_COL         3
#define         MAX_ENTRIES     36
 
#define         SCRN_NUM        01
#define         PLOT_NUM        11
#define         PRNT_NUM        21
#define         CMRA_NUM        41
#define         PHYSICAL_PAGE   0
#define         META_WINDOW     1
 
#define         TOPLEFT         0
#define         CENTERED        1
#define         BOTTOMRIGHT     2
 
#define         MAX_COLORS      16
#define         CONTRL_SIZE     16
#define         INTIN_SIZE      132
#define         PTSIN_SIZE      256
#define         INTOUT_SIZE     128
#define         PTSOUT_SIZE     128
 
#define         GDP             11
#define         CIRCLE          2
#define         ARC             3
#define         PIE             4
#define         ELLIPSE         5
#define         ELLIP_ARC       6
#define         ELLIP_PIE       7
#define         FORMT_TEXT      10
#define         CHAR_BASELINE   13
#define         LINE_WIDTH      16
#define         MARKER_HGT      19
#define         ABS_CHAR_HGT    12
#define         PTS_CHAR_HGT    107
#define         FILL_STYLES     23
#define         SET_FILL_INDEX  24
#define         CLIP            129
#define         ESC_CMD         5
#define         IMGF_CMD        23
#define         SET_FONT_FACE   21
 
#define         PATTERNS        2
#define         HATCH           3
 
#define         WAIT_OPT        0
#define         CYCLE_OPT       1
#define         CLR_OPT         2
 
#define         GSX_EXT         fr_str[ 0 ] 
#define         OPT_EXT         fr_str[ 1 ] 
#define         LIS_EXT         fr_str[ 2 ] 
#define         PCL_EXT         fr_str[ 3 ] 
#define         IMG_EXT         fr_str[ 4 ] 
 
#define         UNTITLED        fr_str[ 5 ] 
 
                /*      033 = octal for 27d, escape character */
#define         GEM_CMD         "\033\033GEM"
#define         IMG_CMD         "\033\033IMG"
 
#define         HTAB            0x09
#define         LF              0x0a
#define         FF              0x0c
#define         CR              0x0d
#define         EOF             0x1a
#define         SP              0x20
#define         ASTERISK        0x2a
#define         COMMA           0x2c
#define         PERIOD          0x2e
#define         SLASH           0x2f
#define         COLON           0x3a
#define         BSLASH          0x5c
 
#define         BUF_SIZE        64   /* 2048 */
 
#define         FNAME_LENGTH    80 
#define         PATH_LENGTH     67
#define         NAME_LENGTH     13
 
#define         MX_FONTS        4
#define         MX_FSIZES       10
 
#define ERROR            1
#define FUNCODE          contrl[ 5 ]
#define NUM_INTIN        contrl[ 3 ]
#define NUM_PTSIN        contrl[ 1 ]
#define OPCODE           contrl[ 0 ]
 
#define FROM_BEG 0
 
typedef struct btfl {
        BYTE head[ 10 ] ;
        WORD num ;
        BYTE names[ MAX_ENTRIES ][ NAME_LENGTH ] ;
} BTCHFL ;
 
typedef struct color_bundle {
        WORD red ;
        WORD green ;
        WORD blue ;
        WORD bas_col ;
        WORD lgtns ;
} CLBNDL ;
 
typedef struct opts {
        BYTE head[ NAME_LENGTH ] ;
        WORD wait ;
        WORD cycle ;
        WORD scr_tmlo ;
        WORD init_ff ;
        WORD final_ff ;
        WORD prscl ;
        WORD prhj ;
        WORD prvj ;
        WORD plscl ;
        WORD plhj ;
        WORD plvj ;
        WORD film;
        WORD lgt;
        CLBNDL cmclr[ MAX_COLORS ] ;
        WORD cur_dvc ;
        WORD pr_bkgrnd ;
} OPTIONS ;
 
typedef struct rtangle {
        WORD    left ;
        WORD    top ;
        WORD    right ;
        WORD    bottom ;
} RECTANGLE ;
 
typedef union bffr {
        WORD mf[ BUF_SIZE ] ;
        BYTE txt[ 2*BUF_SIZE ] ;
} BUFFR ;
 
/* end of outdefs.h */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "O_VAR.H"
 
 
**********************************************************
 
 
/* EXTERNAL declarations of variables for GEM OUTPUT.   */
/* Susan Bancroft               5/6/85                  */
 
 
EXTERN BYTE     cur_fname[ FNAME_LENGTH ] ;
EXTERN BYTE     btch_hdr[ 10 ] ;
EXTERN BYTE     names[ MAX_ENTRIES ][ NAME_LENGTH + 1 ] ;
EXTERN BYTE     nul_name[ 1 ] ;
EXTERN BYTE     cur_file[ FNAME_LENGTH ] ;
EXTERN BYTE     list_name[ FNAME_LENGTH ] ;
EXTERN BYTE     copies[ 3 ] ;
EXTERN BYTE     opts_hdr[ NAME_LENGTH ] ;
EXTERN BYTE     lis_dir[ PATH_LENGTH ] ;
EXTERN BYTE     opt_dir[ PATH_LENGTH ] ;
EXTERN BYTE     opt_file[ 9 ] ;
EXTERN BYTE     app_dir[ PATH_LENGTH ] ;
EXTERN BYTE     lis_wc[ NAME_LENGTH ] ;
EXTERN BYTE     gsx_wc[ NAME_LENGTH ] ;
EXTERN BYTE     opt_wc[ NAME_LENGTH ] ;
EXTERN BYTE     inv_fname[ NAME_LENGTH ] ;
EXTERN BYTE     ret_name[ NAME_LENGTH ] ;
EXTERN BYTE     invoker[ 129 ] ;
EXTERN BYTE     cmd_tail[ 129 ] ;
EXTERN BYTE     invkr_file[ 129 ] ;
EXTERN BYTE     gl_cmd[ INTOUT_SIZE ] ;
EXTERN BYTE     gl_tail[ INTOUT_SIZE ] ;
EXTERN BYTE     gl_fcb1[ MAX_ENTRIES ] ;
EXTERN BYTE     gl_fcb2[ MAX_ENTRIES ] ;
EXTERN BYTE     fr_str[ 10 ][ NAME_LENGTH ] ;
EXTERN BYTE     *pbyte1 ;
EXTERN BYTE     *pbyte2 ;
 
EXTERN BOOLEAN  bool1 ;
EXTERN BOOLEAN  is_pcl_file ;
EXTERN BOOLEAN  is_image ;
EXTERN BOOLEAN  is_spool ;
EXTERN BOOLEAN  expand_tabs ;
EXTERN BOOLEAN  let_rot ;
EXTERN BOOLEAN  bkgnd_ok ;
EXTERN BOOLEAN  fonts_loaded ;
EXTERN BOOLEAN  prnt_open ;
EXTERN BOOLEAN  init_ff ;
EXTERN BOOLEAN  film_names ;
 
EXTERN WORD     nfonts ;
EXTERN WORD     fnt_index[ MX_FONTS ] ;
EXTERN WORD     avail_point[ MX_FONTS][ MX_FSIZES ] ;
EXTERN WORD     avail_pixel[ MX_FONTS][ MX_FSIZES ] ;
EXTERN WORD     font_eps ;
EXTERN WORD     cur_font ;
EXTERN WORD     scr_hndl ;
EXTERN WORD     gem_hndl ;
EXTERN WORD     gl_wchar ;
EXTERN WORD     gl_hchar ;
EXTERN WORD     gl_wbox ;
EXTERN WORD     gl_hbox ;
EXTERN WORD     contrl[ CONTRL_SIZE ] ;
EXTERN WORD     intin[ INTIN_SIZE ] ;
EXTERN WORD     ptsin[ PTSIN_SIZE ] ;
EXTERN WORD     intout[ INTOUT_SIZE ] ;
EXTERN WORD     ptsout[ PTSOUT_SIZE ] ;
EXTERN WORD     out_id ;
EXTERN WORD     gl_rmsg[ 8 ] ;
EXTERN WORD     gl_smsg[ 8 ] ;
EXTERN WORD     tmlo ;
EXTERN WORD     flags ;
EXTERN WORD     wh_out ;
EXTERN WORD     dsp_tmlo ;
EXTERN WORD     cycle ;
EXTERN WORD     num_copy ;
EXTERN WORD     gl_wcol ;
EXTERN WORD     gl_rtray ;
EXTERN WORD     gl_btray ;
EXTERN WORD     gl_ttic ;
EXTERN WORD     gl_xttl ;
EXTERN WORD     gl_yttl ;
EXTERN WORD     gl_tslots ;
EXTERN WORD     s_slot ;
EXTERN WORD     e_slot ;
EXTERN WORD     next_slot ;
EXTERN WORD     num_empty ;
EXTERN WORD     num_slct ;
EXTERN WORD     ob_lst[ MAX_ENTRIES+1 ] ;
EXTERN WORD     modified ;
EXTERN WORD     tray_open ;
EXTERN WORD     gl_ob ;
EXTERN WORD     gl_xob ;
EXTERN WORD     gl_yob ;
EXTERN WORD     gl_wob ;
EXTERN WORD     gl_hob ;
EXTERN WORD     b_indx ;        /* index into current buffer */
EXTERN WORD     b_length ;      /* length in bytes of current buffer */
EXTERN WORD     sav_byte ;      /* current byte number in file */
EXTERN WORD     nn ;            /* length of gem file in printer line widths */
EXTERN WORD     hdr_size ;
EXTERN WORD     f_open ;
EXTERN WORD     f_handle ;
EXTERN WORD     *buf_pos ;
EXTERN WORD     *buf_end ;
EXTERN WORD     buf_lgth ;
EXTERN WORD     fst_buf ;
EXTERN WORD     file_type ;
EXTERN WORD     graf_mode ;     /* Flag for screen or alpha mode*/
EXTERN WORD     best_fit ;      /* Best fit flag for printer or plotter*/
EXTERN WORD     horz_just ;     /* Horizontal justification */
EXTERN WORD     vert_just ;     /* Vertical justification       */
EXTERN WORD     dvc_num ;       /* Number of selected device*/
EXTERN WORD     cur_hndl ;      /* Handle for selected device*/
EXTERN WORD     nxpixel ;       /* Number of x pixels across physical page*/
EXTERN WORD     nypixel ;       /* Number of y pixels across physical page*/
EXTERN WORD     x_size ;        /* Number of x pixels across virtual page*/
EXTERN WORD     y_size ;        /* Number of y pixels across virtual page*/
EXTERN WORD     dvc_nxpixel ;   /* Number of x pixels across device */
EXTERN WORD     dvc_nypixel ;   /* Number of y pixels across device */
EXTERN WORD     dvc_wpixel ;    /* pixel width after rotation */
EXTERN WORD     dvc_hpixel ;    /* pixel height after rotation */
EXTERN WORD     org_nxpixel ;   /* Original device parameters */
EXTERN WORD     org_nypixel ;
EXTERN WORD     org_wpixel ;
EXTERN WORD     org_hpixel ;
EXTERN WORD     set_point ;     /* Parameters for converting point size */
EXTERN WORD     pix_inch ;      /* to absolute height for screen display*/
EXTERN WORD     char_width ;
EXTERN WORD     char_hgt ;
EXTERN WORD     cell_width ;
EXTERN WORD     cell_hgt ;
EXTERN WORD     org_height ;
EXTERN WORD     bf_height ;
EXTERN WORD     page_width ;    /* Page size in tenths of mm */
EXTERN WORD     page_height ;
EXTERN WORD     mf_xtrans ;     /* transformation parameters */
EXTERN WORD     mf_ytrans ;
EXTERN WORD     mf_xlength ;
EXTERN WORD     mf_ylength ;
EXTERN WORD     rotate ;                /* Flag indicating picture rotation */
EXTERN WORD     mf_contrl[ 12 ] ;
EXTERN WORD     mf_intin[ INTOUT_SIZE ] ;
EXTERN WORD     mf_ptsin[ INTOUT_SIZE ] ;
EXTERN WORD     num_planes ;
EXTERN WORD     max_intin ;
EXTERN WORD     max_ptsin ;
EXTERN WORD     nxoffset ;      /* justification offsets        */
EXTERN WORD     nyoffset ;
EXTERN WORD     dvc_nxoff ;     /* justification offsets in device units */
EXTERN WORD     dvc_nyoff ;
EXTERN WORD     brk_out ;       /* flag to breakout of display loop */
EXTERN WORD     p_col1[ 10 ] ;  /* the main color in primary colors */
EXTERN WORD     p_col2[ 10 ] ;  /* the other color in primary colors */
EXTERN WORD     s_col1[ 10 ] ;  /* the main color in secondary colors */
EXTERN WORD     s_col2[ 10 ] ;  /* the other color in secondary colors */
EXTERN WORD     n_col[ 10 ] ;  /* the main color in neutral colors */
 
EXTERN LONG     ad_break ;
EXTERN LONG     tray_tr ;
EXTERN LONG     ad_rmsg ;
EXTERN LONG     ad_smsg ;
EXTERN LONG     gl_menu ;
EXTERN LONG     ad_cmd ;
EXTERN LONG     ad_tail ;
EXTERN LONG     ad_fcb1 ;
EXTERN LONG     ad_fcb2 ;
EXTERN LONG     pcnt_tree ;     /* Address of print count tree  */
EXTERN LONG     w_desk ;
EXTERN LONG     name_ptr[ MAX_ENTRIES ] ;
EXTERN LONG     nul_ptr ;
EXTERN LONG     dvc_xlength ;   /* width of device in micrometers */
EXTERN LONG     dvc_ylength ;   /* height of device in micrometers */
 
EXTERN RECTANGLE page_wdw ;
EXTERN RECTANGLE pcl_extent ;
 
EXTERN BUFFR    buffer ;
 
EXTERN OPTIONS  cur_opts ;
 
EXTERN BTCHFL   btchfl_buf ;
 
EXTERN GRECT    gl_desk ;
EXTERN GRECT    gl_win ;
EXTERN GRECT    gl_out ;
EXTERN GRECT    gl_tray ;
 
EXTERN USERBLK  gl_udtray ;
EXTERN PARMBLK  parm_tr ;
 
EXTERN OBJECT   desk[ 1 ] ; 
 
EXTERN LONG     brk_addr ;              /* util86.asm */
EXTERN LONG     drawaddr ;              /* util86.asm */
 
 
/* end of o_var.h */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "OIMAGUTL.C"
 
 
**********************************************************
 
 
/* file I/O, load/save pattern code for PAINT                           */
 
#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "dos.h"
 
#define MAX_XPELS       1024
#define MAX_PLANES      4               
 
LONG    raw_fptr ;
UWORD   raw_fsize ;
UWORD   scratch[ ( ( MAX_XPELS / 16 ) + 1 ) * MAX_PLANES ] ; 
WORD    xyr[ 8 ] ;              /* source and dest rects in rcs */
GLOBAL struct memform_db
{
    LONG        mp ;
    WORD        fwp ;
    WORD        fh ;
    WORD        fww ;
    WORD        ff ;
    WORD        np ;
    WORD        r1 ;
    WORD        r2 ;
    WORD        r3 ;
} src_MFDB, dest_MFDB ;
 
LONG    decode_buf, decode_ptr ;
LONG    f_ptr ;
 
UWORD   f_buf_len, f_buf_size, f_index ;
WORD    vert_rep ;
WORD    lines_avail ;
WORD    s_next_plane, s_scan_bytes ;
 
GLOBAL WORD     blt_byte, scan_byt, planes ;
GLOBAL LONG     blt_addr, buff_addr, nxt_plane ;
GLOBAL WORD     buff_cnt ;
GLOBAL LONG     buff_ptr, blt_ptr ;
 
GLOBAL struct img_header
{
    WORD        img_ver ;       /* version number */
    WORD        length ;                /* length in words of header */
    WORD        plane_cnt ;
    WORD        patlen ;                /* pattern length 2 bytes*/
    WORD        xsize ;         /* pixel x size in microns */
    WORD        ysize ;         /* pixel y size in microns */
    WORD        num_pels ;      /* length of line in pels */
    WORD        num_scans ;
} header ;
 
EXTERN LONG dos_alloc() ;               
EXTERN LONG dos_avail() ;               
EXTERN WORD dos_free() ;                
EXTERN LONG seg_off() ;                 
EXTERN VOID swapbyte() ;                
EXTERN VOID b_stuff() ;                 
EXTERN VOID bmove() ;                   
 
/*-----------------------------------------------------------------*/
    VOID
init_MFDB( img_addr, dx_pixel, dy_pixel, n_planes )
LONG    img_addr ;
WORD    dx_pixel, dy_pixel ;
WORD    n_planes ;
{
    src_MFDB.mp = img_addr ;
    src_MFDB.fwp = ( (header.num_pels + 15) & (~0x0F) ) ;
    src_MFDB.fh = header.num_scans ;
    src_MFDB.fww = src_MFDB.fwp / 16 ; /* size in words from size in bits */
    src_MFDB.np = header.plane_cnt ;
    b_stuff( ADDR( &dest_MFDB ), sizeof( dest_MFDB ), 0 ) ;
    dest_MFDB.np = n_planes ;
    xyr[ 0 ] = xyr[ 1 ] = 0 ;   /* top left source */
    xyr[ 2 ] = min( header.num_pels  - 1, dx_pixel ) ;
    xyr[ 3 ] = min( header.num_scans - 1, dy_pixel ) ;
    xyr[ 4 ] = (dx_pixel - xyr[ 2 ]) / 2 ;      /* dest rect */
    xyr[ 5 ] = (dy_pixel - xyr[ 3 ]) / 2 ;
    xyr[ 4 ] -= ( xyr[ 4 ] % 16 ) ;
    xyr[ 5 ] -= ( xyr[ 5 ] % 16 ) ;
    xyr[ 6 ] = xyr[ 4 ] + xyr[ 2 ] ;
    xyr[ 7 ] = xyr[ 5 ] + xyr[ 3 ] ;
} /* init_MFDB */
 
#define MAX_BUF 0x0000FFFFL
/*-----------------------------------------------------------------*/
    BOOLEAN
image_alloc( dx_pixel, dy_pixel, n_planes )
WORD    dx_pixel, dy_pixel ;
WORD    n_planes ;
{
LONG    mem_avail ;
LONG    mem_need, scratch_size, raw_need, l_fsize ;
LONG    img_addr ;
 
    scratch_size = ( ((LONG)(header.num_pels) / 8) + 1) * (LONG)( header.plane_c
nt ) ;
    mem_need =  scratch_size * 0x0AL ;
    raw_need = (scratch_size * (LONG)(header.num_scans) / 0x02L ) ;     /* gener
ally plenty for raw file */
    mem_avail = dos_avail() ;
    if ( mem_avail > MAX_BUF )
        mem_avail = MAX_BUF ;
    if ( mem_avail < raw_need )
        return( FALSE ) ;
    raw_fptr = dos_alloc( raw_need ) ;   
    mem_avail = dos_avail() ;
    if ( mem_avail > MAX_BUF )
        mem_avail = MAX_BUF ;
    if ( mem_avail < mem_need )         /* work with at least */
        {                               /* 10 scan lines at a time */
        dos_free( raw_fptr, 0 ) ;
        return( FALSE ) ;
        }
    f_buf_size = ( UWORD )( raw_need ) ;
    img_addr = dos_alloc( mem_avail ) ; /* take all the rest of mem */
    b_stuff( img_addr, mem_avail, 0 ) ;
    init_MFDB( img_addr, dx_pixel, dy_pixel, n_planes ) ;
    lines_avail = ( mem_avail / scratch_size ) ;
    return( TRUE ) ;
} /* image_alloc */
 
 
/*----------------------------------------------------------------------*/
    VOID
do_decode( cur_hndl, f_hndl, sheight, swidth, src_inc, dst_inc, dst_plane, 
                n_planes ) 
WORD    cur_hndl, f_hndl ;
WORD    sheight, swidth ;
LONG    src_inc, dst_inc ;
LONG    dst_plane ;
WORD    n_planes ;
{
    WORD        i, j ,k ;
    UWORD       *sptr, *dptr ;
    LONG        src_mp, dst_mp ;
 
    dst_mp = src_MFDB.mp ;
    for ( i = sheight ; i > 0 ; i-- )
        {
        get_line( f_hndl ) ;
        for ( j = header.plane_cnt ; j > n_planes ; j-- )
            {
            dptr = scratch ;
            sptr = &scratch[( j - 1 ) * ( s_next_plane >> 1 )] ;
            for ( k = ( swidth >> 1 ) ; k > 0 ; k-- )
                *dptr++ |= *sptr++ ;
            }        
        src_mp = ADDR( scratch ) ;
        for ( j = n_planes ; j > 0 ; j-- )
            {
            b_move( src_mp, swidth, dst_mp ) ;
            swapbyte( dst_mp, swidth >> 1 ) ;
            src_mp += src_inc ;
            dst_mp += dst_plane ;
            }   
        for ( j = n_planes ; j > 0 ; j-- )
            dst_mp -= dst_plane ;
        dst_mp += dst_inc ;
        }  /* End for:  over scan lines. */
    src_MFDB.ff = 1 ;  /* standard format */
    vr_trnfm( cur_hndl, &src_MFDB, &src_MFDB ) ;
    v_clrwk( cur_hndl ) ;
    vro_cpyfm( cur_hndl, 3, xyr, &src_MFDB, &dest_MFDB ) ;
} /* do_decode */
 
 
#define HEADSIZE 0x0008
/************************************************************************/
/* d e c o d e                                                          */
/************************************************************************/
    BOOLEAN
decode( cur_hndl, file_handle, dx_pixel, dy_pixel, sz_xpel, sz_ypel, n_planes )
WORD    cur_hndl, file_handle ;
WORD    dx_pixel, dy_pixel, sz_xpel, sz_ypel ;
WORD    n_planes ;
{
    WORD        i, j ,k ;
    UWORD       *sptr, *dptr ;
 
    WORD        newsize ;
    WORD        swidth, sheight ;
    LONG        dst_plane ;
    LONG        src_inc, src_mp, dst_inc, dst_mp ;
 
 
    dos_read( file_handle, HEADSIZE<<1, ADDR( &header ) ) ;
/* Swap bytes in the header.    */
#if I8086
    swapbyte( ADDR( &header ), HEADSIZE ) ;
#endif  
    if ( ! image_alloc( dx_pixel, dy_pixel, n_planes ) )
        return( FALSE ) ;
    s_scan_bytes = ( header.num_pels + 7 ) / 8 ;
    s_next_plane = 2*( (header.num_pels + 15 )/16 ) ;
    decode_buf = ADDR( scratch ) ;
    b_stuff( decode_buf, s_next_plane * n_planes, 0 ) ;
    f_ptr = raw_fptr ;
    f_index = 0 ;
    f_buf_len = dos_read( file_handle, f_buf_size, f_ptr ) ;
    vert_rep = 0 ;
    swidth = 1 + min( src_MFDB.fwp >> 3, s_next_plane ) ;
    swidth &= ( ~0x01 ) ;
    sheight = min( src_MFDB.fh, header.num_scans ) ;
    if ( header.plane_cnt > 1 )
        src_inc = seg_off( s_next_plane ) ;
    else
        src_inc = 0x0L ;
    dst_inc = seg_off( src_MFDB.fww << 1 ) ;
    dst_plane = seg_off( ( src_MFDB.fww << 1 ) * src_MFDB.fh ) ;
    vs_clip( cur_hndl, 1, &xyr[ 4 ] ) ;
    do
        {
        do_decode( cur_hndl, file_handle, 
                        min( sheight, lines_avail ), swidth, 
                        src_inc, dst_inc, dst_plane, 
                        n_planes ) ;
        sheight -= lines_avail ;
        } while ( sheight > 0 ) ;
    dos_free( raw_fptr, 0 ) ;
    dos_free( src_MFDB.mp, 0 ) ;
    return( TRUE ) ;
} /* decode */
 
 
#define PATSIZE  0x0002
/************************************************************************/
/* g e t _ l i n e                                                      */
/************************************************************************/
    VOID
get_line( file_handle )
WORD    file_handle ;
{
    BYTE        color, opcode ;
    BYTE        temp_array[3], pat_buf[PATSIZE] ;
    WORD        bytes, i, j, run ;
 
/* If a vertical replication is to be made, little needs to be done.    */
    if ( vert_rep )
    {
        vert_rep-- ;
        return ;
    }  /* End if:  vertical replication. */
 
        /* Process a scan line escape command, if one is specified.     */
    if ( !LBGET( f_ptr ) )
    {
        transfer( 1, ADDR( temp_array ), file_handle ) ;
        if ( !LBGET( f_ptr ) )
        {
                /* Currently, only one scan line escape is defined:     */
                /* the vertical replication escape.  Process it.        */
            transfer( 3, ADDR( temp_array ), file_handle ) ;
            vert_rep = temp_array[2] - 1 ;
        }  /* End if:  scan line escape command specified. */
        else
        {       
            f_ptr-- ;
            f_index-- ;
        }
    }  /* End if:  must check for scan line escape command. */
                /* Loop over the number of bit planes in the source.    */
    for ( i = 0 ; i < header.plane_cnt ; i++ )
    {
        /* Set the decode buffer pointer to the address of the first    */
        /* byte in the decode buffer of the plane being processed.      */
        decode_ptr = decode_buf + ( LONG )( i * s_next_plane ) ;
        /* Loop until this plane of the scan line has been filled.      */
        bytes = 0 ;
        while ( bytes < s_scan_bytes )
        {
                /* Process according to the byte being pointed to.  If  */
                /* the low seven bits is non-zero, a solid run is to be */
                /* output.  Otherwise, if the byte is zero, a pattern   */
                /* run is to be output.  Otherwise ( low seven bits are  */
                /* zero, but the high bit is set ), a bit string is to   */
                /* be output.                                           */
            if ( ( opcode = ( LBGET( f_ptr ) ) ) & 0x7f )
            {
                transfer( 1, ADDR( temp_array ), file_handle ) ;
                run = ( WORD )( opcode & 0x7f ) ;
                color = ( opcode & 0x80 ) ? 0xff : 0 ;
                b_stuff( decode_ptr, run, color ) ;
                decode_ptr += ( LONG )( run ) ;
                bytes += run ;
            }  /* End if:  solid run. */
            else
            {
                /* Get the first two bytes of the command -- the second */
                /* byte is the length of the data which follows.        */
                transfer( 2, ADDR( temp_array ), file_handle ) ;
                run = ( WORD )( temp_array[1] ) ;
                /* Process according to whether a pattern run or a bit  */
                /* string has been specified.                           */
                if ( !opcode )
                {
                    transfer( header.patlen, ADDR( pat_buf ), file_handle ) ;
                    for ( j = 0 ; j < run ; j++ )
                    {
                        b_move( ADDR( pat_buf ), header.patlen, decode_ptr ) ;
                        decode_ptr += ( LONG )( header.patlen ) ;
                    }  /* End for:  over pattern run length. */
                    bytes += run * header.patlen ;
                }  /* End if:  pattern run. */
                else
                {
                    transfer( run, decode_ptr, file_handle ) ;
                    decode_ptr += ( LONG )( run ) ;
                    bytes += run ;
                }  /* End else:  bit string. */
            }  /* End else:  pattern run or bit string. */
        }  /* End while:  bytes remain to filled in the scan line. */
    }  /* End for:  over source bit planes. */
}  /* get_line */
 
 
/************************************************************************/
/* t r a n s f e r                                                      */
/************************************************************************/
    VOID
transfer( bytes, loc, file_handle )
    WORD        bytes ;
    LONG        loc ;
    WORD        file_handle ;
{
    WORD        amount ;
    LONG        tmp_ptr ;
 
        /* Can the request be satisfied from the current buffer?        */
    if ( f_index + bytes < f_buf_len )
    {
        /* Transfer the requested bytes from the current buffer.        */
        b_move( f_ptr, bytes, loc ) ;
        f_index += bytes ;
        f_ptr += ( LONG )( bytes ) ;
        loc += ( LONG )( bytes ) ;
    }  /* End if:  no new buffer needed. */
    else
    {
                        /* Transfer what is left in the current buffer. */
        b_move( f_ptr, ( amount = f_buf_len - f_index ), loc ) ;
        loc += ( LONG )( amount ) ;
        f_ptr += ( LONG )( amount ) ;
        /* Copy the last byte of the current file buffer into the       */
        /* first byte of the file buffer to be read in so that a single */
        /* byte backspace can be performed, if necessary.  Read in the  */
        /* new file buffer.  If more must be transferred to the         */
        /* destination, do so.                                          */
        tmp_ptr = raw_fptr ;
        LBSET( tmp_ptr,LBGET( f_ptr ) ) ;
        f_ptr = tmp_ptr ;
        f_ptr++ ;
        f_buf_len = dos_read( file_handle, f_buf_size, f_ptr ) + 1 ;
 
        if ( amount < bytes )
        {
            f_index = bytes - amount ;
            b_move( f_ptr, f_index++, loc ) ;
            f_ptr += ( LONG )( f_index - 1 ) ;
        }  /* End if:  more to be transferred. */
        else
            f_index = 1 ;
    }  /* End else: new buffer needed. */
} /* transfer */
 
 
/* end of o_image.c */
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "UTIL86.A86"
 
 
**********************************************************
 
 
; UTIL86.ASM    misc assembly utilities for GEM OUTPUT. 
; 06-04-85      Susan Bancroft
;
; UTIL86.A86    misc assembly utilities for GEM OUTPUT. 
; 07-29-85      modified for RASM86 Mitch Smith
;
 
dseg
 
        public  brk_addr
        public  brk_seg 
 
brk_addr dw     offset brk_hndler
brk_seg  dw     seg    brk_hndler
rtn_addr dw     0
rtn_seg  dw     0
data_seg dw     0
 
 
cseg
 
        public  SMUL_DIV
        public  RMUL_DIV
        public  UMUL_DIV
        public  brk_hndler 
        public  seg_off
        public  b_move
        public  b_stuff
        public  swapbyte
        public  cxc33, cxm33, cxd33
 
 
 
;***************************************************************************
;
; SMUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * m2 ) / d1 ) + 1 / 2 
;       m1 = signed 16 bit integer
;       m2 = snsigned 15 bit integer
;       d1 = signed 16 bit integer
;
;***************************************************************************
SMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        mov     bx,04[bp]
        imul    bx              ; m2 * m1
        mov     si, 1
        and     dx, dx
        jns     smul_div_1
        neg     si
smul_div_1:
        mov     bx,08[bp]
        idiv    bx              ; m2 * m1 / d1
        pop     bp
        and     bx, bx          ; test if divisor is negative
        jns     smul_div_2
        neg     si
        neg     bx              ; make it positive
smul_div_2:
        and     dx, dx          ; test if remainder is negative
        jns     smul_div_3
        neg     dx              ; make remainder positive
smul_div_3:
        shl     dx, 1           ; see if 2 * remainder is > divisor
        cmp     dx, bx
        jl      smul_div_4
        add     ax, si
smul_div_4:
        ret
 
;***************************************************************************
;
; RMUL_DIV (m1,m2,d1,r1)
;
;        ( ( ( m1 * m2 ) / d1 ) with remainder r1       
;       m1 = signed 16 bit integer
;       m2 = snsigned 15 bit integer
;       d1 = signed 16 bit integer
;       r1 = address of remainder
;
;***************************************************************************
RMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        mov     bx,04[bp]
        imul    bx              ; m2 * m1
        mov     bx,08[bp]
        idiv    bx              ; m2 * m1 / d1
        mov     bx,10[bp]       ; return remainder
        mov     [bx],dx
        pop     bp
        ret
 
;***************************************************************************
;
; UMUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * 2 * m2 ) / d1 ) + 1 ) / 2   
;       m1 = usigned 16 bit integer
;       m2 = unsigned 15 bit integer
;       d1 = usigned 16 bit integer
;
;***************************************************************************
UMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        shl     ax,1            ; m2 * 2
        mov     bx,04[bp]
        mul     bx              ; m2 * 2 * m1
        mov     bx,08[bp]
        div     bx              ; m2 * 2 * m1 / d1
        inc     ax
        shr     ax,1            ; m2 * 2 * m1 / d1 +1 / 2
        pop     bp
        ret
;
;***************************************************************************
; BRK_HNDLER
;
; Routine for handling control break interupts
;
;***************************************************************************
brk_hndler:
        pop rtn_addr
        pop rtn_addr
        pop rtn_addr
        pop rtn_addr
        pop rtn_seg
        popf
        stc
        pushf
        push rtn_seg
        push rtn_addr
        mov ax, 200
        iret
 
 
;
;************************************************************************
;               LONG                                                    *
;       address = seg_off(WORD)                                         *
;               returns bx = offset                                     *
;                       ax = segment                                    *
;************************************************************************
seg_off:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ax, bx
                and     bx, 000fh               ;make it an offset
                mov     cl, 4
                shr     ax, cl                  ;make it a segment
                pop     bp
                ret
 
;
;************************************************************************
;       b_move(&from, count, &to);                                      *
;               &from:          ADDR    4[bp]                           *
;               count:          WORD    8[bp]                           *
;               &to:            ADDR    10[bp]                          *
;************************************************************************
b_move:
                push    bp
                mov     bp, sp
 
; Move from the source to the destination.
                mov     cx, 8[bp]
                les     di, 10[bp]              ; es:di = address of destination
                lds     si, 4[bp]               ; ds:si = address of source
        rep     movsb                           ; move bytes
 
; Restore and exit.
                mov     ax, seg data_seg
                mov     ds, ax
                pop     bp
                ret
 
;************************************************************************
;       b_stuff(pointer, count, value);                                 *
;               pointer:        ADDR    4[bp]                           *
;               count:          WORD    8[bp]                           *
;               value:          BYTE    10[bp]                          *
;************************************************************************
b_stuff:
                push    bp
                mov     bp, sp
 
; Set the requested number of bytes to the requested value.
                les     di, 4[bp]               ; es:di = destination address
                mov     cx, 8[bp]               ; cx = count
                mov     al, 10[bp]              ; al = value to set
        rep     stosb                           ; stuff
 
; Restore and exit.
                pop     bp
                ret
 
;************************************************************************
;       swapbyte(&buffer, count);                                       *
;               &buffer         ADDR    4[bp]                           *
;************************************************************************
swapbyte:
                push    bp
                mov     bp, sp
 
; Get the address of the buffer and the count of words to be swapped.
                les     di, 4[bp]               ; es:di = buffer to swap
                mov     cx, 8[bp]
 
; Do the dirty deed.
swapbyte_loop:
                mov     ax, es:[di]
                xchg    ah, al                  ; swap 'em
                stosw
                loop    swapbyte_loop
 
                pop     bp
                ret
;
;************************************************************************
;
;       LONG COMPARE
;
;************************************************************************
cxc33:
        push    bx
        push    dx
        cmp     ax,cx
        jnz     cxc1
        shr     bx,1
        shr     dx,1
        cmp     bx,dx
        jnz     cxc1
        pop     dx
        pop     bx
        cmp     bx,dx
        jmp     cxc2
cxc1:
        pop     dx
        pop     bx
cxc2:
        ret
 
 
;************************************************************************
;
;       LONG DIVIDE
;
;************************************************************************
cxd33:
        xchg    ax,bx
        mov     cx,dx
        jcxz    div0
        cmp     cx,1
        jne     not_div1
        xchg    ax,bx
        xor     cx,cx
        mov     dx,cx
        ret
not_div1:
        xor     dx,dx
        xchg    ax,bx
        push    ax
        div     cx
        mov     di,ax
        mul     cx
        pop     dx
        sub     dx,ax
        mov     ax,bx
        div     cx
        sub     cx,cx
        mov     bx,ax
        mov     ax,di
        ret
div0:
        mov     ax,-1
        mov     bx,ax
        ret
 
 
;*************************************************************
;
;       LONG MULTIPLY
;
;************************************************************************
cxm33:
        push    dx
        mul     dx
        pop     dx
        push    ax
        mov     ax,bx
        push    dx
        mul     cx
        mov     cx,ax
        mov     ax,bx
        pop     dx
        mul     dx
        add     dx,cx
        pop     cx
        add     dx,cx
        mov     bx,ax
        mov     ax,dx
        ret
 
;
end
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "UTIL86.ASM"
 
 
**********************************************************
 
 
; UTIL86.ASM    misc assembly utilities for GEM OUTPUT. 
; 06-04-85      Susan Bancroft
;
PGROUP  GROUP   PROG
DGROUP  GROUP   DATA
 
DATA    SEGMENT PARA PUBLIC 'DATA'
 
        public  brk_addr
        public  brk_seg 
 
brk_addr dw     offset brk_hndler
brk_seg  dw     seg    brk_hndler
rtn_addr dw     0
rtn_seg  dw     0
data_seg dw     0
 
DATA    ENDS
 
 
PROG    SEGMENT BYTE PUBLIC 'PROG'
        ASSUME  CS:PGROUP
        ASSUME  DS:DGROUP
 
        extrn   dr_code:near
 
        public  SMUL_DIV
        public  RMUL_DIV
        public  UMUL_DIV
        public  brk_hndler 
        public  seg_off
        public  b_move
        public  b_stuff
        public  swapbyte
        public  cxc33, cxm33, cxd33
 
 
 
;***************************************************************************
;
; SMUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * m2 ) / d1 ) + 1 / 2 
;       m1 = signed 16 bit integer
;       m2 = snsigned 15 bit integer
;       d1 = signed 16 bit integer
;
;***************************************************************************
SMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        mov     bx,04[bp]
        imul    bx              ; m2 * m1
        mov     si, 1
        and     dx, dx
        jns     smul_div_1
        neg     si
smul_div_1:
        mov     bx,08[bp]
        idiv    bx              ; m2 * m1 / d1
        pop     bp
        and     bx, bx          ; test if divisor is negative
        jns     smul_div_2
        neg     si
        neg     bx              ; make it positive
smul_div_2:
        and     dx, dx          ; test if remainder is negative
        jns     smul_div_3
        neg     dx              ; make remainder positive
smul_div_3:
        shl     dx, 1           ; see if 2 * remainder is > divisor
        cmp     dx, bx
        jl      smul_div_4
        add     ax, si
smul_div_4:
        ret
 
;***************************************************************************
;
; RMUL_DIV (m1,m2,d1,r1)
;
;        ( ( ( m1 * m2 ) / d1 ) with remainder r1       
;       m1 = signed 16 bit integer
;       m2 = snsigned 15 bit integer
;       d1 = signed 16 bit integer
;       r1 = address of remainder
;
;***************************************************************************
RMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        mov     bx,04[bp]
        imul    bx              ; m2 * m1
        mov     bx,08[bp]
        idiv    bx              ; m2 * m1 / d1
        mov     bx,10[bp]       ; return remainder
        mov     [bx],dx
        pop     bp
        ret
 
;***************************************************************************
;
; UMUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * 2 * m2 ) / d1 ) + 1 ) / 2   
;       m1 = usigned 16 bit integer
;       m2 = unsigned 15 bit integer
;       d1 = usigned 16 bit integer
;
;***************************************************************************
UMUL_DIV:
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06[bp]
        shl     ax,1            ; m2 * 2
        mov     bx,04[bp]
        mul     bx              ; m2 * 2 * m1
        mov     bx,08[bp]
        div     bx              ; m2 * 2 * m1 / d1
        inc     ax
        shr     ax,1            ; m2 * 2 * m1 / d1 +1 / 2
        pop     bp
        ret
;
;***************************************************************************
; BRK_HNDLER
;
; Routine for handling control break interupts
;
;***************************************************************************
brk_hndler:
        pop rtn_addr
        pop rtn_addr
        pop rtn_addr
        pop rtn_addr
        pop rtn_seg
        popf
        stc
        pushf
        push rtn_seg
        push rtn_addr
        mov ax, 200
        iret
 
 
;
;************************************************************************
;               LONG                                                    *
;       address = seg_off(WORD)                                         *
;               returns bx = offset                                     *
;                       ax = segment                                    *
;************************************************************************
seg_off:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ax, bx
                and     bx, 000fh               ;make it an offset
                mov     cl, 4
                shr     ax, cl                  ;make it a segment
                pop     bp
                ret
 
;
;************************************************************************
;       b_move(&from, count, &to);                                      *
;               &from:          ADDR    4[bp]                           *
;               count:          WORD    8[bp]                           *
;               &to:            ADDR    10[bp]                          *
;************************************************************************
b_move:
                push    bp
                mov     bp, sp
 
; Move from the source to the destination.
                mov     cx, 8[bp]
                les     di, 10[bp]              ; es:di = address of destination
                lds     si, 4[bp]               ; ds:si = address of source
        rep     movsb                           ; move bytes
 
; Restore and exit.
                mov     ax, seg data_seg
                mov     ds, ax
                pop     bp
                ret
 
;************************************************************************
;       b_stuff(pointer, count, value);                                 *
;               pointer:        ADDR    4[bp]                           *
;               count:          WORD    8[bp]                           *
;               value:          BYTE    10[bp]                          *
;************************************************************************
b_stuff:
                push    bp
                mov     bp, sp
 
; Set the requested number of bytes to the requested value.
                les     di, 4[bp]               ; es:di = destination address
                mov     cx, 8[bp]               ; cx = count
                mov     al, 10[bp]              ; al = value to set
        rep     stosb                           ; stuff
 
; Restore and exit.
                pop     bp
                ret
 
;************************************************************************
;       swapbyte(&buffer, count);                                       *
;               &buffer         ADDR    4[bp]                           *
;************************************************************************
swapbyte:
                push    bp
                mov     bp, sp
 
; Get the address of the buffer and the count of words to be swapped.
                les     di, 4[bp]               ; es:di = buffer to swap
                mov     cx, 8[bp]
 
; Do the dirty deed.
swapbyte_loop:
                mov     ax, es:[di]
                xchg    ah, al                  ; swap 'em
                stosw
                loop    swapbyte_loop
 
                pop     bp
                ret
;
;************************************************************************
;
;       LONG COMPARE
;
;************************************************************************
cxc33:
        push    bx
        push    dx
        cmp     ax,cx
        jnz     cxc1
        shr     bx,1
        shr     dx,1
        cmp     bx,dx
        jnz     cxc1
        pop     dx
        pop     bx
        cmp     bx,dx
        jmp     cxc2
cxc1:
        pop     dx
        pop     bx
cxc2:
        ret
 
 
;************************************************************************
;
;       LONG DIVIDE
;
;************************************************************************
cxd33:
        xchg    ax,bx
        mov     cx,dx
        jcxz    div0
        cmp     cx,1
        jne     not_div1
        xchg    ax,bx
        xor     cx,cx
        mov     dx,cx
        ret
not_div1:
        xor     dx,dx
        xchg    ax,bx
        push    ax
        div     cx
        mov     di,ax
        mul     cx
        pop     dx
        sub     dx,ax
        mov     ax,bx
        div     cx
        sub     cx,cx
        mov     bx,ax
        mov     ax,di
        ret
div0:
        mov     ax,-1
        mov     bx,ax
        ret
 
 
;************************************************************************
;
;       LONG MULTIPLY
;
;************************************************************************
cxm33:
        push    dx
        mul     dx
        pop     dx
        push    ax
        mov     ax,bx
        push    dx
        mul     cx
        mov     cx,ax
        mov     ax,bx
        pop     dx
        mul     dx
        add     dx,cx
        pop     cx
        add     dx,cx
        mov     bx,ax
        mov     ax,dx
        ret
 
;
 
;************************************************************************
;
PROG    ENDS
 
 
        end
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "ODISPLAY.C"
 
 
**********************************************************
 
 
 
 
/* Display file list    Dan Brown       3/7/85  */
/*                      Susan Bancroft  8/15/85 */
 
 
 
/**************************************************************/
get_mf( contrl, siz_intin, intin, siz_ptsin, ptsin )
WORD contrl[], siz_intin, intin[], siz_ptsin, ptsin[] ;
{
  /* Local Declarations. */
  WORD status ;
 
  /* If a file is not open, return an error indication. */
  if ( f_open == 0 )
    return( ERROR ) ;
 
  /* Get an opcode from the metafile.  If it is an end-of-file opcode,  */
  /* return an end-of-file indication ( -1 ).  If it is an invalid opcode, */
  /* return an error indication.  Otherwise, get remaining parameters.   */
  if ( mf_words( 1, &OPCODE ) )
    return( ERROR ) ;
 
  if ( OPCODE == -1 )
    return( OPCODE ) ;
 
      if ( mf_words( 1, &NUM_PTSIN ) )
        return( ERROR ) ;
      if ( mf_words( 1, &NUM_INTIN ) )
        return( ERROR ) ;
      if ( mf_words( 1, &FUNCODE ) )
        return( ERROR ) ;
      status = SUCCESS ;
      if ( NUM_PTSIN > 0 )
      {
        if ( 2*NUM_PTSIN > siz_ptsin )
          status |= mf_skip( 2*NUM_PTSIN ) ;
        else
          status |= mf_words( 2*NUM_PTSIN, ptsin ) ;
      }  /* End if:  vertices captured. */
      if ( NUM_INTIN > 0 )
      {
        if ( NUM_INTIN > siz_intin )
          status |= mf_skip( NUM_INTIN ) ;
        else
          status |= mf_words( NUM_INTIN, intin ) ;
      }  /* End if:  integer parameters captured. */
      return( status ) ;
 
}  /* End "get_mf". */
 
 
/**************************************************************/
        WORD
mf_words( count, buf )
        WORD count ;
        WORD *buf ;
{
        WORD n ;
 
        while( count )
        {
            if ( buf_pos == buf_end )
            {
                if ( !mfread_buffer( 0 ) )
                    break ;
            }
            n = buf_end - buf_pos ;
            n = ( n > count ) ? count : n ;
            count -= n ;
            while( n-- )
            {
                *buf++ = *buf_pos++ ;
            }
        }
        return( count ) ;
} /* mf_words */
 
 
/**************************************************************/
text_out( dvc )
        WORD dvc ;
{
        WORD length ;
 
        length = buf_lgth ;
        do
        {
            dos_write( dvc, length, ADDR( &buffer ) ) ;
        } while( length = mfread_buffer( 0 ) ) ;
} /* text_out */
            
 
/**************************************************************/
        WORD
mfread_buffer( start_byte )
WORD    start_byte ;
{
    WORD size, length ;
 
    fst_buf = FALSE ;
    buf_pos = &buffer.mf[ 0 ] ;
    size = sizeof( buffer ) - start_byte ;
#if I8086
    length = dos_read( f_handle, size, ADDR( &buffer.txt[ start_byte ] ) ) ;
#endif
#if MC68K
    length = mf_read( f_handle, size, ADDR( &buffer.txt[ start_byte ] ) ) ;
#endif
    if ( DOS_ERR )
        return( FALSE ) ;
    length += start_byte ;
    buf_end = buf_pos + length / 2 ;
    return( length ) ;
} /* mfread_buffer */
 
 
/**************************************************************/
        WORD
mf_skip( count )
        WORD count ;
{
        WORD n ;
        while( count )
        {
            if ( buf_pos == buf_end )
            {
                if ( !mfread_buffer( 0 ) )
                    break ;
            }
            n = ( buf_end - buf_pos ) / 2 ;
            n = ( n > count ) ? count : n ;
            count -= n ;
            buf_pos += n ;
        }
        return( count ) ;
} /* mf_skip */
 
 
/**************************************************************/
        WORD
rewind_mf()
{
        if ( fst_buf )
        {
            buf_pos = &buffer.mf[ 0 ] ;
        }
        else
        {
            dos_lseek( f_handle, FROM_BEG, 0L ) ;
            if ( DOS_ERR )
                return( FALSE ) ;
            if ( !( buf_lgth = mfread_buffer( 0 ) ) )
                return( FALSE ) ;
            fst_buf = TRUE ;
        }
        if ( file_type == GEM_FILE )
        {
            mf_skip( hdr_size ) ;
        }
        return( TRUE ) ;
} /* rewind_mf */
 
 
/*--------------------------------------------------------------*/
        VOID
reset_mf()              /* Reset metafile to start of vdi commands */
{
        rewind_mf() ;
 
        while ( !get_mf( contrl, 128, intin, 128, ptsin ) &&
                mf_contrl[ 0 ] == 5 && mf_contrl[ 5 ] == 99 )
        {
        }
 
} /* reset_mf */
 
 
/*--------------------------------------------------------------*/
    VOID
case_gdp()              /* transform gdp data */
{
    switch ( contrl[ 5 ] )
        {
        case CIRCLE : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 4 ] ) ;
                if ( rotate )
                    flip_mag( 1, &ptsin[ 4 ] ) ;
                break ;
        case PIE : 
        case ARC : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 6 ] ) ;
                if ( rotate )
                    {
                    flip_mag( 1, &ptsin[ 6 ] ) ;
                    if ( !full_circle( intin[ 0 ], intin[ 1 ] ) )
                        rot_ang( 2, &intin[ 0 ] ) ;
                    }
                break ;
        case ELLIP_ARC : 
        case ELLIP_PIE : 
                if ( rotate && !full_circle( intin[ 0 ], intin[ 1 ] ) )
                    rot_ang( 2, &intin[ 0 ] ) ;
        case ELLIPSE : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 2 ] ) ;
                break ;
        case FORMT_TEXT : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 2 ] ) ;
                if ( rotate )
                    flip_mag( 1, &ptsin[ 2 ] ) ;
                break ;
        default : 
                trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
        } /* switch contrl[ 5 ] */
} /* case_gdp */
 
 
/*--------------------------------------------------------------*/
        WORD
process_mf()            /* draw device page     */
{
        WORD rmdr ;
        WORD dummy ;
        WORD count ;
        WORD    t_contrl[ 12 ] ;                /* scratch areas for IMG cmd */
        WORD    t_intin[ 5 + NAME_LENGTH ] ;
        WORD    t_ptsin[ 4 ], deltas[ 4 ] ;
 
        count = 20 ;
        while( contrl[ 0 ] != 0xffff )
        {
            if ( count == 20 )
            {
                count = 0 ;
                if ( brk_out = check_esc() )
                    return( FALSE ) ;
            }
            count++ ;
            if ( ! ( contrl[ 0 ] == ESC_CMD && contrl[ 5 ] == 99 ) )
            { 
                switch ( contrl[ 0 ] )
                {
                    case GDP :
                        case_gdp() ;
                        break ;
                    case LINE_WIDTH : 
                    case MARKER_HGT : 
                    case ABS_CHAR_HGT : 
                        trfm_mag( 1, &ptsin[ 0 ] ) ;
                        if ( rotate )
                        {
                            flip_mag( 1, &ptsin[ 0 ] ) ;
                        }
                        break ;
                    case PTS_CHAR_HGT : 
                        intin[ 0 ] = min( intin[ 0 ], 72 ) ;
                        intin[ 0 ] = RMUL_DIV( intin[ 0 ], bf_height, 
                                                org_height, &rmdr ) ;
                        if ( dvc_num == SCRN_NUM )
                            fudge_size( &rmdr ) ;
                        break ;
                    case CHAR_BASELINE : 
                        if ( rotate )
                        {
                            rot_ang( 1, &intin[ 0 ] ) ;
                        }
                        break ;
                    case SET_FONT_FACE : 
                        cur_font = intin[ 0 ] ;
                        break ;
                    case CLIP : 
                        if ( intin[ 0 ] == FALSE )
                        {
                            intin[ 1 ] = TRUE ;
                            movb( sizeof( RECTANGLE ), &page_wdw, &ptsin ) ;
                        }
                        else
                        {
                            trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
                            ptsin[ 0 ] = minmax( page_wdw.left, ptsin[ 0 ], 
                                               page_wdw.right ) ;
                            ptsin[ 1 ] = minmax( page_wdw.top, ptsin[ 1 ], 
                                               page_wdw.bottom ) ;
                            ptsin[ 2 ] = minmax( page_wdw.left, ptsin[ 2 ], 
                                               page_wdw.right ) ;
                            ptsin[ 3 ] = minmax( page_wdw.top, ptsin[ 3 ], 
                                               page_wdw.bottom ) ;
                        }
                        break ;
            case ESC_CMD : 
                        if ( contrl[ 5 ] == IMGF_CMD ) 
                            {
                        if ( dvc_num == SCRN_NUM )
                            {
                            change_dir( app_dir ) ;
                            OUTIMAG() ;                 /* OUTIMAG overlay */
                            }
                        if ( (dvc_num == PRNT_NUM) || (dvc_num == CMRA_NUM) )
                            {
                            movb( sizeof( t_contrl ), &contrl, &t_contrl ) ;
                            movb( sizeof( t_intin ), &intin, &t_intin ) ;
                            movb( sizeof( t_ptsin ), &ptsin, &t_ptsin ) ;
                            vst_unload_fonts( cur_hndl, dummy ) ;
                            fonts_loaded = FALSE ;
                            v_clear_disp_list( cur_hndl ) ;
                            if ( best_fit )
                                {
                                t_intin[ 1 ] = 0 ;      /* fract scale x */
                                t_ptsin[ 0 ] = t_ptsin[ 1 ] = 0 ;
                                t_ptsin[ 2 ] = org_nxpixel ;
                                t_ptsin[ 3 ] = org_nypixel ;
                                vs_clip( cur_hndl, TRUE, &t_ptsin ) ;
                                }
                            else
                                {
/*                              deltas[0] = deltas[2] = t_ptsin[2] - t_ptsin[0] 
;
                                deltas[1] = deltas[3] = t_ptsin[3] - t_ptsin[1] 
;
                                trfm_mag( 1, &deltas[ 0 ] ) ;
                                if ( ( deltas[0] >= deltas[2] ) && (deltas[1] >=
 deltas[3] ) ) 
*/
                                    trfm_pts( t_contrl[ 1 ], &t_ptsin[ 0 ] ) ;
                                }
                            t_intin[ 3 ] = horz_just ;
                            t_intin[ 4 ] = vert_just ;
                            movb( sizeof( t_contrl ), &t_contrl, &contrl ) ;
                            movb( sizeof( t_intin ), &t_intin, &intin ) ;
                            movb( sizeof( t_ptsin ), &t_ptsin, &ptsin ) ;
                            contrl[ 6 ] = cur_hndl ;
                            vdi() ;
                            }
                            return( TRUE ) ;
                            }
                    default : 
                        trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
                }
                contrl[ 6 ] = cur_hndl ;
                vdi() ;
            }
            if ( get_mf( contrl, INTIN_SIZE, intin, PTSIN_SIZE, ptsin ) )
                break ;
        }
        return( TRUE ) ;
} /* process_mf */
 
 
/*--------------------------------------------------------------*/
        WORD
draw_page()             /* draw device page     */
{
        reset_mf() ;
        if ( !process_mf() )
            return( FALSE ) ;
        if ( ( dvc_num == PRNT_NUM ) || (dvc_num == CMRA_NUM) )
        {
            if ( is_pcl_file )
                v_output_window( cur_hndl, &pcl_extent ) ;
            else
                v_updwk( cur_hndl ) ;
        }
        return( TRUE ) ;
} /* draw_page */
 
/* end of display.c */
 
 
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TADDR.H"
 
 
**********************************************************
 
 
 
 
 
/*     This is a modified version of TREEADDR.H  which was included    */
/*            with the GEM Programmer's Toolkit.  The modifications    */
/*            are only required for SNAPSHOT (at this time), but you   */
/*            may use this in place of TREEADDR.H without any adverse  */
/*            effects.          07/29/85                               */
/*                                                                     */       
  
/*      TADDR.H         04/11/84 - 09/11/84     Gregg Morris           */
/*      TADDR.H         12/15/84 - 03/11/85     Scott Raney            */
 
#define OB_NEXT(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 0)
#define OB_HEAD(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 2)
#define OB_TAIL(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 4)
#define OB_TYPE(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 6)
#define OB_FLAGS(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 8)
#define OB_STATE(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 10)
#define OB_SPEC(tree,x) LLGET(tree + (x) * sizeof(OBJECT) + 12)
#define OB_X(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 16)
#define OB_Y(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 18)
#define OB_WIDTH(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 20)
#define OB_HEIGHT(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 22)
 
#define SOB_NEXT(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 0,y)
#define SOB_HEAD(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 2,y)
#define SOB_TAIL(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 4,y)
#define SOB_TYPE(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 6,y)
#define SOB_FLAGS(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 8,y)
#define SOB_STATE(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 10,y)
#define SOB_SPEC(tree,x,y) LLSET(tree + (x) * sizeof(OBJECT) + 12,y)
#define SOB_X(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 16,y)
#define SOB_Y(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 18,y)
#define SOB_WIDTH(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 20,y)
#define SOB_HEIGHT(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 22,y)
 
#define BI_PDATA(long) LLGET(long + 0)
#define BI_WB(long) LWGET(long + 4)
#define BI_HL(long) LWGET(long + 6)
 
 
 
 
 
 
 
 
 
 
**********************************************************
**********************************************************
 
 
        THIS IS THE END OF CODE CONTAINING
 
        A COLLECTION OF IMG & GEM FILE ROUTINES
 
 
**********************************************************
**********************************************************
