ODISPLAY.C      This file contains code for use when reading or 
                writing GEM files.  This same information is in 
                GEMIMG.C along with other useful information.
 
 
Uploaded    09/03/85
 
 
/* Display file list    Dan Brown       3/7/85  */
/*                      Susan Bancroft  8/15/85 */
 
 
 
/**************************************************************/
get_mf( contrl, siz_intin, intin, siz_ptsin, ptsin )
WORD contrl[], siz_intin, intin[], siz_ptsin, ptsin[] ;
{
  /* Local Declarations. */
  WORD status ;
 
  /* If a file is not open, return an error indication. */
  if ( f_open == 0 )
    return( ERROR ) ;
 
  /* Get an opcode from the metafile.  If it is an end-of-file opcode,  */
  /* return an end-of-file indication ( -1 ).  If it is an invalid opcode, */
  /* return an error indication.  Otherwise, get remaining parameters.   */
  if ( mf_words( 1, &OPCODE ) )
    return( ERROR ) ;
 
  if ( OPCODE == -1 )
    return( OPCODE ) ;
 
      if ( mf_words( 1, &NUM_PTSIN ) )
        return( ERROR ) ;
      if ( mf_words( 1, &NUM_INTIN ) )
        return( ERROR ) ;
      if ( mf_words( 1, &FUNCODE ) )
        return( ERROR ) ;
      status = SUCCESS ;
      if ( NUM_PTSIN > 0 )
      {
        if ( 2*NUM_PTSIN > siz_ptsin )
          status |= mf_skip( 2*NUM_PTSIN ) ;
        else
          status |= mf_words( 2*NUM_PTSIN, ptsin ) ;
      }  /* End if:  vertices captured. */
      if ( NUM_INTIN > 0 )
      {
        if ( NUM_INTIN > siz_intin )
          status |= mf_skip( NUM_INTIN ) ;
        else
          status |= mf_words( NUM_INTIN, intin ) ;
      }  /* End if:  integer parameters captured. */
      return( status ) ;
 
}  /* End "get_mf". */
 
 
/**************************************************************/
        WORD
mf_words( count, buf )
        WORD count ;
        WORD *buf ;
{
        WORD n ;
 
        while( count )
        {
            if ( buf_pos == buf_end )
            {
                if ( !mfread_buffer( 0 ) )
                    break ;
            }
            n = buf_end - buf_pos ;
            n = ( n > count ) ? count : n ;
            count -= n ;
            while( n-- )
            {
                *buf++ = *buf_pos++ ;
            }
        }
        return( count ) ;
} /* mf_words */
 
 
/**************************************************************/
text_out( dvc )
        WORD dvc ;
{
        WORD length ;
 
        length = buf_lgth ;
        do
        {
            dos_write( dvc, length, ADDR( &buffer ) ) ;
        } while( length = mfread_buffer( 0 ) ) ;
} /* text_out */
            
 
/**************************************************************/
        WORD
mfread_buffer( start_byte )
WORD    start_byte ;
{
    WORD size, length ;
 
    fst_buf = FALSE ;
    buf_pos = &buffer.mf[ 0 ] ;
    size = sizeof( buffer ) - start_byte ;
#if I8086
    length = dos_read( f_handle, size, ADDR( &buffer.txt[ start_byte ] ) ) ;
#endif
#if MC68K
    length = mf_read( f_handle, size, ADDR( &buffer.txt[ start_byte ] ) ) ;
#endif
    if ( DOS_ERR )
        return( FALSE ) ;
    length += start_byte ;
    buf_end = buf_pos + length / 2 ;
    return( length ) ;
} /* mfread_buffer */
 
 
/**************************************************************/
        WORD
mf_skip( count )
        WORD count ;
{
        WORD n ;
        while( count )
        {
            if ( buf_pos == buf_end )
            {
                if ( !mfread_buffer( 0 ) )
                    break ;
            }
            n = ( buf_end - buf_pos ) / 2 ;
            n = ( n > count ) ? count : n ;
            count -= n ;
            buf_pos += n ;
        }
        return( count ) ;
} /* mf_skip */
 
 
/**************************************************************/
        WORD
rewind_mf()
{
        if ( fst_buf )
        {
            buf_pos = &buffer.mf[ 0 ] ;
        }
        else
        {
            dos_lseek( f_handle, FROM_BEG, 0L ) ;
            if ( DOS_ERR )
                return( FALSE ) ;
            if ( !( buf_lgth = mfread_buffer( 0 ) ) )
                return( FALSE ) ;
            fst_buf = TRUE ;
        }
        if ( file_type == GEM_FILE )
        {
            mf_skip( hdr_size ) ;
        }
        return( TRUE ) ;
} /* rewind_mf */
 
 
/*--------------------------------------------------------------*/
        VOID
reset_mf()              /* Reset metafile to start of vdi commands */
{
        rewind_mf() ;
 
        while ( !get_mf( contrl, 128, intin, 128, ptsin ) &&
                mf_contrl[ 0 ] == 5 && mf_contrl[ 5 ] == 99 )
        {
        }
 
} /* reset_mf */
 
 
/*--------------------------------------------------------------*/
    VOID
case_gdp()              /* transform gdp data */
{
    switch ( contrl[ 5 ] )
        {
        case CIRCLE : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 4 ] ) ;
                if ( rotate )
                    flip_mag( 1, &ptsin[ 4 ] ) ;
                break ;
        case PIE : 
        case ARC : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 6 ] ) ;
                if ( rotate )
                    {
                    flip_mag( 1, &ptsin[ 6 ] ) ;
                    if ( !full_circle( intin[ 0 ], intin[ 1 ] ) )
                        rot_ang( 2, &intin[ 0 ] ) ;
                    }
                break ;
        case ELLIP_ARC : 
        case ELLIP_PIE : 
                if ( rotate && !full_circle( intin[ 0 ], intin[ 1 ] ) )
                    rot_ang( 2, &intin[ 0 ] ) ;
        case ELLIPSE : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 2 ] ) ;
                break ;
        case FORMT_TEXT : 
                trfm_pts( 1, &ptsin[ 0 ] ) ;
                trfm_mag( 1, &ptsin[ 2 ] ) ;
                if ( rotate )
                    flip_mag( 1, &ptsin[ 2 ] ) ;
                break ;
        default : 
                trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
        } /* switch contrl[ 5 ] */
} /* case_gdp */
 
 
/*--------------------------------------------------------------*/
        WORD
process_mf()            /* draw device page     */
{
        WORD rmdr ;
        WORD dummy ;
        WORD count ;
        WORD    t_contrl[ 12 ] ;                /* scratch areas for IMG cmd */
        WORD    t_intin[ 5 + NAME_LENGTH ] ;
        WORD    t_ptsin[ 4 ], deltas[ 4 ] ;
 
        count = 20 ;
        while( contrl[ 0 ] != 0xffff )
        {
            if ( count == 20 )
            {
                count = 0 ;
                if ( brk_out = check_esc() )
                    return( FALSE ) ;
            }
            count++ ;
            if ( ! ( contrl[ 0 ] == ESC_CMD && contrl[ 5 ] == 99 ) )
            { 
                switch ( contrl[ 0 ] )
                {
                    case GDP :
                        case_gdp() ;
                        break ;
                    case LINE_WIDTH : 
                    case MARKER_HGT : 
                    case ABS_CHAR_HGT : 
                        trfm_mag( 1, &ptsin[ 0 ] ) ;
                        if ( rotate )
                        {
                            flip_mag( 1, &ptsin[ 0 ] ) ;
                        }
                        break ;
                    case PTS_CHAR_HGT : 
                        intin[ 0 ] = min( intin[ 0 ], 72 ) ;
                        intin[ 0 ] = RMUL_DIV( intin[ 0 ], bf_height, 
                                                org_height, &rmdr ) ;
                        if ( dvc_num == SCRN_NUM )
                            fudge_size( &rmdr ) ;
                        break ;
                    case CHAR_BASELINE : 
                        if ( rotate )
                        {
                            rot_ang( 1, &intin[ 0 ] ) ;
                        }
                        break ;
                    case SET_FONT_FACE : 
                        cur_font = intin[ 0 ] ;
                        break ;
                    case CLIP : 
                        if ( intin[ 0 ] == FALSE )
                        {
                            intin[ 1 ] = TRUE ;
                            movb( sizeof( RECTANGLE ), &page_wdw, &ptsin ) ;
                        }
                        else
                        {
                            trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
                            ptsin[ 0 ] = minmax( page_wdw.left, ptsin[ 0 ], 
                                               page_wdw.right ) ;
                            ptsin[ 1 ] = minmax( page_wdw.top, ptsin[ 1 ], 
                                               page_wdw.bottom ) ;
                            ptsin[ 2 ] = minmax( page_wdw.left, ptsin[ 2 ], 
                                               page_wdw.right ) ;
                            ptsin[ 3 ] = minmax( page_wdw.top, ptsin[ 3 ], 
                                               page_wdw.bottom ) ;
                        }
                        break ;
            case ESC_CMD : 
                        if ( contrl[ 5 ] == IMGF_CMD ) 
                            {
                        if ( dvc_num == SCRN_NUM )
                            {
                            change_dir( app_dir ) ;
                            OUTIMAG() ;                 /* OUTIMAG overlay */
                            }
                        if ( (dvc_num == PRNT_NUM) || (dvc_num == CMRA_NUM) )
                            {
                            movb( sizeof( t_contrl ), &contrl, &t_contrl ) ;
                            movb( sizeof( t_intin ), &intin, &t_intin ) ;
                            movb( sizeof( t_ptsin ), &ptsin, &t_ptsin ) ;
                            vst_unload_fonts( cur_hndl, dummy ) ;
                            fonts_loaded = FALSE ;
                            v_clear_disp_list( cur_hndl ) ;
                            if ( best_fit )
                                {
                                t_intin[ 1 ] = 0 ;      /* fract scale x */
                                t_ptsin[ 0 ] = t_ptsin[ 1 ] = 0 ;
                                t_ptsin[ 2 ] = org_nxpixel ;
                                t_ptsin[ 3 ] = org_nypixel ;
                                vs_clip( cur_hndl, TRUE, &t_ptsin ) ;
                                }
                            else
                                {
/*                              deltas[0] = deltas[2] = t_ptsin[2] - t_ptsin[0] 
;
                                deltas[1] = deltas[3] = t_ptsin[3] - t_ptsin[1] 
;
                                trfm_mag( 1, &deltas[ 0 ] ) ;
                                if ( ( deltas[0] >= deltas[2] ) && (deltas[1] >=
 deltas[3] ) ) 
*/
                                    trfm_pts( t_contrl[ 1 ], &t_ptsin[ 0 ] ) ;
                                }
                            t_intin[ 3 ] = horz_just ;
                            t_intin[ 4 ] = vert_just ;
                            movb( sizeof( t_contrl ), &t_contrl, &contrl ) ;
                            movb( sizeof( t_intin ), &t_intin, &intin ) ;
                            movb( sizeof( t_ptsin ), &t_ptsin, &ptsin ) ;
                            contrl[ 6 ] = cur_hndl ;
                            vdi() ;
                            }
                            return( TRUE ) ;
                            }
                    default : 
                        trfm_pts( contrl[ 1 ], &ptsin[ 0 ] ) ;
                }
                contrl[ 6 ] = cur_hndl ;
                vdi() ;
            }
            if ( get_mf( contrl, INTIN_SIZE, intin, PTSIN_SIZE, ptsin ) )
                break ;
        }
        return( TRUE ) ;
} /* process_mf */
 
 
/*--------------------------------------------------------------*/
        WORD
draw_page()             /* draw device page     */
{
        reset_mf() ;
        if ( !process_mf() )
            return( FALSE ) ;
        if ( ( dvc_num == PRNT_NUM ) || (dvc_num == CMRA_NUM) )
        {
            if ( is_pcl_file )
                v_output_window( cur_hndl, &pcl_extent ) ;
            else
                v_updwk( cur_hndl ) ;
        }
        return( TRUE ) ;
} /* draw_page */
 
/* end of display.c */
