**********************************************************
**********************************************************
 
 
    THIS IS THE BEGINING OF THE CODE FOR SNAPSHOT.ACC
 
 
**********************************************************
**********************************************************
 
 
 
 
 
WITH RESPECT TO ANY DATA, INFORMATION, OR PROGRAMMING SUGGESTIONS 
PROVIDED BY DIGITAL RESEARCH INC.  (DRI) ON COMPUSERVE, DRI MAKES 
NO WARRANTIES,  EXPRESS OR IMPLIED,  INCLUDING BUT NOT LIMITED TO 
THE  IMPLIED  WARRANTIES OF FITNESS FOR A PARTICULAR PURPOSE  AND 
MERCHANTABILITY.
 
 
 
 
     This  is the code to create a DESK ACCESORY  called 
     SNAPSHOT.  It will create a IMG file and a GEM file 
     after  you  use  the  "crosshairs"  to  define  the 
     rubberbox.  Play with it to see how it works. 
 
     You may use or modify this code in any way that you 
     choose in your own application.
 
 
        Jim Needham
 
**********************************************************
     
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAP.BAT"
 
 
**********************************************************
 
 
rasm86 accstart.a86 $pzsz
lc1 snapshot -s
lc2 snapshot -scode -v
rasm86 snapasm.a86 $pzsz
lc1 gembind -s
lc2 gembind -scode -v
rasm86 gemasm.a86 $pzsz
lc1 vdibind -s
lc2 vdibind -scode -v
rasm86 vdiasm.a86 $pzsz
lc1 dosbind -s
lc2 dosbind -scode -v
rasm86 dosasm.a86 $pzsz
lc1 tcrtl -s
lc2 tcrtl -scode -v
rasm86 tcrtlasm.a86 $pzsz
rasm86 longasm.a86 $pzsz
link86 snapshot[i]      
rename snapshot.exe desk3.acc
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAPSHOT.C"
 
 
**********************************************************
 
 
/*      SNAPSHOT.C                                                      */
 
/*      1/18/85  -- 04/05/85                    John Grant/Don Heiskell */
/*      05/01/85 -- 06/06/85                    Gregg Morris            */
/*      05/01/85 -- 06/24/85                    Lee Lorenzen            */
 
/*------------------------------*/
/*      include files           */
/*------------------------------*/
 
#include "portab.h"
#include "machine.h"
#include "obdefs.h"
#include "vdidefs.h"
#include "gembind.h"
#include "taddr.h"
#include "pdefs.h"
#include "snap.h"
 
/*------------------------------*/
/*      defines                 */
/*------------------------------*/
 
#define headlen 0x0008
#define vers 0x0001
#define patcnt 0x0002
#define NUM_OBS 1
                                        /* used in xform_bim            */
#define IB_PMASK(x) (x)
#define IB_PDATA(x) (x + 4)
#define IB_WICON(x) (x + 22)
#define IB_HICON(x) (x + 24)
#define XSCALE(x) UMUL_DIV(x, gl_ysiz, gl_xsiz)
 
#define BEG_UPDATE      1
#define END_UPDATE      0
#define BEG_MCTRL       3
#define END_MCTRL       2
        
/*------------------------------*/
/*      external functions      */
/*------------------------------*/
 
EXTERN LONG     seg_off();
 
/*------------------------------*/
/*      global data             */
/*------------------------------*/
 
GLOBAL LONG     ad_rmsg;
GLOBAL LONG     bit_ims, howto_dial, no_space;
GLOBAL LONG     buff_ptr, blt_ptr;
GLOBAL LONG     blt_addr, bltbuf_size, buf_addr, buf_size, nxt_plane;
 
GLOBAL WORD     gl_apid;
GLOBAL WORD     gl_handle;
GLOBAL WORD     gl_rmsg[8];
GLOBAL WORD     wh_snap;
GLOBAL WORD     gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk;
GLOBAL WORD     gl_width, gl_height;
GLOBAL WORD     gl_wchar, gl_hchar;
GLOBAL WORD     gl_wbox, gl_hbox;
GLOBAL WORD     gl_xres, gl_yres;
GLOBAL WORD     gl_xsiz, gl_ysiz;
GLOBAL WORD     gl_itsnap;
GLOBAL WORD     contrl[11];
GLOBAL WORD     intin[128];
GLOBAL WORD     ptsin[128];
GLOBAL WORD     intout[128];
GLOBAL WORD     ptsout[128];
GLOBAL WORD     blt_h, blt_x, blt_y, blt_w;
GLOBAL WORD     blt_words, blt_bytes, scan_bytes, planes;
GLOBAL WORD     buff_cnt, f_handle;
 
GLOBAL BYTE     def_path[64];
GLOBAL BYTE     gl_pfname[76];
 
FDB             d_mfdb, s_mfdb, t_mfdb;
 
GLOBAL struct img_header
{
        WORD            img_ver;        /* version number               */
        WORD            length;         /* length in words of header    */
        WORD            plane_cnt;
        WORD            patlen;         /* pattern length 2 bytes       */
        WORD            aspect_x;       /* pixel x size in microns      */
        WORD            aspect_y;       /* pixel y size in microns      */
        WORD            num_pels;       /* length of line in pels       */
        WORD            num_scans;
} header;
 
WORD    gemfile[] =
{
        0xFFFF, 0x0018, 0x0065, 0x0002, 0x0000, 0x0000, 0x0000, 0x0000,
        0x07F0, 0x09EC, 0x0000, 0x0000, 0x0000, 0x0000, 0x0001, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0005, 0x0002, 0x000E, 0x0017, 0x0000, 0x0000, 0x0000, 0x0000,
        0x0001, 0x0001, 0x0000, 0x0001, 0x0001, 0x004A, 0x0055, 0x004E,
        0x004B, 0x0046, 0x0049, 0x004C, 0x0045, 0x002E, 0x0049, 0x004D,
        0x0047, 0xFFFF
};
 
BYTE    mem_error[44] = "[3][Insufficient memory|for a snapshot.][OK]";
 
/*------------------------------*/
/*      GEMAIN                  */
/*------------------------------*/
GEMAIN()  
{
        WORD            bret, done, ev_which, kret, ks, mb, mx, my;
        WORD            cx, cy, xd, yd, wd, cur_drv, obj;
        WORD            ext_inq[57];
        BYTE            tmp_path[64];
 
        gl_apid = appl_init();
        wind_update(BEG_UPDATE);
        gl_handle = graf_handle(&gl_wchar, &gl_hchar, &gl_wbox, &gl_hbox);
        gl_itsnap = menu_register(gl_apid, ADDR("  Snapshot") );
        ad_rmsg = ADDR(gl_rmsg);
                        /* read the camera object from the resource     */
        rsrc_load(ADDR("SNAPSHOT.RSC"));
        rsrc_gaddr(R_TREE, SNAPIMS, &bit_ims);
        rsrc_gaddr(R_TREE, HOWTO, &howto_dial);
        rsrc_gaddr(R_STRING, NOSPACE, &no_space);
                                        /* transform the bit images     */
        xform_bim(bit_ims, CAMERA);
        xform_bim(bit_ims, QMARK);
 
        wind_get(0, WF_WXYWH, &gl_xdesk, &gl_ydesk, &gl_wdesk, &gl_hdesk);
        graf_mouse(0, 0x0L);
 
        cx = gl_xdesk + gl_wdesk / 2;
        cy = gl_ydesk + gl_hdesk / 2;
        xd = cx - (OB_WIDTH(howto_dial, ROOT) + 4) / 2;
        yd = cy - (OB_HEIGHT(howto_dial, ROOT) + 4) / 2;
        SOB_X(howto_dial, ROOT, xd);
        SOB_Y(howto_dial, ROOT, yd);
 
        /* Get the bit image file header information. */
        vq_extnd(gl_handle, 0, ext_inq);
        gl_xres = ext_inq[0];
        gl_yres = ext_inq[1];
        gl_xsiz = ext_inq[3];
        gl_ysiz = ext_inq[4];
        vq_extnd(gl_handle, 1, ext_inq);
        planes = ext_inq[4];
                                /* find out our current directory       */
        def_path[0] = NULL;
                                                /* Loop forever.        */
        done = FALSE;
        wh_snap = 0;
        wind_update(END_UPDATE);
        while (!done)
        {
            ev_which = evnt_multi(MU_BUTTON | MU_MESAG, 0x01, 0x01, 0x01,
                                  0, 0, 0, 0, 0,
                                  0, 0, 0, 0, 0,
                                  ad_rmsg, 0, 0, 
                                  &mx, &my, &mb, &ks, &kret, &bret);
 
            if (ev_which & MU_MESAG)
            {
                wind_update(BEG_UPDATE);
                done = message();
                wind_update(END_UPDATE);
            } /* if */
 
            if (ev_which & MU_BUTTON)
            {
                if (wh_snap)
                {
                    obj = objc_find(bit_ims, ROOT, MAX_DEPTH, mx, my);
                                    /* Is it the snapshot object?       */
                    if ( obj == CAMERA )
                        do_snapshot();
                                        /* is it the question mark?     */
                    else if ( obj == QMARK )
                    {
                        do_dialog(howto_dial);
                        SOB_STATE(howto_dial, HOWOK, NORMAL);
                    } /* if QMARK */
                }  /* End if:  snap accessory open. */
            }  /* End if:  mouse button. */
        }  /* End while. */
}  /* End "main". */
 
/*------------------------------*/
/*      do_snapshot             */
/*------------------------------*/
VOID
do_snapshot()
{
        WORD            x, y, w, h, xd, yd, wd, hd;
        WORD            bx, by, bw, bh;
        WORD            no_cancel;
 
        wind_get(wh_snap, WF_WXYWH, &xd, &yd, &wd, &hd);
        SOB_STATE(bit_ims, ROOT, SELECTED);
        do_redraw(wh_snap, xd, yd, wd, hd);
        evnt_timer(250, 0);
 
        no_cancel = get_file(gl_pfname);
        do_redraw(wh_snap, xd, yd, wd, hd);
        snap_sync();
 
        if (no_cancel)
        {
                        /* Close the window temporarily.  Get the       */
                        /* parameters which will be used to re-open.    */
            wind_close(wh_snap);
            snap_sync();
            bx = OB_X(bit_ims, ROOT);
            by = OB_Y(bit_ims, ROOT);
            bw = OB_WIDTH(bit_ims, ROOT);
            bh = OB_HEIGHT(bit_ims, ROOT);
            wind_calc(WC_BORDER, 0x000B, bx, by, bw, bh, &x, &y, &w, &h);
                                        /* Get the desired extents.     */
            snap_rubbox();
            header.img_ver = vers;
            header.length = headlen;
            header.patlen = patcnt;
            header.aspect_x = gl_xsiz;
            header.aspect_y = gl_ysiz;
            header.plane_cnt = planes;
            header.num_scans = blt_h;
            header.num_pels = blt_w;
            scan_bytes = (blt_w + 7) >> 3;
                        /* Try to allocate memory for the BLT and file  */
                        /* buffers.  If successful, perform the bitblt. */
            if (snap_alloc())
            {
                        /* Perform the BLT from the screen to the       */
                        /* nice chunk just allocated.  Re-open the      */
                        /* window.                                      */
                snap_blt();
                wind_open(wh_snap, x, y, w, h);
                do_redraw(wh_snap, xd, yd, wd, hd);
                snap_sync();
 
                                /* Appropriately encode the information */
                                /* & write it out to the requested file.*/
                snap_output();
 
                                        /* De-allocate the memory.      */
                dos_free(buf_addr, 0);
                dos_free(blt_addr, 0);
            }  /* End if:  allocation successful. */
            else
            {
                        /* Open the window again and output an          */
                        /* error message.                               */
                wind_open(wh_snap, x, y, w, h);
                snap_sync();
                form_alert(1, ADDR(mem_error));
            }  /* End else:  insufficient memory. */
        }  /* End if:  OK selected. */
 
        SOB_STATE(bit_ims, ROOT, NORMAL);
        do_redraw(wh_snap, xd, yd, wd, hd);
}  /* do_snapshot */
 
/*------------------------------*/
/*      do_redraw               */
/*------------------------------*/
WORD
do_redraw(w_handle, xc, yc, wc, hc)
WORD    w_handle;
WORD    xc, yc, wc, hc;          
{
        LONG            tree;
        WORD            x, y, w, h;
 
        graf_mouse(M_OFF, 0x0L);
        wind_update(TRUE);
 
        wind_get(w_handle, WF_FIRSTXYWH, &x, &y, &w, &h);
        while ( w && h )
        {
            if ( rc_intersect(&xc, &x) )
                objc_draw(bit_ims, ROOT, MAX_DEPTH, x, y, w, h);
            wind_get(w_handle, WF_NEXTXYWH, &x, &y, &w, &h);
        }
        wind_update(FALSE);
        graf_mouse(M_ON, 0x0L);
}  /* End "do_redraw". */
 
/*------------------------------*/
/*      ac_open                 */
/*------------------------------*/
WORD
ac_open(tree, pname)
LONG            tree;
BYTE            *pname;
{
        WORD            wh;
        WORD            x, y, w, h;
        WORD            ob_x, ob_y, ob_w, ob_h;
 
        ob_x = OB_X(tree, ROOT);
        ob_y = OB_Y(tree, ROOT);
        ob_w = OB_WIDTH(tree, ROOT);
        ob_h = OB_HEIGHT(tree, ROOT);
        wh = wind_create(0x000B, gl_xdesk, gl_ydesk, gl_wdesk, gl_hdesk);
        wind_set(wh, WF_NAME, ADDR(pname), 0, 0);
        wind_calc(WC_BORDER, 0x000B, 0, 0, ob_w, ob_h,
                  &x, &y, &w, &h);
        x = ((gl_wdesk - w) / 2) + gl_xdesk;
        y = ((gl_hdesk - h) / 2) + gl_ydesk;
        graf_mouse(2, 0x0L);
        graf_growbox(2 * gl_wchar, 0, 4 * gl_wchar, gl_hchar, x, y, w, h);
        wind_open(wh, x, y, w, h);
        wind_get(wh, WF_WXYWH, &x, &y, &w, &h);
        SOB_X(bit_ims, ROOT, x);
        SOB_Y(bit_ims, ROOT, y);
        graf_mouse(0, 0x0L);
        return(wh);
}  /* End "ac_open". */
 
/*------------------------------*/
/*      message                 */
/*------------------------------*/
WORD
message()
{
        WORD            done;
        WORD            x, y, w, h;
 
        done = FALSE;
        switch( gl_rmsg[0] )
        {
            case AC_OPEN:
                if ( (gl_rmsg[4] == gl_itsnap) && (!wh_snap) )
                  wh_snap = ac_open(bit_ims, " Snapshot ");
                else
                  wind_set(wh_snap, WF_TOP, 0, 0, 0, 0);
                break;
            case WM_REDRAW:
                do_redraw(gl_rmsg[3], gl_rmsg[4], gl_rmsg[5], 
                          gl_rmsg[6], gl_rmsg[7]);
                break;
            case WM_TOPPED:
                wind_set(gl_rmsg[3], WF_TOP, 0, 0, 0, 0);
                break;
            case WM_CLOSED:
                graf_mouse(2, 0x0L);
                wind_get(gl_rmsg[3], WF_CXYWH, &x, &y, &w, &h);
                wind_close(gl_rmsg[3]);
                graf_shrinkbox(2 * gl_wchar, 0, 4 * gl_wchar, gl_hchar,
                               x, y, w, h);
                graf_mouse(0, 0x0L);
                wind_delete(wh_snap);
                wh_snap = 0;
                break;
            case AC_CLOSE:
                if ( (gl_rmsg[3] == gl_itsnap) && (wh_snap) )
                    wh_snap = 0;
                break;
            case WM_MOVED:
                wind_set(gl_rmsg[3], WF_CXYWH, gl_rmsg[4], gl_rmsg[5],
                         gl_rmsg[6], gl_rmsg[7]);
                wind_get(wh_snap, WF_WXYWH, &x, &y, &w, &h);
                SOB_X(bit_ims, ROOT, x);
                SOB_Y(bit_ims, ROOT, y);
                break;
            default:
                break;
        } /* switch */
        gl_rmsg[0] = 0;
        return(done);
}  /* End "message". */
 
/*------------------------------*/
/*      get_file                */
/*------------------------------*/
WORD
get_file(full_path)
BYTE    *full_path;
{
        WORD            ast_loc, butn, ii, slash_loc;
        WORD            cur_drv;
        BYTE            tmp_name[13], tmp_drv;
 
        full_path[0] = NULL;
        tmp_name[0] = NULL;
        cur_drv = dos_gdrv();
        tmp_drv = cur_drv + 'A';
        if ( (!def_path[0]) || (def_path[0] != tmp_drv) )
          get_where(&def_path[0]);
        strcpy(full_path, &def_path[0]);
        strcat(full_path, "*.IMG");
 
        if (fsel_input(ADDR(full_path), ADDR(tmp_name), &butn) && butn)
        {   
            /* Find the spot to concatenate the file name to. */
            ii = 0;
            while(full_path[ii])
              ii++;
            while(full_path[ii] != '\\')
              ii--;
            ii++;
            full_path[ii] = NULL;
            strcat(full_path, &tmp_name[0]);
                                                /* update default path  */
            def_path[0] = NULL;
            strcpy(&def_path[0], full_path);
            ii = 0;
            while(def_path[ii])
              ii++;
            while(def_path[ii] != '\\')
              ii--;
            ii++;
            def_path[ii] = NULL;
            return(TRUE);
        }   /* End if:  no error and OKAY selected. */
        else
            return(FALSE);
}  /* End "get_file". */
 
/*------------------------------*/
/*      snap_sync               */
/*------------------------------*/
WORD
snap_sync()
{
        /* Wait a tad and let "window update" do the blocking. */
        evnt_timer(750, 0);
        wind_update(TRUE);
        wind_update(FALSE);
}  /* End "snap_sync". */
 
/*------------------------------*/
/*      snap_rubbox             */
/*------------------------------*/
WORD
snap_rubbox()
{
        WORD            ks, mb;
 
        /* Prepare for undisturbed mouse input. */
        graf_mouse(5, 0x0l);
        wind_update(BEG_UPDATE);
        wind_update(BEG_MCTRL);
 
        /* Get the extents. */
        evnt_button(1, 0x1, 1, &blt_x, &blt_y, &mb, &ks);
        graf_rubberbox(blt_x, blt_y, 1, 1, &blt_w, &blt_h);
 
        /* Restore the environment. */
        wind_update(END_MCTRL);
        wind_update(END_UPDATE);
        graf_mouse(0, 0x0l);
}  /* End "snap_rubbox". */
 
/*------------------------------*/
/*      snap_alloc              */
/*------------------------------*/
WORD
snap_alloc()
{
        LONG            memalloc();
        WORD            ii;
        /* Calculate the size needed for the bitblt buffer. */
        blt_words = (blt_w >> 4) + ( (blt_w % 16) ? 1 : 0 );
        bltbuf_size = (LONG)2 * blt_words * blt_h * planes;
        buf_size = (LONG) (2 * blt_words + 8 ) * planes;
        /* Allocate the bitblt buffer. */
        ii = FALSE;
        if ( blt_addr = memalloc( (WORD)(bltbuf_size >> 4) + 1) )
        {
            if ( buf_addr = memalloc( (WORD)( buf_size >> 4) +1) )
                ii = TRUE;
            else 
                dos_free( blt_addr, 0 );        
        }
        return(ii);
}  /* End "snap_alloc". */
 
/*------------------------------*/
/*      snap_blt                */
/*------------------------------*/
WORD
snap_blt()
{
        WORD            xy[8];
 
        /* Make sure the source MFDB points to the screen. */
        s_mfdb.fd_off = 0;
        s_mfdb.fd_seg = 0;
 
        /* Set up the destination and transform MFDBs. */
        t_mfdb.fd_off = d_mfdb.fd_off = LLOWD(blt_addr);
        t_mfdb.fd_seg = d_mfdb.fd_seg = LHIWD(blt_addr);
        t_mfdb.fd_w = d_mfdb.fd_w = blt_w;
        t_mfdb.fd_h = d_mfdb.fd_h = blt_h;
        t_mfdb.fd_wdwidth = d_mfdb.fd_wdwidth = blt_words;
        t_mfdb.fd_stand = d_mfdb.fd_stand = 0;
        t_mfdb.fd_nplanes = d_mfdb.fd_nplanes = planes;
 
        /* Set up the points array. */
        xy[0] = blt_x;
        xy[1] = blt_y;
        xy[2] = blt_x + (xy[6] = blt_w - 1);
        xy[3] = blt_y + (xy[7] = blt_h - 1);
        xy[4] = xy[5] = 0;
 
        /* Turn off the cursor. */
        v_hide_c(gl_handle);
 
        /* Perform the bitblt and transform to standard format. */
        vro_cpyfm(gl_handle, 3, xy, &s_mfdb, &d_mfdb);
        vr_trnfm(gl_handle, &d_mfdb, &t_mfdb);
 
        /* Turn the cursor back on. */
        v_show_c(gl_handle, 0);
}  /* End "snap_blt". */
 
/*------------------------------*/
/*      snap_output             */
/*------------------------------*/
WORD
snap_output()
{
        LONG    ptr_plane, fspace, lbuff_size;
        UWORD   buff_size;
        WORD    ii, jj, ycount;
        BYTE    *strptr;
                                        /* first write the .IMG file    */
        ii = header.num_scans;
        blt_byte = ( 2 * blt_words );
        nxt_plane = seg_off( blt_byte * ii );
                                        /* check for space on disk      */
        fspace = (LONG) (d_mfdb.fd_wdwidth * d_mfdb.fd_h * 2);
        fspace *= (LONG) planes;
        if ( !chk_space(gl_pfname[0] - 0x40, fspace) )
          return;
                        /* Open the file and write the header to it.    */
        force_ext(&gl_pfname[0], "IMG");
        f_handle = dos_create(ADDR(gl_pfname), 0);
        jj = header.length;
 
#if I8086
        byt_swap( jj, &header );        /* swap the bytes if 8086 code */
#endif  
        dos_write(f_handle, (LONG) jj * 2, ADDR(&header));
#if I8086
        byt_swap( jj, &header );        /* swap back the bytes if 8086 code */
#endif
 
        /* Convert until the bitblt data is exhausted. */
        blt_ptr = blt_addr;
        fringe(header.num_pels, ii);
        while ( ii )
        {
            buff_ptr = buf_addr;
            buff_cnt = 0;
            ycount = gycount(ii);
            ptr_plane = blt_ptr;
            for ( jj = 0; jj < planes; jj++ )
            {   
                encode( ptr_plane );
                ptr_plane += nxt_plane;
            }
            dos_write( f_handle, (LONG) buff_cnt, buf_addr );
            if ( ii > ycount )
                ii -= ycount;
            else
                ii = 0;
            blt_ptr += seg_off( blt_bytes * ycount );
        } /* while ii */
 
        /* Close the file. */
        dos_close(f_handle);
                                        /* now write the .GEM file      */
        gemfile[8] = 2032;
        gemfile[9] = XSCALE(UMUL_DIV(2032, gl_yres, gl_xres));
        gemfile[11] = gl_yres;
        gemfile[12] = gl_xres;
        gemfile[28] = gemfile[4] = blt_x;
        gemfile[29] = gemfile[5] = blt_y;
        gemfile[30] = gemfile[6] = blt_x + blt_w - 1;
        gemfile[31] = gemfile[7] = blt_y + blt_h - 1;
                                                /* put in filename      */
        strptr = &gl_pfname[0];
        while (*strptr++);
        while (*strptr != '\\')
          strptr--;
        strptr++;
 
        gemfile[26] = strlen(strptr) + 5;
        buff_size = (strlen(strptr) << 1) + 76;
        lbuff_size = buff_size;
 
        for (ii = 37 ; *strptr; ii++)
          gemfile[ii] = *strptr++;
        gemfile[ii] = 0xFFFF;
 
        force_ext(&gl_pfname, "GEM");
                                        /* check for space on disk      */
        if ( !chk_space(gl_pfname[0] - 0x40, 0x100L) )
          return;
        f_handle = dos_create(ADDR(&gl_pfname[0]), 0);
        dos_write(f_handle, lbuff_size, ADDR(gemfile));
        dos_close(f_handle);
}  /* End "snap_output". */
 
/*------------------------------*/
/*      do_dialog               */
/*------------------------------*/
VOID
do_dialog(tree)
LONG    tree;
{
        WORD            x, y, w, h;
 
        form_center(tree, &x, &y, &w, &h);
        SOB_X(tree, ROOT, x);
        SOB_Y(tree, ROOT, y);
        x -= 3;
        y -= 3;
        w += 6;
        h += 6;
 
        form_dial(FMD_START, gl_wdesk / 2, (gl_hdesk - gl_hbox) / 2, 0, 0,
                  x, y, w, h);
        form_dial(FMD_GROW, gl_wdesk / 2, (gl_hdesk - gl_hbox) / 2, 0, 0,
                  x, y, w, h);
        graf_mouse(M_OFF, 0x0L);
        objc_draw(tree, ROOT, MAX_DEPTH, x, y, w, h);
        graf_mouse(M_ON, 0x0L);
        form_do(tree, 0);
        form_dial(FMD_SHRINK, gl_wdesk / 2, (gl_hdesk - gl_hbox) / 2, 0, 0,
                  x, y, w, h);
        form_dial(FMD_FINISH, gl_wdesk / 2, (gl_hdesk - gl_hbox) / 2, 0, 0,
                  x, y, w, h);
} /* do_dialog */
 
/*------------------------------*/
/*      xform_bim               */
/*------------------------------*/
VOID
xform_bim(tree, obj)
LONG    tree;
WORD    obj;
{
        LONG            taddr, obspec;
 
        obspec = OB_SPEC(tree, obj);
        if ( (taddr = LLGET(IB_PDATA(obspec))) != -1L)
          do_trans(taddr);
        if ( (taddr = LLGET(IB_PMASK(obspec))) != -1L)
          do_trans(taddr);
} /* xform_bim */
 
/*------------------------------*/
/*      do_trans                */
/*------------------------------*/
VOID
do_trans(bit_addr)
LONG    bit_addr;
{
        MFDB            tmp_mfdb;
 
        tmp_mfdb.fwp = 32;
        tmp_mfdb.fww = 2;
        tmp_mfdb.fh = 24;
        tmp_mfdb.np = 1;
        tmp_mfdb.mp = bit_addr;
        tmp_mfdb.ff = 0;
        vr_trnfm(gl_handle, &tmp_mfdb, &tmp_mfdb);
} /* do_trans */
 
/*------------------------------*/
/*      get_where               */
/*------------------------------*/
VOID
get_where(ppath)
BYTE    *ppath;
{
/* Get the default directory path                                       */
        WORD            cur_drv, ii;
        BYTE            tmp_path[64];
 
        cur_drv = dos_gdrv();
        ppath[0] = cur_drv + 'A';
        ppath[1] = ':';
        ppath[2] = '\\';
        ppath[3] = NULL;
        dos_gdir(cur_drv + 1, ADDR(&tmp_path[0]));
        strcat(ppath, &tmp_path[0]);
        ii = 0;
        while(ppath[ii])
          ii++;
        ii--;
        if (ppath[ii] == '\\')
        {
          ii--;
          if (ppath[ii] == '\\')
          {
            ii++;
            ppath[ii] = NULL;
          } /* if */
        } /* if */
        else
        {
          ii++;
          ppath[ii++] = '\\';
          ppath[ii] = NULL;
        } /* else */
} /* get_where */
 
/*------------------------------*/
/*      force_ext               */
/*------------------------------*/
VOID
force_ext(pstr, pext)
BYTE    *pstr, *pext;
{
/* put extension pext on pstr                                           */
        BYTE            *pend;
 
        pend = pstr;
                                                /* go to end of string  */
        while(*pend)
          pend++;
        pend--;
                                                /* find the .           */
        while((*pend != '\\') && (*pend != '.') && (pend > pstr))
          pend--;
                                                /* did we find a .?     */
        if ((pend == pstr) || (*pend == '\\'))
        {
          strcat(pstr, ".");                    /* put in a period      */
          strcat(pstr, pext);                   /* no extension at all  */
        } /* if */
        else
        {                                       /* overwrite existing extension 
*/
          pend++;
          *pend = '\0';
          strcat(pstr, pext);
        } /* else */
} /* force_ext */
 
/*------------------------------*/
/*      chk_space               */
/*------------------------------*/
WORD
chk_space(drv, min_space)
WORD    drv;
LONG    min_space;
{
/* check free space on disk                                             */
        LONG            tot, avail;
 
        dos_space(drv, &tot, &avail);
        if (min_space > avail)
        {                               /* not enough space-- show alert        
*/
          form_alert(1, no_space);
          return(FALSE);
        } /* if */
        return(TRUE);
} /* chk_space */
 
/*------------------------------*/
/*      rc_intersect            */
/*------------------------------*/
WORD
rc_intersect(p1, p2)            /* compute intersect of two rectangles  */
GRECT           *p1, *p2;
{
        WORD            tx, ty, tw, th;
 
        tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
        th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
        tx = max(p2->g_x, p1->g_x);
        ty = max(p2->g_y, p1->g_y);
        p2->g_x = tx;
        p2->g_y = ty;
        p2->g_w = tw - tx;
        p2->g_h = th - ty;
        return( (tw > tx) && (th > ty) );
}
 
/*------------------------------*/
/*      min                     */
/*------------------------------*/
WORD
min(a, b)                       /* return min of two values */
WORD            a, b;
{
        return( (a < b) ? a : b );
}
 
/*------------------------------*/
/*      max                     */
/*------------------------------*/
WORD
max(a, b)                       /* return max of two values */
WORD            a, b;
{
        return( (a > b) ? a : b );
}
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "VDIDEFS.H"
 
 
**********************************************************
 
 
/*      GSXDEFS.H       05/06/84 - 07/12/84     Lee Lorenzen            */
 
typedef struct wsstr
{
        WORD            ws_xres;
        WORD            ws_yres;
        WORD            ws_noscale;
        WORD            ws_wpixel;
        WORD            ws_hpixel;
        WORD            ws_ncheights;
        WORD            ws_nlntypes;
        WORD            ws_nlnwidths;
        WORD            ws_nmktypes;
        WORD            ws_nmksizes;
        WORD            ws_nfaces;
        WORD            ws_npatts;
        WORD            ws_nhatchs;
        WORD            ws_ncolors;
        WORD            ws_ngdps;
        WORD            ws_supgdps[10];
        WORD            ws_attgdps[10];
        WORD            ws_color;
        WORD            ws_rotate;
        WORD            ws_fill;
        WORD            ws_cell;
        WORD            ws_npals;
        WORD            ws_nloc;
        WORD            ws_nval;
        WORD            ws_nchoice;
        WORD            ws_nstring;
        WORD            ws_type;
        WORD            ws_pts0;
        WORD            ws_chminh;
        WORD            ws_pts2;
        WORD            ws_chmaxh;
        WORD            ws_lnminw;
        WORD            ws_pts5;
        WORD            ws_lnmaxw;
        WORD            ws_pts7;
        WORD            ws_pts8;
        WORD            ws_mkminw;
        WORD            ws_pts10;
        WORD            ws_mkmaxw;
} WS;
 
typedef struct rdbstr
{
        WORD            rd_choff;
        WORD            rd_chseg;
        WORD            rd_atoff;
        WORD            rd_atseg;
        WORD            rd_r1;
        WORD            rd_r2;
        WORD            rd_type;
        WORD            rd_ncol;
        WORD            rd_nrow;
        WORD            rd_format;
} RDB;
 
 
typedef struct fdbstr
{
        WORD            fd_off;
        WORD            fd_seg;
        WORD            fd_w;
        WORD            fd_h;
        WORD            fd_wdwidth;
        WORD            fd_stand;
        WORD            fd_nplanes;
        WORD            fd_r1;
        WORD            fd_r2;
        WORD            fd_r3;
} FDB;
 
 
typedef struct mfstr
{
        WORD    mf_xhot;
        WORD    mf_yhot;
        WORD    mf_nplanes;
        WORD    mf_fg;
        WORD    mf_bg;
        WORD    mf_mask[16];
        WORD    mf_data[16];
} MFORM ;
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "TADDR.H"
 
 
**********************************************************
 
/*     This is a modified version of TREEADDR.H  which was included    */
/*            with the GEM Programmer's Toolkit.  The modifications    */
/*            are only required for SNAPSHOT (at this time), but you   */
/*            may use this in place of TREEADDR.H without any adverse  */
/*            effects.          07/29/85                               */
/*                                                                     */       
  
/*      TADDR.H         04/11/84 - 09/11/84     Gregg Morris           */
/*      TADDR.H         12/15/84 - 03/11/85     Scott Raney            */
 
#define OB_NEXT(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 0)
#define OB_HEAD(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 2)
#define OB_TAIL(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 4)
#define OB_TYPE(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 6)
#define OB_FLAGS(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 8)
#define OB_STATE(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 10)
#define OB_SPEC(tree,x) LLGET(tree + (x) * sizeof(OBJECT) + 12)
#define OB_X(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 16)
#define OB_Y(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 18)
#define OB_WIDTH(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 20)
#define OB_HEIGHT(tree,x) LWGET(tree + (x) * sizeof(OBJECT) + 22)
 
#define SOB_NEXT(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 0,y)
#define SOB_HEAD(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 2,y)
#define SOB_TAIL(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 4,y)
#define SOB_TYPE(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 6,y)
#define SOB_FLAGS(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 8,y)
#define SOB_STATE(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 10,y)
#define SOB_SPEC(tree,x,y) LLSET(tree + (x) * sizeof(OBJECT) + 12,y)
#define SOB_X(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 16,y)
#define SOB_Y(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 18,y)
#define SOB_WIDTH(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 20,y)
#define SOB_HEIGHT(tree,x,y) LWSET(tree + (x) * sizeof(OBJECT) + 22,y)
 
#define BI_PDATA(long) LLGET(long + 0)
#define BI_WB(long) LWGET(long + 4)
#define BI_HL(long) LWGET(long + 6)
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "PDEFS.H"
 
 
**********************************************************
 
 
/* paint structure definitions          Scott Raney                     */
 
#define PICWIDTH  480
#define PICHEIGHT 600
 
#define YSCALE(x) UMUL_DIV(x, scr_xsize, scr_ysize)
#define ABS(x) (x) > 0 ? (x) :  -(x)
#define MAX_POLY_POINTS 128
#define QMAX 0x201
 
#define BOLD    0x01
#define LIGHT   0x02
#define ITALIC  0x04
#define ULINE   0x08
#define OLINE   0x10
#define SHADOW  0x20
 
#define UDMOUSE struct mouseform
UDMOUSE
{
    WORD        hotx;
    WORD        hoty;
    WORD        planes;
    WORD        mcol;
    WORD        dcol;
    UWORD       mask[16];
    UWORD       data[16];
};
 
#define WINDOW struct pwindow
WINDOW
{
    WORD        wh;
    WORD        tool;
    GRECT       work_area;
    GRECT       draw_area;
    GRECT       undo_area;
    GRECT       pic_area;
    MFDB        undo_mfdb;
    BYTE        file[64];
    BOOLEAN     open;
    BOOLEAN     named;
    BOOLEAN     changed;
    BOOLEAN     pats;
    WORD        color;
    WORD        line_width;
    WORD        fill_style;
    WORD        pg_size;
    WORD        quarters;
};
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAP.H"
 
 
**********************************************************
 
 
#define SNAPIMS 0       /* TREE */
#define HOWTO 1         /* TREE */
#define HOWOK 18        /* OBJECT in TREE #1 */
#define CAMERA 1        /* OBJECT in TREE #0 */
#define QMARK 2         /* OBJECT in TREE #0 */
#define NOSPACE 0       /* STRING */
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAPASM.A86"
 
 
**********************************************************
 
 
;       SNAPA.A86       1/25/85 - 4/5/85        John Grant/Don Heiskell
 
ALLOC_MEM       equ     48h
PCDOS           equ     21h
WRITE_BUFFER    equ     40h
 
                cseg
                public  memalloc, gycount, seg_off, encode, fringe, byt_swap
;************************************************************************
;               WORD                                                    *
;               encode(LONG PTR)                                        *
;************************************************************************
encode:
        cld                             ;clear the direction flag
        push    bp
        mov     bp, sp
        mov     di, 4[bp]
        mov     ax, 6[bp]               ;es:di = src ptr
        mov     bx, scan_byt
        mov     scan_ctr, bx            ;init the bytes to scan counter
        mov     run_ptr, di             ;init the run pointer
        mov     run_ptr+2, ax
        mov     src_ptr, di
        mov     src_ptr+2, ax           ;init the source pointer
        mov     es, ax
        mov     run_cnt, 0
encode_main_lp:
        les     di, dword ptr src_ptr   ;load up the source pointer into es:di
        cmp     scan_ctr, 2             ;are there at least two bytes left? 
        jl      encode_bytes
        mov     ax, es:[di]             ;see if there are two 0's
        and     ax, ax
        jnz     encode_test_all1s
        call    flush_run               ;flush any bytes saved up
        call    run0s                   ;run the 0's till don't match
        jmp     encode_scancnt_test
encode_test_all1s:
        cmp     ax, 0ffffh              ;see if there are two ff's
        jnz     encode_test_patt
        call    flush_run               ;flush any bytes saved up
        call    run1s                   ;run the 1's till don't match
        jmp     encode_scancnt_test
encode_test_patt:
        cmp     scan_ctr, 6             ;are there at least 6 bytes left?
        jl      encode_bytes
        mov     ax, es:[di]             ;we will search for 3 words that match
        add     di, 2
        mov     cx, 2
        rep     scasw                   ;do the search
        jnz     encode_bytes
        call    flush_run
        call    run_patt
        jmp     encode_scancnt_test
encode_bytes:
        inc     run_cnt                 ;we have another byte of bits to flush
        inc     src_ptr
        dec     scan_ctr                ;we have another byte of bits
encode_scancnt_test:
        cmp     scan_ctr, 0             ;are we done?
        jnz     encode_main_lp
        call    flush_run               ;flush any remaining bytes
        pop     bp
        ret
;
;flush_run
;       flushes the buffer pointed to by run_ptr to the disk buffer
;       pointed to by buff_ptr
;       run_ptr is reinitialized to point to src_ptr.
;       buff_cnt is incremented by run_cnt
;       run_cnt is set = to 0
flush_run:
        cmp     run_cnt, 0              ;are there any bytes to run
        jz      flush_exit
        les     di, dword ptr buff_ptr  ;point to the disk buffer
        mov     al,80h
        stosb                           ;put out the 80 header byte
        mov     ax, run_cnt
        stosb                           ;put out the count
        mov     cx, ax
        push    ds
        lds     si, dword ptr run_ptr
        rep     movsb                   ;move the string of bytes out
        pop     ds
        mov     ax, run_cnt
        add     buff_cnt, ax
        mov     buff_ptr, di            ;update the buffer pointer
        add     buff_cnt, 2             ;account for the header
flush_exit:
        mov     ax, src_ptr
        mov     run_ptr, ax             ;run pointer = source pointer
        mov     run_cnt, 0              ;init the run count to 0
        ret 
;
;run0s
;       runs out the number of 0's in string to the disk buffer
;       src_ptr is incremented to point to end of string of 0's
;       
run1s:
        mov     dl, 0ffh                ;this is the search byte
        mov     dh, 80h                 ;this is the byte with color (b/w)
        jmp     run0s_internal          ;let 0's code do the work
run0s:
        xor     dx, dx
run0s_internal:
        les     di, dword ptr src_ptr   ;get the pointer to the 0's
        mov     cx, scan_ctr            ;get the max scanln count
        cmp     cx, 127
        jle     run0s_lenok
        mov     cx, 127                 ;max run of 0's is 127
run0s_lenok:
        mov     bx, cx
        mov     ax, dx
        rep     scasb                   ;scan for a string of 0's
        jcxz    run0s_test_flags
        inc     cx
        jmp     run0s_whats_up
run0s_test_flags:
        jz      run0s_whats_up
        inc     cx
run0s_whats_up:
        sub     bx, cx                  ;get the count of bytes of 0's
        or      dh, bl                  ;get the byte to write to buff
        mov     al, dh
        les     di, dword ptr buff_ptr
        stosb                           ;store the encoded byte
        inc     buff_ptr
        inc     buff_cnt                ;add 1 to both ptr and count in buff
        add     src_ptr, bx             ;move the source pointer to end of 0's
        sub     scan_ctr, bx            ;decrement the scancounter by num 0's
        mov     ax,src_ptr
        mov     run_ptr ,ax             ;update the run pointer 
        ret
;
;run_patt
;       runs out the number of words which match the current word in string 
;       to the disk buffer
;       src_ptr is incremented to point to end of string of patts
;       
run_patt:
        les     di, dword ptr src_ptr   ;get the pointer to the 0's
        mov     ax, es:[di]
        add     di, 2                   ;point to the next word
        mov     cx, scan_ctr            ;get the max scanln count
        shr     cx, 1                   ;get the #words left in scan line
        mov     bx, cx
        dec     cx                      ;make up for the word already used
        rep     scasw                   ;scan for a string of patts
        jcxz    run_patt_test_flags
        inc     cx
        jmp     run_patt_whata_up
run_patt_test_flags:
        jz      run_patt_whata_up
        inc     cx
run_patt_whata_up:                      ;all this and 16 bits too?
        sub     bx, cx                  ;get the count of words of patts
        les     di, dword ptr buff_ptr
        mov     dx, ax                  ;save the patt
        xor     al,al
        stosb                           ;store the header 0
        mov     al,bl                   ;store the count of patt reps   
        stosb
        mov     ax, dx
        stosb
        xchg    ah,al
        stosb
        mov     buff_ptr, di
        add     buff_cnt, 4             ;wrote 4 bytes to the buffer
        shl     bx, 1                   ;make the count = bytes
        add     src_ptr, bx             ;move the source pointer to end of patt
        sub     scan_ctr, bx            ;decrement the scancounter by num 0's
        mov     ax,src_ptr
        mov     run_ptr ,ax             ;update the run pointer 
        ret
        ret
;************************************************************************
;               WORD                                                    *
;               byt_swap( count, ptr )                                  *
;************************************************************************
byt_swap:
        cld
        push    bp
        mov     bp, sp
        mov     cx, 4[bp]
        mov     si, 6[bp]               ; get the count and the pointer
        mov     di, si
        mov     ax, ds
        mov     es, ax
byt_swap_lp:
        lodsw                           ; get the word in ax
        xchg    ah,al
        stosw
        loop    byt_swap_lp
        pop     bp
        ret
;routine used internally to byte swap the bitplanes
;
swap_planes:
        push    si                      ; si = scans/plane 
        push    bx
        mov     ax, blt_byte            ; get the width of the form in bytes
        shr     ax, 1                   ; make it words
        mul     si                      ; get the count per plane
        mov     dx, ax
        mov     bx, planes              ; load the loop count
        les     di, dword ptr blt_ptr
swap_planes_xchglp:
        push    es
        push    di
        push    ds
        mov     si, di                  ; make the source = dest
        mov     ax, es
        mov     x
        mov     cx, dx                  ; load the count
swap_planes_byt_swap_lp:
        lodsw                           ; get the word in ax
        xchg    ah,al
        stosw
        loop    swap_planes_byt_swap_lp
        pop     ds
        pop     di
        pop     es
        add     di, nxt_plan            ; point at the next plane
        mov     ax, es
        add     ax, nxt_plan+2
        mov     es, ax
        dec     bx
        jnz     swap_planes_xchglp      ; exchange each plane
        pop     bx
        pop     si
        ret
;************************************************************************
;               WORD                                                    *
;               fringe(width,height)                                    *
;************************************************************************
fringe:
        cld
        push    bp
        mov     bp, sp
        mov     bx, 4[bp]               ; get the width in pels of scan
        mov     si, 6[bp]               ; get the height of a plane in pels
        call    swap_planes
        and     bx, 0007h               ; look at the three lsb's
        mov     al, fringe_table[bx]    ; get the fringe mask byte
        les     di, dword ptr blt_ptr   ; get the pointer to data
        add     di, scan_byt            ; add in the width to scan in bytes
        dec     di                      ; make the last n-1
        mov     dx, planes              ; load up the outer loop count
fringe_oloop:
        mov     cx, si                  ; load up the scans to do
        push    es
        push    di                      ; save the plane head pointer
fringe_iloop:
        and     es: byte ptr[di], al    ; force the perimeter to 1's
        add     di, blt_byte            ; goto the next scan line in this plane
        loop    fringe_iloop
        pop     di
        pop     es
        add     di, nxt_plan            ; goto the next bit plane
        mov     bx, es
        add     bx, nxt_plan+2
        mov     es, bx
        dec     dx
        jnz     fringe_oloop
        pop     bp
        ret
;************************************************************************
;               WORD                                                    *
;       count = gycount(scansleft)                                      *
;               returns                                                 *
;                       ax = count                                      *
;************************************************************************
gycount:
        cld
        push    bp
        mov     bp, sp
        mov     cx, 4[bp]               ;get the max lines to check
        mov     bx, 1                   ;init the scan count
        cmp     cx, bx
        jle     end_gycount
        cmp     cx, 255                 ;if the count is > a byte 
        jle     gycount_ok
        mov     cx, 255                 ;make it 255
gycount_ok:
        dec     cx                      ;make count n-1 
        cld                             ;clear the direction flag 
        les     di, dword ptr blt_ptr
        mov     dest_ptr, di
        mov     ax, es
        mov     dest_ptr+2,ax           ;init the dest ptr
 
gycount_outer_loop:
        mov     dx, planes
        les     di, dword ptr dest_ptr
gycount_plane_loop:
        push    di
        push    es
        call    compstr
        pop     es
        pop     di
        jnz     gycount_exit
        add     di, nxt_plan
        mov     ax, es
        add     ax, nxt_plan+2
        mov     es, ax
        dec     dx
        jnz     gycount_plane_loop
        inc     bx                      ;increment the scan line count
        mov     ax, blt_byte
        add     dest_ptr, ax
        loop    gycount_outer_loop
gycount_exit:
        cmp     bx, 1
        jle     end_gycount
        les     di, dword ptr buff_ptr
        xor     ax, ax
        stosw                           ;write out the esc header
        mov     al, 255
        stosb                           ;write out the command
        mov     ax, bx
        stosb                           ;write out the count
        mov     buff_ptr, di
        add     buff_cnt, 4
end_gycount:
        mov     ax, bx
        pop     bp
        ret
compstr:
        push    cx
        mov     cx, scan_byt            ;load the count of scan
        push    ds
        mov     si, di
        add     si, blt_byte
        mov     ax, es
        mov     ds, ax
        rep     cmpsb                   ; is this plane equal
        pop     ds
        pop     cx
        ret
 
;************************************************************************
;               LONG                                                    *
;       address = seg_off(WORD)                                         *
;               returns bx = offset                                     *
;                       ax = segment                                    *
;************************************************************************
seg_off:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ax, bx
                and     bx, 000fh               ;make it an offset
                mov     cl, 4
                shr     ax, cl                  ;make it a segment
                pop     bp
                ret
 
;************************************************************************
;               LONG                                                    *
;       address = memalloc(paragraphs:WORD)                             *
;************************************************************************
memalloc:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ah, ALLOC_MEM
                int     PCDOS
                jc      alloc_error
                xor     bx, bx
                jmp     end_memalloc
alloc_error:
                xor     ax, ax
                mov     bx, ax
end_memalloc:
                pop     bp
                ret
 
 
; Data segment data declarations.
                dseg
                extrn   buff_ptr:word   ;pointer to buffer
                extrn   buff_cnt:word   ;counter of buffer length
                extrn   blt_ptr:word    ;pointer to current scanline / plane0
                extrn   scan_byt:word   ;bytes to scan / line
                extrn   blt_byte:word   ;bytes per line in form
                extrn   nxt_plan:word   ;bytes to the next plane
                extrn   planes:word     ;plane count    
fringe_table    db      11111111b
                db      10000000b
                db      11000000b
                db      11100000b
                db      11110000b
                db      11111000b
                db      11111100b
                db      11111110b
dest_ptr        dw      0
                dw      0
scan_ctr        dw      0
run_cnt         dw      0
run_ptr         dw      0
                dw      0
src_ptr         dw      0
                dw      0
                end
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAPSHOT.INP"
 
 
**********************************************************
 
 
snapshot=accstart,    
snapshot,
snapasm,
gembind, 
gemasm,
vdibind,             
vdiasm,                
dosbind,                 
dosasm,                 
tcrtl,
tcrtlasm,
longasm[nop,data[max[0   
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "ACCSTART.A86"
 
 
**********************************************************
 
 
;     This is a modified version of ACCSTART.A86  which was included  
;            with the GEM Programmer's Toolkit. The modifications    
;            are only required for SNAPSHOT (at this time), but you   
;            may use this in place of ACCSTART.A86 without any adverse 
;            effects.          07/29/85                               
;                                                              
;       ACCSTART.A86            4/18/84 - 10/18/84      Lee Lorenzen    
;       ACCSTART.A86            07/26/85                Mitch Smith 
;
;
;
        cseg
        extrn   gemain:near
;
        cli
        mov     ax,seg stk
        mov     ds,ax
        mov     ss,ax
        mov     es,ax
        mov     sp,offset stk
        sti
;
;
        call    gemain
        mov     ax,0ch
        mov     di,ax
        mov     ax,0
        int     24h
;
        dseg
;       rw      100   ;  modified 07/26/85     increasing data size from 
        rw      512   ;                           100 to 512
stk     dw      0
        end
 
 
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAPM.BAT"
 
 
**********************************************************
 
 
masm tcs.asm ;
masm accstart.asm ;
lc1 snapshot
lc2 snapshot -v
masm snapasm.asm ;
lc1 gembind
lc2 gembind -v
masm gemasm.asm ;
lc1 vdibind
lc2 vdibind -v
masm vdiasm.asm ;
lc1 dosbind 
lc2 dosbind -v
masm dosasm.asm ;
lc1 tcrtl
lc2 tcrtl -v
masm tcrtlasm.asm ;
masm longasm.asm ;
masm proend.asm ;
link tcs+accstart+snapshot+snapasm+gembind+gemasm+vdibind+vdiasm+dosbind+dosasm+
tcrtl+tcrtlasm+longasm+proend,desk3,desk3/map,,
map2sym <desk3.exe >desk3.sym
rename desk3.exe desk3.acc
 
 
 
**********************************************************
 
 
        THIS IS THE BEGINING OF A NEW FILE
 
        RENAME THIS FILE   "SNAPASM.ASM"
 
 
**********************************************************
 
 
 
;       SNAPA.A86       1/25/85 - 4/5/85        John Grant/Don Heiskell
;       modified for MASM         7/26/85       Mitch Smith
 
 
ALLOC_MEM       equ     48h
PCDOS           equ     21h
WRITE_BUFFER    equ     40h
 
 
PGROUP  GROUP   PROG
 
DGROUP  GROUP   DATA
 
PROG    SEGMENT BYTE PUBLIC 'PROG'
        ASSUME  CS:PGROUP
        ASSUME  DS:DGROUP
;
        PUBLIC  memalloc, gycount, seg_off, encode, fringe, byt_swap
 
;************************************************************************
;               WORD                                                    *
;               encode(LONG PTR)                                        *
;************************************************************************
encode:
        cld                             ;clear the direction flag
        push    bp
        mov     bp, sp
        mov     di, 4[bp]
        mov     ax, 6[bp]               ;es:di = src ptr
        mov     bx, scan_byt
        mov     scan_ctr, bx            ;init the bytes to scan counter
        mov     run_ptr, di             ;init the run pointer
        mov     run_ptr+2, ax
        mov     src_ptr, di
        mov     src_ptr+2, ax           ;init the source pointer
        mov     es, ax
        mov     run_cnt, 0
encode_main_lp:
        les     di, dword ptr src_ptr   ;load up the source pointer into es:di
        cmp     scan_ctr, 2             ;are there at least two bytes left? 
        jl      encode_bytes
        mov     ax, es:[di]             ;see if there are two 0's
        and     ax, ax
        jnz     encode_test_all1s
        call    flush_run               ;flush any bytes saved up
        call    run0s                   ;run the 0's till don't match
        jmp     encode_scancnt_test
encode_test_all1s:
        cmp     ax, 0ffffh              ;see if there are two ff's
        jnz     encode_test_patt
        call    flush_run               ;flush any bytes saved up
        call    run1s                   ;run the 1's till don't match
        jmp     encode_scancnt_test
encode_test_patt:
        cmp     scan_ctr, 6             ;are there at least 6 bytes left?
        jl      encode_bytes
        mov     ax, es:[di]             ;we will search for 3 words that match
        add     di, 2
        mov     cx, 2
        rep     scasw                   ;do the search
        jnz     encode_bytes
        call    flush_run
        call    run_patt
        jmp     encode_scancnt_test
encode_bytes:
        inc     run_cnt                 ;we have another byte of bits to flush
        inc     src_ptr
        dec     scan_ctr                ;we have another byte of bits
encode_scancnt_test:
        cmp     scan_ctr, 0             ;are we done?
        jnz     encode_main_lp
        call    flush_run               ;flush any remaining bytes
        pop     bp
        ret
;
;flush_run
;       flushes the buffer pointed to by run_ptr to the disk buffer
;       pointed to by buff_ptr
;       run_ptr is reinitialized to point to src_ptr.
;       buff_cnt is incremented by run_cnt
;       run_cnt is set = to 0
flush_run:
        cmp     run_cnt, 0              ;are there any bytes to run
        jz      flush_exit
        les     di, dword ptr buff_ptr  ;point to the disk buffer
        mov     al,80h
        stosb                           ;put out the 80 header byte
        mov     ax, run_cnt
        stosb                           ;put out the count
        mov     cx, ax
        push    ds
        lds     si, dword ptr run_ptr
        rep     movsb                   ;move the string of bytes out
        pop     ds
        mov     ax, run_cnt
        add     buff_cnt, ax
        mov     buff_ptr, di            ;update the buffer pointer
        add     buff_cnt, 2             ;account for the header
flush_exit:
        mov     ax, src_ptr
        mov     run_ptr, ax             ;run pointer = source pointer
        mov     run_cnt, 0              ;init the run count to 0
        ret 
;
;run0s
;       runs out the number of 0's in string to the disk buffer
;       src_ptr is incremented to point to end of string of 0's
;       
run1s:
        mov     dl, 0ffh                ;this is the search byte
        mov     dh, 80h                 ;this is the byte with color (b/w)
        jmp     run0s_internal          ;let 0's code do the work
run0s:
        xor     dx, dx
run0s_internal:
        les     di, dword ptr src_ptr   ;get the pointer to the 0's
        mov     cx, scan_ctr            ;get the max scanln count
        cmp     cx, 127
        jle     run0s_lenok
        mov     cx, 127                 ;max run of 0's is 127
run0s_lenok:
        mov     bx, cx
        mov     ax, dx
        rep     scasb                   ;scan for a string of 0's
        jcxz    run0s_test_flags
        inc     cx
        jmp     run0s_whats_up
run0s_test_flags:
        jz      run0s_whats_up
        inc     cx
run0s_whats_up:
        sub     bx, cx                  ;get the count of bytes of 0's
        or      dh, bl                  ;get the byte to write to buff
        mov     al, dh
        les     di, dword ptr buff_ptr
        stosb                           ;store the encoded byte
        inc     buff_ptr
        inc     buff_cnt                ;add 1 to both ptr and count in buff
        add     src_ptr, bx             ;move the source pointer to end of 0's
        sub     scan_ctr, bx            ;decrement the scancounter by num 0's
        mov     ax,src_ptr
        mov     run_ptr ,ax             ;update the run pointer 
        ret
;
;run_patt
;       runs out the number of words which match the current word in string 
;       to the disk buffer
;       src_ptr is incremented to point to end of string of patts
;       
run_patt:
        les     di, dword ptr src_ptr   ;get the pointer to the 0's
        mov     ax, es:[di]
        add     di, 2                   ;point to the next word
        mov     cx, scan_ctr            ;get the max scanln count
        shr     cx, 1                   ;get the #words left in scan line
        mov     bx, cx
        dec     cx                      ;make up for the word already used
        rep     scasw                   ;scan for a string of patts
        jcxz    run_patt_test_flags
        inc     cx
        jmp     run_patt_whata_up
run_patt_test_flags:
        jz      run_patt_whata_up
        inc     cx
run_patt_whata_up:                      ;all this and 16 bits too?
        sub     bx, cx                  ;get the count of words of patts
        les     di, dword ptr buff_ptr
        mov     dx, ax                  ;save the patt
        xor     al,al
        stosb                           ;store the header 0
        mov     al,bl                   ;store the count of patt reps   
        stosb
        mov     ax, dx
        stosb
        xchg    ah,al
        stosb
        mov     buff_ptr, di
        add     buff_cnt, 4             ;wrote 4 bytes to the buffer
        shl     bx, 1                   ;make the count = bytes
        add     src_ptr, bx             ;move the source pointer to end of patt
        sub     scan_ctr, bx            ;decrement the scancounter by num 0's
        mov     ax,src_ptr
        mov     run_ptr ,ax             ;update the run pointer 
        ret
        ret
;************************************************************************
;               WORD                                                    *
;               byt_swap( count, ptr )                                  *
;************************************************************************
byt_swap:
        cld
        push    bp
        mov     bp, sp
        mov     cx, 4[bp]
        mov     si, 6[bp]               ; get the count and the pointer
        mov     di, si
        mov     ax, ds
        mov     es, ax
byt_swap_lp:
        lodsw                           ; get the word in ax
        xchg    ah,al
        stosw
        loop    byt_swap_lp
        pop     bp
        ret
;routine used internally to byte swap the bitplanes
;
swap_planes:
        push    si                      ; si = scans/plane 
        push    bx
        mov     ax, blt_byte            ; get the width of the form in bytes
        shr     ax, 1                   ; make it words
        mul     si                      ; get the count per plane
        mov     dx, ax
        mov     bx, planes              ; load the loop count
        les     di, dword ptr blt_ptr
swap_planes_xchglp:
        push    es
        push    di
        push    ds
        mov     si, di                  ; make the source = dest
        mov     ax, es
        mov     ds, ax
        mov     cx, dx                  ; load the count
swap_planes_byt_swap_lp:
        lodsw                           ; get the word in ax
        xchg    ah,al
        stosw
        loop    swap_planes_byt_swap_lp
        pop     ds
        pop     di
        pop     es
        add     di, nxt_plan            ; point at the next plane
        mov     ax, es
        add     ax, nxt_plan+2
        mov     es, ax
        dec     bx
        jnz     swap_planes_xchglp      ; exchange each plane
        pop     bx
        pop     si
        ret
;************************************************************************
;               WORD                                                    *
;               fringe(width,height)                                    *
;************************************************************************
fringe:
        cld
        push    bp
        mov     bp, sp
        mov     bx, 4[bp]               ; get the width in pels of scan
        mov     si, 6[bp]               ; get the height of a plane in pels
        call    swap_planes
        and     bx, 0007h               ; look at the three lsb's
        mov     al, fringe_table[bx]    ; get the fringe mask byte
        les     di, dword ptr blt_ptr   ; get the pointer to data
        add     di, scan_byt            ; add in the width to scan in bytes
        dec     di                      ; make the last n-1
        mov     dx, planes              ; load up the outer loop count
fringe_oloop:
        mov     cx, si                  ; load up the scans to do
        push    es
        push    di                      ; save the plane head pointer
fringe_iloop:
        and     es: byte ptr[di], al    ; force the perimeter to 1's
        add     di, blt_byte            ; goto the next scan line in this plane
        loop    fringe_iloop
        pop     di
        pop     es
        add     di, nxt_plan            ; goto the next bit plane
        mov     bx, es
        add     bx, nxt_plan+2
        mov     es, bx
        dec     dx
        jnz     fringe_oloop
        pop     bp
        ret
;************************************************************************
;               WORD                                                    *
;}i       count = gycount(scansleft)                                      *
;               returns                                                 *
;                       ax = count                                      *
;************************************************************************
gycount:
        cld
        push    bp
        mov     bp, sp
        mov     cx, 4[bp]               ;get the max lines to check
        mov     bx, 1                   ;init the scan count
        cmp     cx, bx
        jle     end_gycount
        cmp     cx, 255                 ;if the count is > a byte 
        jle     gycount_ok
        mov     cx, 255                 ;make it 255
gycount_ok:
        dec     cx                      ;make count n-1 
        cld                             ;clear the direction flag 
        les     di, dword ptr blt_ptr
        mov     dest_ptr, di
        mov     ax, es
        mov     dest_ptr+2,ax           ;init the dest ptr
 
gycount_outer_loop:
        mov     dx, planes
        les     di, dword ptr dest_ptr
gycount_plane_loop:
        push    di
        push    es
        call    compstr
        pop     es
        pop     di
        jnz     gycount_exit
        add     di, nxt_plan
        mov     ax, es
        add     ax, nxt_plan+2
        mov     es, ax
        dec     dx
        jnz     gycount_plane_loop
        inc     bx                      ;increment the scan line count
        mov     ax, blt_byte
        add     dest_ptr, ax
        loop    gycount_outer_loop
gycount_exit:
        cmp     bx, 1
        jle     end_gycount
        les     di, dword ptr buff_ptr
        xor     ax, ax
        stosw                           ;write out the esc header
        mov     al, 255
        stosb                           ;write out the command
        mov     ax, bx
        stosb                           ;write out the count
        mov     buff_ptr, di
        add     buff_cnt, 4
end_gycount:
        mov     ax, bx
        pop     bp
        ret
compstr:
        push    cx
        mov     cx, scan_byt            ;load the count of scan
        push    ds
        mov     si, di
        add     si, blt_byte
        mov     ax, es
        mov     ds, ax
        rep     cmpsb                   ; is this plane equal
        pop     ds
        pop     cx
        ret
 
;************************************************************************
;               LONG                                                    *
;       address = seg_off(WORD)                                         *
;               returns bx = offset                                     *
;                       ax = segment                                    *
;************************************************************************
seg_off:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ax, bx
                and     bx, 000fh               ;make it an offset
                mov     cl, 4
                shr     ax, cl                  ;make it a segment
                pop     bp
                ret
 
;************************************************************************
;               LONG                                                    *
;       address = memalloc(paragraphs:WORD)                             *
;************************************************************************
memalloc:
                push    bp
                mov     bp, sp
                mov     bx, 4[bp]
                mov     ah, ALLOC_MEM
                int     PCDOS
                jc      alloc_error
                xor     bx, bx
                jmp     end_memalloc
alloc_error:
                xor     ax, ax
                mov     bx, ax
end_memalloc:
                pop     bp
                ret
PROG    ENDS
 
 
; Data segment data declarations.
 
 
DATA    SEGMENT PARA PUBLIC 'DATA'
 
extrn   buff_ptr:word   ;pointer to buffer
extrn   buff_cnt:word   ;counter of buffer length
extrn   blt_ptr:word    ;pointer to current scanline / plane0
extrn   scan_byt:word   ;bytes to scan / line
extrn   blt_byte:word   ;bytes per line in form
extrn   nxt_plan:word   ;bytes to the next plane
extrn   planes:word     ;plane count    
 
fringe_table    db      11111111b
                db      10000000b
                db      11000000b
                db      11100000b
                db      11110000b
                db      11111000b
                db      11111100b
                db      11111110b
dest_ptr        dw      0
                dw      0
scan_ctr        dw      0
run_cnt         dw      0
run_ptr         dw      0
                dw      0
src_ptr         dw      0
                dw      0
 
 
DATA    ENDS
END
 
 
 
 
 
 
**********************************************************
**********************************************************
 
 
  THIS IS THE END OF THE CODE FOR SNAPSHOT DESK ACCESSORY
 
 
**********************************************************
**********************************************************
