
(*****************************************************************)
(**      File Name     :  AESBND.PAS                            **)
(**                                                             **)
(**      Modified for Turbo Pascal.                             **)
(**                                                             **)
(**      Comments      :  All these language bindings use       **)
(**                       array's relative to zero to match the **)
(**                       Programmer's Guide (GEM AES VOL 2)    **)
(**                                                             **)
(**      Author        : Athol M. Foden                         **)
(**      History       : Feb 1985                               **)
(**      Last Modified : 12 February 1986                       **)
(**      Digital Research Inc                                   **)
(*****************************************************************)

PROCEDURE GAES (VAR     a_addrout : aad_ARRAY;
                 VAR a_addrin : aad_ARRAY;
                 VAR aintout : ao_ARRAY;
                 VAR aintin : ai_ARRAY;
                 VAR aglobal : ag_ARRAY;
                 VAR acontrol : ac_ARRAY);

CONST
        AESinterruptVector = $EF;
        AESmagicConstant = 200;

TYPE
        ADDRESS = ^BYTE;

VAR
        parameterBlock : RECORD
                controlArray : ADDRESS;
                globalArray : ADDRESS;
                inputParameterArray : ADDRESS;
                outputParameterArray : ADDRESS;
                inputAddressArray : ADDRESS;
                outputAddressArray : ADDRESS;
        END (* RECORD *);
        registers : RECORD

                ax, bx, cx, dx, bp, si, di, ds, es, flags : INTEGER;

        END (* RECORD *);

BEGIN (* GAES *)

        parameterBlock.controlArray := ADDR(acontrol);
        parameterBlock.globalArray := ADDR(aglobal);
        parameterBlock.inputParameterArray := ADDR(aintin);
        parameterBlock.outputParameterArray := ADDR(aintout);
        parameterBlock.inputAddressArray := ADDR(a_addrin);
        parameterBlock.outputAddressArray := ADDR(a_addrout);

        registers.cx := AESmagicConstant;
        registers.es := SEG(parameterBlock);
        registers.bx := OFS(parameterBlock);

        INTR(AESinterruptvector, registers);

END (* GAES *);

(*---------------------------------------------------------------------*)
(** Common call to the GEM AES routines - used by all other functions *)

FUNCTION GEMAES(opcode, c1, c2, c3, c4 : INTEGER) : INTEGER;
BEGIN
        gcontrol[0] := opcode;
        gcontrol[1] := c1;        (* number of params in gintin *)
        gcontrol[2] := c2;        (* number of params in gintout *)
        gcontrol[3] := c3;        (* number of params in addrin *)
        gcontrol[4] := c4;        (* number of params in addrout *)
        GAES(addr_out, addr_in, gintout, gintin, global, gcontrol);
        GEMAES := gintout[0];                     (* return value if any *)
END;

(***********************************************************************)

                  (*** APPLICATION LIBRARY ***)

(*---------------------------------------------------------------------*)

FUNCTION appl_init : INTEGER;

VAR     ap_id : INTEGER ;
BEGIN
        ap_id := GEMAES(10,0,1,0,0);
        global[ 2 ] := ap_id ;
        appl_init := ap_id;
END ;

(*---------------------------------------------------------------------*)

FUNCTION appl_read ( ap_rid, ap_rlength: INTEGER;
                                ap_rpbuff: ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := ap_rid;
        gintin[ 1 ] := ap_rlength;
        addr_in[ 0 ] := ap_rpbuff;
        appl_read := GEMAES(11,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION   appl_write(  ap_wid, ap_wlength : INTEGER;
                        ap_wpbuff: ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := ap_wid;
        gintin[ 1 ] := ap_wlength;
        addr_in[ 0 ] := ap_wpbuff;
        appl_write := GEMAES(12,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION appl_find (ap_fpname : ADDRESS) : INTEGER;
BEGIN
        addr_in[0] := ap_fpname;
        appl_find := GEMAES(13,0,1,1,0);
END;

(*---------------------------------------------------------------------*)

FUNCTION appl_tplay (ap_tpmem : ADDRESS;
                        ap_tpnum, ap_tpscale : INTEGER) : INTEGER;
BEGIN
        gintin[0] := ap_tpnum;
        gintin[1] := ap_tpscale;
        addr_in[0] := ap_tpmem;
        appl_tplay := GEMAES(14,2,1,1,0);
END;

(*---------------------------------------------------------------------*)

FUNCTION appl_trecord (ap_trmem : ADDRESS;
ap_trcount : INTEGER) : INTEGER;
BEGIN
        gintin[0] := ap_trcount;
        addr_in[0] := ap_trmem;
        appl_trecord := GEMAES(15,1,1,1,0);
END;

(*---------------------------------------------------------------------*)

FUNCTION appl_exit : INTEGER;
BEGIN
        appl_exit := GEMAES(19,0,1,0,0);
END ;

(***********************************************************************)
                (** EVENT LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION evnt_keybd : INTEGER;
BEGIN
        evnt_keybd := GEMAES(20,0,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION evnt_button(ev_bclicks, ev_bmask, ev_bstate : INTEGER;

                        VAR ev_bmx, ev_bmy, ev_bmb, ev_bks : INTEGER) : INTEGER ;
BEGIN
        gintin[ 0 ] := ev_bclicks;
        gintin[ 1 ] := ev_bmask;
        gintin[ 2 ] := ev_bstate;
        evnt_button := GEMAES(21,3,5,0,0);
        ev_bmx := gintout[1];
        ev_bmy := gintout[2];
        ev_bmb := gintout[3];
        ev_bks := gintout[4];
END ;

(*---------------------------------------------------------------------*)

FUNCTION   evnt_mouse( ev_moflags, ev_mox, ev_moy, ev_mowidth, 
                                                ev_moheight : INTEGER;

                VAR ev_momx, ev_momy, ev_momb, ev_momks : INTEGER) : INTEGER;
BEGIN
        gintin[ 0 ] := ev_moflags;
        gintin[ 1 ] := ev_mox;
        gintin[ 2 ] := ev_moy;
        gintin[ 3 ] := ev_mowidth;
        gintin[ 4 ] := ev_moheight;
        evnt_mouse := GEMAES(22,5,5,0,0);
        ev_momx := gintout[1];
        ev_momy := gintout[2];
        ev_momb := gintout[3];
        ev_momks := gintout[4];
END ;

(*---------------------------------------------------------------------*)

FUNCTION   evnt_mesag( ev_mgpbuff : ADDRESS ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ev_mgpbuff;
        evnt_mesag := GEMAES(23,0,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION   evnt_timer( ev_tlocount, ev_thicount : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := ev_tlocount;
        gintin[ 1 ] := ev_thicount;
        evnt_timer := GEMAES(24,2,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION   evnt_multi( ev_mflags, ev_mbclicks, ev_mbmask, ev_mbstate, 
                   ev_mm1flags, ev_mm1x, ev_mm1y, ev_mm1width, ev_m1height, 
           ev_mm2flags, ev_mm2x, ev_mm2y, ev_mm2width, ev_mm2height : INTEGER ;
                           ev_mmgpbuff : ADDRESS ;
                           ev_mtlocount, ev_mthicount : INTEGER ;

            VAR ev_mmox, ev_mmoy, ev_mmobutton, ev_mmokstate, 
                ev_mkreturn, ev_mbreturn : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := ev_mflags;
        gintin[ 1 ] := ev_mbclicks;
        gintin[ 2 ] := ev_mbmask;
        gintin[ 3 ] := ev_mbstate;
        gintin[ 4 ] := ev_mm1flags;
        gintin[ 5 ] := ev_mm1x;
        gintin[ 6 ] := ev_mm1y;
        gintin[ 7 ] := ev_mm1width;
        gintin[ 8 ] := ev_m1height;
        gintin[ 9 ] := ev_mm2flags;
        gintin[ 10 ] := ev_mm2x;
        gintin[ 11 ] := ev_mm2y;
        gintin[ 12 ] := ev_mm2width;
        gintin[ 13 ] := ev_mm2height;
        addr_in[ 0 ] := ev_mmgpbuff ;
        gintin[ 14 ] := ev_mtlocount;
        gintin[ 15 ] := ev_mthicount;
        EVNT_MULTI := GEMAES(25,16,7,1,0);
        ev_mmox  := gintout[ 1 ] ;
        ev_mmoy  := gintout[ 2 ] ;
        ev_mmobutton := gintout[ 3 ] ;
        ev_mmokstate := gintout[4];
        ev_mkreturn := gintout[5];
        ev_mbreturn := gintout[6];
END ;

(*----------------------------------------------------------------------*)

FUNCTION evnt_dclick(ev_dnew, ev_dgtest : INTEGER) : INTEGER;
BEGIN
        gintin[0] := ev_dnew;
        gintin[1] := ev_dgtest;
        evnt_dclick := GEMAES(26,2,1,0,0);
END;

(************************************************************************)

                (** MENU LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION   menu_bar( me_btree : ADDRESS ;
me_bshow : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := me_btree;
        gintin[ 0 ] := me_bshow;
        menu_bar := GEMAES(30,1,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION menu_icheck( me_ctree : ADDRESS ;
                        me_citem, me_ccheck : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := me_ctree;
        gintin[ 0 ] := me_citem;
        gintin[ 1 ] := me_ccheck;
        menu_icheck := GEMAES(31,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION   menu_ienable( me_etree : ADDRESS ;
                         me_eitem, me_eenable : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := me_etree;
        gintin[ 0 ] := me_eitem;
        gintin[ 1 ] := me_eenable;
         menu_ienable := GEMAES(32,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION menu_tnormal( me_ntree : ADDRESS ;
                                me_ntitle, me_nnormal : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := me_ntree;
        gintin[ 0 ] := me_ntitle;
        gintin[ 1 ] := me_nnormal;
        menu_tnormal := GEMAES(33,2,1,1,0);
END ;


(*---------------------------------------------------------------------*)

FUNCTION menu_text( me_ttree : ADDRESS ;
me_titem : INTEGER ;
                me_ttext : ADDRESS ) : INTEGER;
BEGIN
        addr_in[ 0 ] := me_ttree;
        gintin[ 0 ] := me_titem;
        addr_in[ 1 ] := me_ttext;
        menu_text := GEMAES(34,1,1,2,0);
END ;

(*----------------------------------------------------------------------*)

FUNCTION menu_register( me_raccapid : INTEGER;
                                me_rpstring : ADDRESS) : INTEGER;
BEGIN
        gintin[0] := me_raccapid;
        addr_in[0] := me_rpstring;
        menu_register := GEMAES(35,1,1,1,0);
END;

(************************************************************************)

                (** OBJECT LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION   objc_add( ob_atree : ADDRESS ;
                        ob_aparent, ob_achild : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_atree;
        gintin[ 0 ] := ob_aparent;
        gintin[ 1 ] := ob_achild;
        objc_add := GEMAES(40,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_delete( ob_dltree : ADDRESS ;
ob_dlobject : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_dltree;
        gintin[ 0 ] := ob_dlobject;
        objc_delete := GEMAES(41,1,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_draw( ob_dtree : ADDRESS ;
                        ob_drstartob, ob_drdepth, ob_drxclip, 
                ob_dryclip, ob_drwclip, ob_drhclip : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_dtree;
        gintin[ 0 ] := ob_drstartob;
        gintin[ 1 ] := ob_drdepth;
        gintin[ 2 ] := ob_drxclip;
        gintin[ 3 ] := ob_dryclip;
        gintin[ 4 ] := ob_drwclip;
        gintin[ 5 ] := ob_drhclip;
        objc_draw := GEMAES(42,6,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_find( ob_ftree : ADDRESS ;
                ob_fstartob, ob_fdepth, ob_fmx, ob_fmy : INTEGER) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_ftree;
        gintin[ 0 ] := ob_fstartob;
        gintin[ 1 ] := ob_fdepth;
        gintin[ 2 ] := ob_fmx;
        gintin[ 3 ] := ob_fmy;
        objc_find := GEMAES(43,4,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_offset( ob_oftree : ADDRESS ;
                        ob_ofobject  : INTEGER  ;

                        VAR ob_ofxoff, ob_ofyoff : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_oftree;
        gintin[ 0 ] := ob_ofobject;
        objc_offset := GEMAES(44,1,3,1,0);
        ob_ofxoff := gintout[ 1 ] ;
        ob_ofyoff := gintout[ 2 ] ;

END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_order( ob_ortree : ADDRESS ;
                     ob_orobject, ob_ornewpos : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_ortree;
        gintin[ 0 ] := ob_orobject;
        gintin[ 1 ] := ob_ornewpos;
        objc_order := GEMAES(45,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_edit( ob_edtree : ADDRESS ;
                        ob_edobject : INTEGER;
                        ob_edchar : char;
                        ob_edidx, ob_edkind : INTEGER;

                  VAR ob_ednewidx : INTEGER) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_edtree;
        gintin[ 0 ] := ob_edobject;
        gintin[ 1 ] := ORD(ob_edchar);
        gintin[ 2 ] := ob_edidx;
        gintin[ 3 ] := ob_edkind;
        objc_edit := GEMAES(46,4,2,1,0);
        ob_ednewidx := gintout[1];
END ;

(*---------------------------------------------------------------------*)

FUNCTION objc_change(ob_ctree : ADDRESS;
                ob_cobject, ob_cresvd,
                ob_cxclip, ob_cyclip, ob_cwclip, ob_chclip,
                ob_cnewstate, ob_credraw : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := ob_ctree;
        gintin[ 0 ] := ob_cobject;
        gintin[ 1 ] := ob_cresvd;
        gintin[ 2 ] := ob_cxclip;
        gintin[ 3 ] := ob_cyclip;
        gintin[ 4 ] := ob_cwclip;
        gintin[ 5 ] := ob_chclip;
        gintin[ 6 ] := ob_cnewstate;
        gintin[ 7 ] := ob_credraw;
        objc_change := GEMAES(47,8,1,1,0);
END ;

(**********************************************************************)

                      (** FORM LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION   form_do( fo_dotree: ADDRESS ;
             fo_dostartob : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := fo_dostartob;
        addr_in[ 0 ] := fo_dotree;
        form_do := GEMAES(50,1,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION  form_dial(fo_diflag, fo_dilx, fo_dily, fo_dilw, 
                        fo_dilh, fo_dibigx, fo_dibigy, 
                        fo_dibigw, fo_dibigh : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := fo_diflag;
        gintin[ 1 ] := fo_dilx ;
        gintin[ 2 ] := fo_dily ;
        gintin[ 3 ] := fo_dilw ;
        gintin[ 4 ] := fo_dilh ;
        gintin[ 5 ] := fo_dibigx ;
        gintin[ 6 ] := fo_dibigy ;
        gintin[ 7 ] := fo_dibigw ;
        gintin[ 8 ] := fo_dibigh ;
        form_dial := GEMAES(51,9,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION form_alert(fo_adefbttn : INTEGER;
                    fo_aastring : ADDRESS ) : INTEGER ;
BEGIN
        addr_in[ 0 ] := fo_aastring ;
        gintin[ 0 ] := fo_adefbttn ;
        form_alert := GEMAES(52,1,1,1,0);
END ;

(*-------------------------------------------------------------------*)

FUNCTION form_error (fo_enum : INTEGER) : INTEGER;
BEGIN
        gintin[0] := fo_enum;
        form_error := GEMAES(53,1,1,0,0);
END;

(*---------------------------------------------------------------------*)

FUNCTION form_center (fo_ctree : ADDRESS;
                  VAR fo_cx, fo_cy, fo_cw, fo_ch : INTEGER) : INTEGER;
BEGIN
        addr_in[0] := fo_ctree;
        form_center := GEMAES(54,0,5,1,0);
        fo_cx := gintout[1];
        fo_cy := gintout[2];
        fo_cw := gintout[3];
        fo_ch := gintout[4];
END;

(**********************************************************************)

                    (** GRAPHICS LIBRARY **)

(*--------------------------------------------------------------------*)

FUNCTION graf_rubbox ( gr_rx, gr_ry, gr_rminwidth, gr_rminheight : INTEGER;
                VAR gr_rlastwidth, gr_rlastheight : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_rx;
        gintin[1] := gr_ry;
        gintin[2] := gr_rminwidth;
        gintin[3] := gr_rminheight;
        graf_rubbox := GEMAES(70,4,3,0,0);
        gr_rlastwidth := gintout[1];
        gr_rlastheight := gintout[2];
END;

(*-------------------------------------------------------------------*)

FUNCTION graf_dragbox (gr_dwidth, gr_dheight, gr_dstx, gr_dsty, 
                 gr_dbndx, gr_dbndy, gr_dbndw, gr_dbndh : INTEGER;

                        VAR gr_dfinx, gr_dfiny : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_dwidth;
        gintin[1] := gr_dheight;
        gintin[2] := gr_dstx;
        gintin[3] := gr_dsty;
        gintin[4] := gr_dbndx;
        gintin[5] := gr_dbndy;
        gintin[6] := gr_dbndw;
        gintin[7] := gr_dbndh;
        graf_dragbox := GEMAES(71,8,3,0,0);
        gr_dfinx := gintout[1];
        gr_dfiny := gintout[2];
END;

(*--------------------------------------------------------------------*)

FUNCTION graf_movebox (gr_mwidth, gr_mheight, gr_msrcex, gr_msrcey,
                       gr_mdestx, gr_mdesty : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_mwidth;
        gintin[1] := gr_mheight;
        gintin[2] := gr_msrcex;
        gintin[3] := gr_msrcey;
        gintin[4] := gr_mdestx;
        gintin[5] := gr_mdesty;
        graf_movebox := GEMAES(72,6,1,0,0);
END;

(*-------------------------------------------------------------------*)

FUNCTION graf_growbox (gr_gstx, gr_gsty, gr_gstwidth, gr_gstheight, 
          gr_gfinx, gr_gfiny, gr_gfinwidth, gr_gfinheight : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_gstx;
        gintin[1] := gr_gsty;
        gintin[2] := gr_gstwidth;
        gintin[3] := gr_gstheight;
        gintin[4] := gr_gfinx;
        gintin[5] := gr_gfiny;
        gintin[6] := gr_gfinwidth;
        gintin[7] := gr_gfinheight;
        graf_growbox := GEMAES(73,8,1,0,0);
END;

(*---------------------------------------------------------------------*)

FUNCTION graf_shrinkbox(gr_sstx, gr_ssty, gr_sstwidth, gr_sstheight, 
        gr_sfinx, gr_sfiny, gr_sfinwidth, gr_sfinheight : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_sstx;
        gintin[1] := gr_ssty;
        gintin[2] := gr_sstwidth;
        gintin[3] := gr_sstheight;
        gintin[4] := gr_sfinx;
        gintin[5] := gr_sfiny;
        gintin[6] := gr_sfinwidth;
        gintin[7] := gr_sfinheight;
        graf_shrinkbox := GEMAES(74,8,1,0,0);
END;

(*--------------------------------------------------------------------*)

FUNCTION graf_watchbox (gr_wptree : ADDRESS;
                gr_wobject, gr_winstate, gr_woutstate : INTEGER) : INTEGER;
BEGIN
        gintin[1] := gr_wobject;
        gintin[2] := gr_winstate;
        gintin[3] := gr_woutstate;
        addr_in[0] := gr_wptree;
        graf_watchbox := GEMAES(75,4,1,1,0);
END;

(*-------------------------------------------------------------------*)

FUNCTION graf_slidebox(gr_slptree : ADDRESS;
                gr_slparent, gr_slobject, gr_slvh : INTEGER) : INTEGER;
BEGIN
        gintin[0] := gr_slparent;
        gintin[1] := gr_slobject;
        gintin[2] := gr_slvh;
        graf_slidebox := GEMAES(76,3,1,1,0);
END;

(*-------------------------------------------------------------------*)

FUNCTION graf_handle (VAR gr_hwchar, gr_hhchar, gr_hwbox,
                      gr_hhbox : INTEGER) : INTEGER;
BEGIN
        graf_handle := GEMAES(77,0,5,0,0);
        gr_hwchar := gintout[1];
        gr_hhchar := gintout[2];
        gr_hwbox := gintout[3];
        gr_hhbox := gintout[4];
END;

(*------------------------------------------------------------------*)

FUNCTION graf_mouse(gr_monumber : INTEGER;
gr_mofaddr : ADDRESS) : INTEGER;
BEGIN
        gintin[0] := gr_monumber;
        addr_in[0] := gr_mofaddr;
        graf_mouse := GEMAES(78,1,1,1,0);
END;

(*------------------------------------------------------------------*)

FUNCTION graf_mkstate (VAR gr_mkmx, gr_mkmy,
                        gr_mkmstate, gr_mkkstate : INTEGER) : INTEGER;
BEGIN
        graf_mkstate := GEMAES(79,0,5,0,0);
        gr_mkmx := gintout[1];
        gr_mkmy := gintout[2];
        gr_mkmstate := gintout[3];
        gr_mkkstate := gintout[4];
END;

(*********************************************************************)

                (** SCRAP LIBRARY **)


(*---------------------------------------------------------------------*)

FUNCTION   scrp_info( sc_idtype : INTEGER ;
                      VAR sc_ioutdtype, sc_iavail,
                      sc_iused : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := sc_idtype;
        scrp_info := GEMAES(0,1,4,0,0);
        sc_ioutdtype := gintout[ 1 ] ;
        sc_iavail := gintout[ 2 ] ;
        sc_iused := gintout[ 3 ] ;
END ;

(*---------------------------------------------------------------------*)

FUNCTION scrp_read( sc_rdtype, sc_rsize : INTEGER ;
                    sc_rpbuff : ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := sc_rdtype;
        gintin[ 1 ] := sc_rsize;
        addr_in[ 0 ] := sc_rpbuff;
        scrp_read := GEMAES(81,2,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION scrp_write( sc_wdtype, sc_wsize : INTEGER ;
                        sc_wpbuff : ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := sc_wdtype;
        gintin[ 1 ] := sc_wsize;
        addr_in[ 0 ] := sc_wpbuff;
        scrp_write := GEMAES(82,2,1,1,0);
END ;

(**********************************************************************)
                 (** FILE SELECTOR LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION fsel_input( fs_iinpath, fs_iinsel : ADDRESS ;
                     VAR fs_iexbutton : INTEGER ) : INTEGER;
BEGIN
        addr_in[ 0 ] := fs_iinpath;
        addr_in[ 1 ] := fs_iinsel;
        fsel_input := GEMAES(90,0,2,2,0);
        fs_iexbutton  := gintout[ 1 ] ;
END ;

(************************************************************************)

                (** WINDOW LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION wind_create( wi_crkind, wi_crwx, wi_crwy,
                wi_crww, wi_crwh : INTEGER ) : INTEGER ;
BEGIN
        gintin[ 0 ] := wi_crkind;
        gintin[ 1 ] := wi_crwx;
        gintin[ 2 ] := wi_crwy;
        gintin[ 3 ] := wi_crww;
        gintin[ 4 ] := wi_crwh;
        wind_create := GEMAES(100,5,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_open( wi_ohandle, wi_owx, wi_owy, 
                    wi_oww, wi_owh : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_ohandle;
        gintin[ 1 ] := wi_owx;
        gintin[ 2 ] := wi_owy;
        gintin[ 3 ] := wi_oww;
        gintin[ 4 ] := wi_owh;
        wind_open := GEMAES(101,5,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_close( wi_clhandle : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_clhandle;
        wind_close := GEMAES(102,1,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_delete( wi_dhandle : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_dhandle;
        wind_delete := GEMAES(103,1,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_get( wi_ghandle, wi_gfield : INTEGER ;
                   VAR wi_gw1, wi_gw2, wi_gw3, wi_gw4 : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_ghandle;
        gintin[ 1 ] := wi_gfield;
        wind_get := GEMAES(104,2,5,0,0);
        wi_gw1 := gintout[ 1 ];
        wi_gw2 := gintout[ 2 ];
        wi_gw3 := gintout[ 3 ];
        wi_gw4 := gintout[ 4 ];
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_set( wi_shandle, wi_sfield, 
                wi_sw1, wi_sw2, wi_sw3, wi_sw4 : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_shandle;
        gintin[ 1 ] := wi_sfield;
        gintin[ 2 ] := wi_sw1;
        gintin[ 3 ] := wi_sw2;
        gintin[ 4 ] := wi_sw3;
        gintin[ 5 ] := wi_sw4;
        wind_set := GEMAES(105,6,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_find( wi_fmx, wi_fmy : INTEGER ) : INTEGER ;
BEGIN
        gintin[ 0 ] := wi_fmx;
        gintin[ 1 ] := wi_fmy;
        wind_find := GEMAES(106,2,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION wind_update( wi_ubegend : INTEGER ) : INTEGER;
BEGIN
        gintin[ 0 ] := wi_ubegend;
        wind_update := GEMAES(107,1,1,0,0);
END ;


(*---------------------------------------------------------------------*)

FUNCTION wind_calc( wi_ctype, wi_ckind, 
            wi_cx, wi_cy, wi_cinwidth, wi_cinheight : INTEGER;
            VAR wi_coutx, wi_couty, wi_coutwidth, wi_coutheight : INTEGER ) :
                                                                  INTEGER;
BEGIN
        gintin[ 0 ] := wi_ctype ;
        gintin[ 1 ] := wi_ckind ;
        gintin[ 2 ] := wi_cx ;
        gintin[ 3 ] := wi_cy ;
        gintin[ 4 ] := wi_cinwidth ;
        gintin[ 5 ] := wi_cinheight ;
        wind_calc := GEMAES(108,6,5,0,0);
        wi_coutx := gintout[ 1 ] ;
        wi_couty := gintout[ 2 ] ;
        wi_coutwidth  := gintout[ 3 ] ;
        wi_coutheight := gintout[ 4 ] ;
END ;

(************************************************************************)
                (** RESOURCE LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION rsrc_load( re_lpfname : ADDRESS ) : INTEGER;
BEGIN
        addr_in[ 0 ] := re_lpfname ;
        rsrc_load := GEMAES(110,0,1,1,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION rsrc_free : INTEGER;
BEGIN
        rsrc_free := GEMAES(111,0,1,0,0);
END ;

(*---------------------------------------------------------------------*)

FUNCTION rsrc_gaddr( re_gttype, re_gtindex : INTEGER ;
                     VAR re_gtaddr : ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := re_gttype ;
        gintin[ 1 ] := re_gtindex ;
        rsrc_gaddr := GEMAES(112,2,1,0,1);
        re_gtaddr := addr_out[ 0 ] ;
END ;

(*---------------------------------------------------------------------*)

FUNCTION rsrc_saddr( re_sttype, re_stindex : INTEGER ;
                        re_staddr : ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := re_sttype ;
        gintin[ 1 ] := re_stindex ;
        addr_in[ 0 ] := re_staddr ;
        rsrc_saddr := GEMAES(113,2,1,1,0);
END ;

(*------------------------------------------------------------------------*)

FUNCTION rsrc_obfix (re_oobject : INTEGER;
                     re_otree : ADDRESS) : INTEGER;
BEGIN
        gintin[0] := re_oobject;
        addr_in[0] := re_otree;
        rsrc_obfix := GEMAES(114,1,1,1,0);
END;

(***********************************************************************)
                        (** SHELL LIBRARY **)

(*---------------------------------------------------------------------*)

FUNCTION shel_read( sh_rpcmd, sh_rptail : ADDRESS ) : INTEGER;
BEGIN
        addr_in[ 0 ] := sh_rpcmd;
        addr_in[ 1 ] := sh_rptail;
        shel_read := GEMAES(120,0,1,2,0);
END ;


(*---------------------------------------------------------------------*)

FUNCTION shel_write( sh_wdoex, sh_wisgr, sh_wiscr : INTEGER ;
                     sh_wpcmd, sh_wptail : ADDRESS ) : INTEGER;
BEGIN
        gintin[ 0 ] := sh_wdoex;
        gintin[ 1 ] := sh_wisgr;
        gintin[ 2 ] := sh_wiscr;
        addr_in[ 0 ] := sh_wpcmd;
        addr_in[ 1 ] := sh_wptail;
        shel_write := GEMAES(121,3,1,2,0);
END ;
