
(*****************************************************************************)
(*                                                                           *)
(*      CString.Pas                                                          *)
(*                                                                           *)
(*      Converts Pascal style strings to/from C style strings.               *)
(*                                                                           *)
(*      Last modified: 11 February 1986                                      *)
(*                                                                           *)
(*****************************************************************************)
{$R+}   (* Turn on range checking *)


(*****************************************************************************)

PROCEDURE MakeCString(pString : CharString; VAR cString : CharString);

(* make a Pascal style string into a C style string *)

VAR
        index : INTEGER;

BEGIN (* MakeCString *)

        FOR index := 1 TO StrLen(pString) DO

                cString[index - 1] := pString[index];

        cString[StrLen(pString)] := CHR(0);

END (* MakeCString *);

(*****************************************************************************)

PROCEDURE MakePString(cString : CharString; VAR pString : CharString);

(* make a C style string into a Pascal style string *)

VAR
        index : INTEGER;

BEGIN (* MakePString *)

        index := 0;
        WHILE cString[index] <> CHR(0) DO BEGIN

                pString[index + 1] := cString[index];
                index := index + 1;

        END (* WHILE *);

        pString[0] := CHR(index);

END (* MakePString *);


