;/*     MLONGASM.ASM     2/3/84 - 10/09/84       Lee Jay Lorenzen	*/
;/*     modified for MASM           01/31/85    Tom Rolander            */
;/*     for Lattice C ==>  AX=HI, BX=LO
;
;       modified for Large model  9/12/85       C. Shaw                 */
;/*     renamed LLONGASM.ASM     09/27/85                               */
;
;/*	modified for MS-C v3.0	    11/21/85	Lenox Brassell		*/
;/*     for Microsoft C ==>  DX=HI, AX=LO

        INCLUDE MSDOS.MAC

RETLONG	MACRO			; converts Lattice long return value [AX:BX]
	mov	dx,ax		; into MS-C long return value        [DX:AX]
	mov	ax,bx
	ret
	ENDM
 
	IF	LPROG
X	EQU	2		; extra offset for caller's segment
	ELSE
X	EQU	0
	ENDIF
 
        PSEG
;               WORD
;       LSTRLEN(long_addr)
;
BEGIN	_LSTRLEN
        push    bp
        mov     bp,sp
        push    ds
        mov     bx,4+X[bp]
        mov     ax,6+X[bp]
        mov     ds,ax
        sub     cx,cx
slagain:
        cmp     byte ptr [bx],0
        jz      sldone
        inc     bx
        jmp     slagain
sldone:
        mov     ax,bx
        mov     bx,4+X[bp]
        sub     ax,bx
        pop     ds
        pop     bp
        ret
_LSTRLEN	ENDP


;               LONG
;       ADDR(shrt_addr)
;
	IF (LDATA EQ 0)
	BEGIN	_ADDR
		push	bp
		mov	bp,sp
		mov	bx,4+X[bp]
		mov	ax,ds
		pop	bp
		RETLONG
		_ADDR	ENDP
	ENDIF
;

;
;               LONG
;       LLDS()
;
;
BEGIN	_LLDS
        push bp
        mov bp,sp
        sub bx,bx
        mov ax,ds
        pop bp
        RETLONG
_LLDS	ENDP

;
;               LONG
;       LLCS()
;
BEGIN	_LLCS
        push bp
        mov bp,sp
        sub bx,bx
        mov ax,cs
        pop bp
        RETLONG
_LLCS	ENDP
;
;               LONG
;       LLSS()
;
;
BEGIN	_LLSS
        push bp
        mov bp,sp
        sub bx,bx
        mov ax,ss
        pop bp
        RETLONG
_LLSS	ENDP


;
;       LWCOPY(pdstoff, pdstseg, psrcoff, psrcseg, numwds)
;
;
BEGIN	_LWCOPY
        push bp
        mov bp,sp
        push di
        push si
        mov di,4+X[bp]            ; dest off
        mov bx,6+X[bp]            ; dest seg
        mov si,8+X[bp]            ; src off
        mov dx,10+X[bp]           ; src seg
        mov cx,12+X[bp]           ; count
        cld                     ; assume forward
        cmp bx,dx               ; if !same seg
        jne lwcopy_mov          ;     then dont worry about overlap
        cmp si,di               ; if src offs < dest offs
                                ;     then start from end and go back
                                ; else normal
        ja lwcopy_mov           ;  jg changed to ja  (JJN)
          mov ax,cx
          shl ax,1
          add si,ax
          sub si,2
          add di,ax
          sub di,2
          std                   ;  go backwards
lwcopy_mov:
        push ds
        push es
        mov ds,dx               ; src
        mov es,bx               ; dest
        rep movsw
        pop es
        pop ds
 
 
        lea sp,-4[bp]           ; this seems like a no-op since the sp
                                ; is two pushes (si and di) away from bp
        pop si
        pop di
        pop bp
        cld
        ret
_LWCOPY	ENDP

;
;       LBCOPY(pdstoff, pdstseg, psrcoff, psrcseg, numbytes)
;
;
BEGIN	_LBCOPY
        push bp
        mov bp,sp
        push di
        push si
        mov di,4+X[bp]            ; dest off
        mov bx,6+X[bp]            ; dest seg
        mov si,8+X[bp]            ; src off
        mov dx,10+X[bp]           ; src seg
        mov cx,12+X[bp]           ; count
        cld                     ; assume forward
        cmp bx,dx               ; if !same seg
        jne lbcopy_mov          ;     then dont worry about overlap
        cmp si,di               ; if src offs < dest offs
                                ;     then start from end and go back
                                ; else normal
        ja lbcopy_mov           ;   jg changed to ja  (JJN)
          add si,cx
          dec si
          add di,cx
          dec di
          std                   ;  go backwards
lbcopy_mov:
        push ds
        push es
        mov ds,dx               ; src
        mov es,bx               ; dest
        rep movsb
        pop es
        pop ds
 
 
        lea sp,-4[bp]         ; see comment in lwcopy
        pop si
        pop di
        pop bp
        cld
        ret
_LBCOPY	ENDP

;
;       expand from bytes to words until you hit a null also return
;       the number of characters moved
;
;       LBWMOV(pdstoff, pdstseg, psrcoff, psrcseg)
;
;
BEGIN	_LBWMOV
        push bp
        mov bp,sp
        push di
        push si
        mov di,4+X[bp]            ; dest off
        mov bx,6+X[bp]            ; dest seg
        mov si,8+X[bp]            ; src off
        mov dx,10+X[bp]           ; src seg
        mov cx,0                ; count
        cld                     ; assume forward
lbw_mov:
        push ds
        push es
        mov ds,dx               ; src
        mov es,bx               ; dest
        mov ah,0
lbw_loop:
        lodsb
        cmp al,0
        je lbw_done
        inc cx
        stosw
        jmp lbw_loop
lbw_done:
        pop es
        pop ds
 
 
        lea sp,-4[bp]
        pop si
        pop di
        pop bp
        cld
        mov     ax,cx
        ret
_LBWMOV	ENDP
;
	IF (LDATA EQ 0)
	;
	;		UBYTE
	;	LBGET(lp)
	;		LONG		p;
	;
	BEGIN	_LBGET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		sub	ax,ax
		mov	al,es:[bx]
		pop	es
		pop	bp
		ret
	_LBGET	ENDP	
	;
	;		UBYTE
	;	LBSET(lp, abyte)
	;		LONG		p;
	;		BYTE		abyte;
	;
	BEGIN	_LBSET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		mov	ax,8+X[bp]
		mov	es:[bx],al
		xor	ah,ah
		pop	es
		pop	bp
		ret
	_LBSET	ENDP
	;
	;		UWORD
	;	LWGET(lp)
	;		LONG		p;
	;
	BEGIN	_LWGET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		mov	ax,es:[bx]
		pop	es
		pop	bp
		ret
	_LWGET	ENDP
	;
	;		UWORD
	;	LWSET(lp, aword)
	;		LONG		p;
	;		WORD		aword;
	;
	BEGIN	_LWSET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		mov	ax,8+X[bp]
		mov	es:[bx],ax
		pop	es
		pop	bp
		ret
	_LWSET	ENDP
	;
	;		ULONG
	;	LLGET(lp)
	;		LONG		p;
	;
	BEGIN	_LLGET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		mov	ax,es:[bx]
		inc	bx
		inc	bx
		mov	bx,es:[bx]
		xchg	ax,bx
		pop	es
		pop	bp
		RETLONG
	_LLGET	ENDP
	;
	;		ULONG
	;	LLSET(lp, along)
	;		LONG		p;
	;		LONG		along;
	;
	BEGIN	_LLSET
		push	bp
		mov	bp,sp
		push	es
		les	bx,DWORD PTR 4+X[bp]
		mov	ax,8+X[bp]
		mov	es:[bx],ax
		inc	bx
		inc	bx
		mov	cx,10+X[bp]
		mov	es:[bx],cx
		xchg	ax,cx
		pop	es
		pop	bp
		RETLONG
	_LLSET	ENDP
	
	ENDIF  ;(LDATA EQ 0)
	
        ENDPS
        END
