/*      MMACHINE.H               09/29/84-02/08/85       Lee Lorenzen    */
/*      modified for large model     C. Shaw    9/17/85                 */
/*      renamed LMACHINE.H          09/27/85                            */
/*	modified for MS-C v3.0	    11/21/85	Lenox Brassell		*/
 
#ifdef M_I86		/* Defined by default for MS-C v3.0, all models */ 

/*  Lattice C v2.15 defines two preprocessor variables, SPTR and LPTR,
 *  which make it possible for source code to "know" at compile-time
 *  whether data pointers are two bytes long or four bytes long.
 *
 *  MS C v3.0 defines one of M_I86SM, M_I86MM,or M_I86LM to indicate
 *  whether the program is being compiled under the Small, Medium, or
 *  Large memory models, respectively.  
 *
 *  We will accept Lattice's style as our "standard convention", and
 *  emulate its memory-dependent preprocessor variables based on our
 *  compile-time knowlege of our memory model.
 */

#ifdef M_I86SM		/* Defined by default for MS-C v3.0 Small Model */ 
#define SPTR	1
#define LPTR	0
#endif

#ifdef M_I86MM		/* Defined by default for MS-C v3.0 Medium Model */ 
#define SPTR	1
#define LPTR	0
#endif

#ifdef M_I86LM		/* Defined by default for MS-C v3.0 Large Model */ 
#define SPTR	0
#define LPTR	1
#endif

#endif /* M_I86 */



#define PCDOS   1       /* IBM PC DOS */
#define CPM     0       /* CP/M version 2.2 */
 
#define HILO 0          /* how bytes are stored */
 
#define I8086   1       /* Intel 8086/8088 */
 
#define MC68K   0       /* Motorola 68000 */
 
#define ALCYON  0       /* Alcyon C Compiler */
 
#define ALPHA   1       /* if character screen  */
 
#define LINKED  0       /* if desktop linked with GEM   */
#define UNLINKED 1
 
 
EXTERN BYTE     *strcpy();
EXTERN BYTE     *strcat();
EXTERN BYTE     *strscn();


/* return length of string pointed at by long pointer  */
EXTERN WORD     LSTRLEN();

/* copy n words from src long ptr to dst long ptr i.e., LWCOPY(dlp, slp, n) */
EXTERN WORD     LWCOPY();

/* copy n words from src long ptr to dst long ptr i.e., LBCOPY(dlp, slp, n)*/
EXTERN BYTE     LBCOPY();

/* move bytes into wds from src long ptr to dst long ptr 
 * i.e., until a null is encountered, then num moved is returned
 * LBWMOV(dwlp, sblp)
 */
EXTERN WORD     LBWMOV();
 
/* coerce short ptr to low word of long */
#define LW(x) ( (LONG)((UWORD)(x)) )

/* coerce short ptr to high word of long */
#define HW(x) ((LONG)((UWORD)(x)) << 16)

/* return low word of a long value */
#define LLOWD(x) ((UWORD)(x))

/* return high word of a long value */
#define LHIWD(x) ((UWORD)(((LONG) x) >> 16))

/* return low byte of a word value */
#define LLOBT(x) ((BYTE)(x & 0x00ff))

/* return high byte of a word value */
#define LHIBT(x) ((BYTE)( (x >> 8) & 0x00ff))
 
/* return long address of the data seg    */
EXTERN LONG     LLDS();
 
/* return long address of the code seg    */
EXTERN LONG     LLCS();
 
 
/************************************************************************/
/*  model-dependent support for long pointers				*/
/************************************************************************/ 

/***** Return a long address of a short pointer *****/
#if LPTR
#define ADDR(lp)	((LONG) ((BYTE *) (lp)))
#else
EXTERN LONG	ADDR();
#endif 
 
/***** Return a single byte pointed at by long ptr. *****/
#if LPTR
#define LBGET(x)	( (UBYTE) *((BYTE * )(x)) )
#else
EXTERN BYTE LBGET();
#endif

/***** Set a single byte pointed at by long ptr, LBSET(lp, bt) *****/
#if LPTR
#define LBSET(x, y)	( *((BYTE *)(x)) = y)
#else
EXTERN BYTE LBSET();
#endif

/***** Return a single word pointed at by long ptr *****/
#if LPTR
#define LWGET(x)	( (WORD) *((WORD *)(x)) )
#else
EXTERN WORD LWGET();
#endif


/***** Set a single word pointed at by long ptr, LWSET(lp, bt) *****/
#if LPTR
#define LWSET(x, y)	( *((WORD *)(x)) = y)
#else
EXTERN WORD LWSET();
#endif
 
/***** return a single long pointed at by long ptr *****/
#if LPTR
#define LLGET(x)	( *((LONG *)(x)))
#else
EXTERN LONG LLGET();
#endif


/***** set a single long pointed at by long ptr, LLSET(lp, bt) *****/
#if LPTR
#define LLSET(x, y)	( *((LONG *)(x)) = y)
#else
EXTERN LONG LLSET();
#endif
 

/************************************************************************/
/*  machine-dependent support for byte-ordering of long values		*/
/*  These macros are for the Intel 8086.				*/
/************************************************************************/ 

/* Return 0th byte of a long value, given a pointer to the long value */
#define LBYTE0(x) ( *(((BYTE *)(x))+3) )

/* Return 1st byte of a long value, given a pointer to the long value */
#define LBYTE1(x) ( *(((BYTE *)(x))+2) )

/* Return 2nd byte of a long value, given a pointer to the long value */
#define LBYTE2(x) ( *(((BYTE *)(x))+1) )

/* Return 3rd byte of a long value, given a pointer to the long value */
#define LBYTE3(x) (*(x))
