;/*     MTCRTLAS.ASM    4/18/84 - 10/24/84      Lee Jay Lorenzen        */
;/*     modified for MASM           01/31/85    Tom Rolander            */
;
;
;/*     modified for Large model    09/12/85    C. Shaw                 */
;/*     no need to run lattice C runtime library                        */
;/*     renamed LTCRTLAS.ASM                                            */
;/*	modified for MS-C v3.0	    11/21/85	Lenox Brassell		*/
 
        INCLUDE MSDOS.MAC
 
	IF	LPROG
X	EQU	2		; extra offset for caller's segment
	ELSE
X	EQU	0
	ENDIF

 
        PSEG                                                              
;***************************************************************************
;
; MUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * 2 * m2 ) / d1 ) + 1 ) / 2
;       m1 = signed 16 bit integer
;       m2 = unsigned 15 bit integer
;       d1 = signed 16 bit integer
;
; The point of this routine is to get floating point accuracy without
; going to the expense of floating point (sk)
;***************************************************************************
BEGIN	_MUL_DIV
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06+X[bp]
        shl     ax,1            ; m2 * 2
        mov     bx,04+X[bp]
        imul    bx              ; m2 * 2 * m1
        mov     bx,08+X[bp]
        idiv    bx              ; m2 * 2 * m1 / d1
        and     ax,ax           ; set flags
        js      mul_div_neg
        inc     ax
        shr     ax,1            ; m2 * 2 * m1 / d1 +1 / 2
        pop     bp
        ret
mul_div_neg:
        add     ax,-1
        neg     ax
        shr     ax,1
        neg     ax              ; m2 * 2 * m1 / d1 -1 / 2
        pop     bp
        ret
_MUL_DIV	ENDP
;
;
;***************************************************************************
;
; UMUL_DIV (m1,m2,d1)
;
;        ( ( ( m1 * 2 * m2 ) / d1 ) + 1 ) / 2
;       m1 = usigned 16 bit integer
;       m2 = unsigned 15 bit integer
;       d1 = usigned 16 bit integer
;
; The point of this routine is to get floating point accuracy without
; going to the expense of floating point (sk)
;***************************************************************************
BEGIN	_UMUL_DIV
        push    bp              ;save the callers bp
        mov     bp,sp
        mov     ax,06+X[bp]
        shl     ax,1            ; m2 * 2
        mov     bx,04+X[bp]
        mul     bx              ; m2 * 2 * m1
        mov     bx,08+X[bp]
        div     bx              ; m2 * 2 * m1 / d1
        inc     ax
        shr     ax,1            ; m2 * 2 * m1 / d1 +1 / 2
        pop     bp
        ret
_UMUL_DIV	ENDP 
 
        ENDPS                   ; "th-th-th-that's all folks!"  --Porky Pig
        END
