
(*****************************************************************)
(**    File Name   :  VDIBND.PAS                                **)
(**                                                             **)
(**    Modified for Turbo Pascal                                **)
(**                                                             **)
(**    Comments    :  All these language bindings               **)
(**                   use array's relative to 0.                **)
(**                                                             **)
(**     Author         : Athol M Foden                          **)
(**     History        : Feb 1985                               **)
(**     Last Modified  : 12 February 1986                       **)
(**     Digital Research Inc.                                   **)
(**                                                             **)
(*****************************************************************)

(* reuires gempcon.i, gemptype.i, gempvar.i *)

(*****************************************************************)

PROCEDURE GVDI (VAR gptsout : ptsout_ARRAY;
                VAR gintout : intout_ARRAY;
                VAR gptsin : ptsin_ARRAY;
                VAR gintin : intin_ARRAY;
                VAR gcontrl : contrl_ARRAY);

CONST
        VDIinterruptVector = $EF;
        VDImagicConstant = $0473;

TYPE
        ADDRESS = ^BYTE;

VAR
        parameterBlock : RECORD
                controlArray : ADDRESS;
                inputParameterArray : ADDRESS;
                inputPointCoordinateArray : ADDRESS;
                outputParameterArray : ADDRESS;
                outputPointCoordinateArray : ADDRESS;
        END (* RECORD *);

        registers : RECORD
                ax, bx, cx, dx, bp, si, di, ds, es, flags : INTEGER;
        END (* RECORD *);

BEGIN (* GVDI *)

        parameterBlock.controlArray := ADDR(gcontrl);
        parameterBlock.inputParameterArray := ADDR(gintin);
        parameterBlock.inputPointCoordinateArray := ADDR(gptsin);
        parameterBlock.outputParameterArray := ADDR(gintout);
        parameterBlock.outputPointCoordinateArray := ADDR(gptsout);

        registers.cx := VDImagicConstant;
        registers.ds := SEG(parameterBlock);
        registers.dx := OFS(parameterBlock);

        INTR(VDIinterruptvector, registers);

END (* GVDI *);

(**************************************************************)
(* general (and only) call to GEM VDI *)

FUNCTION gemvdif(opcode, handle : INTEGER) : INTEGER;
BEGIN
        contrl[0] := opcode;
        contrl[6] := handle;
        (* in gempcall - gdos interrupt*)
        GVDI(ptsout, intout, ptsin, intin, contrl);
        gemvdif := intout[0];
END;

(********************************************************************)
        (*** CONTROL FUNCTIONS ***)
(*****************************************************************)
(** open workstation **)

FUNCTION v_opnwk (workin : intin_ARRAY;
                  VAR  handle : INTEGER;
                  VAR workout : ARRAY_57) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        FOR i:=0 TO intin_max DO
                intin[i] := workin[i];
        contrl[1] := 0;
        contrl[3] := 11;
        v_opnwk := gemvdif(1,handle);             (* opcode = 1 *)
        handle := contrl[6];
        FOR i:=0 TO 44 DO
                workout[i] := intout[i];
        FOR i:=0 TO 11 DO
                workout[i + 44] := ptsout[i];
END;

(****************************************************************)
(** close workstation **)

FUNCTION v_clswk (handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        v_clswk := gemvdif(2,handle);
END;

(*****************************************************************)
(** open virtual workstation **)

FUNCTION v_opnvwk (workin : intin_ARRAY;
                   VAR handle : INTEGER;
                   VAR workout : ARRAY_57) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;           (* no of input vertices *)
        contrl[3] := 11;          (* length of intin *)
        FOR i:=0 TO intin_max DO
                intin[i] := workin[i];
        v_opnvwk := gemvdif(100,handle);
        (* handle from previously opened screen device *)
        handle := contrl[6];
        FOR i:=0 TO 44 DO
                workout[i] := intout[i];
        FOR i:=0 TO 11 DO
                workout[i + 44] := ptsout[i];
END;

(****************************************************************)
(** close virtual workstation **)

FUNCTION v_clsvwk (handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        v_clsvwk := gemvdif(101,handle);
END;

(*****************************************************************)
(** clear workstation **)

FUNCTION v_clrwk (handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        v_clrwk := gemvdif(3,handle);
END;

(******************************************************************)
(** update workstation **)

FUNCTION v_updwk ( handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        v_updwk := gemvdif(4,handle);
END;

(**************************************************************************)
(** Load extra fonts into memory - caller must free up some memory space **)

FUNCTION vst_load_fonts(handle, select : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := select;
        vst_load_fonts := gemvdif(119,handle);
END;

(********************************************************************)
(** Unload those extra fonts **)

FUNCTION vst_unload_fonts(handle, select : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := select;
        vst_unload_fonts := gemvdif(120,handle);
END;

(**************************************************************************)
(** set clipping rectangle **)

FUNCTION vs_clip (handle : INTEGER;
                  clipflag : INTEGER;
                  pxyarray : ARRAY_4) : INTEGER;

VAR
        i:      INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 1;
        intin[0] := clipflag;
        FOR i:=0 TO 3 DO
                ptsin[i] := pxyarray[i];
        vs_clip := gemvdif(129,handle);
END;

        (************************)
        (**  OUTPUT FUNCTIONS  **)
(***************************************************************)
(** polyline **)

FUNCTION v_pline (handle, count : INTEGER;
                  pxyarray : ptsin_ARRAY) : INTEGER;

VAR
        i, n :  INTEGER;
BEGIN
        contrl[1] := count;       (* number of vertices to follow *)
        contrl[3] := 0;
        n := count * 2 - 1;               (* twice as many numbers as there are coords *)
        FOR i:=0 TO n DO
                ptsin[i] := pxyarray[i];
        v_pline := gemvdif(6,handle);
END;

(****************************************************************)
(** polymarker **)

FUNCTION v_pmarker (handle, count : INTEGER;
                        pxyarray : ptsin_ARRAY) : INTEGER;

VAR
        i, n :  INTEGER;
BEGIN
        contrl[1] := count;       (* number of markers *)
        contrl[3] := 0;
        n := count * 2 - 1;
        FOR i:=0 TO n DO
                ptsin[i] := pxyarray[i];
        v_pmarker := gemvdif(7,handle);
END;

(**************************************************************)
(** text **)

FUNCTION v_gtext (handle, x, y : INTEGER;
                  chstring : CharString) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := LENGTH(chstring);
        ptsin[0] := x;
        ptsin[1] := y;
        FOR i:=1 TO LENGTH(chstring) DO
                intin[i- 1] := ORD(chstring[i]);
        intin[LENGTH(chstring)] := 0;
        v_gtext := gemvdif(8,handle);
END;

(***************************************************************)
(** filled area **)

FUNCTION  v_fillarea(handle, count : INTEGER;
                        pxyarray : ptsin_ARRAY) : INTEGER;

VAR
        i, n  : INTEGER;
BEGIN
        contrl[1] := count;
        contrl[3] := 0;
        n := count * 2 - 1;
        FOR i:=0 TO n DO
                ptsin[i] := pxyarray[i];
        v_fillarea := gemvdif(9,handle);
END;

(**************************************************************)
(** cell array **)

FUNCTION v_cellarray (handle : INTEGER;
pxyarray : ARRAY_4;
                rowlength, elused, numrows, wrtmode : INTEGER;
                        colorlen : INTEGER;
colarray : intin_ARRAY) : INTEGER;

VAR 
        i, j :  INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := colorlen;
        contrl[7] := rowlength;
        contrl[8] := elused;
        contrl[9] := numrows;
        contrl[10] := wrtmode;
        FOR i:=0 TO 3 DO
                ptsin[i] := pxyarray[i];
        j := colorlen - 1 ;
        FOR i:=0 TO j DO
                intin[i] := colarray[i];
        v_cellarray := gemvdif(10,handle);
END;

(***************************************************************)
(** contour fill **)

FUNCTION v_contour (handle, x, y, index : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 1;
        ptsin[0] := x;
        ptsin[1] := y;
        intin[0] := index;
        v_contour := gemvdif(103,handle);
END;

(***********************************************************)
(** fill rectangle **)

FUNCTION vr_recfl(handle : INTEGER;
                  pxyarray : ARRAY_4) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        FOR i:=0 TO 3 DO
                ptsin[i] := pxyarray[i];
        vr_recfl := gemvdif(114,handle);
END;

                (*****************)
                (**   GDP 's    **)
(****************************************************************)
(** gdp - bar **)

FUNCTION v_bar (handle : INTEGER;
                                pxyarray : ARRAY_4) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        contrl[5] := 1;
        FOR i:=0 TO 3 DO
                ptsin[i] := pxyarray[i];
        v_bar := gemvdif(11,handle);
END;

(****************************************************************)
(** GDP - arc **)

FUNCTION v_arc (handle, x, y, radius, begang, endang : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 4;
        contrl[3] := 2;
        contrl[5] := 3;
        intin[0] := begang;
        intin[1] := endang;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[6] := radius;
        v_arc := gemvdif(11,handle);
END;

(********************************************************************)
(** GDP - pieslice **)

FUNCTION v_pieslice (handle, x, y, radius, begang, endang : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 4;
        contrl[3] := 2;
        contrl[5] := 3;
        intin[0] := begang;
        intin[1] := endang;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[6] := radius;
        v_pieslice := gemvdif(11,handle);
END;

(**********************************************************************)
(** GDP - circle **)

FUNCTION v_circle (handle, x, y, radius : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 3;
        contrl[3] := 0;
        contrl[5] := 4;
        contrl[6] := handle;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[4] := radius;
        v_circle := gemvdif(11,handle);
END;

(********************************************************************)
(** GDP - elliptical arc **)

FUNCTION v_ellarc (handle, x, y, xradius, yradius, 
                   begang, endang : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 2;
        contrl[5] := 6;
        intin[0] := begang;
        intin[1] := endang;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[2] := xradius;
        ptsin[3] := yradius;
        v_ellarc := gemvdif(11,handle);
END;

(*****************************************************************)
(** GDP - elliptical pie **)

FUNCTION v_ellpie (handle, x, y, xradius, yradius, 
                                        begang, endang : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 2;
        contrl[5] := 7;
        intin[0] := begang;
        intin[1] := endang;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[2] := xradius;
        ptsin[3] := yradius;
        v_ellpie := gemvdif(11,handle);
END;

(*****************************************************************)
(** GDP - Ellipse **)

FUNCTION v_ellipse (handle, x, y, xradius, yradius : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        contrl[5] := 5;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[2] := xradius;
        ptsin[3] := yradius;
        v_ellipse := gemvdif(11,handle);
END;

(****************************************************************)
(** GDP rounded rectangle **)

FUNCTION v_rbox (handle : INTEGER;
                 xyarray : ARRAY_4) : INTEGER;

VAR 
        i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        contrl[5] := 8;
        FOR i:=0 TO 3 DO
                ptsin[i] := xyarray[i];
        v_rbox := gemvdif(11,handle);
END;

(****************************************************************)
(** GDP Filled rounded rectangle **)

FUNCTION v_rfbox (handle : INTEGER;
                        xyarray : ARRAY_4) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        contrl[5] := 9;
        FOR i:=0 TO 3 DO
                ptsin[i] := xyarray[i];
        v_rfbox := gemvdif(11,handle);
END;

(**************************************************************)
(**  Justified graphics text **)

FUNCTION v_justified(handle, x, y, jlength : INTEGER;
                     gstring : CharString;
                     wordspace, charspace : INTEGER) : INTEGER;

VAR
        i:      INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := LENGTH(gstring) + 2;
        FOR i:=1 TO LENGTH(gstring) DO
                intin[i+1] := ORD(gstring[i]);
        intin[LENGTH(gstring)] := 0;
        intin[0] := wordspace;
        intin[1] := charspace;
        ptsin[0] := x;
        ptsin[1] := y;
        ptsin[2] := jlength;
        v_justified := gemvdif(10,handle);
END;

                (*******************************)
                (*** SET ATTRIBUTE FUNCTIONS ***)
(**********************************************************)
(** general set routine, called by many procedures below **)

FUNCTION genset(opcode, handle, param : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := param;
        genset := gemvdif(opcode,handle);         (* return value suggested *)
END;

(***************************************************************)
(** set writing mode **)

FUNCTION vswr_mode (handle, mode : INTEGER) : INTEGER;
BEGIN
        vswr_mode := genset(32,handle,mode);
END;

(**************************************************************)
(** set color representation **)

FUNCTION vs_color (handle, index : INTEGER;
                         rgbin : ARRAY_3) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 4;
        intin[0] := index;
        intin[1] := rgbin[0];
        intin[2] := rgbin[1];
        intin[3] := rgbin[2];
        vs_color := gemvdif(14,handle);
END;


(***********************************************************)
(** set polyline line type **)

FUNCTION vsl_type ( handle, style : INTEGER) : INTEGER;
BEGIN
        vsl_type := genset(15,handle,style);
END;

(***********************************************************)
(** set user defined line style pattern **)

FUNCTION vsl_udsty (handle, pattern : INTEGER) : INTEGER;
BEGIN
        vsl_udsty := genset(113,handle,pattern);
END;

(**********************************************************)
(** set polyline linewidth **)

FUNCTION vsl_width (handle, width : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 0;
        ptsin[0] := width;
        ptsin[1] := 0;
        vsl_width := gemvdif(16,handle);
        vsl_width := ptsout[0];
END;

(***********************************************************)
(** set polyline color index **)

FUNCTION vsl_color (handle, colindex : INTEGER) : INTEGER;
BEGIN
        vsl_color := genset(17,handle,colindex);
END;

(*************************************************************)
(** set polyline end style **)

FUNCTION vsl_ends (handle, begstyle, endstyle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 2;
        intin[0] := begstyle;
        intin[1] := endstyle;
        vsl_ends := gemvdif(108,handle);
END;

(**************************************************************)
(** set polymarker type **)

FUNCTION vsm_type (handle, symbol : INTEGER) : INTEGER;
BEGIN
        vsm_type := genset(18,handle,symbol);
END;

(***************************************************************)
(** set polymarker height **)

FUNCTION vsm_height (handle, height : INTEGER) : INTEGER;
BEGIN
        contrl[0] := 19;
        contrl[1] := 1;
        contrl[3] := 0;
        contrl[6] := handle;
        ptsin[0] := 0;
        ptsin[1] := height;
        vsm_height := gemvdif(19,handle);
        vsm_height := ptsout[1];
END;

(*************************************************************)
(** set polymarker color index **)

FUNCTION vsm_color (handle, colindex : INTEGER) : INTEGER;
BEGIN
        vsm_color := genset(20,handle,colindex);
END;

(***************************************************************)
(** set character height, absolute mode **)

FUNCTION vst_height (handle, height : INTEGER;

VAR     charwidth, charheight, 
                        cellwidth, cellheight : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 0;
        ptsin[0] := 0;
        ptsin[1] := height;
        vst_height := gemvdif(12,handle);
        charwidth := ptsout[0];
        charheight := ptsout[1];
        cellwidth := ptsout[2];
        cellheight := ptsout[3];
END;

(**********************************************************************)
(** set character cell height, points mode **)

FUNCTION vst_point (handle, point : INTEGER;

VAR     charwidth, charheight, 
                        cellwidth, cellheight : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := point;
        vst_point := gemvdif(107,handle);
        charwidth := ptsout[0];
        charheight := ptsout[1];
        cellwidth := ptsout[2];
        cellheight := ptsout[3];
END;

(*********************************************************************)
(** set text character baseline vector - rotation **)

FUNCTION vst_rotation (handle, angle : INTEGER) : INTEGER;
BEGIN
        vst_rotation := genset(13,handle,angle);
END;

(******************************************************************)
(** set text font **)

FUNCTION vst_font (handle, font : INTEGER) : INTEGER;
BEGIN
        vst_font := genset(21,handle,font);
END;

(******************************************************************)
(** set text color **)

FUNCTION vst_color (handle, colindex : INTEGER) : INTEGER;
BEGIN
        vst_color := genset(22,handle,colindex);
END;

(*****************************************************************)
(** set text special effects **)

FUNCTION vst_effects (handle, effects : INTEGER) : INTEGER;
BEGIN
        vst_effects := genset(106,handle,effects);
END;

(****************************************************************)
(** set graphics text alignment **)

FUNCTION vst_alignment (handle, horin, vertin : INTEGER;
                        VAR horout, vertout : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 2;
        intin[0] := horin;
        intin[1] := vertin;
        vst_alignment := gemvdif(39,handle);
        horout := intout[0];
        vertout := intout[1];
END;


(*****************************************************************)
(** set fill interior style **)

FUNCTION vsf_interior (handle, style : INTEGER) : INTEGER;
BEGIN
        vsf_interior := genset(23,handle,style);
END;

(****************************************************************)
(** set fill style index **)

FUNCTION vsf_style (handle, styleindex : INTEGER) : INTEGER;
BEGIN
        vsf_style := genset(24,handle,styleindex);
END;

(***************************************************************)
(** set fill color index **)

FUNCTION vsf_color ( handle, colorindex : INTEGER) : INTEGER;
BEGIN
        vsf_color := genset(25,handle,colorindex);
END;

(****************************************************************)
(** set fill perimeter visibility **)

FUNCTION vsf_perimeter (handle, pervis : INTEGER) : INTEGER;
BEGIN
        vsf_perimeter := genset(104,handle,pervis);
END;

(********************************************************************)
(** Exchange fill pattern **)

FUNCTION vsf_udpat (handle : INTEGER;
pfillpat, poldfpat : gempoint) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[7] := pfillpat.hi;
        contrl[8] := pfillpat.lo;
        contrl[9] := poldfpat.hi;
        contrl[10] := poldfpat.lo;
        vsf_udpat := gemvdif(112,handle);
END;


                    (***********************)
                    (***** RASTOR OPS ******)
(****************************************************************)
(** Copy rastor , Opaque **)

FUNCTION vro_cpyfm (handle, wrmode : INTEGER;
                        pxyarray : ARRAY_8;
                        psrcMFDB, pdesMFDB : MFDB) : INTEGER;

VAR
        i :     INTEGER;
        gtemp1, gtemp2 : gempoint;
        sm, dm : MFDB;
BEGIN
        contrl[1] := 4;
        contrl[3] := 1;
        (* ensure MFDB is local to get right segment address *)
        sm := psrcMFDB;   
        gtemp1.gp := ADDR(sm);            (* long address *)
        contrl[7] := gtemp1.hi;           (* offset of MFDB *)
        contrl[8] := gtemp1.lo;           (* segemnt of MFDB *)
        dm := pdesMFDB;
        gtemp2.gp := ADDR(dm);
        contrl[9] := gtemp2.hi;
        contrl[10] := gtemp2.lo;
        intin[0] := wrmode;               (* logic operation write mode *)
        FOR i:=0 TO 7 DO
                ptsin[i] := pxyarray[i];
        vro_cpyfm := gemvdif(109,handle);
END;

(****************************************************************)
(** Copy rastor , Transparent **)

FUNCTION vrt_cpyfm (handle, wrmode : INTEGER;
                    pxyarray : ARRAY_8;
                    psrcMFDB, pdesMFDB : MFDB;
                    color1, color0 : INTEGER) : INTEGER;

VAR     i :     INTEGER;
        gemp1, gemp2 : gempoint;
        sm, dm : MFDB;
BEGIN
        contrl[1] := 4;
        contrl[3] := 3;
        sm := psrcMFDB;                   (* local MFDB *)
        gemp1.gp := ADDR(sm);
        contrl[7] := gemp1.hi;            (* hi order word of address ptr *)
        contrl[8] := gemp1.lo;            (* lo order word *)
        dm := pdesMFDB;
        gemp2.gp := ADDR(dm);
        contrl[9] := gemp2.hi;
        contrl[10] := gemp2.lo;
        intin[0] := wrmode;               (* logic operation write mode *)
        intin[1] := color1;
        intin[2] := color0;
        FOR i:=0 TO 7 DO
                ptsin[i] := pxyarray[i];
        vrt_cpyfm := gemvdif(121,handle);
END;

(*************************************************************)
(** Transform Form **)

FUNCTION vr_trn_fm (handle : INTEGER;
                    psrcMFDB, pdesMFDB : MFDB) : INTEGER;

VAR 
        gemp1, gemp2 : gempoint;
        sm, dm : MFDB;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        sm := psrcMFDB;
        gemp1.gp := ADDR(sm);
        contrl[7] := gemp1.hi;
        contrl[8] := gemp1.lo;
        dm := pdesMFDB;
        gemp2.gp := ADDR(dm);
        contrl[9] := gemp2.hi;
        contrl[10] := gemp2.lo;
        vr_trn_fm := gemvdif(110,handle);
END;

                   (*************************)
                   (**** INPUT FUNCTIONS ****)
(*********************************************************************)
(** Set Input Mode **)

FUNCTION vsin_mode (handle, devtype, mode : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 2;
        intin[0] := devtype;
        intin[1] := mode;
        vsin_mode := gemvdif(33,handle);
        vsin_mode := intout[0];
END;

(************************************************************************)
(**  Input locator, request mode **)
(**********************************)

FUNCTION vrq_locator (handle, x, y : INTEGER;
                     VAR xout, yout : INTEGER;
                     VAR term :  CHAR) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 0;
        ptsin[0] := x;
        ptsin[1] := y;
        vrq_locator := gemvdif(28,handle);
        xout := ptsout[0];
        yout := ptsout[1];
        term := CHR(intout[0]);           (* return single byte character *)
END;

(******************************************************************)
(** Input Locator , Sample mode **)

FUNCTION vsm_locator (handle, x, y : INTEGER;
                VAR xout, yout, term, coorchg, keypress : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 0;
        ptsin[0] := x;
        ptsin[1] := y;
        vsm_locator := gemvdif(28,handle);
        xout := ptsout[0];
        yout := ptsout[1];
        term := intout[0];
        coorchg := contrl[2];
        keypress := contrl[4];
END;

(********************************************************************)
(**  Input Valuator, Request Mode **)

FUNCTION vrq_valuator (handle, valin : INTEGER;
                       VAR valout : INTEGER;
                       VAR term :  CHAR) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := valin;
        vrq_valuator := gemvdif(29,handle);
        valout := intout[0];
        term := CHR(intout[1]);
END;

(*******************************************************************)
(** Input Valuator, Sample Mode **)    (* check this !!!*)

FUNCTION vsm_valuator (handle, valin : INTEGER;
                       VAR valout : INTEGER;
                       VAR     term :  CHAR;
                       VAR     status : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := valin;
        vsm_valuator := gemvdif(29,handle);
        valout := intout[0];
        status := contrl[4];
        term := CHR(intout[1]);
END;

(*****************************************************************)
(** Input Choice, request Mode **)

FUNCTION vrq_choice (handle: INTEGER;
                     VAR     choice : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := choice;
        vrq_choice := gemvdif(30,handle);
        choice := intout[0];
END;

(*******************************************************************)
(** Input Choice, Sample Mode **)

FUNCTION vsm_choice (handle : INTEGER;
                        VAR choice, status : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vsm_choice := gemvdif(30,handle);
        choice := intout[0];
        status := contrl[4];
END;

(******************************************************************)
(** Input String, Request Mode **)

FUNCTION vrq_string (handle, maxlen, echomode, 
                     echox, echoy : INTEGER;
                     VAR     instring : CharString) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 2;
        intin[0] := 0-maxlen;             (* force standard keyboard input *)
        intin[1] := echomode;
        ptsin[0] := echox;
        ptsin[1] := echoy;
        vrq_string := gemvdif(31,handle);
        instring := '';                           (* null string *)
        FOR i:=1 TO contrl[4] DO
                instring := CONCAT(instring,CHR(intout[i-1]));
                                        (* into string char form *)
END;

(****************************************************************)
(** Input String, Sample Mode **)

FUNCTION vsm_string (handle, maxlen, echomode,
                    echox, echoy : INTEGER;
                    VAR     instring : CharString;
                        VAR status : INTEGER) : INTEGER;

VAR
        I :     INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 2;
        intin[0] := 0-maxlen;             (* force standard keyboard input  *)
        intin[1] := echomode;
        ptsin[0] := echox;
        ptsin[1] := echoy;
        vsm_string := gemvdif(31,handle);
        instring := '';                           (* null string *)
        FOR i:=1 TO contrl[4] DO
                instring := CONCAT(instring,CHR(intout[i-1]));
                                        (* into string char form *)
        status := contrl[4];
END;

(*******************************************************************)
(** Set Moose Form **)

FUNCTION vsc_form (handle : INTEGER;
                         pcurform : ARRAY_37) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 37;
        FOR i:=0 TO 36 DO
                intin[i] := pcurform[i];
        vsc_form := gemvdif(111,handle);
END;


(********************************************************************)
(** Exchange Mouse Movement Vector **)

FUNCTION vex_motv (handle : INTEGER;
                   pusrcode : gempoint;
                   VAR psavcode : gempoint) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[7] := pusrcode.hi;         (* check this !!*)
        contrl[8] := pusrcode.lo;
        vex_motv := gemvdif(126,handle);
        psavcode.hi := contrl[9];
        psavcode.lo := contrl[10];
END;

(****************************************************************)
(*** show graphic cursor ****)

FUNCTION v_show_c (handle, reset : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := reset;
        v_show_c := gemvdif(122,handle);
END;

(*******************************************************)
(** hide graphic cursor **)

FUNCTION v_hide_c (handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        v_hide_c := gemvdif(123,handle);
END;

(********************************************************************)
(** Exchange Button Change Vector **)

FUNCTION vex_butv (handle : INTEGER;
                        pusrcode : gempoint;
                        VAR psavcode : gempoint) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[7] := pusrcode.hi;         (* CHECK THIS *)
        contrl[8] := pusrcode.lo;
        vex_butv := gemvdif(125,handle);
        psavcode.hi := contrl[8];
        psavcode.lo := contrl[9];
END;

(**********************************************************************)
(** Exchange Cursor Change  Vector **)

FUNCTION vex_curv (handle : INTEGER;
                        pusrcode : gempoint;
                        VAR psavcode : gempoint) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[7] := pusrcode.hi;         (* CHECK THIS *)
        contrl[8] := pusrcode.lo;
        vex_curv := gemvdif(127,handle);
        psavcode.hi := contrl[8];
        psavcode.lo := contrl[9];
END;

(***********************************************************************)
(** Sample Keyboard State Information **)

FUNCTION vq_key_s (handle : INTEGER;
                  VAR     pstatus : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vq_key_s := gemvdif(128,handle);
        pstatus := intout[0];
END;

(********************************************************************)
(** Sample Mouse Button State **)

FUNCTION vq_mouse (handle : INTEGER;
                   VAR pstatus, x, y : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vq_mouse := gemvdif(124,handle);
        pstatus := intout[0];
        x := ptsout[0];
        y := ptsout[1];
END;

(********************************************************************)
(** Exchange Timer Interrupt Vector **)

FUNCTION vex_timv (handle : INTEGER;
                  timaddr : gempoint;
                  VAR otimaddr : gempoint;
                  VAR     timconv : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[7] := timaddr.hi;                  (* CHECK THIS *)
        contrl[8] := timaddr.lo;
        vex_timv := gemvdif(118,handle);
        otimaddr.hi := contrl[9];
        otimaddr.lo := contrl[10];
        timconv := intout[0];
END;

(*********************************************************************)


                (**** INQUIRE FUNCTIONS *******)
(**********************************************************************)
(** Extended Inquire Function **)

FUNCTION vq_extend (handle, owflag : INTEGER;
                   VAR workout : ARRAY_57) : INTEGER;

VAR
        i:      INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := owflag;
        vq_extend := gemvdif(102,handle);
        FOR i:=0 TO 44 DO
                workout[i] := intout[i];
        FOR i:=45 TO 56 DO
                workout[i] := ptsout[i-45];
END;

(*********************************************************************)
(** Inquire color representation **)

FUNCTION vq_color (handle, colorindex, setflag : INTEGER;
                   VAR rgb : ARRAY_3) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 2;
        intin[0] := colorindex;
        intin[1] := setflag;
        vq_color := gemvdif(26,handle);
        FOR i:=0 TO 2 DO
                rgb[i] := intout[i];
END;

(********************************************************)
(** Inquire polyline attributes *)

FUNCTION vql_attributes (handle :INTEGER;
                        VAR attrib : ARRAY_4) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vql_attributes := gemvdif(35,handle);
        FOR i:=0 TO 2 DO
                attrib[i] := intout[i];
        attrib[3] := ptsout[0];
END;

(*********************************************************)
(** Inquire polymarker attributes **)

FUNCTION vqm_attributes (handle :INTEGER;
                        VAR attrib : ARRAY_4) : INTEGER;

VAR
        I :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vqm_attributes := gemvdif(36,handle);
        FOR i:= 0 TO 2 DO
                attrib[i] := intout[i];
        attrib[3] := ptsout[0];
END;

(***********************************************************)
(** Inquire fill area attributes **)

FUNCTION vqf_attributes (handle :INTEGER;
                        VAR attrib : ARRAY_4) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vqf_attributes := gemvdif(37,handle);
        FOR i:=0 TO 3 DO
                attrib[i] := intout[i];
                (* what about fill perim status **)
END;

(******************************************************************)
(** Inquire current Graphic text attributes **)

FUNCTION vqt_attributes (handle :INTEGER;
                        VAR attrib : ARRAY_10) : INTEGER;

VAR
        i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vqt_attributes := gemvdif(38,handle);
        FOR i:=0 TO 5 DO
                attrib[i] := intout[i];
        FOR i:=6 TO 9 DO
                attrib[i] := ptsout[i-6];
END;

(*******************************************************************)
(** Inquire Text Extent **)

FUNCTION vqt_extent (handle : INTEGER;
                     chstring: CharString;
                     VAR extent : ARRAY_8) : INTEGER;

VAR     I :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := LENGTH(chstring);
        FOR i:=1 TO LENGTH(chstring) DO intin[i-1] := ORD(chstring[i]);
        intin[LENGTH(chstring)] := 0;
        vqt_extent := gemvdif(116,handle);
        FOR i:=0 TO 7 DO extent[i] := ptsout[i];
END;

(**********************************************************************)
(** Inquire character cell width **)

FUNCTION vqt_width (handle : INTEGER;
                   character : CHAR;
                   VAR cellwidth, leftdelta, rightdelta : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := ORD(character);
        vqt_width := gemvdif(117,handle);
        cellwidth := ptsout[0];
        leftdelta := ptsout[2];
        rightdelta := ptsout[4];
END;

(********************************************************************)
(*** Inquire font name and index **)

FUNCTION vqt_name (handle, elementnum : INTEGER;
                   VAR name : CharString) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        intin[0] := elementnum;
        vqt_name := gemvdif(130,handle);
        name := '';                       (* initialize string to null *)
        FOR i:=1 TO 32 DO
                name := CONCAT(name,CHR(intout[i]));
END;

(**********************************************************************)
(** Inquire Cell Array **)

FUNCTION vq_cellarray (handle : INTEGER;
                      pxyarray : ARRAY_4;
                      rowlen, numrows : INTEGER;
                      VAR elused, rowsused, status : INTEGER;
                      VAR     colarray : intout_ARRAY) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[7] := rowlen;
        contrl[8] := numrows;
        FOR i:=0 TO 3 DO ptsin[i] := pxyarray[i];
        vq_cellarray := gemvdif(27,handle);
        elused := contrl[9];
        rowsused := contrl[10];
        status := contrl[11];
        FOR i:=0 TO intout_max DO colarray[i] := intout[i];
END;

(**********************************************************************)
(** Inquire Input Mode **)

FUNCTION vqn_mode (handle :INTEGER;
                  VAR     inputmode : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        vqn_mode := gemvdif(115,handle);
        inputmode := intout[0];
END;



(********************************************************************)
(** Inquire Current Font Information **)

FUNCTION vqt_fontinfo (handle : INTEGER;
                       VAR minADE, maxADE : INTEGER;
                       VAR distances : ARRAY_4;
                       VAR maxwidth : INTEGER;
                       effects : ARRAY_3) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        vqt_fontinfo := gemvdif(131,handle);
        minADE := intout[0];
        maxADE := intout[1];
        distances[0] := ptsout[1];
        distances[1] := ptsout[3];
        distances[2] := ptsout[5];
        distances[3] := ptsout[7];
        maxwidth := ptsout[0];
        effects[0] := ptsout[2];
        effects[1] := ptsout[4];
        effects[2] := ptsout[6];
END;

                (*********************)
                (******  ESCAPES *****)
(********************************************************************)
(** escape : inquire addressable alpha char cells **)

FUNCTION vq_chcells (handle : INTEGER;
                    VAR     rows, columns : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := 1;
        vq_chcells := gemvdif(5,handle);
        rows := intout[0];
        columns := intout[1];
END;

(************************************************************)
(*** general escape routine..called by many of those below **)

FUNCTION genescape (fid, handle : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := fid;         (* function id *)
        genescape := gemvdif(5,handle);
END;

(**************************************************************)

FUNCTION v_exit_cur (handle : INTEGER) : INTEGER;
BEGIN
        v_exit_cur := genescape(2,handle);
END;

FUNCTION v_enter_cur (handle : INTEGER) : INTEGER;
BEGIN
        v_enter_cur := genescape(3,handle);
END;

FUNCTION v_curup (handle : INTEGER) : INTEGER;
BEGIN
        v_curup := genescape(4,handle);
END;

FUNCTION v_curdown (handle : INTEGER) : INTEGER;
BEGIN
        v_curdown := genescape(5,handle);
END;

FUNCTION v_curright (handle : INTEGER) : INTEGER;
BEGIN
        v_curright := genescape(6,handle);
END;

FUNCTION v_curleft (handle : INTEGER) : INTEGER;
BEGIN
        v_curleft := genescape(7,handle);
END;

FUNCTION v_curhome (handle : INTEGER) : INTEGER;
BEGIN
        v_curhome := genescape(8,handle);
END;

FUNCTION v_eeos (handle : INTEGER) : INTEGER;
BEGIN
        v_eeos := genescape(9,handle);
END;

FUNCTION v_eeol (handle : INTEGER) : INTEGER;
BEGIN
        v_eeol := genescape(10,handle);
END;

(*******************************************************************)
(** direct alpha cursor address **)

FUNCTION vs_curaddress (handle, row, column : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 2;
        contrl[5] := 11;
        intin[0] := row;
        intin[1] := column;
        vs_curaddress := gemvdif(5,handle);
END;

(**************************************************************)
(** output cursor addressable text **)

FUNCTION v_curtext (handle : INTEGER;
                   chstring : CharString) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := LENGTH(chstring);
        contrl[5] := 12;
        FOR i:=1 TO LENGTH(chstring) DO intin[i- 1] := ORD(chstring[i]);
        intin[LENGTH(chstring)] := 0;
        v_curtext := gemvdif(5,handle);
END;

(**************************************************************)

FUNCTION v_rvon (handle : INTEGER) : INTEGER;
BEGIN
        v_rvon := genescape(13,handle);
END;

FUNCTION v_rvoff (handle : INTEGER) : INTEGER;
BEGIN
        v_rvoff := genescape(14,handle);
END;

(***************************************************************)
(** inquire current alpha cursor address **)

FUNCTION vq_curaddress (handle : INTEGER;
                        VAR     row, column : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := 15;
        vq_curaddress := gemvdif(5,handle);
        row := intout[0];
        column := intout[1];
END;

(**************************************************************)
(** inquire tablet status **)

FUNCTION vq_tabstatus (handle : INTEGER;
                      VAR     status : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := 16;
        vq_tabstatus := gemvdif(5,handle);
        status := intout[0];
END;

(***************************************************************)
(** Hard Copy **)

FUNCTION v_hardcopy (handle : INTEGER) : INTEGER;
BEGIN
        v_hardcopy := genescape(17,handle);
END;

(******************************************************************)
(** place a graphic cursor at the specifeid location **)

FUNCTION v_dspcur (handle, x, y : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 1;
        contrl[3] := 0;
        contrl[5] := 18;
        ptsin[0] := x;
        ptsin[1] := y;
        v_dspcur := gemvdif(5,handle);
END;

(**************************************************************)

FUNCTION v_rmcur (handle : INTEGER) : INTEGER;
BEGIN
        v_rmcur := genescape(19,handle);
END;

(**************************************************************)
(***    Form advance **)

FUNCTION v_form_adv(handle : INTEGER) : INTEGER;
BEGIN
        v_form_adv := genescape(20,handle);
END;

(**************************************************************)
(** Output Window **)

FUNCTION v_output_window(handle : INTEGER;
                         xyarray : ARRAY_4) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 2;
        contrl[3] := 0;
        contrl[5] := 21;
        FOR i:=0 TO 3 DO ptsin[i] := xyarray[i];
        v_output_window := gemvdif(5,handle);
END;

(***************************************************************)
(** Clear display list **)

FUNCTION v_clear_display_list (handle : INTEGER) : INTEGER;
BEGIN
        v_clear_display_list := genescape(22,handle);
END;


(**************************************************************)
(** selection of IBM color palette 0 = red,green,yelllow 1=cyan,blue,magenta *)

FUNCTION vs_palette(handle, palette : INTEGER) : INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 1;
        contrl[5] := 60;
        intin[0] := palette;
        vs_palette := gemvdif(5,handle);
END;

(**************************************************************)
(** Inquire Palette Film Types **)

FUNCTION vqp_films(handle : INTEGER;
                   VAR     filmnames : CharString) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := 91;
        vqp_films := gemvdif(5,handle);
        filmnames := '';
        FOR i:=0 TO 127 DO filmnames := CONCAT(filmnames,CHR(intout[i]));
END;

(**************************************************************)
(** Inquire Palette Driver State **)

FUNCTION vqp_state (handle : INTEGER;
                    VAR port, filmname, lightness, interlace, planes : INTEGER;
                    VAR indexes : ARRAY_16) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 0;
        contrl[5] := 92;
        vqp_state := gemvdif(5,handle);
        port := intout[0];
        filmname := intout[1];
        lightness := intout[2];
        interlace := intout[3];
        planes := intout[4];
        FOR i:=0 TO 15 DO indexes[i] := intout[i+5];
END;

(*****************************************************************)
(** Set Palette Driver State **)

FUNCTION vsp_state (handle : INTEGER;
                    port, filmname, lightness, interlace, planes : INTEGER;
                    indexes : ARRAY_16) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := 20;
        contrl[5] := 93;
        contrl[6] := 93;
        intin[0] := port;
        intin[1] := filmname;
        intin[2] := lightness;
        intin[3] := interlace;
        intin[4] := planes;
        FOR i:=0 TO 15 DO intin[i+4] := indexes[i];               (* CHECK *)
        vsp_state := gemvdif(5,handle);
END;

(*************************************************************)
(** Save Palette Driver State **)

FUNCTION vsp_save (handle : INTEGER) : INTEGER;
BEGIN
        vsp_save := genescape(94, handle);
END;

(**************************************************************)
(** suppress polaroid palette messages **)

FUNCTION vsp_message (handle : INTEGER) : INTEGER;
BEGIN
        vsp_message := genescape(95,handle);
END;

(**************************************************************)
(** Palette Error Inquiries **)

FUNCTION vqp_error (handle : INTEGER) : INTEGER;
BEGIN
        vqp_error := genescape(96,handle);
END;

(*******************************************************************)
(*** write gsx metafile ***)

FUNCTION v_write_meta (handle, numintin : INTEGER;
                       intin : intin_ARRAY;
                       numptsin : INTEGER;
                       ptsin : ptsin_ARRAY) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := numintin;
        contrl[3] := numptsin;
        contrl[5] := 99;
        contrl[6] := handle;
        v_write_meta := gemvdif(5,handle);        (* CHECK *)
END;

(******************************************************************)
(** change gsx metafile filename from  gsxfile.gsx **)

FUNCTION vm_filename (handle : INTEGER;
                      filename : CharString) : INTEGER;

VAR     i :     INTEGER;
BEGIN
        contrl[1] := 0;
        contrl[3] := LENGTH(filename);
        contrl[5] := 100;
        FOR i:=1 TO LENGTH(filename) DO intin[i- 1] := ORD(filename[i]);
        intin[LENGTH(filename)] := 0;
        vm_filename := gemvdif(5,handle);
END;

(********************************************************************)

