/************************************************************************/
/*	File:	term.c							*/
/************************************************************************/
/*									*/
/*		     GGGGG        EEEEEEEE     MM      MM		*/
/*		   GG             EE           MMMM  MMMM		*/
/*		   GG   GGG       EEEEE        MM  MM  MM		*/
/*		   GG   GG        EE           MM      MM		*/
/*		     GGGGG        EEEEEEEE     MM      MM		*/
/*									*/
/************************************************************************/
/*									*/
/*			  +--------------------------+			*/
/*			  | Digital Research, Inc.   |			*/
/*			  | Oxford Street	     |			*/
/*			  | Newbury, (UK)	     |			*/
/*			  +--------------------------+			*/
/*									*/
/*									*/
/*   Author:	Christof Fetzer						*/
/*   PRODUCT:	GEM Sample Desk Top Accessory				*/
/*   Module:	TERM							*/
/*   Version:	July 28, 1985						*/
/*									*/
/*   Copyright (c) by Digital Research , 1985				*/
/*									*/
/************************************************************************/


/*

Page*/
/*------------------------------*/
/*	includes		*/
/*------------------------------*/

#include "termver.h"				/* #define VERSION x	*/
#include "term.h"				/* rsc - defines	*/
#include "termdefs.h"				/* #defines ...		*/
#include "termmess.h"				/* string definitions	*/
#include "portab.h"				/* portable coding conv	*/
#include "machine.h"				/* machine depndnt conv	*/
#include "obdefs.h"				/* object definitions	*/
#include "treeaddr.h"
#include "gembind.h"				/* gem binding structs	*/


/*------------------------------*/
/*	defines			*/
/*------------------------------*/

#define	ARROW		0
#define	HOUR_GLASS	2			

#define	DESK		0

#define END_UPDATE	0
#define	BEG_UPDATE	1

#define	READ_MODE	0		/* opening file for reading	*/
#define	WRITE_MODE	1		/* opening file for writing	*/
#define	READ_WRITE	2		/* opening file for both modes	*/

#define	MENU_ENABLE	1		/* enable menu item		*/
#define	MENU_DISABLE	0		/* disable menue item		*/

#define	FINELINE	1


#define X_FWD		0x0100		/* extended object types */
#define X_BAK		0x0200		/* used with scrolling	 */
#define X_SEL		0x0300		/* selectors		 */


#define TE_TXTLEN(x) (x + 24)
#define BI_PDATA(x)	(x)
#define BI_WB(x)	(x + 4)
#define BI_HL(x)	(x + 6)

#define	LF		0x0a
#define	CR		0x0d

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Data Structures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	Global			*/
/*------------------------------*/

GLOBAL WORD	contrl[11];		/* control inputs		*/
GLOBAL WORD	intin[LENGTH];		/* max string length (= col. len) */
GLOBAL WORD	ptsin[256];		/* polygon fill points		*/
GLOBAL WORD	intout[45];		/* open workstation output	*/
GLOBAL WORD	ptsout[12];


/*------------------------------*/
/*	Local			*/
/*------------------------------*/

WORD	gl_wchar;			/* character width		*/
WORD	gl_hchar;			/* character height		*/
WORD	gl_wbox;			/* box (cell) width		*/
WORD	gl_hbox;			/* box (cell) height		*/
WORD	gem_handle;			/* GEM vdi handle		*/
WORD	vdi_handle;			/* term vdi handle		*/
WORD	work_out[57];			/* open virt workstation values	*/
GRECT	work_area;			/* current window work area	*/
WORD	gl_apid;			/* application ID		*/
WORD	gl_rmsg[8];			/* message buffer		*/
LONG	ad_rmsg;			/* LONG pointer to message bfr	*/
WORD	gl_itemterm = 0;		/* term menu item		*/
WORD	gl_xfull;			/* full window 'x'		*/
WORD	gl_yfull;			/* full window 'y'		*/
WORD	gl_wfull;			/* full window 'w' width	*/
WORD	gl_hfull;			/* full window 'h' height	*/
WORD	ev_which;			/* event message returned value	*/
WORD	term_whndl = 0;			/* term window handle		*/
WORD	term_size;			/* system font cell size	*/
WORD	fs_iexbutton;			/* selected exit buttom from fsel_input */
WORD	fs_ireturn;			/* returncode from fsel_input	*/
WORD	gp_x;				/* previously used window 'x'	*/
WORD	gp_y;				/* previously used window 'y'	*/
WORD	gp_w;				/* previously used window 'w'	*/
WORD	gp_h;				/* previously used window 'h'	*/


WORD	columns = INIT_COLS;		/* Number of columns		*/ 
WORD	rows    = INIT_ROWS;		/* Number of rows		*/
WORD	row_offset = 0;			/* absolut row offset to act. line */ 
WORD	row_ptr = 0;			/* relativ offset to start_ptr in the ring buffer */ 
WORD	col_offset = 0;			/* column offset		*/
WORD	h_sd_step = 1000 / LENGTH;	/* step size for one row of the  hor. slider */
WORD	h_sd_len  = (1000/LENGTH) * INIT_COLS; /* slider length		*/
WORD	h_sd_pos  = 0;			/* slider position		*/
WORD	v_sd_step = 1000 / LINES;	/* step size of the vert.slider	*/
WORD	v_sd_len  = (1000/LENGTH) * INIT_ROWS; /* vert. slider length	*/
WORD	v_sd_pos = 0;			/* vert. slider position 	*/

BYTE	lin_buf [LINES] [LENGTH];	/* line ring buffer		*/
WORD	start_ptr = 0;			/* start of text ptr		*/
WORD	end_ptr = 0;			/* end of text ptr		*/
WORD	prev_ptr = 0;			/* end_ptr - 1			*/

BYTE	*wdw_title  = M_TITLE;		/* window title			*/
BYTE	*wdw_italk  = M_TALK;		/* window info in talk mode	*/
BYTE	*wdw_iwrite = M_WRITE;		/* window info in write mode	*/
BYTE	*wdw_itrans = M_TRANS;		/* window info in transmit mode	*/

BYTE	fs_iinpath [80] =		/* selected dir. for fsel_inp	*/
	{ 'C', ':', '*', '.', '*', '\0' };
BYTE	fs_iinsel [80]  = { '\0'};	/* selected file for fsel_inp	*/
BYTE	filename [80];			/* filename to term		*/

/*

Page*/

#define	OP_SIZE		512		/* Buffersize for input buffer	*/
WORD	op_hndl;			/* act. open file path		*/
WORD	op_fil = FALSE;			/* file open flag		*/
WORD	op_eof;				/* file at end of file		*/
WORD	op_cnt;				/* number of bytes in input buffer	*/
WORD	op_cnter;			/* number of bytes read out of the input buffer */
BYTE	op_buf [OP_SIZE];		/* input buffer			*/

WORD	ev_moflags = 0;			/* mouse in wdw  wait for exit (1) else entry (0) */ 
MFDB	lowr_mfdb;			/* lower scroll window mfdb	*/
MFDB	upr_mfdb;			/* upper scroll window mfdb	*/
GRECT	lowr_area;			/* lower scroll area		*/
GRECT	upr_area;			/* upper scroll area		*/
GRECT	lln_area;			/* last line scroll area	*/
	int	inoffset = 0;

WORD	lfi_toggle = CR;		/* Auto lf inp on / (off)	*/
BOOLEAN	lfo_toggle = TRUE;		/* Auto lf out on / (off)	*/
BOOLEAN	du_toggle  = FALSE;		/* Full duplex on / (off)	*/ 
BOOLEAN	em_toggle  = FALSE;		/* Echo mode   on / (off)	*/
BOOLEAN	trans_flag = FALSE;		/* Transmit file flag		*/
BOOLEAN	write_flag = FALSE;		/* Write flag			*/
LONG	gl_menu;			/* menu tree address		*/
WORD	baudrate = BD9600,
	parity   = NOPARITY,
	bits     = B8,
	sbits    = SB1,
	port	 = P0;			/* Card 0			*/

WORD	duplex   = HALF,
	autoilf	 = ALFION,
	autoolf	 = ALFOON,
	echomode = EMOFF;

WORD	card	 = 0;			/* Card 0 			*/

struct	sel_tbl {
	WORD	item;
	WORD	slct;
	};

struct	sel_tbl bd_tbl [] = {
		{  BD110, 0x000 },
		{  BD150, 0x020 },
		{  BD300, 0x040 },
		{  BD600, 0x060 },
		{ BD1200, 0x080 },
		{ BD2400, 0x0a0 },
		{ BD4800, 0x0c0 },
		{ BD9600, 0x0e0 },
		{     -1, 000 }		/* End marker			*/
	};
	
struct	sel_tbl pa_tbl [] = {	
		{ NOPARITY, 0x00 },
		{      ODD, 0x08 },
		{     EVEN, 0x10 },
		{       -1, 0x00 }
	};

struct	sel_tbl	bt_tbl [] = {	
		{ B7, 0x02 },
		{ B8, 0x03 },
		{ -1, 0x00 }
	};


struct	sel_tbl	sb_tbl [] = {
		{ SB1, 0x00 },
		{ SB2, 0x04 },
		{ -1,  0x00 }
	};
struct	sel_tbl po_tbl [] = {
		{ P0, 0x00 },
		{ P1, 0x01 },
		{ -1, 0x00 }
	};
struct	sel_tbl du_tbl [] = {
		{ HALF, FALSE },
		{ FULL,	TRUE },
		{   -1, 0x00 }
	};

struct	sel_tbl il_tbl [] = {		/* Auto LF Input sel_tbl	*/
		{  ALFION, CR   },	/* if on next line char = CR	*/
		{ ALFIOFF, LF   },	/* else next line char = LF	*/
		{      -1, 0x00 }
	};
	
struct	sel_tbl ol_tbl [] = {
		{  ALFOON, TRUE  },
		{ ALFOOFF, FALSE },
		{      -1, 0x00  }
	};

struct	sel_tbl em_tbl [] = {
		{  EMON, TRUE  },
		{ EMOFF, FALSE },
		{    -1, 0x00  }
	};

/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Local Procedures			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	min			*/
/*------------------------------*/
WORD
min(a, b)			/* return min of two values	*/
WORD		a, b;
{
	return( (a < b) ? a : b );
}


/*------------------------------*/
/*	max			*/
/*------------------------------*/
WORD
max(a, b)			/* return max of two values	*/
WORD		a, b;
{
	return( (a > b) ? a : b );
}

/*------------------------------*/
/*	distnt			*/
/*------------------------------*/
WORD
distnt (start, end, len, flag)	/* calculate the distant of two buffer	*/
WORD	start, end, len, flag;	/* ptr in a given range len 		*/
{				

	if (start < end)
		return (end-start);
	else if (flag && start == end) 	/* if the flag is true then the */
		return (0);		/* distant if the two ptr are 	*/
	else				/* is zero else it is len	*/
		return (len - start + end);
}

/*------------------------------*/
/*	sub_rptr		*/
/*------------------------------*/
WORD
sub_rptr (start, len, off)
WORD	start, len, off;
{				

	if (start >= off)
		return (start - off);
	else				
		return (len + start - off);
}

/*------------------------------*/
/*	strcpy			*/
/*------------------------------*/
BYTE	*strcpy(s1, s2)
BYTE	*s1, *s2;
{

	while (*(s1++) = *(s2++));

}

/*------------------------------*/
/*	strncpy			*/
/*------------------------------*/
BYTE	*strncpy(str1, str2, len)
BYTE	*str1, *str2; 
WORD	len;
{
	while ((len--) && (*(str1++) = *(str2++)));
}

/*------------------------------*/
/*	strcat			*/
/*------------------------------*/
BYTE	*strcat(str1, str2)
BYTE	*str1, *str2;
{

	while (*str1)
		++str1;
	--str1;
	strcpy (str1, str2);
}

/*------------------------------*/
/*	readln			*/
/*------------------------------*/
WORD	readln(handle, buffer, count)	/* Read line from handle without CR/LF */
WORD	handle;
BYTE	*buffer;
WORD	count;
{

	WORD	cnt = 0;

	while (cnt < count && (read (handle,&(buffer [cnt]), 1) > 0) 
		 && buffer [cnt] != '\n')
	{
		if (buffer [cnt] == '\t')	/* expand tabs on every 8th column */
			do
				buffer [cnt++] = ' ';
			while (cnt % 8 && cnt < count);
		else if ((buffer [cnt] & 0x7f) >= '\0' && (buffer [cnt] & 0x7f) < ' ' )		/* just skip CR's,.. */
			;
		else
			cnt++;
	}
	buffer [count-1] = '\0';
	while (cnt < count)
		buffer [cnt++] = '\0';
	return (cnt);

}

/*------------------------------*/
/*	open			*/
/*------------------------------*/
WORD	open (str, mode)	/* open a file				*/
BYTE	*str;			/* file name				*/
WORD	mode;			/* acces mode: 0 read, 1 write, 2 both	*/ 
{

	if (op_fil)		/* We only support one open file */
		return (-1);
	if ((op_hndl = x_open (str, mode)) < 0)
		return (-1);
	if (mode = READ_MODE)	/* fill up buffer		*/
		if ((op_cnt = x_read (op_hndl, op_buf, OP_SIZE)) < 1)
		{
			return (-1);
		}
	op_eof = FALSE;
	op_fil = TRUE;
	op_cnter = 0;
	return (op_hndl);
}

/*------------------------------*/
/*	create			*/
/*------------------------------*/
WORD	create (str, attr)	/* create a file			*/
BYTE	*str;			/* file name				*/
WORD	attr;			/* file attributes - usually 0		*/ 
{

	if (op_fil)		/* We only support one open file */
		return (-1);
	if ((op_hndl = x_create (str, attr)) < 0)
		return (-1);
	op_eof = FALSE;
	op_fil = TRUE;
	op_cnter = 0;
	return (0);
}


/*------------------------------*/
/*	read			*/	
/*------------------------------*/
WORD	read (handle, buffer, count)		/* read count bytes from handle to buffer */
WORD	handle, count;
BYTE	*buffer;
{

	int	cnt = 0;

	if (! op_fil || handle != op_hndl) /* Note: we only support one open file */
		return (-1);
	if (op_eof)
		return (0);
	while (count--)
	{
		if (op_cnter == op_cnt)
		{
			if ((op_cnt = x_read (op_hndl, op_buf, OP_SIZE)) < 1)
			{
				op_eof = TRUE;
				return (cnt);
			}
			op_cnter = 0;
		}
		buffer [cnt++] = op_buf [op_cnter++]; 
	}
	return (cnt);
}

/*------------------------------*/
/*	write			*/	
/*------------------------------*/
WORD	write (handle, buffer, count)		/* write count bytes to handle to buffer */
WORD	handle, count;
BYTE	*buffer;
{

	int	cnt = 0;

	if (! op_fil || handle != op_hndl) /* Note: we only support one open file */
		return (-1);
	while (count--)
	{
		if (op_cnter == OP_SIZE)
		{
			if ((op_cnt = x_write (op_hndl, op_buf, OP_SIZE)) < OP_SIZE)
			{
				return (-1);
			}
			op_cnter = 0;
		}
		op_buf [op_cnter++] = buffer [cnt++]; 
	}
	return (cnt);
}



/*------------------------------*/
/*	flush			*/	
/*------------------------------*/
BOOLEAN	flush (handle)		/* flush write buffer 	*/
WORD	handle;
{

	int	cnt = 0;

	if (! op_fil || handle != op_hndl) /* Note: we only support one open file */
		return (-1);
	if (x_write (op_hndl, op_buf, op_cnter) < op_cnter)
		return (-1);
	op_cnter = 0;
	return (0);
}

/*------------------------------*/
/*	eof			*/
/*------------------------------*/
WORD
eof (handle)				/* (handle) at eof ?		*/
WORD	handle;
{

	if (handle != op_hndl || ! op_fil)
		return (TRUE);
	return (op_eof);
}

/*------------------------------*/
/*	clear_buf		*/
/*------------------------------*/
VOID
clear_buf ()				/* clear line buffer		*/
{

	WORD	i, j;

	for (i = 0 ; i < LINES ; ++i)			/* from  first to the last line		*/
	{
		for (j = 0 ; j < (LENGTH - 1) ; ++j) 	/* from the first to the last col	*/  
			lin_buf [i][j] = ' ';		/* fill line buffers with blanks	*/
		lin_buf [i][LENGTH-1] = '\0';			/* and mark end of string		*/	
	}
}


/*------------------------------*/
/*	close			*/
/*------------------------------*/
WORD
close (handle)				/* clode handle			*/
WORD	handle;
{

	if (!op_fil || handle != op_hndl)
		return (-1);
	x_close (handle);
	op_fil = FALSE;
	return (1);
}

/*------------------------------*/
/*	scroll_up		*/
/*------------------------------*/
scroll_up ()				/* scroll up wdw one line	*/
{

	WORD	pxy [4], wh;
	GRECT	box;

	wind_update (BEG_UPDATE);
	wh = term_whndl;
	graf_mouse(M_OFF, 0x0L);
	grect_to_array(&lln_area, pxy);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(&work_area, &box))
		{
			if ((box.g_y + box.g_h) == (work_area.g_y + work_area.g_h))
			{
				set_clip (TRUE, &box);
				rast_op (3, &lowr_area, &lowr_mfdb, &upr_area, &upr_mfdb);
				vr_recfl(vdi_handle, pxy);	/* clear last line	*/
				disp_line (rows-1);
				set_clip (FALSE, &box);
			}
			else
			{
				disp_mesag (lin_buf, &box);
			}
			
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(ARROW, 0x0L);
	graf_mouse(M_ON, 0x0L);
	wind_update (END_UPDATE);
}


/*------------------------------*/
/*	rc_equal		*/
/*------------------------------*/
WORD
rc_equal(p1, p2)		/* tests for two rectangles equal	*/
GRECT		*p1, *p2;
{
	if ((p1->g_x != p2->g_x) ||
	    (p1->g_y != p2->g_y) ||
	    (p1->g_w != p2->g_w) ||
	    (p1->g_h != p2->g_h))
		return(FALSE);
	return(TRUE);
}


/*------------------------------*/
/*	rc_intersect		*/
/*------------------------------*/
WORD
rc_intersect(p1, p2)		/* compute inter of two rectangles	*/
GRECT		*p1, *p2;
{
	WORD		tx, ty, tw, th;

	tw = min(p2->g_x + p2->g_w, p1->g_x + p1->g_w);
	th = min(p2->g_y + p2->g_h, p1->g_y + p1->g_h);
	tx = max(p2->g_x, p1->g_x);
	ty = max(p2->g_y, p1->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
	return( (tw > tx) && (th > ty) );
}


/*------------------------------*/
/*	grect_to_array		*/
/*------------------------------*/
VOID
grect_to_array(area, array)	/* convert x,y,w,h to upr lt x,y and	*/
GRECT	*area;			/*		      lwr rt x,y	*/
WORD	*array;
{
	*array++ = area->g_x;
	*array++ = area->g_y;
	*array++ = area->g_x + area->g_w - 1;
	*array = area->g_y + area->g_h - 1;
}


/*------------------------------*/
/*	rast_op			*/
/*------------------------------*/
VOID
rast_op(mode, s_area, s_mfdb, d_area, d_mfdb)	/* bit block level trns	*/
WORD	mode;
GRECT	*s_area, *d_area;
MFDB	*s_mfdb, *d_mfdb;
{
	WORD	pxy[8];

	grect_to_array(s_area, pxy);
	grect_to_array(d_area, &pxy[4]);
	vro_cpyfm(vdi_handle, mode, pxy, s_mfdb, d_mfdb);
}


/*------------------------------*/
/*	vdi_fix			*/
/*------------------------------*/
VOID
vdi_fix(pfd, theaddr, wb, h)
	MFDB		*pfd;
	LONG		theaddr;
	WORD		wb, h;
{
	pfd->fww = wb >> 1;
	pfd->fwp = wb << 3;
	pfd->fh = h;
	pfd->np = 1;
	pfd->mp = theaddr;
}

/*------------------------------*/
/*	vdi_trans		*/
/*------------------------------*/
WORD
vdi_trans(saddr, swb, daddr, dwb, h) 
	LONG		saddr;
	UWORD		swb;
	LONG		daddr;
	UWORD		dwb;
	UWORD		h;
{
	MFDB		src, dst;

	vdi_fix(&src, saddr, swb, h);
	src.ff = TRUE;

	vdi_fix(&dst, daddr, dwb, h);
	dst.ff = FALSE;
	vr_trnfm(vdi_handle, &src, &dst );
}

/*------------------------------*/
/*	trans_gimage		*/
/*------------------------------*/
VOID
trans_gimage(tree, obj)
	LONG	tree;
	WORD	obj;
{
	LONG	taddr, obspec;
	WORD	wb, hl;

	obspec = LLGET(OB_SPEC(obj));
	taddr = LLGET(BI_PDATA(obspec));
	wb = LWGET(BI_WB(obspec));
	hl = LWGET(BI_HL(obspec));
	vdi_trans(taddr, wb, taddr, wb, hl);
}

/*------------------------------*/
/*	do_open			*/
/*------------------------------*/
WORD
do_open(wh, org_x, org_y, x, y, w, h)	/* grow and open specified wdw	*/
WORD	wh;
WORD	org_x, org_y;
WORD	x, y, w, h;
{
	WORD	ret_code;

	graf_mouse(2,0x0L);
	graf_growbox(org_x, org_y, 21, 21, x, y, w, h);
	ret_code = wind_open(wh, x, y, w, h);
	graf_mouse(ARROW,0x0L);
	return(ret_code);
}


/*------------------------------*/
/*	do_close		*/
/*------------------------------*/
VOID
do_close(wh, org_x, org_y)	/* close and shrink specified window	*/
WORD	wh;
WORD	org_x, org_y;
{
	WORD	x, y, w, h;

	graf_mouse(2,0x0L);
	wind_get(wh, WF_CXYWH, &x, &y, &w, &h);
	wind_close(wh);
	graf_shrinkbox(org_x, org_y, 21, 21, x, y, w, h);
	graf_mouse(ARROW,0x0L);
}

/*------------------------------*/
/*	set_clip		*/
/*------------------------------*/
VOID
set_clip(clip_flag, s_area)	/* set clip to specified area		*/
WORD	clip_flag;
GRECT	*s_area;
{
	WORD	pxy[4];

	grect_to_array(s_area, pxy);
	vs_clip(vdi_handle, clip_flag, pxy);
}

/*------------------------------*/
/*	align_x			*/
/*------------------------------*/
WORD
align_x(x)		/* forces word alignment for column positon,	*/
WORD	x;		/*   rounding to nearest word			*/
{
	return((x & 0xfff0) + ((x & 0x000c) ? 0x0010 : 0));
}	



/*------------------------------*/
/*	align_h			*/
/*------------------------------*/
WORD
align_h(h)		/* forces 'line alignment' for wdw_h,	*/
WORD	h;		/*   rounding to nearest line			*/
{

	return(h - (h % gl_hbox) + 2);
}	


/*------------------------------*/
/*	align_y			*/
/*------------------------------*/
WORD
align_y(y, h)
WORD	y, h;
{

	if (y < (gl_yfull + gl_hfull - h))
		return (y);
	else
		return (y + (((gl_yfull + gl_hfull) - y) % gl_hbox) + 1);
}	


/*------------------------------*/
/*	string_addr		*/
/*------------------------------*/
LONG
string_addr(which)		/* returns a tedinfo LONG string addr	*/
WORD	which;
{
	LONG	where;

	rsrc_gaddr(R_STRING, which, &where);
	return (where);
} 


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			Advanced Dialog Handling		     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	set_select		*/
/*------------------------------*/
VOID
set_select(tree, obj, init_no, bind, arry)
LONG	tree, bind[], arry[];
WORD	obj, init_no;
{
	WORD	n, nobj, cobj, count;

	indir_obj(tree, obj);
	bind[0] = LLGET(OB_SPEC(obj));
	LLSET(OB_SPEC(obj), ADDR(bind));
	bind[1] = ADDR(arry);

	n = (WORD) arry[0];
	count = 0;
	for (cobj = LWGET(OB_HEAD(obj)); cobj != obj; 
	cobj = LWGET(OB_NEXT(cobj)))
	{
		indir_obj(tree, cobj);
		LLSET(OB_SPEC(cobj), ADDR( &arry[count + 1] ));
		count = (count + 1) % n;
	}

	nobj = LWGET(OB_NEXT(obj));
	indir_obj(tree, nobj);
	LLSET(OB_SPEC(nobj), ADDR( &arry[1 + init_no % n] ));
}

/*------------------------------*/
/*	get_select		*/
/*------------------------------*/
WORD
get_select(tree, obj)
LONG	tree;
WORD	obj;
{
	WORD	nobj, cobj;
	LONG	bind, arry, temp;

	bind = LLGET(OB_SPEC(obj));
	dir_obj(tree, obj);
	LLSET(OB_SPEC(obj), LLGET(bind));
	arry = LLGET(bind + sizeof(LONG) );

	for (cobj = LWGET(OB_HEAD(obj)); cobj != obj;
	cobj = LWGET(OB_NEXT(cobj)))
	{
		dir_obj(tree, cobj);
		LLSET(OB_SPEC(cobj), LLGET(LLGET(OB_SPEC(cobj))));
	}

	nobj = LWGET(OB_NEXT(obj));
	dir_obj(tree, nobj);
	temp = LLGET(OB_SPEC(nobj));
	LLSET(OB_SPEC(nobj), LLGET(temp));
	return (WORD) (temp - arry) / sizeof(LONG) - 1;
}

/*------------------------------*/
/*	move_do			*/
/*------------------------------*/
VOID
move_do(tree, obj, inc)
LONG	tree;
WORD	obj, inc;
{
	WORD	cobj; 
	LONG	n, bind, arry, limit, obspec;

	obj = get_parent(tree, obj);
	obj = LWGET(OB_NEXT(obj));
	bind = LLGET(OB_SPEC(obj));
	arry = LLGET(bind + sizeof(LONG));
	n = LLGET(arry) * sizeof(LONG);
	limit = arry + n;

	for (cobj = LWGET(OB_HEAD(obj)); cobj != obj;
	cobj = LWGET(OB_NEXT(cobj)))
	{
		obspec = LLGET(OB_SPEC(cobj));
		obspec += inc * sizeof(LONG);
		while (obspec <= arry || obspec > limit)
			obspec += n * ((obspec > limit)? -1: 1);
		LLSET(OB_SPEC(cobj), obspec);
	}

	redraw_do(tree, obj);
}

/*------------------------------*/
/*	redraw_do		*/
/*------------------------------*/
VOID
redraw_do(tree, obj)
LONG	tree;
WORD	obj;
{
	WORD	x, y, w, h;

	objc_xywh(tree, obj, &x);
	x -= 3; y -= 3; w += 6; h += 6;
	objc_draw(tree, ROOT, MAX_DEPTH, x, y, w, h);
}

/*------------------------------*/
/*	xtend_do		*/
/*------------------------------*/
WORD
xtend_do(tree, obj, xtype)
LONG	tree;
WORD	obj, xtype;
{
	LONG	obspec;

	switch (xtype) {
		case X_SEL:
			obspec = LLGET(OB_SPEC(obj));
			obj = get_parent(tree, obj);
			obj = LWGET(OB_NEXT(obj));
			LLSET(OB_SPEC(obj), obspec);
			redraw_do(tree, obj);
			break;
		case X_FWD:
			move_do(tree, obj, 1);
			redraw_do(tree, obj);
			break;
		case X_BAK:
			move_do(tree, obj, -1);
			redraw_do(tree, obj);
			break;
		default:
	}
	return(FALSE);
}

/*------------------------------*/
/*	hndl_dial		*/
/*------------------------------*/
VOID
hndl_dial(tree, def, x, y, w, h)
LONG	tree;
WORD	def;
WORD	x, y, w, h;
{
	WORD	xdial, ydial, wdial, hdial, exitobj;
	UWORD	xtype;

	form_center(tree, &xdial, &ydial, &wdial, &hdial);
	form_dial(0, x, y, w, h, xdial, ydial, wdial, hdial);
	form_dial(1, x, y, w, h, xdial, ydial, wdial, hdial);
	objc_draw(tree, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);

	FOREVER
	{
		exitobj = form_do(tree, def) & 0x7FFF;
		xtype = LWGET(OB_TYPE(exitobj)) & 0xFF00;
		if (!xtype)
			break;
		if (xtend_do(tree, exitobj, xtype))
			break;
	}

	form_dial(2, x, y, w, h, xdial, ydial, wdial, hdial);
	form_dial(3, x, y, w, h, xdial, ydial, wdial, hdial);
	return (exitobj);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Object Tree Manipulation		     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	do_obj			*/
/*------------------------------*/
VOID
do_obj(tree, which, bit)	/* set specified bit in object state	*/
LONG	tree;
WORD	which, bit;
{
	WORD	state;

	state = LWGET(OB_STATE(which));
	LWSET(OB_STATE(which), state | bit);
}


/*------------------------------*/
/*	undo_obj		*/
/*------------------------------*/
VOID
undo_obj(tree, which, bit)	/* clear specified bit in object state	*/
LONG	tree;
WORD	which, bit;
{
	WORD	state;

	state = LWGET(OB_STATE(which));
	LWSET(OB_STATE(which), state & ~bit);
}

/*------------------------------*/
/*	sel_obj			*/
/*------------------------------*/
VOID
sel_obj(tree, which)		/* turn on selected bit of spcfd object	*/
LONG	tree;
WORD	which;
{
	do_obj(tree, which, SELECTED);
}

/*------------------------------*/
/*	desel_obj		*/
/*------------------------------*/
VOID
desel_obj(tree, which)		/* turn off selected bit of spcfd object*/
LONG	tree;
WORD	which;
{
	undo_obj(tree, which, SELECTED);
}

/*------------------------------*/
/*	enab_menu		*/
/*------------------------------*/
VOID
enab_menu(which)		/* enable specified menu item	*/
WORD	which;
{
	undo_obj(gl_menu, which, DISABLED);
}
/*------------------------------*/
/*	disab_menu		*/
/*------------------------------*/
VOID
disab_menu(which)		/* disable specified menu item	*/
WORD	which;
{
	do_obj (gl_menu, which, DISABLED);
}

/*------------------------------*/
/*	unflag_obj		*/
/*------------------------------*/
VOID
unflag_obj(tree, which, bit)
LONG	tree;
WORD	which, bit;
{
	WORD	flags;

	flags = LWGET(OB_FLAGS(which));
	LWSET(OB_FLAGS(which), flags & ~bit);
}

/*------------------------------*/
/*	flag_obj		*/
/*------------------------------*/
VOID
flag_obj(tree, which, bit)
LONG	tree;
WORD	which, bit;
{
	WORD	flags;

	flags = LWGET(OB_FLAGS(which));
	LWSET(OB_FLAGS(which), flags | bit);
}

/*------------------------------*/
/*	indir_obj		*/
/*------------------------------*/
VOID
indir_obj(tree, which)
LONG	tree;
WORD	which;
{
	flag_obj(tree, which, INDIRECT);
}

/*------------------------------*/
/*	dir_obj			*/
/*------------------------------*/
VOID
dir_obj(tree, which)
LONG	tree;
WORD	which;
{
	unflag_obj(tree, which, INDIRECT);
}

/*------------------------------*/
/*	get_parent		*/
/*------------------------------*/
/*
*	Routine that will find the parent of a given object.  The
*	idea is to walk to the end of our siblings and return
*	our parent.  If object is the root then return NIL as parent.
*/
WORD
get_parent(tree, obj)
LONG		tree;
WORD		obj;
{
	WORD		pobj;

	if (obj == NIL)
		return (NIL);
	pobj = LWGET(OB_NEXT(obj));
	if (pobj != NIL)
	{
	  	while( LWGET(OB_TAIL(pobj)) != obj ) 
	  	{
	    		obj = pobj;
	    		pobj = LWGET(OB_NEXT(obj));
	  	}
	}
	return(pobj);
} 

/*------------------------------*/
/*	objc_xywh		*/
/*------------------------------*/
VOID
objc_xywh(tree, obj, p)		/* get x,y,w,h for specified object	*/
LONG	tree;
WORD	obj;
GRECT	*p;
{
	objc_offset(tree, obj, &p->g_x, &p->g_y);
	p->g_w = LWGET(OB_WIDTH(obj));
	p->g_h = LWGET(OB_HEIGHT(obj));
}

/*------------------------------*/
/*	wdw_size		*/
/*------------------------------*/
VOID
wdw_size(box, w, h)	/* compute window size for given w * h chars	*/
GRECT	*box;
WORD	w, h;
{
	WORD	pw, ph;

	vst_height(vdi_handle, term_size,
	&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	pw = w * gl_wbox + 1;
	ph = h * gl_hbox + 2;
#if (VERSION & ACCESSORY)
	wind_calc(WC_BORDER, 0x0fff, gl_wfull - 2*pw, gl_hbox*4, pw, ph, &box->g_x, &box->g_y, &box->g_w, &box->g_h);
#else
	wind_calc(WC_BORDER, 0x0fff, gl_wbox*2, gl_hbox*4, pw, ph, &box->g_x, &box->g_y, &box->g_w, &box->g_h);
#endif
	box->g_x = align_x(box->g_x) - 1;
}

/*------------------------------*/
/*	wdw_col_rows		*/
/*------------------------------*/
VOID
wdw_col_rows(x, y)	/* compute columns and rows for a given window size */
WORD	x, y;
{


	y =  min (y, lowr_area.g_h + gl_hbox);
	vst_height(vdi_handle, term_size,
	&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	columns = x / gl_wbox;			/* columns = wide/char_wide */
	rows	= y / gl_hbox;			/* rows    = high/char_high */

}

/*------------------------------*/
/*	calc_sliders		*/
/*------------------------------*/
VOID
calc_sliders ()		/* compute the length snd position of the two sliders	*/ 
{

	row_ptr = (start_ptr + min (row_offset,distnt (start_ptr, end_ptr, LINES, FALSE))) % LINES;
	if (distnt (row_ptr, end_ptr, LINES, FALSE) < rows)
		if (distnt (start_ptr, end_ptr, LINES, FALSE) > rows)
			row_ptr = sub_rptr (end_ptr, LINES, rows);
		else
			row_ptr = start_ptr;
	row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
	v_sd_step = 1000 / (LINES - rows);
	h_sd_pos = h_sd_step * col_offset;
	h_sd_len = h_sd_step * columns;
	v_sd_pos = v_sd_step * row_offset;
	v_sd_len = v_sd_step * rows;

}


/*------------------------------*/
/*	calc_hslider		*/
/*------------------------------*/
VOID
calc_hslider ()		/* compute the length snd position of the hor. sliders	*/ 
{			/* and set slider					*/

	row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
	h_sd_pos = h_sd_step * col_offset;
	h_sd_len = h_sd_step * columns;
	wind_set(term_whndl, WF_HSLIDE, h_sd_pos);
	wind_set(term_whndl, WF_HSLSIZE, h_sd_len, 0, 0 );

}

/*------------------------------*/
/*	calc_lowa_upa		*/	
/*------------------------------*/
VOID	calc_lowa_upa ()	/* calculate upper, lower and last line area */
{

	lowr_area.g_w = upr_area.g_w = lln_area.g_w = work_area.g_w;
	lowr_area.g_h = upr_area.g_h = max (min(work_area.g_h - gl_hbox,
		gl_yfull+gl_hfull-work_area.g_y-gl_hbox), 0);
	lowr_area.g_x = upr_area.g_x = lln_area.g_x = work_area.g_x;
	lowr_area.g_y = work_area.g_y + gl_hbox;
	upr_area.g_y = work_area.g_y;
	lln_area.g_h = ((gl_yfull + gl_hfull - work_area.g_y) > gl_hbox) ?
			gl_hbox : 0;
	lln_area.g_y = min (work_area.g_y + work_area.g_h - gl_hbox,
			    gl_yfull + gl_hfull -gl_hbox);
}


/*------------------------------*/
/*	set_sliders		*/
/*------------------------------*/
VOID	set_sliders ()		/* set vert. and hor. sliders */
{

	wind_set(term_whndl, WF_VSLIDE, v_sd_pos);
	wind_set(term_whndl, WF_VSLSIZE, v_sd_len, 0, 0 );
	wind_set(term_whndl, WF_HSLIDE, h_sd_pos);
	wind_set(term_whndl, WF_HSLSIZE, h_sd_len, 0, 0 );

}	

/*------------------------------*/
/*	get_fname		*/
/*------------------------------*/
VOID	get_fname (fn)		/* make file nameout of fs_iinpath and fs_iinsel */
BYTE	*fn;
{

	BYTE	*ptr, *last;
	
	last = fn;
	ptr = fs_iinpath;
	while (*ptr)
	{
		if ((*ptr) == '\\' || (*ptr) == ':') 
			last = fn + 1;
		else if ((*ptr) == '*' || (*ptr) == '?')
		{
			strcpy (last, fs_iinsel);
			return;
		}
		*(fn++) = *(ptr++);
	}
	if (fn[-1] != '\\') 
		*(fn++) = '\\';
	strcpy (fn, fs_iinsel);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Soft Cursor Support			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	cursor			*/
/*------------------------------*/
VOID
cursor(x, y,color)			/* turn cursor on,  color = BLACK	*/
WORD	x, y,color;				/*   or cursor off, color = WHITE	*/
{
	WORD	pxy[4];

	pxy[0] = work_area.g_x + x*gl_wbox + 1;
	pxy[1] = work_area.g_y + y*gl_hbox + 1;
	pxy[2] = work_area.g_x + x*gl_wbox + 1;
	pxy[3] = work_area.g_y + y*gl_hbox - gl_hbox + 2;

	wind_update (BEG_UPDATE);
	vsl_color(vdi_handle,color);
	vswr_mode(vdi_handle,MD_REPLACE);
	vsl_type (vdi_handle,FIS_SOLID);
	vsl_width (vdi_handle,FINELINE);
	graf_mouse(M_OFF, 0x0L);
	set_clip(TRUE, &work_area);
	v_pline(vdi_handle, 2, pxy);
	set_clip(FALSE, &work_area);
	graf_mouse(M_ON, 0x0L);
	wind_update (END_UPDATE);
}


/*------------------------------*/
/*	curs_on			*/
/*------------------------------*/
VOID
curs_on()			/* turn 'soft' cursor 'on'	*/
{
	cursor(inoffset - col_offset, distnt (row_ptr, end_ptr, LINES, TRUE), BLACK);
}

/*------------------------------*/
/*	curs_off		*/
/*------------------------------*/
VOID
curs_off()			/* turn 'soft' cursor 'off'	*/
{
	cursor(inoffset-col_offset, distnt (row_ptr, end_ptr, LINES, TRUE), WHITE);
}



/*------------------------------*/
/*	disp_message		*/
/*------------------------------*/
VOID
disp_mesag(strptr, clip_area)	/* display message applying input clip	*/
BYTE	strptr [] [LENGTH];
GRECT	*clip_area;
{
	WORD	pxy[4];
	WORD	ycurr, linecnt = 0, drow_ptr;

	set_clip(TRUE, clip_area);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	grect_to_array(&work_area, pxy);
	if (ev_moflags)
		graf_mouse(M_OFF, 0x0L);
	vr_recfl(vdi_handle, pxy);	/* clear entire message area	*/

	vsl_color(vdi_handle,BLACK);
	vswr_mode(vdi_handle,MD_REPLACE);
	vsl_type (vdi_handle,FIS_SOLID);
	vswr_mode(vdi_handle, 1);
	ycurr = work_area.g_y - 1;
	drow_ptr = row_ptr;
	do
	{
		ycurr += gl_hbox;
		v_gtext(vdi_handle, work_area.g_x, ycurr, strptr [drow_ptr] + col_offset);
		drow_ptr = (++drow_ptr) % LINES;
	}
	while (linecnt++ < rows && drow_ptr != start_ptr &&
		drow_ptr != end_ptr);

	if (ev_moflags)
		graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, clip_area);
}


/*------------------------------*/
/*	disp_line		*/
/*------------------------------*/
VOID
disp_line (line)	/* display one single line	*/
WORD	line;
{
	WORD	pxy[4];
	WORD	ycurr, linecnt = 0, drow_ptr;

	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	if (ev_moflags)
		graf_mouse(M_OFF, 0x0L);
	 
	grect_to_array(&work_area, pxy);
	vsl_color(vdi_handle,BLACK);
	vswr_mode(vdi_handle,MD_REPLACE);
	vsl_type (vdi_handle,FIS_SOLID);
	vswr_mode(vdi_handle, 1);
	ycurr = work_area.g_y - 1;
	drow_ptr = row_ptr;
/*	ycurr += gl_hbox * (line +1); /* There must be a mistake ... */
 *
 *	drow_ptr = (row_ptr + line+1) % LINES;
 *	if (distnt (start_ptr, drow_ptr, LINES, TRUE) < distnt ((start_ptr, end_ptr, LINES, FALSE) - rows))
 *		v_gtext(vdi_handle, work_area.g_x, ycurr, lin_buf [drow_ptr] + col_offset);
 */
	do
	{
		ycurr += gl_hbox;
		if (linecnt == line)
			v_gtext(vdi_handle, work_area.g_x, ycurr, lin_buf [drow_ptr] + col_offset);
		drow_ptr = (++drow_ptr) % LINES;
	}
	while (linecnt++ < line && drow_ptr != start_ptr &&
		drow_ptr != end_ptr);

	if (ev_moflags)
		graf_mouse(M_ON, 0x0L);
}

/*------------------------------*/
/*	insert			*/
/*------------------------------*/
VOID	insert (c)			/* insert char into line buffer */
WORD	c;
{


	if (c == lfi_toggle)
	{

		inoffset = 0;
		lin_buf [end_ptr] [inoffset] = '\0';
		incr_end_ptr ();
	}
	else if ( c == 0x08 || c == 0x7f)
	{
		if (inoffset)
		{
			lin_buf [prev_ptr] [inoffset] = '\0';
			lin_buf [prev_ptr] [--inoffset] = ' ';
		}
	}
	else  if ((c & 0x7f) >=  ' ' && (c & 0x07f) <= 'z')
	{
		if (inoffset == LENGTH-1)  
		{
			incr_end_ptr ();
			inoffset = 0;
		}
		lin_buf [prev_ptr] [inoffset++] = c;	
		lin_buf [prev_ptr] [inoffset]   = '\0';
	}

}

/*------------------------------*/
/*	ins_ln			*/
/*------------------------------*/

ins_ln (str)
BYTE	*str;
{

	while (*str)
		insert (*(str++));
}

/*------------------------------*/
/*	sendln			*/
/*------------------------------*/

sendln (str)			/* send line to remote	*/
BYTE	*str;
{

	while (*str)
		if (! sendc (*(str++)))
			break;
	sendcr ();

}

/*------------------------------*/
/*	sendcr			*/
/*------------------------------*/
VOID	sendcr ()		/* send CR ( + LF) to remote	*/
{

	sendc ('\r');
	if (lfo_toggle )
		sendc ('\n');
}

/*------------------------------*/
/*	sendc			*/
/*------------------------------*/
VOID	sendc (c)		/* send char to remote		*/
BYTE	c;
{

		WORD	tmp;
		LONG	delay = 10000;

Outc:		rs_out (card, c);
		if (em_toggle)
		{
			while (! (rs_stat (card) & 0x0100) && delay) 	/* replace through timer wait 	*/
				delay--;
			if (rs_in (card) != c)
				if ((tmp = trans_error ()) == 3)
				{
					stop_trans ();			/* stop transmitting 		*/
					em_toggle = FALSE;
					return (FALSE);
				}
				else if (tmp == 2)
					goto Outc;
		}
		return (TRUE);
}

/*------------------------------*/
/*	trans_error		*/
/*------------------------------*/
WORD	trans_error ()			/* echo transmission error	*/
{

		return (form_alert (1, string_addr (TERMASK3)));
}

/* test function */

i_to_a (i,c)
WORD	i;
BYTE	c;
{
	WORD	mask;

	insert (c);
	for (mask = 7 ; mask >= 0 ; mask--)
		insert ((i & (1<<mask)) ? '1' : '0');
}


/*------------------------------*/
/*	incr_end_ptr		*/
/*------------------------------*/
VOID	incr_end_ptr ()
{

	prev_ptr = ++prev_ptr % LINES;
	end_ptr = ++end_ptr % LINES;
  	if (end_ptr == start_ptr)
		start_ptr = ++start_ptr % LINES;
}



/*------------------------------*/
/*	clear_disp		*/
/*------------------------------*/
VOID
clear_disp (clip_area)	/* clear message display applying input clip	*/
GRECT	*clip_area;
{
	WORD	pxy[4];

	set_clip(TRUE, clip_area);
	vsf_interior(vdi_handle, 1);
	vsf_color(vdi_handle, WHITE);
	grect_to_array(&work_area, pxy);
	graf_mouse(M_OFF, 0x0L);
	vr_recfl(vdi_handle, pxy);	/* clear entire message area	*/
	graf_mouse(M_ON, 0x0L);
	set_clip(FALSE, clip_area);
}






/*------------------------------*/
/*	do_redraw		*/
/*------------------------------*/
VOID
do_redraw(wh, area)		/* redraw message applying area clip	*/
WORD	wh;
GRECT	*area;
{
	GRECT	box;

	wind_update (BEG_UPDATE);
	graf_mouse(M_OFF, 0x0L);
	wind_get(wh, WF_FIRSTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	while ( box.g_w && box.g_h )
	{
		if (rc_intersect(area, &box))
		{
			if (wh == term_whndl)
			{
				disp_mesag(lin_buf, &box);
			}
		}
		wind_get(wh, WF_NEXTXYWH, &box.g_x, &box.g_y, &box.g_w, &box.g_h);
	}
	graf_mouse(M_ON, 0x0L);
	wind_update (END_UPDATE);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Menu Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	hndl_menu		*/
/*------------------------------*/
WORD
hndl_menu(title, item)
WORD 	title, item;
{
	WORD	done;

	done = FALSE;
	switch (title)
	{
	case FILE:
		switch (item)
		{
		case OPEN:
			opn_fil ();
			if (write_flag)			/* if no error in opn_fil */
			{
				disab_menu (OPEN);	/* disable open		*/
				disab_menu (TRANSMIT);	/* disable transmit	*/
				disab_menu (STOPTRAN);	/* disable stop transmit*/
				enab_menu (CLOSE);	/* enable close 	*/
			}
			break;

		case TRANSMIT:
			do_trans();
			if (trans_flag)
			{
				disab_menu (OPEN);
				disab_menu (TRANSMIT);
				disab_menu (CLOSE);
				enab_menu (STOPTRANS);	/* enable only stop transmit */
			}
			break;

		case STOPTRAN:
			stop_trans ();			/* stop transmission	*/
			break;
			
		case CLOSE:
			flush (op_hndl);		/* flush write buffer	*/
			close (op_hndl);		/* close file		*/
			write_flag = FALSE;		/* clear write flag	*/
			enab_menu (OPEN);		/* enable open and	*/
			enab_menu (TRANSMIT);		/* transmit and disable	*/
			disab_menu (CLOSE);		/* CLOSE itself		*/
			wind_set(term_whndl,		/* print talk info 			*/
			   WF_INFO, (WORD) LLOWD(ADDR(wdw_italk)), (WORD) LHIWD(ADDR(wdw_italk)), 0, 0); 
			break;

		case QUIT:
			done = TRUE;
			break;
		}
		break;
		
	case OPTIONS:
		switch (item)
		{
		case CONFIG:
			do_config ();
			break;
		case SETPARA:
			set_para ();
			break;
		}
		break;
	default:
		do_about ();		/* case DESK */
	}
	menu_tnormal(gl_menu,title,TRUE);
	return (done);
}


/*------------------------------*/
/*	do_about		*/
/*------------------------------*/
VOID
do_about()			/* display Doodle Info... 	*/
{
	LONG	tree;
	GRECT	box;

	objc_xywh(gl_menu, TERMINFO, &box);
	rsrc_gaddr(R_TREE, TERMINFO, &tree);
	hndl_dial(tree, 0, box.g_x, box.g_y, box.g_w, box.g_h);
	desel_obj(tree, INFOOK);
}




/*------------------------------*/
/*	do_config		*/
/*------------------------------*/
BOOLEAN	do_config()		/* use dialogue box to input selection	*/
{	
	WORD	exit_obj, select;
	LONG	tree;
	GRECT	box;
	BOOLEAN	ret;

	wind_update (BEG_UPDATE);
	objc_xywh(gl_menu, TERMPORT, &box);
	rsrc_gaddr(R_TREE, TERMPORT, &tree);
	/**/			/* first setup current selection state	*/
	sel_obj (tree, baudrate);
	sel_obj (tree, parity);
	sel_obj (tree, bits);
	sel_obj (tree, sbits);
	sel_obj (tree, port);
	/**/			/* get dialogue box input		*/
	exit_obj = hndl_dial(tree, 0, box.g_x, box.g_y, box.g_w, box.g_h);
	if (exit_obj == CFIGOK)
	{
		baudrate = get_sl (tree, bd_tbl); /* get selection and deselect */
		parity   = get_sl (tree, pa_tbl);
		bits     = get_sl (tree, bt_tbl);
		sbits    = get_sl (tree, sb_tbl);
		port	 = get_sl (tree, po_tbl);
		desel_obj (tree, CFIGOK);
		select  = get_slc (bd_tbl, baudrate);
		select |= get_slc (pa_tbl, parity);
		select |= get_slc (bt_tbl, bits);
		select |= get_slc (sb_tbl, sbits);
		card	= get_slc (po_tbl, port);
		rs_con (card, select);		/* config. port x	*/
		ret = TRUE;			/* we configurated port	*/
	}
	else
	{
		get_sl (tree, bd_tbl);		/* just delselect all 	*/
		get_sl (tree, pa_tbl);
		get_sl (tree, bt_tbl);
		get_sl (tree, sb_tbl);
		get_sl (tree, po_tbl);
		desel_obj (tree, CFIGCNCL);
		ret = FALSE;			/* no configuration made*/
	}
	wind_update (END_UPDATE);
	return (ret);
}


/*------------------------------*/
/*	set_para		*/
/*------------------------------*/
VOID
set_para ()			/* use dialogue box to input selection	*/
{	
	WORD	exit_obj, select;
	LONG	tree;
	GRECT	box;

	wind_update (BEG_UPDATE);
	objc_xywh(gl_menu, TERMPARA, &box);
	rsrc_gaddr(R_TREE, TERMPARA, &tree);
	/**/			/* first setup current selection state	*/
	sel_obj (tree, autoilf);
	sel_obj (tree, autoolf);
	sel_obj (tree, echomode);
	sel_obj (tree, duplex);
	/**/				/* get dialogue box input	*/
	exit_obj = hndl_dial(tree, 0, box.g_x, box.g_y, box.g_w, box.g_h);
	if (exit_obj == SETPOK)
	{
		autoilf	= get_sl (tree, il_tbl); /* get selection and deselect */
		autoolf	= get_sl (tree, ol_tbl);
		echomode= get_sl (tree, em_tbl);
		duplex	= get_sl (tree, du_tbl);
		desel_obj (tree, SETPOK);
		lfi_toggle = get_slc (il_tbl, autoilf);
		lfo_toggle = get_slc (ol_tbl, autoolf);
		em_toggle  = get_slc (em_tbl, echomode);
		du_toggle  = get_Slc (du_tbl, duplex);
	}
	else
	{
		get_sl (tree, il_tbl);	 /* deselect */
		get_sl (tree, ol_tbl);
		get_sl (tree, em_tbl);
		get_sl (tree, du_tbl);
		desel_obj (tree, SETPCNCL);
	}
	wind_update (END_UPDATE);
}

/*------------------------------*/
/*	get_sl			*/
/*------------------------------*/
WORD 	get_sl (tree, table)			/* return selected field */
LONG	tree;
struct	sel_tbl table [];
{

	WORD	psel_obj, i = 0;

	while ((psel_obj = table[i++].item) != -1)
		if (LWGET(OB_STATE(psel_obj)) & SELECTED)
		{
			desel_obj(tree, psel_obj);
			break;
		}
	return (psel_obj);
}


/*------------------------------*/
/*	get_slc			*/
/*------------------------------*/
WORD	get_slc (table, srchcd)		/* get select code */
struct	sel_tbl table [];
WORD	srchcd;
{

	WORD	i = 0;
	
	while (table[i].item != srchcd && table[i].item != -1)
		++i;
	return (table[i].slct);

}

/*------------------------------*/
/*	do_trans		*/
/*------------------------------*/

VOID	do_trans()
{

	close (op_hndl);
	if (trans_flag || write_flag)
		return;
#if	(VERSION & SHOWMESS)
	if (form_alert (1, string_addr (TERMASK1)) == 2)
	{
		return;
	}
#endif
	if (fs_iinpath [0])
		fs_iinpath [0] = dos_gdrv () + 'A';
	wind_update (BEG_UPDATE);
	fs_ireturn = fsel_input (ADDR(fs_iinpath),ADDR(fs_iinsel), &fs_iexbutton);
	wind_update (END_UPDATE);
	get_fname (filename);
	if (!fs_ireturn || !fs_iexbutton)
	{
		return;
	}
	if (open (filename, READ_MODE) < 0)
	{
		form_alert (1, string_addr (TERMERR2));
		return;
	}
	wind_set(term_whndl, WF_INFO,		/* print new info */
	(WORD) LLOWD(ADDR(wdw_itrans)), (WORD) LHIWD(ADDR(wdw_itrans)), 0, 0); 
	col_offset = 0;				/* No auto wrap	*/
	trans_flag = TRUE;
}

/*------------------------------*/
/*	stop_trans		*/
/*------------------------------*/

VOID	stop_trans ()		/* stop transmitting file, close file 	*/
{				/* and reset transmit flag, and info	*/ 

	insert (lfi_toggle);	/* goto next line			*/
	trans_flag = FALSE;	/* clear tansmit flag			*/
	close (op_hndl);	/* close transmitted file		*/
	wind_set(term_whndl,	/* print talk info 			*/
	   WF_INFO, (WORD) LLOWD(ADDR(wdw_italk)), (WORD) LHIWD(ADDR(wdw_italk)), 0, 0); 
	enab_menu (OPEN);	/* enable open and			*/
	enab_menu (TRANSMIT);	/* transmitt and dis-			*/
	disab_menu (STOPTRAN);	/* able STOPTRAN			*/
}

/*------------------------------*/
/*	opn_fil			*/
/*------------------------------*/

VOID	opn_fil ()		/* get filename and open file for echo to file -> transmit mode */
{

	if (trans_flag || write_flag)
		return;
#if	(VERSION & SHOWMESS)
	if (form_alert (1, string_addr (TERMASK2)) == 2)
	{
		return;
	}
#endif
	if (fs_iinpath [0])
		fs_iinpath [0] = dos_gdrv () + 'A';
	wind_update (BEG_UPDATE);
	fs_ireturn = fsel_input (ADDR(fs_iinpath),ADDR(fs_iinsel), &fs_iexbutton);
	wind_update (END_UPDATE);
	get_fname (filename);
	if (!fs_ireturn || !fs_iexbutton)
	{	
		return;
	}
	if (open (filename, READ_MODE) > 0)	/* test if file exist */
	{
		close (op_hndl);
		if (form_alert (1, string_addr (TERMASK4)) == 1)
			return;
	}
	if (create (filename, 0) < 0 )
	{
		form_alert (1, string_addr (TERMERR3));
		return;
	}
	wind_set(term_whndl, WF_INFO,		/* print new info	*/
	(WORD) LLOWD(ADDR(wdw_iwrite)), (WORD) LHIWD(ADDR(wdw_iwrite)), 0, 0); 
	col_offset = 0;				/* No auto wrap		*/
	write_flag = TRUE;

}
/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Message Handling			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	hndl_mesag		*/
/*------------------------------*/
BOOLEAN	hndl_mesag()
{
	GRECT	box;
	BOOLEAN	done; 
	WORD	wdw_hndl, i;

	done = FALSE;
	wdw_hndl = gl_rmsg[3];			/* wdw handle of mesag	*/
	switch( gl_rmsg[0] )			/* switch on term of msg*/
	{
	case MN_SELECTED:
		done = hndl_menu (wdw_hndl, gl_rmsg [4]);
#if (VERSION & ACCESSORY)
		if (done)
			goto wdw_close;
#endif
		break;

	case AC_OPEN:				/* do accessory open	*/
		if ( (gl_rmsg[4] == gl_itemterm) && 
		 	(!term_whndl))		/* unless already open	*/
		{
			row_offset = col_offset = row_ptr = 0;
			graf_mouse(HOUR_GLASS, 0x0L);
			/* 0x0fff = NAME | CLOSER | MOVER | INFO SIZE | UPARROW | DNARROW | VSLIDE | HSLIDE */
			term_whndl = wind_create(0x0fff, align_x(gl_xfull)-1, gl_yfull, gl_wfull, gl_hfull);
			if (term_whndl == -1)	/* if no window left */
			{
				form_alert (1,string_addr (TERMERR1));
				done = TRUE;
			}
			wdw_size(&box, INIT_COLS, INIT_ROWS);
#if	(VERSION & ACCESSORY)			/* open from menu area	*/
			do_open(term_whndl, gl_hbox * 2,  gl_hbox*4, box.g_x, box.g_y, box.g_w, box.g_h);
#else						/* open from screen cntr*/
			do_open(term_whndl, gl_wfull/2, gl_hfull/2, box.g_x, box.g_y, box.g_w, box.g_h);
#endif
			wind_set(term_whndl, WF_NAME,(WORD) LLOWD(ADDR(wdw_title)), (WORD) LHIWD(ADDR(wdw_title)), 0, 0);
			wind_set(term_whndl, WF_INFO,(WORD) LLOWD(ADDR(wdw_italk)), (WORD) LHIWD(ADDR(wdw_italk)), 0, 0); 
			wind_get(term_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
			clear_disp (&work_area);
			calc_lowa_upa ();
			wdw_col_rows (work_area.g_w, work_area.g_h);
			calc_sliders ();
			set_sliders ();
			done = -1;
		}
		else
			wind_set(term_whndl, WF_TOP, 0, 0, 0, 0);
		break;

	case WM_REDRAW:				/* do redraw wdw contnts*/
		do_redraw(wdw_hndl, (GRECT *) &gl_rmsg[4]);
		break;

	case WM_TOPPED:				/* do window topped	*/
		wind_set(wdw_hndl, WF_TOP, 0, 0, 0, 0);
		break;

	case AC_CLOSE:				/* do accessory close	*/
		done = TRUE;
		term_whndl = 0;
		break;

	case WM_CLOSED:				/* do window closed	*/
wdw_close:
#if	(VERSION & ACCESSORY)			/* close to menu bar	*/
		do_close(term_whndl, gl_wbox*4, gl_hbox/2);
#else						/* close to screen cntr	*/
		do_close(term_whndl, gl_wfull/2, gl_hfull/2);
#endif
		wind_delete(term_whndl);
		term_whndl = 0;
		done = TRUE;
		break;

	case WM_SIZED:				/* do window size or	*/
	case WM_MOVED:				/* do window move	*/
		wind_set(wdw_hndl, WF_CXYWH, align_x(gl_rmsg[4])-1, align_y (gl_rmsg[5],
			align_h (gl_rmsg[7])), gl_rmsg[6], align_h (gl_rmsg[7]));
		wind_get(term_whndl, WF_WXYWH,	&work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		calc_lowa_upa ();
		wdw_col_rows (work_area.g_w, work_area.g_h);
		calc_sliders ();
		set_sliders ();
		break;

	case WM_FULLED:
		do_full (wdw_hndl);
		wind_get(term_whndl, WF_WXYWH, &work_area.g_x, &work_area.g_y, &work_area.g_w, &work_area.g_h);
		calc_lowa_upa ();
		wdw_col_rows (work_area.g_w, work_area.g_h);
		calc_sliders ();
		set_sliders ();
		break;

	case WM_ARROWED:
		switch (gl_rmsg [4])
		{
		case 0:				/* page up	 	*/
			row_offset = (row_offset >= rows) ? row_offset - rows : 0;
			break;
		case 1:				/* page down		*/
			row_offset = (row_offset < LINES - (2 * rows)) ? row_offset + rows : LINES - rows;
			break;
		case 2:				/* row up		*/
			row_offset = (row_offset >= 1) ? row_offset - 1 : 0;
			break;
		case 3:				/* row down		*/
			row_offset = (row_offset < LINES - rows) ? row_offset + 1 : LINES - rows;
			break;
		case 4:				/* page left		*/ 
			col_offset = (col_offset >= columns) ? col_offset - columns : 0;
			break;
		case 5:				/* page right		*/
			col_offset = (col_offset < LENGTH - columns) ? col_offset + columns : LENGTH - 1;
			break;
		case 6:				/* column left		*/
			col_offset = (col_offset >= 1) ? col_offset - 1 : 0;
			break;
		case 7:				/* column right		*/
			col_offset = (col_offset < LENGTH - 1) ? col_offset + 1 : LENGTH - 1;
			break;
		}
		calc_sliders ();
		set_sliders ();
		disp_mesag (lin_buf, &work_area); 
		break;

	case WM_HSLID:
		col_offset = max ((gl_rmsg [4] / h_sd_step) - 1, 0);
		calc_sliders ();
		wind_set(term_whndl, WF_HSLIDE, h_sd_pos);
		wind_set(term_whndl, WF_HSLSIZE, h_sd_len, 0, 0 );
		disp_mesag (lin_buf, &work_area); 
		break;

	case WM_VSLID:
		row_offset = max (gl_rmsg [4] / v_sd_step - 1, 0);
		calc_sliders ();
		wind_set(term_whndl, WF_VSLIDE, v_sd_pos);
		wind_set(term_whndl, WF_VSLSIZE, v_sd_len, 0, 0 );
		disp_mesag (lin_buf, &work_area); 
		break;
		
	default:
		break;
	} /* switch */
	return(done);
} /* hndl_mesag */


/*------------------------------*/
/*	do_full			*/
/*------------------------------*/
VOID
do_full(wh)	/* depending on current window state, either make window*/
WORD	wh;	/*   full size -or- return to previous shrunken size	*/
{
	GRECT	curr;
	GRECT	full;

	graf_mouse(M_OFF,0x0L);
	wind_get(wh, WF_CXYWH, &curr.g_x, &curr.g_y, &curr.g_w, &curr.g_h);
	wind_get(wh, WF_FXYWH, &full.g_x, &full.g_y, &full.g_w, &full.g_h);
	align_h (full.g_h);
	if (rc_equal(&curr, &full))
	{					/* is full now so change*/
		/**/					/*   to previous	*/
		graf_shrinkbox(gp_x, gp_y, gp_w, gp_h,
			full.g_x, full.g_y, full.g_w, full.g_h);
		wind_set(wh, WF_CXYWH, gp_x, gp_y, gp_w, gp_h);
	}
	else
	{					/* is not full so make	*/
		/**/					/*   it full		*/
		graf_growbox(curr.g_x, curr.g_y, curr.g_w, curr.g_h,
			full.g_x, full.g_y, full.g_w, full.g_h);
		wind_get(term_whndl, WF_CXYWH, &gp_x, &gp_y, &gp_w, &gp_h); 
		wind_set(wh, WF_CXYWH, full.g_x, full.g_y, full.g_w, full.g_h);
	}
	graf_mouse(M_ON,0x0L);
}

/*

Page*/

/*************************************************************************/
/*************************************************************************/
/****								      ****/
/****			       Term main function		      ****/
/****								      ****/
/*************************************************************************/
/*************************************************************************/

WORD
comm ()
{

	WORD	ready = FALSE, ev_mwitch, done, h0;
	LONG	delay = 2;
	WORD	ev_mmox, ev_mmoy, ev_mmobutton, ev_mmokstate,
		ev_mkreturn, ev_mbreturn, ev_mflags, ev;
	BOOLEAN	change = FALSE;
	BYTE	buf [LENGTH];

	if ( !do_config ())			/* first configurate port*/
	{					/* if no configuration	*/
		gl_rmsg[0] = WM_CLOSED;		/* Simulate wdw close 	*/
		gl_rmsg[4] = gl_itemterm;	/* to get rid of the	*/
		hndl_mesag();			/* window		*/
#if (VERSION & ACCESSORY)			/* if ACCESSORY end of	*/
		wind_update (END_UPDATE);	/* wdw update		*/
#endif
		return (-1);			/* and just return	*/
	}
	clear_buf ();				/* clear line buffer	*/
	start_ptr = prev_ptr = row_ptr = 0;	/* init global vars	*/
	col_offset = row_offset = 0;
	end_ptr = 1;				
	graf_mouse(ARROW,0x0L);			/* set mouse form	*/
	disp_mesag (lin_buf, &work_area); 	/* show buffer		*/
#if (VERSION & ACCESSORY)			/* if ACCESSORY end of	*/
	wind_update (END_UPDATE);		/* window update	*/
#endif
 	ev_mflags = MU_M1 | MU_MESAG |		/* set var. for multi	*/
		    MU_TIMER | MU_KEYBD;	/* event wait		*/
	graf_mkstate (&ev_mmox, &ev_mmoy, &ev_mmokstatem, &ev);
	if ((ev_mmox >= work_area.g_x) &&	/* test if the mouse is */
	    (ev_mmox <= work_area.g_x + work_area.g_w) &&
	    (ev_mmoy >= work_area.g_y) &&	/* inside of the w.area	*/
	    (ev_mmoy <= work_area.g_y + work_area.g_h))
	{
		ev_moflags = 1;			/* if inside the set	*/
		ev_mflags |= MU_BUTTON;		/* flag and var for 	*/
	}					/* BUTTON wait		*/
	else
		ev_moflags = 0;			/* else clear flag	*/
	do
	{
		curs_off ();			/* soft cursor off	*/
#if	(VERSION & HOR_SCROLL)
		if (col_offset > inoffset&& !trans_flag)
		{				/* adjust col_offset	*/
			col_offset = max (0, inoffset - columns + 2);
			row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
			calc_sliders ();
			set_sliders ();
			wind_update (BEG_UPDATE);
			disp_mesag (lin_buf, &work_area); 
			wind_update (END_UPDATE);
		}
		else if (inoffset > col_offset + columns && !trans_flag)
		{
			row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
			col_offset = inoffset - 2;
			calc_sliders ();
			set_sliders ();
			wind_update (BEG_UPDATE);
			disp_mesag (lin_buf, &work_area); 
			wind_update (END_UPDATE);
		} 
#endif
		if (distnt (row_ptr , end_ptr, LINES, TRUE) > rows)
		{
#if	(VERSION & NO_VSCROLL)
			if (distnt (row_ptr , end_ptr, LINES, TRUE) ==  rows + 1)
			{					
				row_ptr = ++row_ptr % LINES;	/* incr buffer ptr 		*/
				v_sd_pos += v_sd_step;		/* incr v-slider position	*/
				wind_set(term_whndl, WF_VSLIDE, v_sd_pos);	/* set v-slider */
				scroll_up ();
			}
			else
			{
				row_ptr = sub_rptr (end_ptr, LINES, rows);	/* goto last page 	*/
				wind_update (BEG_UPDATE);
				disp_mesag (lin_buf, &work_area); 		/* and display it	*/
				wind_update (END_UPDATE);
				calc_hslider ();
			}
			change = FALSE;
#else
			row_ptr = ++row_ptr % LINES;	/* incr buffer ptr 		*/
			v_sd_pos += v_sd_step;		/* incr v-slider position	*/
			wind_set(term_whndl, WF_VSLIDE, v_sd_pos);	/* set v-slider */
			scroll_up ();
#endif
		}
		else if (((col_offset <= inoffset) && (inoffset < col_offset + columns)) ||
			 trans_flag)
		{					/* update only if char visible */
				if (change && distnt (row_ptr, end_ptr, LINES, TRUE) == rows)
				{
					set_clip (TRUE, &work_area);
					wind_update (BEG_UPDATE);
					disp_line (rows-1);
					wind_update (END_UPDATE);
					set_clip (FALSE, &work_area);
					change = FALSE;
				}
				else if (change)
				{
					set_clip (TRUE, &work_area);
					wind_update (BEG_UPDATE);
					disp_line (distnt (row_offset, end_ptr, LINES, TRUE) -1);
					wind_update (END_UPDATE);
					set_clip (FALSE, &work_area);
					change = FALSE;
				}
		}
		else
			change = FALSE;
		curs_on ();
		do 
		{
/* Poll Serial Port */
			if (rs_stat (card) & 0x0100)
			{
				curs_off ();
				do
				{
					h0 = rs_in (card); 			/* mask off status*/
					if (! (h0 & 0xff00))
					{
						insert (h0 & 0xff); /* mask off status*/
						if (em_toggle)
							rs_out (card, h0);
						if (write_flag)
						{
							write (op_hndl, &h0, 1);
							if (lfo_toggle && h0 == '\r')
							{
								h0 = '\n';
								write (op_hndl, &h0, 1);
							}
						}
					}
					change = TRUE;
				}
				while (rs_stat (card) & 0x0100);
				curs_on ();
			}
			ev_mwitch = evnt_multi (ev_mflags, 2, 0x01, 0x01,
				ev_moflags, work_area.g_x, work_area.g_y,
				work_area.g_w, work_area.g_h,
				0,0,0,0,0,
				ad_rmsg,
				LLOWD(delay), LHIWD(delay),
				&ev_mmox, &ev_mmoy,
				&ev_mmobutton, &ev_mmokstate,
				&ev_mkreturn, &ev_mbreturn);
			if (ev_mwitch & MU_MESAG)
			{
				row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
				done = hndl_mesag();		/* handle event message	*/
				if (done)
				{
					ev_moflags = TRUE;
					return (-1);
				}
			}				
			if (ev_mwitch & MU_M1)
			{
				ev_moflags = ! ev_moflags;
				if (ev_moflags)
					ev_mflags |= MU_BUTTON;
				else
				{
					ev_mflags &= ~MU_BUTTON;
					ev_mwitch &= ~MU_BUTTON;
				}
			}
			if (trans_flag)
			{
				curs_off ();
				if (! eof (op_hndl))
				{
					readln (op_hndl, buf, LENGTH);
					if (! du_toggle)
					{
						insert (lfi_toggle);
						ins_ln (buf);
						change = TRUE;
					}
					sendln (buf);
				}
				else
				{
					if (distnt (start_ptr, end_ptr, LINES, FALSE) > rows)
						row_ptr = sub_rptr (end_ptr, LINES, rows);
					else
						row_ptr = start_ptr;
					stop_trans ();	/* close trans. file , update info field */
				}
				curs_on ();
			}
			else if (ev_mwitch & MU_KEYBD)
			{
				curs_off ();
				if ( ! du_toggle)
				{
					insert (ev_mkreturn & 0x0ff);
					if (write_flag)
						write (op_hndl, &ev_mkreturn, 1);
				}
				curs_on ();
				sendc (ev_mkreturn & 0x0ff);
				if ((ev_mkreturn & 0xff) == '\r' && lfo_toggle)
				{
					ev_mkreturn = '\n';
					sendc (ev_mkreturn);
					if (write_flag && ! du_toggle)
						write (op_hndl, &ev_mkreturn, 1);
				}
				change = TRUE;
				if (ev_mkreturn == 0x1a) /* eof char ?	*/
					ready = TRUE;
			}
#if	(VERSION & DOUBLE_CLICK)
			if (ev_mwitch & MU_BUTTON)
			{
				if (ev_mbreturn == 1)
				{
				    do
				    {
					ev = evnt_multi (0x12, 2, 0x01, 0x01,
						0,0,0,0,0,0,0,0,0,0,
						ad_rmsg,0,0,
						&ev_mmox, &ev_mmoy,
						&ev_mmobutton, &ev_mmokstate,
						&ev_mkreturn, &ev_mbreturn);
						if (ev & MU_MESAG)
						{
							row_offset = distnt (start_ptr, row_ptr, LINES, TRUE);
							done = hndl_mesag();		/* handle event message	*/
							if (done)
							{
								ev_moflags = TRUE;
								return (-1);
							}
						}				
				    }
				    while (!(ev & MU_BUTTON));
				    if (ev_mbreturn == 2)
				    {				
					if (trans_flag)
					{
						if (distnt (start_ptr, end_ptr, LINES, FALSE) > rows)
							row_ptr = sub_rptr (end_ptr, LINES, rows);
						else
							row_ptr = start_ptr;
						stop_trans ();	
					}
					else
					{
						gl_rmsg[0] = WM_CLOSED;		/* Simulate wdw close */
						gl_rmsg[4] = gl_itemterm;
						hndl_mesag();
						ev_moflags = TRUE;
						return (-1);
					}
				    }
				}
				else
				{				
					if (trans_flag)
					{
						if (distnt (start_ptr, end_ptr, LINES, FALSE) > rows)
							row_ptr = sub_rptr (end_ptr, LINES, rows);
						else
							row_ptr = start_ptr;
						stop_trans ();
					}
					else
					{
						gl_rmsg[0] = WM_CLOSED;		/* Simulate wdw close */
						gl_rmsg[4] = gl_itemterm;
						hndl_mesag();
						ev_moflags = TRUE;
						ev_moflags = TRUE;
						return (-1);
					}
				}
			}
#endif
		}
		while (! change && ! ready);

	}
	while (!ready);
	ev_moflags = TRUE;
	return (0);
}



/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Type Event Handler			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	term			*/
/*------------------------------*/
term()
{
	BOOLEAN	done;

	/**/					/* loop handling user	*/
	/**/					/*   input until done	*/
	done = FALSE;				/*   -or- if DESKACC	*/
	while( !done )				/*   then forever	*/
	{
		ev_which = evnt_mesag(ad_rmsg);	/* wait for message	*/
#if (VERSION & ACCESSORY)
		wind_update(BEG_UPDATE);	/* begin window update	*/
#endif

 		done = hndl_mesag();		/* handle event message	*/
		if (done == -1)
			comm ();		/* communicate		*/
#if	(VERSION & ACCESSORY)
		else
			wind_update(END_UPDATE);/* end window update	*/
		done = FALSE;	/* never exit loop for desk accessory	*/
#endif
	}
}


/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Termination				     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	term_term		*/
/*------------------------------*/
term_term()
{
#if	(VERSION & ACCESSORY)
	return;				/* desk accessory never ends	*/
#else
	v_clsvwk( vdi_handle );		/* close virtual work station	*/
	menu_bar (0x0L, FALSE);		/* close menue bar		*/
	appl_exit();			/* application exit		*/
#endif
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Initialization			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/

/*------------------------------*/
/*	pict_init		*/
/*------------------------------*/
VOID 
pict_init()
{
	LONG	tree;
	WORD	tr_obj, nobj;

	rsrc_gaddr(R_TREE, TERMINFO, &tree);
	trans_gimage(tree, TERMIMG);
/*	rsrc_gaddr(R_TREE, DOODPEND, &tree);
	for (tr_obj = DOODPFIN; tr_obj <= DOODEBRD; tr_obj++)
	{
		trans_gimage(tree, tr_obj);
		LWSET(OB_TYPE(tr_obj), G_USERDEF);
		nobj = tr_obj - DOODPFIN;
		brushub[nobj].ub_code = drawaddr;
		brushub[nobj].ub_parm = LLGET(OB_SPEC(tr_obj));
		LLSET(OB_SPEC(tr_obj), ADDR(&brushub[nobj]));	
	}
*/
}

/*------------------------------*/
/*	term_init		*/
/*------------------------------*/
WORD
term_init()
{
	WORD	i;
	WORD	work_in[11];

	gl_apid = appl_init();			/* initialize libraries	*/
	if (! rsrc_load (ADDR(M_RSC)))
	{
		graf_mouse (ARROW, 0x0L);
		form_alert (1, 	ADDR (M_ERR4));
		return (FALSE);
	}

#if	(VERSION & ACCESSORY)
	wind_update(BEG_UPDATE);
#endif
	for (i=0; i<10; i++)
	{
		work_in[i]=1;
	}
	work_in[10]=2;
	gem_handle = graf_handle(&gl_wchar,&gl_hchar,&gl_wbox,&gl_hbox);
	vdi_handle = gem_handle;
	v_opnvwk(work_in,&vdi_handle,work_out);	/* open virtual work stn*/
	term_size = work_out[48];		/* get system font hbox	*/
	lowr_mfdb.mp = 0x0L;			/* lower and upper scroll */
	upr_mfdb.mp = 0x0L;			/* area physical devices  */

#if	(VERSION & ACCESSORY)			/* enter term in menu	*/
	gl_itemterm = menu_register(gl_apid, ADDR(M_TACC) );
#else
	if (vdi_handle == 0)
		return(FALSE);
#endif
	/**/					/* init. message address*/
	ad_rmsg = ADDR((BYTE *) &gl_rmsg[0]);
	pict_init ();
	/* initialize menu	*/
	rsrc_gaddr(R_TREE, TERMMENU, &gl_menu);
	/* show menu		*/
	menu_bar(gl_menu, TRUE);	

 	wind_get(DESK, WF_WXYWH, &gl_xfull, &gl_yfull, &gl_wfull, &gl_hfull);
	return(TRUE);
}

/*

Page*/
/************************************************************************/
/************************************************************************/
/****								     ****/
/****			    Main Program			     ****/
/****								     ****/
/************************************************************************/
/************************************************************************/


/*------------------------------*/
/*	GEMAIN			*/
/*------------------------------*/
GEMAIN ()
{
	if (term_init())			/* initialization	*/
	{
#if	(VERSION & ACCESSORY)
		wind_update(END_UPDATE);
		term ();
#else						/* simulate AC_OPEN	*/
		gl_rmsg[0] = AC_OPEN;
		gl_rmsg[4] = gl_itemterm;
		hndl_mesag();
		if (! comm ())
			term ();
		term_term();			/* termination		*/
#endif
	}
#if 	(VERSION & ACCESSORY)
		wind_update(END_UPDATE);
#endif
}
