#pragma once

#include "lip_handle.h"
#include "lip_except.h"


namespace lip {


	class events : private boost::noncopyable
	{
	public:
		typedef enum { event_unknown, event_first, event_second, event_timeout, event_message } event_type;
	private:
		const handle handle_;
		static event_type await_event (const unsigned int n, const HANDLE* const h, const unsigned int timeout, const DWORD flags)
		{	_ASSERT ((n == 1) || (n == 2));
			switch (::MsgWaitForMultipleObjects (n, h, FALSE, timeout, flags)) {
				case WAIT_TIMEOUT : return event_timeout;
				case WAIT_ABANDONED : throw_error (ERROR_INVALID_PARAMETER);
				case WAIT_OBJECT_0 : return event_first;
				case WAIT_OBJECT_0 + 1 : if (n == 2) return event_second;
				//lint -fallthrough
				case WAIT_OBJECT_0 + 2 : return event_message;
				case WAIT_FAILED : throw_last_error (); 
				default: break; }
		 return event_unknown; } //lint !e533
		static event_type await_event (const unsigned int n, const HANDLE* const h, const unsigned int timeout)
		{	_ASSERT ((n == 1) || (n == 2));
			switch (::WaitForMultipleObjects (n, h, FALSE, timeout)) {
				case WAIT_TIMEOUT : return event_timeout;
				case WAIT_OBJECT_0 : return event_first;
				case WAIT_OBJECT_0 + 1 : if (n == 2) return event_second;
				//lint -fallthrough
				case WAIT_ABANDONED : throw_error (ERROR_INVALID_PARAMETER);
				case WAIT_FAILED : throw_last_error (); 
				default: break; }
			return event_unknown; } //lint !e533
		
	public:
		inline events () : handle_ (::CreateEvent (NULL, TRUE, FALSE, NULL)) { if (! valid ()) throw_last_error (); }
		inline bool valid () const throw () { return handle_.valid (); }
		inline const HANDLE data () const throw () { return handle_.data (); }
		inline void set () const { _ASSERT (valid ()); if (! ::SetEvent (data ())) throw_last_error (); }
		inline void reset () const { _ASSERT (valid ()); if (! ::ResetEvent (data ())) throw_last_error (); }
		inline event_type wait (const unsigned int timeout = INFINITE) const
			{ _ASSERT (valid ()); const HANDLE h (handle_.data ()); return await_event (1, &h, timeout); }
		inline event_type wait (const events& ev, const unsigned int timeout = INFINITE) const
			{	_ASSERT (valid ()); _ASSERT (ev.valid ()); HANDLE h [2]; h [0] = data (); h [1] = ev.data ();
				return await_event (2, h, timeout); }
		inline event_type msg_wait (const unsigned int timeout = INFINITE, const DWORD flags = QS_ALLEVENTS) const
			{ _ASSERT (valid ()); const HANDLE h (data ()); return await_event (1, &h, timeout, flags); }
		inline event_type msg_wait (const events& ev, const unsigned int timeout = INFINITE, const DWORD flags = QS_ALLEVENTS) const
			{	_ASSERT (valid ()); _ASSERT (ev.valid ()); HANDLE h [2]; h [0] = data (); h [1] = ev.data ();
				return await_event (2, h, timeout, flags); }

	};

		
}; //lint !e19
