#pragma once


namespace lip {

	inline void throw_error (const long l) { throw MAKE_HRESULT (SEVERITY_ERROR, FACILITY_ITF, l); }
	inline void throw_error (const unsigned long l) { throw MAKE_HRESULT (SEVERITY_ERROR, FACILITY_ITF, l); }
	inline void throw_last_error () { throw_error (::GetLastError ()); }

	inline void maybe_throw_error (const long l) { if (l != NO_ERROR) throw MAKE_HRESULT (SEVERITY_ERROR, FACILITY_ITF, l); }
	inline void maybe_throw_error (const unsigned long l) { if (l != NO_ERROR) throw MAKE_HRESULT (SEVERITY_ERROR, FACILITY_ITF, l); }
	inline void maybe_throw_last_error () { maybe_throw_error (::GetLastError ()); }
	
	
	class exception
	{
	public:
		static std::wstring get_system_error_text (const DWORD err)
			{	wchar_t* buf = NULL; std::wstring txt;
				if (::FormatMessageW (	FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_IGNORE_INSERTS,	
										NULL, err, MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT), 
										reinterpret_cast <LPWSTR> (&buf), 0, NULL)) { txt = buf; ::LocalFree (buf); }
				return txt; }
	private:
		std::wstring text_;
		HRESULT code_;
	protected:
		inline void numeric_error (const DWORD n)
			{ try	{ if (n == 0) clear (); else { std::wostringstream out;
						out << L"Exception " << std::setiosflags (std::ios_base::hex) << n; text_ = out.str (); }
					} catch (...) { text_ = L"Catestrophic Error"; } }
		inline void standard_error (const DWORD n)
			{	try { text_ = get_system_error_text (n); } catch (...) { }
				if (text_.empty ()) numeric_error (n); }
	public:
		inline exception () : code_ (S_OK) { }
		inline exception (const exception& ae) : code_ (ae.code_), text_ (ae.text_) { }
		explicit inline exception (const HRESULT hr, const std::wstring& txt) : code_ (hr), text_ (txt) { }
		explicit inline exception (const std::wstring& txt) : code_ (txt.empty () ? S_OK : E_FAIL), text_ (txt) { }
		explicit inline exception (const char* p) : code_ ((p == NULL) ? S_OK : E_FAIL) { if (p != NULL) text_ = CA2W (p); }
		explicit inline exception (const HRESULT hr) : code_ (hr) { standard_error (HRESULT_CODE (hr)); }
		explicit inline exception (const DWORD err) : code_ (MAKE_HRESULT (SEVERITY_ERROR, FACILITY_ITF, err))
			{ standard_error (err); }
		virtual inline const std::wstring text() const { return text_; }
		virtual inline const wchar_t* c_str() const { return text_.c_str (); }
		virtual inline const char *what() const { return CW2A (text_.c_str ()); }
		virtual inline HRESULT result () const throw () { return code_; }
		virtual inline DWORD error () const throw () { return HRESULT_CODE (code_); }
		inline bool succeeded () const { return text_.empty () || SUCCEEDED (code_); }
		inline bool failed () const { return ! succeeded (); }
		inline bool cancelled () const throw () { return (HRESULT_CODE (code_) == ERROR_CANCELLED); } 
		inline void clear () { text_.clear (); code_ = S_OK; }
	};
	
	inline void report_exception (const exception& err) { ::MessageBoxW (::GetDesktopWindow (), err.c_str (), L"Error", MB_ICONERROR); }
	inline void report_exception (const HRESULT hr) { exception ex (hr); report_exception (ex); }
	inline void report_exception (const std::exception& err) { exception ex (err.what ()); report_exception (ex); }
};	//lint !e19
