#pragma once
#include "lip_except.h"
#include "lip_buffer.h"
#include "lip_vest.h"


namespace lip {

	inline long decode_shell_execute (const HINSTANCE hi)
#pragma warning (push)
#pragma warning (disable: 4311) // compiler winges about reinterpret_cast but doesn't support long long; has its cake and eats it.	
		{	switch (reinterpret_cast <int> (hi)) {
				case 0 : return ERROR_NO_SYSTEM_RESOURCES;
				case ERROR_FILE_NOT_FOUND : case ERROR_PATH_NOT_FOUND : case ERROR_BAD_FORMAT : return reinterpret_cast <int> (hi);
				case SE_ERR_ACCESSDENIED : return ERROR_ACCESS_DENIED;
				case SE_ERR_ASSOCINCOMPLETE : return ERROR_INVALID_NAME;
				case SE_ERR_DDEBUSY : return ERROR_BUSY;					
				case SE_ERR_DDEFAIL : return ERROR_DDE_FAIL;
				case SE_ERR_DDETIMEOUT : return ERROR_TIMEOUT;					
				case SE_ERR_DLLNOTFOUND : return ERROR_DLL_NOT_FOUND;					
				case SE_ERR_NOASSOC : return ERROR_NO_ASSOCIATION;					
				case SE_ERR_OOM	: return ERROR_NOT_ENOUGH_MEMORY;					
				case SE_ERR_SHARE : return ERROR_SHARING_VIOLATION;					
				default : break; }
#pragma warning (pop)
			return NO_ERROR; }
	inline long launch_executable (const wchar_t* const command)
		{	return decode_shell_execute (::ShellExecute (NULL, L"open", command, NULL, NULL, SW_SHOWNORMAL)); }
	inline std::wstring get_current_directory ()
		{	DWORD len = ::GetCurrentDirectory (0, NULL);
			_ASSERT (len > 0);
			temp_string <wchar_t> buffer (len);
			const DWORD length = ::GetCurrentDirectory (len, buffer.get ());
			if (length == 0 || length >= MAX_PATH) throw_last_error ();
			return std::wstring (buffer.get ()); }
	inline void delete_file (const std::wstring& file)
		{ if (! ::DeleteFile (file.c_str ())) ::MoveFileEx (file.c_str (), NULL, MOVEFILE_DELAY_UNTIL_REBOOT); }
		

	template <class T> class temp_io_format
	{
	private:
		T& input_; //lint !e1725
		std::ios_base::fmtflags flags_;
		temp_io_format (); //lint !e1704
		temp_io_format (const temp_io_format& io); //lint !e1704
		temp_io_format& operator = (const temp_io_format& io);
	public:
		explicit temp_io_format (T& input) : input_ (input), flags_ (input.flags ()) { }
		~temp_io_format () throw () { try { input_.flags (flags_); } catch (...) { } }
		
		std::ios_base::fmtflags flags () const { return input_.flags (); }
		bool is_set (const std::ios_base::fmtflags flag) const { return ((input_.flags () & flag) != 0); }
		std::ios_base::fmtflags set (const std::ios_base::fmtflags flag) 
			{ return input_.flags (static_cast <std::ios_base::fmtflags> (flags () | flag)); }
		std::ios_base::fmtflags reset (const std::ios_base::fmtflags flag)
			{ return input_.flags (static_cast <std::ios_base::fmtflags> (flags () & ~flag)); } //lint !e502
	};
	


	class temp_file_name
	{
	private:
		static std::wstring path_;
	public:
		inline temp_file_name (const wchar_t* const path = NULL) { if ((path != NULL) && path_.empty ()) path_ = path; } //lint !e1931
		inline explicit temp_file_name (const std::wstring& path) { if (path_.empty ()) path_ = path; }
		static std::wstring get_path ()
			{	if (path_.empty ()) { wchar_t path [_MAX_PATH - 12];
					const DWORD dw = ::GetTempPath (_MAX_PATH - 14, path);
					if (dw == 0) throw_last_error ();
					if (dw > _MAX_PATH - 14) throw E_ABORT;
					path_ = path; } 
				return path_; }
		std::wstring get_file (const wchar_t* const prefix = L"~LI")
			{	_ASSERT (prefix != NULL); _ASSERT (wcslen (prefix) < 4);
				wchar_t	file [_MAX_PATH + 1];
				const unsigned int u = ::GetTempFileName (get_path ().c_str (), prefix, 0, file); 
				if (u == 0) throw_last_error ();
				return file; }
		static std::wstring get (const wchar_t* const path = NULL) { temp_file_name tf (path); return tf.get_file (); }
		static std::wstring get (const std::wstring& path) { temp_file_name tf (path); return tf.get_file (); }
	};
	
	
	
	class files_to_delete
	{
	private:
		string_vest	files_;
	public:
		files_to_delete () { }
		~files_to_delete () throw () { try { clear (); } catch (...) { } }
		void push_back (const std::wstring& file) { files_.push_back (file); }
		void clear () { std::for_each (files_.begin (), files_.end (), delete_file); }
	};



	template <class T> class binary_file // should this be inherited from handle, above?
	{
	public:
		typedef enum { plain, ro, temp, exist, fresh } file_type;
	private:
		HANDLE	h_;
		binary_file (); //lint !e1704
		binary_file (const binary_file& b); //lint !e1704
	public:
		explicit binary_file (const std::wstring& name, const file_type ft = plain) : h_ (INVALID_HANDLE_VALUE)
			{	std::wstring n (name);
				if ((n.find (L'\\') == std::wstring::npos) && (n.find (L':') == std::wstring::npos))
					n = lip::temp_file_name::get_path () + name;
				h_ = ::CreateFile (	n.c_str (), 
									(ft == ro) ? GENERIC_READ : (GENERIC_READ | GENERIC_WRITE),	//lint !e40
									FILE_SHARE_READ,
									NULL,
									((ft == ro) || (ft == exist)) ? OPEN_EXISTING : ((ft == fresh) ? CREATE_NEW : OPEN_ALWAYS),	//lint !e40
									(ft == temp) ? 	//lint !e40
										(FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_DELETE_ON_CLOSE | FILE_FLAG_SEQUENTIAL_SCAN) :
										FILE_FLAG_SEQUENTIAL_SCAN,
									NULL);
				if (h_ == INVALID_HANDLE_VALUE) throw_last_error (); }
		~binary_file () throw () { try { clear (); } catch (...) { } }

		bool empty () const throw () { return h_ == INVALID_HANDLE_VALUE; } 
		bool valid () const throw () { return ! empty (); } 
		bool operator ! () const throw () { return ! valid (); }
		void clear () { if (valid ()) { if (! ::CloseHandle (h_)) throw_last_error (); h_ = INVALID_HANDLE_VALUE; } }

		void read (T* p, const size_t count = 1) const
			{	if (sizeof (T) * count >= ULONG_MAX) throw_error (ERROR_BAD_LENGTH);
				DWORD got; const DWORD size = sizeof (T) * count;
				_ASSERT (valid ());
				_ASSERT (! ::IsBadWritePtr (p, size));
				if (! ::ReadFile (h_, p, size, &got, NULL)) throw_last_error ();
				if (got != size) throw_last_error (); }
		temp_buffer <T> read (const size_t count = 1) const
			{ temp_buffer buf <T> (count); get (buf.get (), count); return buf; }
		void write (const T* const p, const size_t count = 1) const
			{	if (sizeof (T) * count >= ULONG_MAX) throw_error (ERROR_BAD_LENGTH);
				DWORD writ; const DWORD size = static_cast <DWORD> ((sizeof (T) * count) & 0xFFFFFFFF);
				_ASSERT (valid ());
				_ASSERT (! ::IsBadReadPtr (p, size));
				if (! ::WriteFile (h_, p, size, &writ, NULL)) throw_last_error ();
				if (writ != size) throw_last_error (); }
	};

	
		
}; //lint !e19
