#pragma once

namespace lip {

	class handle : private boost::noncopyable
	{
	private:
		HANDLE handle_;
	public:
		inline handle () throw () : handle_ (INVALID_HANDLE_VALUE) { }
		explicit inline handle (const HANDLE h) throw () : handle_ (h) { _ASSERT (valid ()); }
		inline ~handle () throw () { try { clear (); } catch (...) { } } //lint !e1740
		
		inline void clear () { ::CloseHandle (handle_); handle_ = INVALID_HANDLE_VALUE; }
		inline void init (const HANDLE h) throw () { _ASSERT (empty ()); handle_ = h; _ASSERT (valid ()); }
		inline HANDLE data () const throw () { _ASSERT (valid ()); return handle_; } //lint !e1763
		inline bool valid () const throw () { return ! empty (); }
		inline bool empty () const throw () { return (handle_ == NULL) || (handle_ == INVALID_HANDLE_VALUE); }
		inline operator HANDLE () const throw () { _ASSERT (valid ()); return handle_; } //lint !e1930 !e1763
	};

	
}; //lint !e19
