#pragma once
#include "lip_except.h"

namespace lip {

		
	
	class help
	{
	private:
		mutable bool launched_;
		std::wstring file_;
		HWND main_;
		void cmd (const UINT command, ULONG_PTR data = NULL) const
			{	_ASSERT (! file_.empty ()); 
				if (! ::WinHelp (main_, file_.c_str (), command, data)) throw_last_error ();
				launched_ = true;
			}
	public:
		help () : launched_ (false), main_ (NULL) { }
		~help () throw () { if (launched_) try { cmd (HELP_QUIT); } catch (...) { } main_ = NULL; }
		void init (const HWND main, const std::wstring& file)
			{ _ASSERT (! launched_); _ASSERT (! file.empty ()); file_ = file; main_ = main; }
		void contents () const { cmd (HELP_CONTENTS); } 
		void index () const { cmd (HELP_INDEX); }
		void context (const int id) const
			{ _ASSERT (id > 0); const ULONG_PTR data = static_cast <ULONG_PTR> (id); cmd (HELP_CONTEXT, data); } 
	};
	
	
	
}; //lint !e19
