#pragma once


namespace lip {

	
	class critical		// replace with http://www.cl.cam.ac.uk/research/srg/netos/lock-free/ ?
	{
	private:
		CRITICAL_SECTION critic_;
		bool inited_;
	public:
		inline critical () throw () : inited_ (false) { ::memset (&critic_, 0, sizeof (CRITICAL_SECTION)); }
		inline ~critical () throw () { term (); }
		inline void lock () throw () { _ASSERT (valid ()); ::EnterCriticalSection (&critic_); }
		inline void unlock () throw () { _ASSERT (valid ()); ::LeaveCriticalSection (&critic_); }
		inline bool init () throw ()
			{	inited_ = FALSE != ::InitializeCriticalSectionAndSpinCount (&critic_, 4000); return inited_; }
		inline void term () throw ()
			{	if (valid ()) { ::DeleteCriticalSection (&critic_); ::memset (&critic_, 0, sizeof (CRITICAL_SECTION)); }
				inited_ = false; }
		bool valid () const throw () { return inited_; }
	};

	
	template <typename pointed> class locker : private boost::noncopyable
	{
	private:
		pointed*			item_;
		volatile critical*	gate_;
	private:
		locker ();
		inline void lock () throw ()
			{ _ASSERT (! ::IsBadWritePtr ((LPVOID) gate_, sizeof (critical))); const_cast <critical*> (gate_) -> lock (); }
	public:
		explicit inline locker (volatile pointed& obj, volatile critical& mtx) throw ()
			: item_ (const_cast <pointed*> (&obj)), gate_ (&mtx) { lock (); }
		inline ~locker () throw ()
			{ _ASSERT (! ::IsBadWritePtr ((LPVOID) gate_, sizeof (critical))); const_cast <critical*> (gate_) -> unlock (); }
		inline pointed* operator -> () throw () { _ASSERT (! ::IsBadReadPtr (item_, sizeof (pointed))); return item_; }
		inline const pointed& operator* () const throw () { _ASSERT (! ::IsBadReadPtr (item_, sizeof (pointed))); return *item_; }
		inline pointed& operator* () throw () { _ASSERT (! ::IsBadWritePtr (item_, sizeof (pointed))); return *item_; }
	};
	

	class interlocked : private boost::noncopyable
	{
	private:
		volatile long* counter_;
		interlocked (); //lint !e1704
	public:
		inline explicit interlocked (volatile long* counter) throw () : counter_ (counter)
			{ _ASSERT (counter != NULL); if (counter_) ::InterlockedIncrement (counter_); }
		inline ~interlocked () throw () { if (counter_) ::InterlockedDecrement (counter_); counter_ = NULL; }
	};
	
	
};	//lint !e19
