#pragma once
#include "lip_except.h"

namespace lip {

		

	class global_memory
	{
	private:
		HGLOBAL handle_;
		unsigned int locked_;
		void* ptr_;
		void verify () const throw () { _ASSERT ((locked_ == 0) ^ (ptr_ != NULL)); _ASSERT (valid ()); }
	public:
		inline global_memory () throw () : handle_ (NULL), locked_ (0), ptr_ (NULL) { }
		explicit inline global_memory (const HGLOBAL h) throw () : handle_ (h), locked_ (0), ptr_ (NULL) { _ASSERT (valid ()); }
		explicit inline global_memory (const size_t sz) : handle_ (NULL), locked_ (0), ptr_ (NULL)
			{ alloc (sz); }
		inline ~global_memory () throw () 
			{ 
				if (valid ()) 
					if (locked ()) 
						try { unlock (true); } catch (...) { } 
						
				try { free (); } catch (...) { } 
			}
		
		inline bool locked () const throw () { return (locked_ > 0); }
		inline bool empty () const throw () { return (handle_ == NULL); }
		inline bool valid () const throw () { return ! empty (); } //line -e634

		inline void alloc (const size_t sz)
			{	_ASSERT (empty ());
				handle_ = ::GlobalAlloc (GMEM_MOVEABLE | GMEM_ZEROINIT, sz);
				if (! valid ()) throw_last_error (); 
				verify (); 
			}
		inline void* lock ()
			{	verify (); 
				if (locked_++ == 0) { ptr_ = ::GlobalLock (handle_); if (ptr_ == NULL) throw_last_error (); }
				return ptr_; 
			}
		inline void unlock (const bool force = false)
			{	_ASSERT (locked ());
				verify (); 
				if (--locked_ > 0) if (! force) return;
				if (! ::GlobalUnlock (handle_)) maybe_throw_last_error ();
				ptr_ = NULL; 
				locked_ = 0; 
			}
		inline void free ()
			{	_ASSERT (locked_ == 0); 
				_ASSERT (valid ());
				if (::GlobalFree (handle_)) throw_last_error (); 
				handle_ = NULL; 
			}
		
		inline void clear () { if (valid ()) { if (locked ()) unlock (true); free (); } }
		inline const void* get () const throw () { return ptr_; }
		inline void* get () throw () { return ptr_; }
		size_t size () const throw () { verify (); return ::GlobalSize (handle_); }
	};

	
}; //lint !e19
