#pragma once

#include "lip_event.h"


namespace lip {

		
	struct no_notification
	{
		inline no_notification () throw () { }
		explicit inline no_notification (const unsigned int) throw () { }
		inline ~no_notification () throw () { }
		bool inline await_notification () const volatile throw () { return true; }
		bool inline notify () const volatile throw () { return true; }
	};
	
	
	const unsigned int default_event_timeout = 250;
	

	class timeout_notification
	{
	private:
		volatile unsigned int ennui_;
	public:
		inline timeout_notification () throw () : ennui_ (default_event_timeout) { }
		inline timeout_notification (const timeout_notification& to) throw () : ennui_ (to.get_timeout ()) { }
		inline timeout_notification& operator = (const timeout_notification& to) throw () { ennui_ = to.ennui_; return *this; } //lint !e1529
		explicit inline timeout_notification (const unsigned int timeout) throw () : ennui_ (timeout) { }
		inline ~timeout_notification () throw () { }
		inline bool await_notification () const volatile throw () { ::Sleep (ennui_); return true; }
		inline unsigned int get_timeout () const volatile throw () { return ennui_; }
		inline void set_timeout (const unsigned int timeout) volatile throw () { ennui_ = timeout; }
		inline bool notify () const volatile throw () { return true; }
	};
	

	class event_notification : boost::noncopyable
	{	
	private:
		events event_;
		const unsigned int ennui_;
	public:
		inline event_notification () : ennui_ (default_event_timeout) { }
		inline explicit event_notification (const unsigned int timeout) : ennui_ (timeout) { }
		inline void notify () const  { event_.set (); }
		inline void toggle (const unsigned int ennui = INFINITE) const 
			{ event_.set (); ::Sleep ((ennui == INFINITE) ? ennui_ : ennui); event_.reset (); }
		void await_notification () const { event_.wait (ennui_); }
		inline unsigned int timeout () const throw () { return ennui_; }
	};

};	//lint !e19
