#pragma once

#include "lip_except.h"
#include "lip_notify.h"
#include "lip_lock.h"


namespace lip {


	struct stage_component;
	typedef unsigned int stage_index;
	
	typedef enum { category_unstarted, category_normal, category_finished, category_failed } stage_categories;
	
	inline bool is_inactive_stage (const stage_categories category_) throw ()
		{ return (category_ == category_finished) || (category_ == category_unstarted); }
	


	class activity_context
	{
	private:
		stage_index		final_stage_;
		stage_index		error_stage_;
		exception		booboo_;
	public:
		inline activity_context () : final_stage_ (0), error_stage_ (0) { }
		explicit inline activity_context (	const stage_index oops_stage,
											const exception& ex = exception ()) :
			final_stage_ (oops_stage), error_stage_ (oops_stage), booboo_ (ex) { }
		virtual inline ~activity_context () throw () { };

		inline void final_stage (const stage_index final) throw () { final_stage_ = final; } 
		inline stage_index final_stage () const throw () { return final_stage_; }
		inline void booboo (const stage_index stage, const exception& ex)
			{ if (booboo_.succeeded ()) { booboo_ = ex; error_stage_ = stage; } }
		inline const exception booboo () const { return booboo_; }
		inline stage_index error_stage () const throw () { return error_stage_; }
		inline bool succeeded () const throw () { return booboo_.succeeded () && (error_stage () == 0); }
		inline bool failed () const throw () { return ! succeeded (); }
		inline virtual bool verify_valid () const { return true; }
	};
	
		
	template <typename T, T stage> struct stage_plan
		{
			T callback (boost::shared_ptr <activity_context>&) const; 
			T abort (boost::shared_ptr <activity_context>&, const exception& ) const;
			bool cancel (boost::shared_ptr <activity_context>&) const; 
		};

	template <typename T, T stage>
	inline T stage_plan <T, stage>::callback (boost::shared_ptr <activity_context>&) const
		{ _ASSERT (FALSE); return static_cast <T> (stage + 1); }
	template <typename T, T stage>
	inline T stage_plan <T, stage>::abort (boost::shared_ptr <activity_context>&, const exception& ) const
		{ return static_cast <T> (stage + 1); }
	template <typename T, T stage>
	inline bool stage_plan <T, stage>::cancel (boost::shared_ptr <activity_context>&) const
		{ return true; }
		
		
		
		 

	struct stage_component
		{
			virtual stage_index callback (boost::shared_ptr <activity_context>&) const = 0;
			virtual stage_index abort (boost::shared_ptr <activity_context>&, const exception&) const = 0;
			virtual bool cancel (boost::shared_ptr <activity_context>&) const = 0;
			virtual stage_categories category () const throw () = 0; 
		};
	
	

	template <	typename stage, stage_categories stage_category, stage current_stage >
		struct stage_data : public stage_component, private stage_plan < stage, current_stage >
	{
		virtual stage_index callback (boost::shared_ptr <activity_context>& context) const
			{ return static_cast <stage_index> (stage_plan < stage, current_stage >::callback (context)); }
		virtual stage_index abort (boost::shared_ptr <activity_context>& context, const exception& error) const
			{ return static_cast <stage_index> (stage_plan < stage, current_stage >::abort (context, error)); }
		virtual bool cancel (boost::shared_ptr <activity_context>& context) const
			{ return stage_plan < stage, current_stage >::cancel (context); }
			
		virtual stage_categories category () const throw () { return stage_category; }
	};


	template <typename T, T starter, T maximum_stage> class stage_sequence
	{
	public:
		static bool is_valid_stage (const T stage) throw () { return (stage < maximum_stage); }
		static bool is_valid_stage (const stage_index stage) throw () { return is_valid_stage (static_cast <T> (stage)); }
		static stage_index start_stage () throw () { return starter; }
	public:	
		typedef typename T stage_type;
		typedef typename boost::array <typename stage_component*, maximum_stage> stage_array;
	protected:
		stage_array stages_;
	public:
		stage_sequence () throw () { stage_array blank = { NULL }; assign_sequence (blank); }
		explicit stage_sequence (const stage_array& stages) : stages_ (stages) { }
		void assign_sequence (const stage_array& stages) { stages_ = stages; }
		~stage_sequence () throw () { try { clear (); } catch (...) { } stage_array blank = { NULL }; stages_ = blank; }
		void clear () { for (stage_array::size_type i = 0; i < stages_.size (); ++i) delete stages_ [i]; }
		bool valid (const stage_index s) const throw () { return is_valid_stage (s) && (stages_ [s] != NULL); }
		stage_categories category (const stage_index s) const throw () { _ASSERT (valid (s)); return stages_ [s] -> category (); }
	};
	

	template < class schedule_specification > class stage_schedule : private schedule_specification
	{
	public:
		using schedule_specification::start_stage;
		using schedule_specification::is_valid_stage;
		using schedule_specification::category;

	private:
		inline bool valid (const stage_index stage) const throw ()			
			{ return is_valid_stage (stage) && (stages_ [stage] != NULL); }
		inline bool valid (const stage_index stage, const boost::shared_ptr <activity_context>& context) const throw ()			
			{ return valid (stage) && (! context || context -> verify_valid ()); }
	public:
		inline stage_index callback (const stage_index stage, boost::shared_ptr <activity_context>& context) const
			{ _ASSERT (valid (stage, context)); return stages_ [stage] -> callback (context); }
		inline stage_index abort (const stage_index stage, boost::shared_ptr <activity_context>& context, const exception& error) const
			{ _ASSERT (valid (stage, context)); return stages_ [stage] -> abort (context, error); }
		inline bool cancel (const stage_index stage, boost::shared_ptr <activity_context>& context) const
			{ _ASSERT (valid (stage, context)); return stages_ [stage] -> cancel (context); }
	};

		
	template < class schedule_specification > class activity
	{
	private:
		static stage_schedule <schedule_specification>	schedule_;
		bool											cancelled_, do_cancel_, catastrophe_;
		typename stage_index							current_stage_;
		boost::shared_ptr <activity_context>			parameter_;
	private:	
		inline void verify () const throw ()
			{	_ASSERT (schedule_.is_valid_stage (current_stage_)); }
	protected:		
		void process_exception (const typename exception& error) throw ()
			{	try {
					verify ();
					parameter_ -> booboo (current_stage_, error);
					current_stage_ = schedule_.abort (current_stage_, parameter_, error);
					verify ();
					return;
				} catch (...) { }
				catastrophe_ = true;
			}
	public:
		inline activity () throw () :	cancelled_ (false), do_cancel_ (false), catastrophe_ (false),
										current_stage_ (schedule_.start_stage ()), parameter_ (NULL)
			{ parameter_ = new activity_context (schedule_.unitialised_stage (), S_OK); verify (); }
		explicit inline activity (	const boost::shared_ptr <activity_context> initial_parameter) :
									cancelled_ (false), do_cancel_ (false), catastrophe_ (false),
									current_stage_ (schedule_.start_stage ()), 
									parameter_ (initial_parameter)
			{ verify ();  }
		inline ~activity () throw () { }
		inline const boost::shared_ptr <activity_context> parameter () const { return parameter_; }
		inline boost::shared_ptr <activity_context> parameter () { return parameter_; }
		inline void cancel () throw () { do_cancel_ = true; }
		inline bool has_ceased () const throw ()
			{	verify (); if (catastrophe_) return true; 
				if (current_stage_ <= schedule_.start_stage ()) return false; 
				return is_inactive_stage (schedule_.category (current_stage_)); 
			}
		void process (const bool approved) throw ()
			{	_ASSERT (! has_ceased ());
				verify ();
				try {
					if (! approved || do_cancel_) { do_cancel_ = false;	
						if (! cancelled_) if (schedule_.cancel (current_stage_, parameter_)) 
							{ cancelled_ = true; throw_error (ERROR_CANCELLED); } }
					current_stage_ = schedule_.callback (current_stage_, parameter_);
				} catch (const exception& ex) {
					process_exception (ex);
				} catch (const std::wstring& ex) {
					process_exception (exception (ex));
				} catch (const LPCTSTR ex) {
					process_exception (exception (std::wstring (ex)));
				} catch (const HRESULT ex) {
					process_exception (exception (ex));
				} catch (...) {
					process_exception (exception (::GetLastError ()));
				}
				verify ();
				if (has_ceased ()) { parameter_ -> final_stage (current_stage_); verify (); }
			}
	};

	template < class schedule_specification >
		stage_schedule < schedule_specification >
			activity < schedule_specification > :: schedule_;

		

	
	
	template <	class schedule_specification, class process_notification, class termination_notification > class activity_queue
	{
	protected:
		typedef locker <activity_queue>										guard;
		typedef locker <const activity_queue>								const_guard;
	public:
		typedef activity < schedule_specification >							work_specification;
		typedef std::deque < boost::shared_ptr < work_specification > >		activity_queue_specification;
		typedef typename activity_queue_specification::size_type			queue_size;
		typedef typename activity_queue_specification::iterator				queue_iterator;
		typedef typename activity_queue_specification::const_iterator		queue_const_iterator;
	protected:
		typedef boost::shared_ptr <work_specification>						work_ptr;
	protected:
		mutable critical						gate_;
	private:
		typename termination_notification		at_termination_;
		typename process_notification			on_activity_;
		activity_queue_specification			active_, finished_;
		volatile long							processing_;
		volatile bool							terminated_;
	private:		
		inline void init () throw () { gate_.init (); }
		inline bool no_work_to_process () const throw () { return active_.empty (); }
		inline bool all_work_completed () const throw () { return (processing_ == 0) && no_work_to_process () && finished_.empty (); }
		void clear_queue (activity_queue_specification& q) throw ()
			{ try { q.clear (); } catch (...) { } }
		void cancel_queue (activity_queue_specification& q) throw ()
			{	const queue_iterator past_it = q.end ();
				for (queue_iterator i = q.begin (); i != past_it; ++i) try { if (*i) (*i) -> cancel (); } catch (...) { } }
		work_ptr get_next_work (bool& all_done)
			{	all_done = no_work_to_process ();
				if (all_done) return work_ptr ();
				work_ptr work (active_.front ());
				active_.pop_front ();
				return work; }
		void push_to_apt_queue (work_ptr work)
			{	if (work -> has_ceased ()) finished_.push_back (work);
				else active_.push_back (work); }
		bool get_completed_activity (boost::shared_ptr <activity_context>& item) 
			{	if (finished_.empty ()) return false;
				work_ptr work (finished_.front ());
				finished_.pop_front ();
				item = work -> parameter ();
				return true; } 
		bool do_activity (const bool approved) volatile
			{	volatile interlocked incrementor (&processing_);
				bool all_done = false; 
				work_ptr work (get_next_work (all_done));
				if (all_done) { _ASSERT (! work); return true; }
				if (! work) return false;
				work -> process (approved); 
				push_to_apt_queue (work); 
				return true; }			 
		inline void cancel () { cancel_queue (active_); }
		inline void terminate () { at_termination_.notify (); }
	protected:
		inline work_ptr get_next_work (bool& all_done) volatile
			{ return guard (*this, gate_) -> get_next_work (all_done); }
		inline void push_to_apt_queue (work_ptr work) volatile
			{	_ASSERT (! ::IsBadWritePtr (work.get (), sizeof (work_specification))); 
				guard (*this, gate_) -> push_to_apt_queue (work); }
		inline void submit_activity (const boost::shared_ptr <activity_context> item)
			{	work_specification* worker = new work_specification (item);
				active_.push_back (boost::shared_ptr <work_specification> (worker)); }
		inline void get_queue_sizes (queue_size& active_size, queue_size& finished_size) const
			{ active_size = active_.size (); finished_size = finished_.size (); }
	public:
		inline activity_queue () throw () : processing_ (0), terminated_ (false) { init (); }
		~activity_queue () throw ()
			{	_ASSERT (processing_ == 0);
				clear_queue (active_); clear_queue (finished_);
				gate_.term (); }
		inline void terminate () volatile { terminated_ = true; guard (*this, gate_) -> terminate (); }
		inline void cancel () volatile { return guard (*this, gate_) -> cancel (); }
		inline bool no_work_to_process () const volatile throw () { return const_guard (*this, gate_) -> no_work_to_process (); }
		inline bool all_work_completed () const volatile throw () { return const_guard (*this, gate_) -> all_work_completed (); }
		inline bool terminated () const volatile throw () { return terminated_; }
		inline void wake_up () const volatile throw () { _on_activity.toggle (); }
		inline void submit_activity (const boost::shared_ptr <activity_context> item) volatile
			{ guard (*this, gate_) -> submit_activity (item); }
		inline bool get_completed_activity (boost::shared_ptr <activity_context>& item) volatile
			{ return guard (*this, gate_) -> get_completed_activity (item); }
		inline void get_queue_sizes (queue_size& active_size, queue_size& finished_size) const volatile
			{ guard (*this, gate_) -> get_queue_sizes (active_size, finished_size); }
		bool process (const bool approved) volatile
			{	if (! do_activity (approved)) on_activity_.await_notification ();
				return all_work_completed (); }
		bool await_completion () const volatile throw ()
			{	if (terminated ()) return false;
				{	const_guard lock (*this, gate_);
					if (! lock -> finished_.empty ()) return true;
					if (lock -> all_work_completed ()) return false; }
				const_cast <const typename termination_notification&> (at_termination_).await_notification ();
				return true; }
	};


	template < class activity_queue > class pool_worker
	{
	public:
		typedef void* RequestType;
	private:
		volatile bool approved_;
	public:
		inline pool_worker () throw () : approved_ (true) { }
		inline ~pool_worker () throw () { }
		inline BOOL Initialize (void *) const volatile throw () { return TRUE; }
		inline void Terminate (void* ) volatile throw () { approved_ = false; }
		virtual BOOL GetWorkerData (DWORD, void **) volatile throw () { return FALSE; }
		void Execute (RequestType, void *pvParam, OVERLAPPED*) volatile throw()
			{	if (approved_)
				try {
					_ASSERT (! ::IsBadWritePtr (pvParam, sizeof (activity_queue))); 
					volatile activity_queue* const action = reinterpret_cast <volatile activity_queue*> (pvParam);
					while (action -> process (approved_));
				} catch (...) { } }
	};


	template <	class schedule_specification, 
				class process_notification = timeout_notification, 
				class termination_notification = event_notification
			>
		class pool_manager
	{
	public:
		typedef activity_queue < schedule_specification, process_notification, termination_notification >	queue_type;
		typedef CThreadPool < pool_worker < queue_type > >													pool_type;
	private:
		volatile pool_type	pool_;
		volatile queue_type cue_;
	private:
		pool_manager (const pool_manager& pm); //lint !e1704
		void init (int thread_count, unsigned int max_wait)
			{	if (thread_count == 0) { SYSTEM_INFO info; ::GetSystemInfo (&info);
					thread_count = static_cast <int> (info.dwNumberOfProcessors * 5); }
				pool_type& lido (const_cast <pool_type&> (pool_));
				HRESULT hr = lido.Initialize (const_cast <queue_type*> (&cue_), thread_count); 
				if (SUCCEEDED (hr)) if (max_wait != 0) hr = lido.SetTimeout (max_wait);
				if (FAILED (hr)) throw hr; }		
	public:
		inline pool_manager () { init (0, 0); }
		explicit inline pool_manager (int thread_count, unsigned int max_wait = 0) { init (thread_count, max_wait); }
		inline ~pool_manager () throw () { try { cancel (); } catch (...) { } try { terminate (); } catch (...) { } }
		void terminate () volatile { cue_.terminate (); const_cast <pool_type&> (pool_).Shutdown (); }
		inline void cancel () volatile { cue_.cancel (); }
		inline bool get_completed_activity (boost::shared_ptr <activity_context>& item) volatile
			{ return cue_.get_completed_activity (item); }
		inline int get_thread_count () const volatile throw ()
			{ int count; const_cast <pool_type&> (pool_).GetSize (&count); return count; }
		inline bool submit_activity (const boost::shared_ptr <activity_context>& param) volatile
			{ cue_.submit_activity (param); return (const_cast <pool_type&> (pool_).QueueRequest (NULL) != FALSE); }
		inline bool no_work_to_process () const volatile throw () { return cue_.no_work_to_process (); }
		inline bool all_work_completed () const volatile throw () { return cue_.all_work_completed (); }
		inline bool terminated () const volatile throw () { return cue_.terminated (); }
		inline bool await_completion () const volatile { return cue_.await_completion (); }
		inline void get_queue_sizes (size_t& active, size_t& finished) const volatile
			{ cue_.get_queue_sizes (active, finished); }
		inline void wake_up () const throw () { return cue_.wake_up (); }
	};
};	//lint !e19
