#include <stdafx.h>
#include "lip_registry.h"





#pragma warning (push)
#pragma warning (disable: 4715)




bool lip::registry_key::read_string (const std::wstring& value, std::wstring& reply, LONG& error) const

{		
	wchar_t buffer [_MAX_PATH];
	_ASSERT (! empty ());
	DWORD len = _MAX_PATH, type = REG_SZ;
	
	error = ::RegQueryValueEx (key_, value.c_str (), NULL, &type, reinterpret_cast <BYTE*> (buffer), &len);
	
	if (error != ERROR_SUCCESS)
		return false;
		
	if (type != REG_SZ) {
	
		error = ERROR_INVALID_DATA;
		return false;
		
	}
	
	reply = buffer;
	return true;
}


std::wstring lip::registry_key::read_string (const std::wstring& value) const

{	LONG error;
	std::wstring reply;
	
	if (! read_string (value, reply, error))
		throw_error (error);
		
	return reply;
}



HRESULT lip::registry_key::read_vest (const std::wstring& value, string_vest& vest) const

{	
	_ASSERT (! empty ());
	DWORD len = 0, type = REG_MULTI_SZ;
	LONG error = ::RegQueryValueEx (key_, value.c_str (), NULL, &type, NULL, &len);
	
	if (error != ERROR_SUCCESS)
		return error;
		
	if (type != REG_MULTI_SZ)
		return ERROR_INVALID_PARAMETER;

	const unsigned int wchar_size = len / sizeof (wchar_t);		
	temp_buffer <wchar_t> buffer (wchar_size);
	error = ::RegQueryValueEx (key_, value.c_str (), NULL, &type, reinterpret_cast <BYTE*> (buffer.get ()), &len);
	
	if (error != ERROR_SUCCESS)
		return error;
		
	if (type != REG_MULTI_SZ)
		return ERROR_INVALID_DATA;

	const wchar_t* p = buffer.get ();
	const wchar_t* start = p;
	bool null = false;
	string_vest v;
	
	for (;;)
		if (*p) {
		
			null = false;
			++p;
			
		} else {
		
			if (null)
				break;
				
			null = true;
			v.push_back (start);
			start = ++p;
			
		}
		
	std::swap (v, vest);
	return ERROR_SUCCESS;

}


bool lip::registry_key::read_number (const std::wstring& value, unsigned int& reply, LONG& error) const

{	
	DWORD n = 0;
	_ASSERT (! empty ());
	DWORD len = sizeof (DWORD), type = REG_DWORD;
	
	error = ::RegQueryValueEx (key_, value.c_str (), NULL, &type, reinterpret_cast <BYTE*> (n), &len);
	
	if (error != ERROR_SUCCESS)
		return false;
		
	if (type != REG_DWORD) {
	
		error = ERROR_INVALID_DATA;
		return false;
		
	}
		
	reply = n;
	return true;
}	//lint !e953


unsigned int lip::registry_key::read_number (const std::wstring& value) const

{	LONG error;
	unsigned int reply;
	
	if (! read_number (value, reply, error))
		throw_error (error);
		
	return reply;
}


bool lip::registry_key::enumerate (unsigned int& index, std::wstring& name) const
{	
	wchar_t buffer [_MAX_PATH];
	wchar_t c [_MAX_PATH];
	
	DWORD len = _MAX_PATH;
	DWORD clen = _MAX_PATH;
	FILETIME ft;
	
	_ASSERT (! empty ());
	const LONG error = ::RegEnumKeyEx (key_, index, buffer, &len, NULL, c, &clen, &ft);
	
	if (error == ERROR_NO_MORE_ITEMS)
		return false;
	
	maybe_throw_error (error);
	_ASSERT (len < _MAX_PATH);
	buffer [len] = 0;
	name.assign (buffer);
	++index;
	return true;
}

	
