#pragma once
#include "lip_except.h"
#include "lip_file.h"

namespace lip {

	inline std::wstring load_string (const unsigned int id)
		{	TCHAR buffer [1024];
			if (! ::LoadString (::GetModuleHandle (NULL), id, buffer, 1024)) throw_last_error ();
			return buffer;
		}
		
	inline void message_box (const unsigned int id, const unsigned int id2)
		{ ::MessageBox (::GetDesktopWindow (), load_string (id).c_str (), load_string (id2).c_str (), MB_OK); }
		
		
	class resource : private boost::noncopyable
	{
	private:
		HGLOBAL h_;
		HRSRC rsc_;
		resource (); //lint !e1704
	public:
		explicit inline resource (const unsigned int id, const wchar_t* const res_type = L"RESOURCES") : h_ (NULL), rsc_ (NULL)
			{	rsc_ = ::FindResource (NULL, MAKEINTRESOURCE (id), res_type);
				if (rsc_ == NULL) throw_last_error ();
				h_ = ::LoadResource (NULL, rsc_);	
				if (h_ == NULL) throw_last_error ();
			}
		inline ~resource () throw () { try { clear (); } catch (...) { } } //lint !e1740
		
		inline void clear () { if (valid ()) ::FreeResource (h_); h_ = NULL; rsc_ = NULL; } //lint !e534
		inline const void* const get () const
			{	_ASSERT (valid ());
				const void* const p = ::LockResource (h_); 
				if (p == NULL) throw_last_error ();
				return p; } //lint !e1763
		inline bool empty () const throw () { return (h_ == NULL) && (rsc_ == NULL); }
		inline bool valid () const throw () { return (h_ != NULL) && (rsc_ != NULL); }
		inline size_t size () const throw () { _ASSERT (valid ()); return ::SizeofResource (NULL, rsc_); }
		inline void write (const std::wstring& file) const
			{ binary_file <BYTE> bin (file); bin.write (reinterpret_cast <const BYTE* const> (get ()), size ()); }
		static inline void write (const unsigned int id, const std::wstring& file, const wchar_t* const res_type = L"RESOURCES")
			{ resource mem (id, res_type); mem.write (file); }
	};
	

	
}; //lint !e19
