#pragma once
#include "lip_except.h"

namespace lip {

		

	
	class wait_cursor : boost::noncopyable
	{
	private:
		HCURSOR wait_cursor_, old_cursor_;
		HWND	window_;
		wait_cursor (); //lint !e1704
	public:
#pragma warning (push)
#pragma warning (disable: 4311 4312) // conversions of HCURSOR to long in SetClassLong; call requires it	
		explicit wait_cursor (const HWND hwnd) : wait_cursor_ (NULL), old_cursor_ (NULL), window_ (hwnd)
			{	_ASSERT (window_ != NULL);
				wait_cursor_ = ::LoadCursor (NULL, MAKEINTRESOURCE (IDC_WAIT)); //lint !e507
				if (wait_cursor_ != NULL)
					old_cursor_ = reinterpret_cast <HCURSOR> (
						::SetClassLong (window_, GCL_HCURSOR, reinterpret_cast <LONG> (wait_cursor_))); }
		~wait_cursor () throw () { try { clear (); } catch (...) { _ASSERT (FALSE); } } //lint !e1740
		void clear () {
			if (valid ()) if (! ::SetClassLong (window_, GCL_HCURSOR, reinterpret_cast <LONG> (old_cursor_)))
				maybe_throw_last_error ();
			wait_cursor_ = old_cursor_ = NULL;  window_ = NULL; }
#pragma warning (pop)
		bool empty () const throw () { return wait_cursor_ == NULL; }
		bool valid () const throw () { return ! empty (); }
	};


	class lock_window_update
	{
	private:
		bool	locked_;
		lock_window_update (); //lint !e1704
	public:
		explicit lock_window_update (const HWND hwnd) : locked_ (false) 
			{	_ASSERT (hwnd != NULL); 
				locked_ = (FALSE != ::LockWindowUpdate (hwnd));
				if (! locked_) maybe_throw_last_error (); 
			}
		~lock_window_update () throw () { if (locked_) ::LockWindowUpdate (NULL); locked_ = false; } 
	};


	
	template <class T> class restore_on_destruct
		// there's a more general CScopeHolder around
	{
	private:
		T& object_; //lint !e1725
		const T value_;
		restore_on_destruct (); //lint !e1704
		restore_on_destruct (const restore_on_destruct& rod); //lint !e1704
		restore_on_destruct& operator = (const restore_on_destruct& rod);
	public:
		explicit restore_on_destruct (T& t) : object_ (t), value_ (t) { }
		explicit restore_on_destruct (T& t, const T newval) : object_ (t), value_ (t) { t = newval; }
		~restore_on_destruct () { object_ = value_; }
	};
	
	
	
}; //lint !e19
