#pragma once

#include "lip_except.h"
#include "lip_handle.h"
#include "lip_buffer.h"
#include "lip_overlapped.h"

namespace lip {

	class path_sneak
	{
	private:
		handle directory_, port_;
		secure_buffer <BYTE> buffer_;
		bool subtree_;
		overlapped overlapped_;
		unsigned int timeout_;
	public:
		path_sneak (const bool subtree = false, const unsigned int size = 65536, const unsigned int maxtime = 0)
				: buffer_ (size), subtree_ (subtree), timeout_ (maxtime)
			{ }
		explicit path_sneak (	const std::wstring& path, unsigned int ref = 0, const bool subtree = false,
								const unsigned int size = 65536, const unsigned int maxtime = 0)
				: buffer_ (size), subtree_ (subtree), timeout_ (maxtime)
			{ associate (path, ref); }
		~path_sneak () throw () { try { clear (); } catch (...) { } }
		
		void swap (path_sneak& ps) throw ()
			{
				std::swap (directory_, ps.directory_); 
				std::swap (port_, ps.port_); 
				buffer_.swap (ps.buffer_); 
				std::swap (subtree_, ps.subtree_);
				overlapped_.swap (ps.overlapped_);
			}
		void clear () { port_.clear (); directory_.clear (); buffer_.clear (); }	
		void associate (const std::wstring& path, unsigned int ref = 0) {
			_ASSERT (! path.empty ());
			path_sneak ps;
			ps.directory_.init (::CreateFile (	path.c_str (),
												FILE_LIST_DIRECTORY, 
												FILE_SHARE_READ | FILE_SHARE_WRITE | FILE_SHARE_DELETE,
												NULL,
												OPEN_EXISTING,
												FILE_FLAG_BACKUP_SEMANTICS | FILE_FLAG_OVERLAPPED,
												NULL));
			if (ps.directory_.empty ()) throw_last_error ();
			ps.port_.init (::CreateIoCompletionPort (ps.directory_, port_, ref, 0)); 
			if (ps.port_.empty ()) throw_last_error ();
			swap (ps);
		}
		bool changes ()
			{	DWORD got;
				if (! ::ReadDirectoryChangesW (	directory_,
												buffer_.get (), 
												buffer_.size_in_bytes (), 
												subtree_,
												FILE_NOTIFY_CHANGE_FILE_NAME | FILE_NOTIFY_CHANGE_DIR_NAME | FILE_NOTIFY_CHANGE_LAST_WRITE,
												&got,
												overlapped_.ptr (),
												NULL))
					throw_last_error ();
				return got != 0;
			}
		void post_status (const unsigned int code = 0xFFFFFFFF, void* data = NULL) const
			{
				if (! ::PostQueuedCompletionStatus (port_, 0, code, reinterpret_cast <LPOVERLAPPED> (data)))
					throw_last_error ();
			}
		unsigned int timeout () const throw () { return timeout_; }
		void timeout (const unsigned u) throw () { timeout_ = u; }
		bool wait ()
			{	DWORD bytes = 0;
				ULONG_PTR key;
				LPOVERLAPPED overlapped;
				if (! ::GetQueuedCompletionStatus (port_, &bytes, &key, &overlapped, timeout_)) {
					LONG err = ::GetLastError ();
					if ((err == WAIT_TIMEOUT) || (err == NO_ERROR))
						return false;
					throw_error (err);
				}
			}
				
	};

	// PostQueuedCompletionStatus



	
}; //lint !e19
