#include <stdafx.h>
#include "lip_vest.h"
#include "lip_file.h"






std::wstring lip::quote (const std::wstring::const_iterator& start, const std::wstring::const_iterator& finish, const wchar_t quote_char)

{	std::wstring output;

	output += quote_char;
	
	for (std::wstring::const_iterator i = start; i != finish; ++i)
		if (*i == quote_char) {
		
			output += default_protect_char;
			output += quote_char;
		
		} else
		switch (*i) {
		
			case default_protect_char :
				output += default_protect_char;
				output += default_protect_char;
				break;

			case L'\r' :
				output += default_protect_char;
				output += L'r';
				break;

			case L'\n' :
				output += default_protect_char;
				output += L'n';
				break;

			case L'\t' :
				output += default_protect_char;
				output += L't';
				break;

			default :
				if (*i >= L' ')
					output += *i;
					
				break;
				
		}
		
	output += quote_char;
	return output;
}


bool lip::skip (std::wstring::const_iterator& i, const std::wstring::const_iterator& finish, const wchar_t ch)

{
	for ( ; i != finish; ++i)
		if (*i == ch) {
		
			++i;
			return true;
			
		}

	return false;
}


bool lip::skip (std::wistream& input, const wchar_t ch)

{
	if (input.good ()) {

		wchar_t in; 
		
		do {
		 
			input >> in;
			
			if (in == ch)
				return input.good ();
				
		} while (! input.eof ());
		
		input.setstate (std::ios::failbit);

	}
	
	return false; 
}



static bool unquoted_character (const wchar_t in, bool& quoted, std::wstring& output, const wchar_t quote_char)

{	wchar_t append (in);

	if (quoted) {
	
		quoted = false;
		
		switch (in) {

			case L'r' :
				append = L'\r';
				break;

			case L'n' :
				append = L'\n';
				break;

			case L't' :
				append = L'\t';
				break;
				
		}	//lint !e744
		
	} else
	if (in == lip::default_protect_char) {
	
		quoted = true;
		return false;
		
	} else
	if (in == quote_char)
		return true;
		
	output += append;
	return false;
	
}




std::wstring lip::unquote (const std::wstring::const_iterator& start, const std::wstring::const_iterator& finish, const wchar_t quote_char)
	
{	std::wstring output;
	bool quoted = false;
	std::wstring::const_iterator i = start;
	
	if (skip (i, finish, quote_char))
		for ( ; i != finish; ++i)
			if (unquoted_character (*i, quoted, output, quote_char))
				break;

	return output;
}


bool lip::unquote (std::wistream& input, std::wstring& output, const wchar_t quote_char)

{	
	_ASSERT (! input.bad ());
	
	if (! skip (input, quote_char))
		return false;
	
	temp_io_format <std::wistream> tio (input);
	tio.reset (std::ios_base::skipws);

	bool quoted = false;
	wchar_t in;
	std::wstring s;
	
	do {
	
		if (! input.good ())
			break;
			
		input >> in;
		
		if (unquoted_character (in, quoted, s, quote_char)) {
		
			std::swap (s, output);
			return true;
			
		}
	
	} while (! input.eof ());
		
	input.setstate (std::ios::failbit);
	return false;
}



lip::string_vest& lip::operator >> (lip::string_vest& vest, std::wstring& str)

{	//lint !e1929
	if (! vest.empty ()) {
	
		std::wstring s (vest.front ());
		vest.erase (vest.begin ()); 
		std::swap (s, str);
		
	} 
	
	return vest; 
}






std::wistream& lip::operator >> (std::wistream& input, lip::string_vest& vest)

{	//lint !e1929
	if (input.good ()) {
		string_vest sv;
		unsigned int count;
		
		input >> count;
		
		if (count > 512)
			input.setstate (std::ios::failbit);
			
		else {
		
			if (count > 0) {
			
				sv.reserve (count);
				std::wstring str;
				
				for ( ; input.good () && (count > 0) && unquote (input, str); count--)
					sv.push_back (str);
				
				if (count != 0)
					input.setstate (std::ios::badbit);
				
			}
			
			if (input.good ())
				std::swap (sv, vest);

		}
				
	}
		
	return input;
}


std::wostream& lip::operator << (std::wostream& output, const lip::string_vest& vest)

{	//lint !e1929
	if (output.good ()) {
		std::wstringstream out;

		const unsigned int count = vest.size ();
		out << count;
		
		if (count) {
		
			const vest_const_iterator past_it = vest.end ();
		
			for (vest_const_iterator i = vest.begin (); i != past_it; ++i)
				out << default_value_separator << quote (*i);
				
		}
		
		output << out.str ();
	
	}

	return output;
		
}







std::wistream& lip::load (std::wistream& input, SYSTEMTIME& st)

{	//lint !e1929
	if (input.good ())
		input >> st.wYear >> st.wMonth >> st.wDay >> st.wDayOfWeek >> st.wHour >> st.wMinute >> st.wSecond >> st.wMilliseconds;
		
	return input;
}


 
std::wostream& lip::save (std::wostream& output, const SYSTEMTIME& st)

{	//lint !e1929
	if (output.good ()) {
	
		output << st.wYear << L' ' << st.wMonth << L' ' << st.wDay << L' ';
		output << st.wDayOfWeek << L' ' << st.wHour << L' ' << st.wMinute << L' ';
		output << st.wSecond << L' ' << st.wMilliseconds;
		
	}
	
	return output;
}
 




