#pragma once

namespace lip {

	typedef std::vector <std::wstring>			string_vest;
	typedef string_vest::iterator				vest_iterator;
	typedef string_vest::const_iterator			vest_const_iterator;
	typedef string_vest::reverse_iterator		vest_back_iterator;
	typedef string_vest::const_reverse_iterator vest_back_const_iterator;
	typedef string_vest::size_type				vest_size;
	
	const wchar_t default_value_separator = L',';
	const wchar_t default_quote_char = L'"';
	const wchar_t default_line_separator = L'\n';
	const wchar_t default_protect_char = L'\\';
	


	std::wstring quote (const std::wstring::const_iterator& start, const std::wstring::const_iterator& finish, const wchar_t quote_char = default_quote_char);
	inline std::wstring quote (const std::wstring& origin, const wchar_t quote_char = default_quote_char)
		{ return quote (origin.begin (), origin.end (), quote_char); }
	inline void quote (std::wostream& output, const std::wstring& input, const wchar_t quote_char = default_quote_char)
		{ _ASSERT (! output.bad ()); output << quote (input.begin (), input.end (), quote_char); _ASSERT (! output.bad ()); }
	
	bool skip (std::wstring::const_iterator& i, const std::wstring::const_iterator& finish, const wchar_t ch = default_quote_char);
	bool skip (std::wistream& input, const wchar_t ch = default_quote_char);

	std::wstring unquote (const std::wstring::const_iterator& start, const std::wstring::const_iterator& finish, const wchar_t quote_char = default_quote_char);
	inline std::wstring unquote (const std::wstring& input, const wchar_t quote_char = default_quote_char)
		{ return unquote (input.begin (), input.end (), quote_char); }
	bool unquote (std::wistream& input, std::wstring& output, const wchar_t quote_char = default_quote_char);
	
	std::wistream& operator >> (std::wistream& input, string_vest& vest); //lint !e1929
	std::wostream& operator << (std::wostream& output, const string_vest& vest); //lint !e1929
	
	string_vest& operator >> (string_vest& vest, std::wstring& str); //lint !e1929
	inline string_vest& operator << (string_vest& vest, const std::wstring& str) { vest.push_back (str); return vest; } //lint !e1929
	
	std::wistream& load (std::wistream& input, SYSTEMTIME& st); //lint !e1929 
	std::wostream& save (std::wostream& output, const SYSTEMTIME& st); //lint !e1929 

	inline std::wistream& operator >> (std::wistream& input, SYSTEMTIME& st) { return load (input, st); } //lint !e1929
	inline std::wostream& operator << (std::wostream& output, const SYSTEMTIME& st) { return save (output, st); } //lint !e1929

}; //lint !e19
