#include <stdafx.h>
#include "lip_wgroup.h"


std::wstring lip::net_add_connection (	const std::wstring& machine,
											const lip::secure_buffer <wchar_t>& user, 
											const lip::secure_buffer <wchar_t>& password)

{
	user.verify ();
	password.verify ();
		
	wchar_t remote_name [MAX_PATH];
	_ASSERT (machine.length () < MAX_PATH - 8);
	wcscpy (remote_name, machine.c_str ());
	wcscat (remote_name, L"\\IPC$");

	NETRESOURCE	nr;
	memset (&nr, 0, sizeof (NETRESOURCE));

	nr.dwType = RESOURCETYPE_ANY;
	nr.dwUsage = RESOURCEUSAGE_CONNECTABLE;
	nr.lpRemoteName = remote_name;
	
	DWORD dw = 1;
	
	for (int i = 0; i < 16; ++i) {
	
		dw = ::WNetAddConnection2 (&nr, password.get (), user.get (), 0);
		
		if (dw != ERROR_BUSY)
			break;
			
		::Sleep (250);
		
	}
	
	if (dw != NO_ERROR)
		throw lip::exception (dw);
		
	return std::wstring (remote_name);
}


void lip::net_cancel_connection (const std::wstring& connection, const bool nice)

{
	const DWORD dw  = ::WNetCancelConnection2 (connection.c_str (), 0, ! nice); //lint !e730
	
	if (dw != 0)
		throw lip::exception (dw);

}



