#pragma once
#include "lip_except.h"
#include "lip_buffer.h"


namespace lip {

#define NET_WORKGROUP_ENUM_BUF_SIZE 16384
		// see docs. for WNetEnumResource
		
	class net_workgroup_enum
	{
	private:
		HANDLE h_;
		bool exhausted_;
		secure_buffer <BYTE> data_;
		
		net_workgroup_enum (const net_workgroup_enum&); //lint !e1704
		net_workgroup_enum& operator = (const net_workgroup_enum&); //lint !e1704

		const NETRESOURCE& rsc () const throw ()
			{ verify (); return *(reinterpret_cast <const NETRESOURCE*> (data_.get ())); } //lint !e826
		void open_enum (const NETRESOURCE* nr = NULL)
			{	_ASSERT (h_ == NULL);
				_ASSERT (! data_.empty ());
				_ASSERT (nr == NULL || ! ::IsBadReadPtr (nr, sizeof (NETRESOURCE)));
				maybe_throw_error (::WNetOpenEnum (RESOURCE_GLOBALNET, RESOURCETYPE_ANY, 0, const_cast <NETRESOURCE*> (nr), &h_));
				verify (); 
			}
		
	public:
		net_workgroup_enum ()
				: h_ (NULL), exhausted_ (false), data_ (NET_WORKGROUP_ENUM_BUF_SIZE)
			{ open_enum (); }
		explicit net_workgroup_enum (const NETRESOURCE* const nr)
				: h_ (NULL), exhausted_ (false), data_ (NET_WORKGROUP_ENUM_BUF_SIZE)
			{ open_enum (nr); }
		explicit net_workgroup_enum (const secure_buffer <BYTE>& container)
					: h_ (NULL), exhausted_ (false), data_ (NET_WORKGROUP_ENUM_BUF_SIZE)
			{ open_enum (reinterpret_cast <const NETRESOURCE*> (container.get ())); }	//lint !e826
		~net_workgroup_enum () { if (valid ()) try { clear (); } catch (...) { } }

		bool empty () const throw () { return (h_ == NULL); }
		bool valid () const throw () { return ! empty (); }
		bool exhausted () const throw () { return exhausted_; }
		void clear () { _ASSERT (valid ()); maybe_throw_error (::WNetCloseEnum (h_)); h_ = NULL; data_.clear (); }
		void verify () const throw () { _ASSERT (valid ()); _ASSERT (! exhausted ()); _ASSERT (! data_.empty ()); }
		bool next () 
			{	verify ();
				DWORD count = 1; DWORD size = NET_WORKGROUP_ENUM_BUF_SIZE;
				const unsigned long ret = ::WNetEnumResource (h_, &count, data_.get (), &size);
				if (ret == ERROR_NO_MORE_ITEMS) { exhausted_ = true; clear (); return false; }
				if (ret != ERROR_MORE_DATA) maybe_throw_error (ret);
				return true;
			}
			
		secure_buffer <BYTE>& net_resource () throw () { verify (); return data_; } //lint !e826 !e1536
		const secure_buffer <BYTE>& net_resource () const throw () { verify (); return data_; }

		DWORD scope () const throw () { return rsc ().dwScope; }
		DWORD type () const throw () { return rsc ().dwType; }
		bool is_any () const throw () { return (type () == RESOURCETYPE_ANY); }
		DWORD display_type () const throw () { return rsc ().dwDisplayType; }
		bool is_server () const throw () { return display_type () == RESOURCEDISPLAYTYPE_SERVER; }
		bool is_domain () const throw () { return display_type () == RESOURCEDISPLAYTYPE_DOMAIN; }
		bool is_network () const throw () { return display_type () == RESOURCEDISPLAYTYPE_NETWORK; }
		DWORD usage () const throw () { return rsc ().dwUsage; }
		bool is_container () const throw () { return (usage () & RESOURCEUSAGE_CONTAINER) == RESOURCEUSAGE_CONTAINER; }
		const wchar_t* const local_name () const throw () { return rsc ().lpLocalName; }
		const wchar_t* const remote_name () const throw () { return rsc ().lpRemoteName; }
		const wchar_t* const comment () const throw () { return rsc ().lpComment; }
		const wchar_t* const provider () const throw () { return rsc ().lpProvider; }
		
		bool is_machine () const throw () { return is_container () && is_any () && is_server (); }
		bool is_net () const throw () { return is_container () && is_any () && (is_domain () || is_network ()); }
		
	};
	
	
	std::wstring net_add_connection (	const std::wstring& machine,
										const lip::secure_buffer <wchar_t>& user, 
										const lip::secure_buffer <wchar_t>& password);
	void net_cancel_connection (const std::wstring& connection, const bool nice = true);
	
}; //lint !e19
