/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "attr.h"

#define ABBR        "abbr"
#define ACCEPT      "accept"
#define ACCEPTCHARSET "accept-charset"
#define ACCESSKEY   "accesskey"
#define ACTION      "action"
#define ALLOWFULLSCREEN "allowfullscreen"
#define ALLOWPAYMENTREQUEST "allowpaymentrequest"
#define ALLOWUSERMEDIA "allowusermedia"
#define ARIASTAR    "aria-"
#define AS          "as"
#define ASYNC       "async"
#define ALT         "alt"
#define AUTOCAPITALISE "autocapitalize"  // NOTE misspelling obligatory
#define AUTOCOMPLETE "autocomplete"
#define AUTOFOCUS   "autofocus"
#define AUTOPLAY    "autoplay"
#define BORDER      "border"
#define CAPTURE     "capture"
#define CHARSET     "charset"
#define CHECKED     "checked"
#define CITE        "cite"
#define CLASS       "class"
#define CLASSID     "classid"
#define CODEBASE    "codebase"
#define COLS        "cols"
#define COLSPAN     "colspan"
#define CONTENT     "content"
#define CONTENTEDITABLE "contenteditable"
#define CONTROLS    "controls"
#define COORDS      "coords"
#define CROSSORIGIN "crossorigin"
#define DATA        "data"
#define DATASTAR    "data-"
#define DATETIME    "datetime"
#define DECODING    "decoding"
#define DEFER       "defer"
#define DEFAULT     "default"
#define DIR         "dir"
#define DIRNAME     "dirname"
#define DISABLED    "disabled"
#define DISABLEREMOTEPLAYBACK "disableremoteplayback"
#define DOWNLOAD    "download"
#define DRAGGABLE   "draggable"
#define FOR         "for"
#define FORM        "form"
#define FORMACTION  "formaction"
#define FORMENCTYPE "formenctype"
#define FORMMETHOD  "formmethod"
#define FORMNOVALIDATE "formnovalidate"
#define FORMTARGET  "formtarget"
#define ENCTYPE     "enctype"
#define HEADERS     "headers"
#define HEIGHT      "height"
#define HIDDEN      "hidden"
#define HIGH        "high"
#define HREF        "href"
#define HREFLANG    "hreflang"
#define HTML        "html"
#define HTTPEQUIV   "http-equiv"
#define ID          "id"
#define INPUTTYPE   "type(input)"
#define INTEGRITY   "integrity"
#define IS          "is"
#define ISMAP       "ismap"
#define ITEMID      "itemid"
#define ITEMPROP    "itemprop"
#define ITEMREF     "itemref"
#define ITEMSCOPE   "itemscope"
#define ITEMTYPE    "itemtype"
#define KIND        "kind"
#define LABEL       "label"
#define LANG        "lang"
#define LIST        "list"
#define LONGDESC    "longdesc"
#define LOOP        "loop"
#define LOW         "low"
#define MANIFEST    "manifest"
#define MAX         "max"
#define MAXLENGTH   "maxlength"
#define METHOD      "method"
#define MEDIA       "media"
#define METANAME    "name(meta)"
#define MIN         "min"
#define MINLENGTH   "minlength"
#define MULTIPLE    "multiple"
#define MUTED       "muted"
#define NAME        "name"
#define NONCE       "nonce"
#define NOVALIDATE  "novalidate"
#define ONAFTERPRINT "onafterprint"
#define ONBEFOREPRINT "onbeforeprint"
#define ONBEFOREUNLOAD "onbeforeunload"
#define ONHASHCHANGE "onhashchange"
#define ONLANGUAGECHANGE "onlanguagechange"
#define ONMESSAGE   "onmessage"
#define ONOFFLINE   "onoffline"
#define ONONLINE    "ononline"
#define ONPAGEHIDE  "onpagehide"
#define ONPAGESHOW  "onpageshow"
#define ONPOPSTATE  "onpopstate"
#define ONREJECTIONHANDLED "onrejectionhandled"
#define ONSTORAGE   "onstorage"
#define ONUNHANDLEDREJECTION "onunhandledrejection"
#define ONUNLOAD    "onunload"
#define OPEN        "open"
#define OPTIMUM     "optimum"
#define PATTERN     "pattern"
#define PING        "ping"
#define PLACEHOLDER "placeholder"
#define POSTER      "poster"
#define PRELOAD     "preload"
#define PROFILE     "profile"
#define PUBLIC      "public"
#define READONLY     "readonly"
#define REFERRERPOLICY "referrerpolicy"
#define REL         "rel"
#define REQUIRED    "required"
#define REV         "rev"
#define REVERSED    "reversed"
#define ROLE        "role"
#define ROWS        "rows"
#define ROWSPAN     "rowspan"
#define SANDBOX     "sandbox"
#define SCOPE       "scope"
#define SELECTED    "selected"
#define SHAPES      "shapes"
#define SIZE        "size"
#define SIZES       "sizes"
#define SPAN        "span"
#define SPELLCHECK  "spellcheck"
#define SRC         "src"
#define SRCDOC      "srcdoc"
#define SRCLANG     "srclang"
#define SRCSET      "srcset"
#define START       "start"
#define STEP        "step"
#define STYLE       "style"
#define SYSTEM      "system"
#define TABINDEX    "tabindex"
#define TARGET      "target"
#define TITLE       "title"
#define TRANSLATE   "translate"
#define TYPE        "type"
#define TYPEMUSTMATCH "typemustmatch"
#define USEMAP      "usemap"
#define VALUE       "value"
#define WIDTH       "width"
#define WRAP        "wrap"
#define XMLBASE     "xml:base"
#define XMLLANG     "xml:lang"
#define XMLNS       "xmlns"
#define XMLNSSTAR   "xmlns:"

struct symbol_entry < e_attribute > attribute_symbol_table [] =
{   {   ABBR, a_abbr },
    {   ACCEPT, a_accept },
    {   ACCEPTCHARSET, a_acceptcharset },
    {   ACCESSKEY, a_accesskey },
    {   ACTION, a_action },
    {   ALLOWFULLSCREEN, a_allowfullscreen },
    {   ALLOWPAYMENTREQUEST, a_allowpaymentrequest },
    {   ALLOWUSERMEDIA, a_allowusermedia },
    {   ALT, a_alt },
    {   ARIASTAR, a_ariastar },
    {   AS, a_as },
    {   ASYNC, a_async },
    {   AUTOCAPITALISE, a_autocapitalise },
    {   AUTOCOMPLETE, a_autocomplete },
    {   AUTOFOCUS, a_autofocus },
    {   AUTOPLAY, a_autoplay },
    {   BORDER, a_border },
    {   CAPTURE, a_capture },
    {   CHARSET, a_charset },
    {   CITE, a_cite },
    {   CLASS, a_class },
    {   CLASSID, a_classid },
    {   CODEBASE, a_codebase },
    {   COLS, a_cols },
    {   COLSPAN, a_colspan },
    {   CONTENT, a_content },
    {   CONTENTEDITABLE, a_contenteditable },
    {   CONTROLS, a_controls },
    {   COORDS, a_coords },
    {   CROSSORIGIN, a_crossorigin },
    {   DATA, a_data },
    {   DATASTAR, a_datastar },
    {   DATETIME, a_datetime },
    {   DECODING, a_decoding },
    {   DEFER, a_defer },
    {   DEFAULT, a_default },
    {   DIR, a_dir },
    {   DIRNAME, a_dirname },
    {   DISABLED, a_disabled },
    {   DISABLEREMOTEPLAYBACK, a_disableremoteplayback },
    {   DOWNLOAD, a_download },
    {   DRAGGABLE, a_draggable },
    {   ENCTYPE, a_enctype },
    {   FOR, a_for },
    {   FORM, a_form },
    {   FORMACTION, a_formaction },
    {   FORMENCTYPE, a_formenctype },
    {   FORMMETHOD, a_formmethod },
    {   FORMNOVALIDATE, a_formnovalidate },
    {   FORMTARGET, a_formtarget },
    {   HEADERS, a_headers },
    {   HEIGHT, a_height },
    {   HIDDEN, a_hidden },
    {   HREF, a_href },
    {   HREFLANG, a_hreflang },
    {   HTML, a_html },
    {   HTTPEQUIV, a_httpequiv },
    {   ID, a_id },
    {   INPUTTYPE, a_inputtype },
    {   INTEGRITY, a_integrity },
    {   IS, a_is },
    {   ISMAP, a_ismap },
    {   ITEMID, a_itemid },
    {   ITEMPROP, a_itemprop },
    {   ITEMREF, a_itemref },
    {   ITEMSCOPE, a_itemscope },
    {   ITEMTYPE, a_itemtype },
    {   KIND, a_kind },
    {   LABEL, a_label },
    {   LANG, a_lang },
    {   LIST, a_list },
    {   LONGDESC, a_longdesc },
    {   MAX, a_max },
    {   MAXLENGTH, a_maxlength },
    {   MANIFEST, a_manifest },
    {   METHOD, a_method },
    {   MEDIA, a_media },
    {   METANAME, a_metaname },
    {   MIN, a_min },
    {   MINLENGTH, a_minlength },
    {   MUTED, a_muted },
    {   MULTIPLE, a_multiple },
    {   NAME, a_name },
    {   NONCE, a_nonce },
    {   NOVALIDATE, a_novalidate },
    {   ONAFTERPRINT, a_onafterprint },
    {   ONBEFOREPRINT, a_onbeforeprint },
    {   ONBEFOREUNLOAD, a_onbeforeunload },
    {   ONHASHCHANGE, a_onhashchange },
    {   ONLANGUAGECHANGE, a_onlanguagechange },
    {   ONMESSAGE, a_onmessage },
    {   ONOFFLINE, a_onoffline },
    {   ONONLINE, a_ononline },
    {   ONPAGEHIDE, a_onpagehide },
    {   ONPAGESHOW, a_onpageshow },
    {   ONPOPSTATE, a_onpopstate },
    {   ONREJECTIONHANDLED, a_onrejectionhandled },
    {   ONSTORAGE, a_onstorage },
    {   ONUNHANDLEDREJECTION, a_onunhandledrejection },
    {   ONUNLOAD, a_onunload },
    {   OPEN, a_open },
    {   OPTIMUM, a_optimum },
    {   PATTERN, a_pattern },
    {   PLACEHOLDER, a_placeholder },
    {   PING, a_ping },
    {   POSTER, a_poster },
    {   PUBLIC, a_public },
    {   PRELOAD, a_preload },
    {   PROFILE, a_profile },
    {   READONLY, a_readonly },
    {   REFERRERPOLICY, a_referrerpolicy },
    {   REL, a_rel },
    {   REQUIRED, a_required },
    {   REV, a_rev },
    {   REVERSED, a_reversed },
    {   ROLE, a_role },
    {   ROWS, a_rows },
    {   ROWSPAN, a_rowspan },
    {   SANDBOX, a_sandbox },
    {   SCOPE, a_scope },
    {   SELECTED, a_selected },
    {   SHAPES, a_shape },
    {   SIZE, a_size },
    {   SIZES, a_sizes },
    {   SPAN, a_span },
    {   SRC, a_src },
    {   SRCDOC, a_srcdoc },
    {   SRCLANG, a_srclang },
    {   SRCSET, a_srcset },
    {   START, a_start },
    {   STEP, a_step },
    {   SPELLCHECK, a_spellcheck },
    {   STYLE, a_style },
    {   SYSTEM, a_system },
    {   TABINDEX, a_tabindex },
    {   TARGET, a_target },
    {   TITLE, a_title },
    {   TRANSLATE, a_translate },
    {   TYPE, a_type },
    {   TYPEMUSTMATCH, a_typemustmatch },
    {   USEMAP, a_usemap },
    {   VALUE, a_value },
    {   WRAP, a_wrap },
    {   WIDTH, a_width },
    {   XMLBASE, a_xmlbase },
    {   XMLLANG, a_xmllang },
    {   XMLNS, a_xmlns }
//    {   XMLNSSTAR, a_xmlns }      these needs checking out before reactivating
};

void attr::init ()
{   symbol::init (attribute_symbol_table, sizeof (attribute_symbol_table) / sizeof (symbol_entry < e_attribute >), true); }

e_attribute attr::parse (const ::std::string& x)
{   if (x.length () < 2) return a_unknown;
    ::std::string lc (::boost::algorithm::to_lower_copy (x));
    e_attribute res = a_unknown;
    symbol::find (lc, res);
    return res; }
