/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "common.h"
#include "type.h"
#include "attribute_myhtml.h"

template < class CATEGORY, e_type TYPE, CATEGORY IDENTITY > struct typed_attribute : public typed_value < CATEGORY, TYPE, IDENTITY >
{   static ::std::string name () { return attr :: name (IDENTITY); }
    constexpr static CATEGORY whoami () { return IDENTITY; }
    constexpr static e_type mytype () { return TYPE; }
    void swap (typed_attribute& t) noexcept
    {   typed_value < CATEGORY, TYPE, IDENTITY > :: swap (t); }
    void parse (const myhtml_attribute& html)
    {   if (html.has_value ()) typed_value < CATEGORY, TYPE, IDENTITY > :: set_value (html.get_value ());
        else typed_value < CATEGORY, TYPE, IDENTITY > :: set_value (::std::string ()); }
    ::std::string diagnose () const
    {   return typed_value < CATEGORY, TYPE, IDENTITY > :: diagnose (name ()); }
    ::std::string report () const
    {   return typed_value < CATEGORY, TYPE, IDENTITY > :: report (name ()); } };
