/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "attribute_myhtml.h"

bool myhtml_attribute::has_key () const
{   return (! invalid () && myhtml_attribute_key (attribute_, nullptr) != nullptr); }

const char* myhtml_attribute::get_key () const
{   assert (! invalid ());
    return myhtml_attribute_key (attribute_, nullptr); }

void myhtml_attribute::parse ()
{   e_ = a_unknown;
    if (has_key ()) e_ = attr :: parse (get_key ()); }

bool myhtml_attribute::has_value () const
{   return (! invalid () && myhtml_attribute_value (attribute_, nullptr) != nullptr); }

const char* myhtml_attribute::get_value () const
{   assert (! invalid ());
    return myhtml_attribute_value (attribute_, nullptr); }

bool myhtml_attribute::next ()
{   e_ = a_unknown;
    if (attribute_ != nullptr)
    {   attribute_ = myhtml_attribute_next (attribute_);
        if (attribute_ != nullptr)
        {   parse ();
            return true; } }
    return false; }
