/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "symbol.h"
#include "myhtml/api.h"

// additional tags
// WARNING an upgrade to mythml will probably require edits here
#define TAG_DATA            0x100
#define TAG_PICTURE         0x101
#define TAG_SLOT            0x102
#define TAG_WEBMENTION      0x103
#define TAG_FIRST_NEW_ELEM  TAG_DATA
#define TAG_MORE_ELEM       0x104

class context;

struct elem : symbol < size_t >
{   static size_t max_tag_;
    static size_t parse (const ::std::string& x);
    static void init ();
    static size_t add_tag (const ::std::string& tag, ::std::ostringstream& ss);
    bool unknown () const
    {   return (symbol < size_t > :: unknown ()) ||
        (symbol < size_t > :: get () == MyHTML_TAG__UNDEF) ||
        (symbol < size_t > :: get () == MyHTML_TAG__END_OF_FILE); }
    elem () {}
    elem (const ::std::string& x) { set (parse (x)); } };
