/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "microformats_ptr.h"
#include "element_wrapper.h"
#include "microformat_export.h"

class page;
class element;
typedef ::std::vector < element* > velptr_t;
typedef ::std::pair < element*, e_vocabulary > found_farm;
typedef ::std::shared_ptr < element > element_ptr;

class element
{   element_wrapper element_;
    myhtml_element node_;
    bool examined_;
    page* page_;
    element* parent_;
    element_ptr sibling_, child_;
    microformats_ptr mf_;
    ::std::string name_;
    sstr_t* ids_;
    ::std::ostringstream diagnosis_;
    void examine_base ();
    bool examine_class ();
    bool examine_rel (const ::std::string& content);
    found_farm find_farm (const e_property prop, element* starter = nullptr) const;
    void seek_webmention (::std::string& mention, e_wm_status& wms);
    bool to_sibling (element_ptr& e, const int depth);
    template < class PROPERTY > void note_reply ();
    void activate_microformats () { if (! mf_) mf_.reset (new microformats ()); }
    myhtml_tag_id_t check_bespoke_tag (myhtml_tag_id_t tag, const int n);
    void mf_put_vocab (const e_vocabulary v, const prop& p, const ::std::string& itemtype = ::std::string (EXPORT_ITEMTYPE), const ::std::string& itemprop = ::std::string (EXPORT_ITEMPROP));
    void mf_put_rel (const e_vocabulary v, const prop& p, const vstr_t& rels);
    void verify_children (const int depth);
public:
    element (const ::std::string& name, myhtml_tree_node_t* n, element* parent, sstr_t* ids, page* p, const int depth) : node_ (n), examined_ (false), parent_ (parent), name_ (name), ids_ (ids), page_ (p)
    {   assert (p != nullptr);
        if (n != nullptr)
        {   myhtml_element he (n);
            he.set_tag (check_bespoke_tag (he.tag (), depth));
            element_.reset (he); } }
    element (const ::std::string& name, const myhtml_element& n, element* parent, sstr_t* ids, page* p, const int depth) : node_ (n), examined_ (false), parent_ (parent), name_ (name), ids_ (ids), page_ (p)
    {   assert (p != nullptr);
        myhtml_element he (n);
        he.set_tag (check_bespoke_tag (he.tag (), depth));
        element_.reset (he); }
    ~element ();
    void swap (element& e) noexcept;
    void set_page (page* p);
    const myhtml_element& node () const { return node_; }
    const ::std::string name () const { return name_; }
    bool has_child () const { return node_.has_child (); }
    bool has_next () const { return node_.has_next (); }
    element_ptr child (const int depth);
    element_ptr next (const int depth);
    myhtml_tag_id_t tag () const { return node_.tag (); }
    bool invalid () const { return node_.invalid (); }
    bool is_top () const { return parent_ == nullptr; }
    void examine_self (const directory& d, const int depth);
    void examine_children (const directory& d, const int depth);
    void verify (const int depth);
    ::std::string find_date_value () const;
    ::std::string find_text_value () const;
    ::std::string find_url_value () const;
    ::std::string find_html_value () const;
    ::std::string find_webmention (const int depth);
    ::std::string find_mention_info (const url& u, bool text, bool anything);
    element* parent () const { assert (! is_top ()); return parent_; }
    void clear ();
    bool reportable () const { return ((tag () != MyHTML_TAG__UNDEF) || context.tell (e_splurge) || (child_ != nullptr)); }
    ::std::string report (const int n); };

template < class PROPERTY > void element::note_reply ()
{   if (! mf_) return;
    if (is_microformat_property_empty < mf_entry, PROPERTY> (mf_)) return;
    context.note_reply (name_, element_.get_value < attr_id > (), get_microformat_property_value < mf_entry, PROPERTY > (mf_), node_.content (true, false)); }
