/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "element_html.h"

#define ELEMENTS    generic_element, a_element, abbr_element, address_element, area_element, article_element, aside_element, b_element, base_element, \
                    bdi_element, bdo_element, blockquote_element, body_element, br_element, button_element, canvas_element, \
                    caption_element, cite_element, code_element, col_element, colgroup_element,  data_element, datalist_element, \
                    dd_element, del_element, details_element, dfn_element, dialogue_element, div_element, dl_element, doctype_element, dt_element, \
                    embed_element, fieldset_element, figcaption_element, figure_element, footer_element, form_element, h1_element, \
                    h2_element, h3_element, h4_element, h5_element, h6_element, head_element, header_element, hr_element, html4_element, \
                    html5_element, i_element, iframe_element, img_element, input_element, ins_element, kbd_element, label_element, \
                    legend_element, li_element, link_element, m_element, main_element, map_element, mark_element, meta_element, \
                    meter_element, nav_element, noscript_element, object_element, ol_element, optgroup_element, option_element, \
                    output_element, p_element, param_element,  picture_element, pre_element, progress_element, q_element, rb_element, \
                    rp_element, rt_element, rtc_element, ruby_element, s_element, samp_element, script_element, section_element, \
                    select_element, slot_element, small_element, span_element, source_element, strong_element, style_element, sub_element, \
                    summary_element, sup_element, table_element, tbody_element, td_element, template_element, textarea_element, \
                    tfoot_element, th_element, thead_element, time_element, title_element, tr_element, track_element, u_element, \
                    ul_element, var_element, video_element, wbr_element


#define DOCTYPE_ATTRIBUTES  attr_html, attr_system, attr_public

#define COMMON_ATTRIBUTES   attr_class, attr_hidden, attr_id, attr_is, attr_lang, attr_style, attr_title, attr_itemid, attr_itemprop, attr_itemref, \
                            attr_itemtype, attr_itemscope, attr_dir, attr_translate, attr_accesskey,  attr_contenteditable, attr_nonce, \
                            attr_role, attr_spellcheck, attr_tabindex, attr_ariastar, attr_datastar, attr_xmlbase, attr_xmllang, attr_xmlns
#define SPAN_ATTRIBUTES     attr_span, COMMON_ATTRIBUTES
#define CITE_ATTRIBUTES     attr_cite, COMMON_ATTRIBUTES
#define CITE_DT_ATTRIBUTES  attr_cite, attr_datetime, COMMON_ATTRIBUTES
#define NAME_ATTRIBUTES     attr_name, COMMON_ATTRIBUTES
#define OPEN_ATTRIBUTES     attr_open, COMMON_ATTRIBUTES
#define VALUE_ATTRIBUTES    attr_value, COMMON_ATTRIBUTES

#define BASE_ATTRIBUTES     attr_href, attr_target, COMMON_ATTRIBUTES
#define BODY_ATTRIBUTES     attr_onafterprint, attr_onbeforeprint, attr_onbeforeunload, attr_onhashchange, attr_onlanguagechange, attr_onmessage, attr_onoffline, attr_ononline, \
                            attr_onpagehide, attr_onpageshow, attr_onpopstate, attr_onrejectionhandled, attr_onstorage, attr_onunhandledrejection, attr_onunload, COMMON_ATTRIBUTES
#define HTML_ATTRIBUTES     attr_manifest, COMMON_ATTRIBUTES
#define LINK_ATTRIBUTES     attr_href, attr_crossorigin, attr_rel, attr_rev, attr_media, attr_hreflang, attr_integrity, attr_ping, attr_type, attr_referrerpolicy, attr_sizes, attr_as, COMMON_ATTRIBUTES
#define META_ATTRIBUTES     attr_name, attr_metaname, attr_httpequiv, attr_content, attr_charset, COMMON_ATTRIBUTES
#define STYLE_ATTRIBUTES    attr_media, attr_type, COMMON_ATTRIBUTES

#define OL_ATTRIBUTES       attr_reversed, attr_start, attr_type, COMMON_ATTRIBUTES

#define A_ATTRIBUTES        attr_href, attr_target, attr_download, attr_ping, attr_rel, attr_rev, attr_hreflang, attr_type, attr_referrerpolicy, attr_name, COMMON_ATTRIBUTES
#define TIME_ATTRIBUTES     attr_datetime, COMMON_ATTRIBUTES

#define SOURCE_ATTRIBUTES   attr_src, attr_type, attr_srcset, attr_sizes, attr_media, COMMON_ATTRIBUTES
#define IMG_ATTRIBUTES      attr_alt, attr_src, attr_srcset, attr_sizes, attr_crossorigin, attr_decoding, attr_usemap, attr_ismap, attr_width, attr_height, attr_referrerpolicy, \
                            attr_longdesc, COMMON_ATTRIBUTES
#define IFRAME_ATTRIBUTES   attr_src, attr_srcdoc, attr_name, attr_sandbox, attr_allowfullscreen, attr_allowpaymentrequest, attr_allowusermedia, attr_width, attr_height, attr_referrerpolicy, COMMON_ATTRIBUTES
#define EMBED_ATTRIBUTES    attr_src, attr_type, attr_width, attr_height, COMMON_ATTRIBUTES
#define OBJECT_ATTRIBUTES   attr_data, attr_type, attr_typemustmatch, attr_name, attr_width, attr_height, COMMON_ATTRIBUTES
#define PARAM_ATTRIBUTES    attr_name, attr_value, COMMON_ATTRIBUTES
#define VIDEO_ATTRIBUTES    attr_src, attr_crossorigin, attr_poster, attr_preload, attr_autoplay, attr_loop, attr_muted, attr_controls, attr_disableremoteplayback, attr_width, attr_height, COMMON_ATTRIBUTES
#define AUDIO_ATTRIBUTES    attr_src, attr_crossorigin, attr_preload, attr_autoplay, attr_loop, attr_muted, attr_controls, attr_disableremoteplayback, COMMON_ATTRIBUTES
#define TRACK_ATTRIBUTES    attr_kind, attr_src, attr_srclang, attr_label, attr_default, COMMON_ATTRIBUTES

#define AREA_ATTRIBUTES     attr_alt, attr_coords, attr_download, attr_href, attr_hreflang, attr_ping, attr_rel, attr_shape, attr_target, attr_type, attr_referrerpolicy, COMMON_ATTRIBUTES

#define TABLE_ATTRIBUTES    attr_border, COMMON_ATTRIBUTES
#define TD_ATTRIBUTES       attr_colspan, attr_rowspan, attr_headers, COMMON_ATTRIBUTES
#define TH_ATTRIBUTES       attr_colspan, attr_rowspan, attr_headers, attr_scope, attr_abbr, COMMON_ATTRIBUTES

#define FORM_ATTRIBUTES     attr_acceptcharset, attr_action, attr_autocomplete, attr_enctype, attr_method, attr_name, attr_novalidate, attr_target, COMMON_ATTRIBUTES
#define LABEL_ATTRIBUTES    attr_for, COMMON_ATTRIBUTES
#define INPUT_ATTRIBUTES    attr_accept, attr_alt, attr_autocapitalise, attr_autocomplete, attr_autofocus, attr_capture, attr_checked, attr_dirname, attr_disabled, attr_form, attr_formaction, attr_formenctype, \
                            attr_formmethod, attr_formnovalidate, attr_formtarget, attr_height, attr_inputtype, attr_list, attr_max, attr_maxlength, attr_min, attr_minlength, attr_multiple, attr_name, attr_pattern, \
                            attr_placeholder, attr_readonly, attr_required, attr_size, attr_src, attr_type, attr_value, attr_width, COMMON_ATTRIBUTES
#define BUTTON_ATTRIBUTES   attr_autofocus, attr_disabled, attr_form, attr_formaction, attr_formenctype, attr_formmethod, attr_formnovalidate, attr_formtarget, attr_name, attr_type, attr_value, COMMON_ATTRIBUTES
#define SELECT_ATTRIBUTES   attr_autocomplete, attr_autofocus, attr_disabled, attr_form, attr_multiple, attr_name, attr_required, attr_size, COMMON_ATTRIBUTES
#define OPTGROUP_ATTRIBUTES attr_disabled, attr_label, COMMON_ATTRIBUTES
#define OPTION_ATTRIBUTES   attr_disabled, attr_label, attr_selected, attr_value, COMMON_ATTRIBUTES
#define TEXTAREA_ATTRIBUTES attr_autocapitalise, attr_autocomplete, attr_autofocus, attr_cols, attr_dirname, attr_disabled, attr_form, attr_maxlength, attr_minlength, \
                            attr_name, attr_placeholder, attr_readonly, attr_required, attr_rows, attr_wrap, COMMON_ATTRIBUTES
#define OUTPUT_ATTRIBUTES   attr_for, attr_form, attr_name, COMMON_ATTRIBUTES
#define PROGRESS_ATTRIBUTES attr_value, attr_max, COMMON_ATTRIBUTES
#define METER_ATTRIBUTES    attr_value, attr_min, attr_max, attr_low, attr_high, attr_optimum, COMMON_ATTRIBUTES
#define FIELDSET_ATTRIBUTES attr_disabled, attr_form, attr_name, COMMON_ATTRIBUTES

#define SCRIPT_ATTRIBUTES   attr_src, attr_type, attr_async, attr_defer, attr_crossorigin, attr_integrity, COMMON_ATTRIBUTES
#define CANVAS_ATTRIBUTES   attr_width, attr_height, COMMON_ATTRIBUTES


typedef html_element < MyHTML_TAG__UNDEF, COMMON_ATTRIBUTES > generic_element;

typedef html_element < MyHTML_TAG__DOCTYPE, DOCTYPE_ATTRIBUTES > doctype_element;

typedef html_element < MyHTML_TAG_BASE, BASE_ATTRIBUTES > base_element;
typedef html_element < MyHTML_TAG_BODY, BODY_ATTRIBUTES > body_element;
typedef html_element < MyHTML_TAG_HEAD, COMMON_ATTRIBUTES > head_element;
typedef html_element < MyHTML_TAG_HTML, HTML_ATTRIBUTES > html4_element;
typedef html_element < MyHTML_TAG_HTML, COMMON_ATTRIBUTES > html5_element;
typedef html_element < MyHTML_TAG_LINK, LINK_ATTRIBUTES > link_element;
typedef html_element < MyHTML_TAG_META, META_ATTRIBUTES > meta_element;
typedef html_element < MyHTML_TAG_STYLE, STYLE_ATTRIBUTES > style_element;
typedef html_element < MyHTML_TAG_TITLE, COMMON_ATTRIBUTES > title_element;

typedef html_element < MyHTML_TAG_ARTICLE, COMMON_ATTRIBUTES > article_element;
typedef html_element < MyHTML_TAG_ASIDE, COMMON_ATTRIBUTES > aside_element;
typedef html_element < MyHTML_TAG_FOOTER, COMMON_ATTRIBUTES > footer_element;
typedef html_element < MyHTML_TAG_H1, COMMON_ATTRIBUTES > h1_element;
typedef html_element < MyHTML_TAG_H2, COMMON_ATTRIBUTES > h2_element;
typedef html_element < MyHTML_TAG_H3, COMMON_ATTRIBUTES > h3_element;
typedef html_element < MyHTML_TAG_H4, COMMON_ATTRIBUTES > h4_element;
typedef html_element < MyHTML_TAG_H5, COMMON_ATTRIBUTES > h5_element;
typedef html_element < MyHTML_TAG_H6, COMMON_ATTRIBUTES > h6_element;
typedef html_element < MyHTML_TAG_HEADER, COMMON_ATTRIBUTES > header_element;
typedef html_element < MyHTML_TAG_NAV, COMMON_ATTRIBUTES > nav_element;
typedef html_element < MyHTML_TAG_SECTION, COMMON_ATTRIBUTES > section_element;

typedef html_element < MyHTML_TAG_ADDRESS, COMMON_ATTRIBUTES > address_element;
typedef html_element < MyHTML_TAG_BLOCKQUOTE, CITE_ATTRIBUTES > blockquote_element;
typedef html_element < MyHTML_TAG_DD, COMMON_ATTRIBUTES > dd_element;
typedef html_element < MyHTML_TAG_DIV, COMMON_ATTRIBUTES > div_element;
typedef html_element < MyHTML_TAG_DL, COMMON_ATTRIBUTES > dl_element;
typedef html_element < MyHTML_TAG_DT, COMMON_ATTRIBUTES > dt_element;
typedef html_element < MyHTML_TAG_FIGURE, COMMON_ATTRIBUTES > figure_element;
typedef html_element < MyHTML_TAG_FIGCAPTION, COMMON_ATTRIBUTES > figcaption_element;
typedef html_element < MyHTML_TAG_HR, COMMON_ATTRIBUTES > hr_element;
typedef html_element < MyHTML_TAG_LI, VALUE_ATTRIBUTES > li_element;
typedef html_element < MyHTML_TAG_MAIN, COMMON_ATTRIBUTES > main_element;
typedef html_element < MyHTML_TAG_OL, OL_ATTRIBUTES > ol_element;
typedef html_element < MyHTML_TAG_P, COMMON_ATTRIBUTES > p_element;
typedef html_element < MyHTML_TAG_PRE, COMMON_ATTRIBUTES > pre_element;
typedef html_element < MyHTML_TAG_UL, COMMON_ATTRIBUTES > ul_element;

typedef html_element < MyHTML_TAG_A, A_ATTRIBUTES > a_element;
typedef html_element < MyHTML_TAG_ABBR, COMMON_ATTRIBUTES > abbr_element;
typedef html_element < MyHTML_TAG_B, COMMON_ATTRIBUTES > b_element;
typedef html_element < MyHTML_TAG_BDI, COMMON_ATTRIBUTES > bdi_element;
typedef html_element < MyHTML_TAG_BDO, COMMON_ATTRIBUTES > bdo_element;
typedef html_element < MyHTML_TAG_BR, COMMON_ATTRIBUTES > br_element;
typedef html_element < MyHTML_TAG_CITE, COMMON_ATTRIBUTES > cite_element;
typedef html_element < MyHTML_TAG_CODE, COMMON_ATTRIBUTES > code_element;
typedef html_element < TAG_DATA, VALUE_ATTRIBUTES > data_element;
typedef html_element < MyHTML_TAG_DFN, COMMON_ATTRIBUTES > dfn_element;
typedef html_element < MyHTML_TAG_EM, COMMON_ATTRIBUTES > m_element;
typedef html_element < MyHTML_TAG_I, COMMON_ATTRIBUTES > i_element;
typedef html_element < MyHTML_TAG_KBD, COMMON_ATTRIBUTES > kbd_element;
typedef html_element < MyHTML_TAG_MARK, COMMON_ATTRIBUTES > mark_element;
typedef html_element < MyHTML_TAG_Q, CITE_ATTRIBUTES > q_element;
typedef html_element < MyHTML_TAG_RUBY, COMMON_ATTRIBUTES > ruby_element;
typedef html_element < MyHTML_TAG_RB, COMMON_ATTRIBUTES > rb_element;
typedef html_element < MyHTML_TAG_RP, COMMON_ATTRIBUTES > rp_element;
typedef html_element < MyHTML_TAG_RT, COMMON_ATTRIBUTES > rt_element;
typedef html_element < MyHTML_TAG_RTC, COMMON_ATTRIBUTES > rtc_element;
typedef html_element < MyHTML_TAG_S, COMMON_ATTRIBUTES > s_element;
typedef html_element < MyHTML_TAG_SAMP, COMMON_ATTRIBUTES > samp_element;
typedef html_element < MyHTML_TAG_SMALL, COMMON_ATTRIBUTES > small_element;
typedef html_element < MyHTML_TAG_SPAN, COMMON_ATTRIBUTES > span_element;
typedef html_element < MyHTML_TAG_STRONG, COMMON_ATTRIBUTES > strong_element;
typedef html_element < MyHTML_TAG_SUB, COMMON_ATTRIBUTES > sub_element;
typedef html_element < MyHTML_TAG_SUP, COMMON_ATTRIBUTES > sup_element;
typedef html_element < MyHTML_TAG_TIME, TIME_ATTRIBUTES > time_element;
typedef html_element < MyHTML_TAG_U, COMMON_ATTRIBUTES > u_element;
typedef html_element < MyHTML_TAG_VAR, COMMON_ATTRIBUTES > var_element;
typedef html_element < MyHTML_TAG_WBR, COMMON_ATTRIBUTES > wbr_element;

typedef html_element < MyHTML_TAG_INS, CITE_DT_ATTRIBUTES > ins_element;
typedef html_element < MyHTML_TAG_DEL, CITE_DT_ATTRIBUTES > del_element;

typedef html_element < TAG_PICTURE, COMMON_ATTRIBUTES > picture_element;
typedef html_element < MyHTML_TAG_SOURCE, SOURCE_ATTRIBUTES > source_element;

typedef html_element < MyHTML_TAG_IMG, IMG_ATTRIBUTES > img_element;
typedef html_element < MyHTML_TAG_IFRAME, IFRAME_ATTRIBUTES > iframe_element;
typedef html_element < MyHTML_TAG_EMBED, EMBED_ATTRIBUTES > embed_element;
typedef html_element < MyHTML_TAG_OBJECT, OBJECT_ATTRIBUTES > object_element;
typedef html_element < MyHTML_TAG_PARAM, PARAM_ATTRIBUTES > param_element;
typedef html_element < MyHTML_TAG_VIDEO, VIDEO_ATTRIBUTES > video_element;
typedef html_element < MyHTML_TAG_AUDIO, AUDIO_ATTRIBUTES > audio_element;
typedef html_element < MyHTML_TAG_TRACK, TRACK_ATTRIBUTES > track_element;

typedef html_element < MyHTML_TAG_MAP, NAME_ATTRIBUTES > map_element;

typedef html_element < MyHTML_TAG_AREA, AREA_ATTRIBUTES > area_element;

typedef html_element < MyHTML_TAG_TABLE, TABLE_ATTRIBUTES > table_element;
typedef html_element < MyHTML_TAG_CAPTION, COMMON_ATTRIBUTES > caption_element;
typedef html_element < MyHTML_TAG_COLGROUP, SPAN_ATTRIBUTES > colgroup_element;
typedef html_element < MyHTML_TAG_COL, SPAN_ATTRIBUTES > col_element;
typedef html_element < MyHTML_TAG_TBODY, COMMON_ATTRIBUTES > tbody_element;
typedef html_element < MyHTML_TAG_THEAD, COMMON_ATTRIBUTES > thead_element;
typedef html_element < MyHTML_TAG_TFOOT, COMMON_ATTRIBUTES > tfoot_element;
typedef html_element < MyHTML_TAG_TR, COMMON_ATTRIBUTES > tr_element;
typedef html_element < MyHTML_TAG_TD, TD_ATTRIBUTES > td_element;
typedef html_element < MyHTML_TAG_TH, TH_ATTRIBUTES > th_element;

typedef html_element < MyHTML_TAG_FORM, FORM_ATTRIBUTES > form_element;
typedef html_element < MyHTML_TAG_LABEL, LABEL_ATTRIBUTES > label_element;
typedef html_element < MyHTML_TAG_INPUT, INPUT_ATTRIBUTES > input_element;
typedef html_element < MyHTML_TAG_BUTTON, BUTTON_ATTRIBUTES > button_element;
typedef html_element < MyHTML_TAG_SELECT, SELECT_ATTRIBUTES > select_element;
typedef html_element < MyHTML_TAG_DATALIST, COMMON_ATTRIBUTES > datalist_element;
typedef html_element < MyHTML_TAG_OPTGROUP, OPTGROUP_ATTRIBUTES > optgroup_element;
typedef html_element < MyHTML_TAG_OPTION, OPTION_ATTRIBUTES > option_element;
typedef html_element < MyHTML_TAG_TEXTAREA, TEXTAREA_ATTRIBUTES > textarea_element;
typedef html_element < MyHTML_TAG_OUTPUT, OUTPUT_ATTRIBUTES > output_element;
typedef html_element < MyHTML_TAG_PROGRESS, PROGRESS_ATTRIBUTES > progress_element;
typedef html_element < MyHTML_TAG_METER, METER_ATTRIBUTES > meter_element;
typedef html_element < MyHTML_TAG_FIELDSET, FIELDSET_ATTRIBUTES > fieldset_element;
typedef html_element < MyHTML_TAG_LEGEND, COMMON_ATTRIBUTES > legend_element;

typedef html_element < MyHTML_TAG_DETAILS, OPEN_ATTRIBUTES > details_element;
typedef html_element < MyHTML_TAG_SUMMARY, COMMON_ATTRIBUTES > summary_element;
typedef html_element < MyHTML_TAG_DIALOG, OPEN_ATTRIBUTES > dialogue_element;

typedef html_element < MyHTML_TAG_SCRIPT, SCRIPT_ATTRIBUTES > script_element;
typedef html_element < MyHTML_TAG_NOSCRIPT, COMMON_ATTRIBUTES > noscript_element;
typedef html_element < MyHTML_TAG_TEMPLATE, COMMON_ATTRIBUTES > template_element;
typedef html_element < TAG_SLOT, NAME_ATTRIBUTES > slot_element;
typedef html_element < MyHTML_TAG_CANVAS, CANVAS_ATTRIBUTES > canvas_element;

// Unfortunately, recent versions of macos block the use of ::std::variant
// typedef ::std::variant < ELEMENTS > element_v;
typedef html_element_base element_v;

