/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "elem.h"
#include <assert.h>

class myhtml_element
{   myhtml_tree_node_t *node_;
    mutable myhtml_tag_id_t tag_;
    ::std::string name_;
public:
    myhtml_element () : node_ (nullptr), tag_ (MyHTML_TAG__UNDEF) { }
    explicit myhtml_element (myhtml_tree_node_t *node) : node_ (node), tag_ (MyHTML_TAG__UNDEF) { }
    myhtml_element (const myhtml_element& x) { node_ = x.node_; tag_ = x.tag_; }
    myhtml_element& operator = (const myhtml_element& x) { node_ = x.node_; tag_ = x.tag_; return *this; }
    bool invalid () const { return node_ == nullptr; }
    void reset (myhtml_tree_node_t *node = nullptr) { node_ = node; tag_ = MyHTML_TAG__UNDEF; }
    void swap (myhtml_element& el) noexcept
    {   ::std::swap (node_, el.node_);
        ::std::swap (tag_, el.tag_);
        name_.swap (name_); }
    bool has_child () const { return ! invalid () && myhtml_node_child (node_) != nullptr; }
    bool has_next () const { return ! invalid () && myhtml_node_next (node_) != nullptr; }
    bool has_parent () const { return ! invalid () && myhtml_node_parent (node_) != nullptr; }
    bool has_data () const { return ! invalid () && myhtml_node_get_data (node_) != nullptr; }
    bool has_attributes () const { return ! invalid () && myhtml_node_attribute_first (node_) != nullptr; }
    myhtml_element child ()
    {   assert (has_child ());
        return myhtml_element (myhtml_node_child (node_)); }
    myhtml_element next ()
    {   assert (has_next ());
        return myhtml_element (myhtml_node_next (node_)); }
    myhtml_element parent ()
    {   assert (has_parent ());
        return myhtml_element (myhtml_node_parent (node_)); }
    const void* data () const
    {   assert (! invalid ());
        return myhtml_node_get_data (node_); }
    ::std::string content (bool text, bool anything) const;
    myhtml_tree_attr_t* attributes () const
    {   assert (has_attributes ());
        return myhtml_node_attribute_first (node_); }
    myhtml_tag_id_t tag () const;
    void set_tag (const myhtml_tag_id_t tag)
    {   tag_ = tag; }
    ::std::string name ();
    void name (const ::std::string& name) { name_ = name; }
    const myhtml_token_node_t* token () const
    {   assert (! invalid ());
        return myhtml_node_token (node_); }
    ::std::string get_raw_name () const;
    ::std::string report (const int n) const; };

::std::string rpt_structure (myhtml_tree_t* tree);
::std::string rpt_structure (myhtml_tree_node_t* node, const int depth = 0);
