   /*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "element_wrapper.h"

element_wrapper::element_wrapper (const myhtml_element& node)
    : v_ (make_element_v_ptr (node)) { }

void element_wrapper::reset (const myhtml_element& node)
{   element_v_ptr ep (make_element_v_ptr (node));
    v_.swap (ep); }

bool element_wrapper::empty () const
{   if (v_ == nullptr) return true;
    return v_ -> empty (); }

size_t element_wrapper::tag () const
{   if (v_ == nullptr) return MyHTML_TAG__UNDEF;
    return v_ -> whoami (); }

void element_wrapper::set_tag (const size_t tag)
{   if (v_ != nullptr) v_ -> set_tag (tag); }

bool element_wrapper::invalid () const
{   if (v_ == nullptr) return false;
    return v_ -> invalid (); }

bool element_wrapper::valid () const
{   if (v_ == nullptr) return true;
    return v_ -> valid (); }

::std::string element_wrapper::diagnose (const int n) const
{   if (v_ == nullptr) return ::std::string ();
    return v_ -> diagnose (n); }

bool element_wrapper::verify_url (const directory& d)
{   if (v_ == nullptr) return true;
    return v_ -> verify_url (d); }

::std::string element_wrapper::content (bool text, bool anything) const
{   if (v_ == nullptr) return ::std::string ();
    return v_ -> content (text, anything); }

::std::string element_wrapper::report (const int n) const
{   if (v_ == nullptr) return ::std::string ("");
    return v_ -> report (n); }

bool element_wrapper::has_url () const
{   if (v_ == nullptr) return false;
    return v_ -> has_url (); }

void element_wrapper::verify (sstr_t* ssi)
{   if (v_ != nullptr) v_ -> verify (ssi); }

bool element_wrapper::invalid_id (sstr_t* ids)
{   if (v_ == nullptr) return false;
    return v_ -> invalid_id (ids); }
