/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "field.h"

struct field
{   e_vocabulary vocab_;
    e_property prop_;
    field (const e_vocabulary v, const e_property p)
        : vocab_ (v), prop_ (p) { } };

// rewrite when <=> is ubiquitous

inline bool operator == (const field& lhs, const field& rhs)
{   return  (lhs.vocab_ == rhs.vocab_) &&
            (lhs.prop_ == rhs.prop_); }

inline bool operator != (const field& lhs, const field& rhs)
{   return ! (lhs == rhs); }

inline bool operator < (const field& lhs, const field& rhs)
{   if (lhs.vocab_ < rhs.vocab_) return true;
    if (lhs.vocab_ > rhs.vocab_) return false;
    return lhs.prop_ < rhs.prop_; }

inline bool operator <= (const field& lhs, const field& rhs)
{   if (lhs < rhs) return true;
    return (lhs.prop_ == rhs.prop_); }

inline bool operator > (const field& lhs, const field& rhs)
{   return ! (lhs <= rhs); }

inline bool operator >= (const field& lhs, const field& rhs)
{   return ! (lhs < rhs); }


template <> struct std::hash <field>
{   size_t operator() (const field& f) const
    {   return ::std::hash <int> () (
                (static_cast <size_t> (f.vocab_) << 16) +
                static_cast <size_t> (f.prop_)); } };

field fields [] =
{   { h_adr, p_altitude },
    { h_adr, p_country_name },
    { h_adr, p_extended_address },
    { h_adr, p_geo },
    { h_adr, p_label },
    { h_adr, p_latitude },
    { h_adr, p_locality },
    { h_adr, p_longitude },
    { h_adr, p_post_office_box },
    { h_adr, p_postal_code },
    { h_adr, p_region },
    { h_adr, p_street_address },
    { h_adr, u_geo },

    { h_aggregate, p_average },
    { h_aggregate, p_best },
    { h_aggregate, p_count },
    { h_aggregate, p_item },
    { h_aggregate, p_name },
    { h_aggregate, p_votes },
    { h_aggregate, p_worst },

    { h_breadcrumb, p_name },
    { h_breadcrumb, u_url },

    { h_card, dt_anniversary },
    { h_card, dt_bday },
    { h_card, dt_rev },
    { h_card, p_additional_name },
    { h_card, p_adr },
    { h_card, p_altitude },
    { h_card, p_category },
    { h_card, p_country_name },
    { h_card, p_extended_address },
    { h_card, p_family_name },
    { h_card, p_gender_identity },
    { h_card, p_geo },
    { h_card, p_given_name },
    { h_card, p_honorific_prefix },
    { h_card, p_honorific_suffix },
    { h_card, p_job_title },
    { h_card, p_label },
    { h_card, p_latitude },
    { h_card, p_locality },
    { h_card, p_longitude },
    { h_card, p_name },
    { h_card, p_nickname },
    { h_card, p_note },
    { h_card, p_org },
    { h_card, p_organization_name },
    { h_card, p_organization_unit },
    { h_card, p_post_office_box },
    { h_card, p_postal_code },
    { h_card, p_region },
    { h_card, p_role },
    { h_card, p_sex },
    { h_card, p_sort_string },
    { h_card, p_street_address },
    { h_card, p_tel },
    { h_card, p_tz },
    { h_card, u_email },
    { h_card, u_geo },
    { h_card, u_impp },
    { h_card, u_key },
    { h_card, u_logo },
    { h_card, u_photo },
    { h_card, u_uid },
    { h_card, u_url },

    { h_cite, dt_accessed },
    { h_cite, dt_published },
    { h_cite, p_author },
    { h_cite, p_content },
    { h_cite, p_name },
    { h_cite, p_publication },
    { h_cite, u_uid },
    { h_cite, u_url },

    { h_entry, dt_published },
    { h_entry, dt_updated },
    { h_entry, e_content },
    { h_entry, p_author },
    { h_entry, p_category },
    { h_entry, p_comment },
    { h_entry, p_geo },
    { h_entry, p_latitude },
    { h_entry, p_location },
    { h_entry, p_longitude },
    { h_entry, p_name },
    { h_entry, p_rsvp },
    { h_entry, p_summary },
    { h_entry, u_audio },
    { h_entry, u_bookmark_of },
    { h_entry, u_featured },
    { h_entry, u_in_reply_to },
    { h_entry, u_like },
    { h_entry, u_like_of },
    { h_entry, u_photo },
    { h_entry, u_repost },
    { h_entry, u_repost_of },
    { h_entry, u_syndication },
    { h_entry, u_uid },
    { h_entry, u_url },
    { h_entry, u_video },

    { h_event, dt_duration },
    { h_event, dt_end },
    { h_event, dt_start },
    { h_event, e_content },
    { h_event, p_attendee },
    { h_event, p_category },
    { h_event, p_description },
    { h_event, p_geo },
    { h_event, p_latitude },
    { h_event, p_location },
    { h_event, p_longitude },
    { h_event, p_name },
    { h_event, p_summary },
    { h_event, u_url },

    { h_feed, p_author },
    { h_feed, p_entry },
    { h_feed, p_name },
    { h_feed, p_summary },
    { h_feed, u_photo },
    { h_feed, u_url },

    { h_geo, p_altitude },
    { h_geo, p_latitude },
    { h_geo, p_longitude },

    { h_item, p_name },
    { h_item, u_photo },
    { h_item, u_url },

    { h_listing, p_action },
    { h_listing, p_category },
    { h_listing, dt_expired },
    { h_listing, dt_listed },
    { h_listing, p_lister },
    { h_listing, p_price },
    { h_listing, u_url },

    { h_product, e_description },
    { h_product, p_brand },
    { h_product, p_category },
    { h_product, p_name },
    { h_product, p_price },
    { h_product, p_review },
    { h_product, u_identifier },
    { h_product, u_photo },
    { h_product, u_url },

    { h_recipe, dt_duration },
    { h_recipe, dt_published },
    { h_recipe, e_instructions },
    { h_recipe, p_author },
    { h_recipe, p_ingredient },
    { h_recipe, p_name },
    { h_recipe, p_nutrition },
    { h_recipe, p_summary },
    { h_recipe, p_yield },
    { h_recipe, u_photo },

    { h_resume, p_affiliation },
    { h_resume, p_contact },
    { h_resume, p_education },
    { h_resume, p_experience },
    { h_resume, p_name },
    { h_resume, p_skill },
    { h_resume, p_summary },

    { h_review, p_author },
    { h_review, p_best },
    { h_review, p_category },
    { h_review, e_content },
    { h_review, p_item },
    { h_review, p_location },
    { h_review, p_name },
    { h_review, dt_published },
    { h_review, p_rating },
    { h_review, p_summary },
    { h_review, p_worst },
    { h_review, u_syndication },
    { h_review, u_url } };

typedef ssc_set < field > field_t;
field_t farm;

void fields_init () { for (int i = 0; i < sizeof (fields) / sizeof (field); ++i) farm.insert (fields [i]); }
bool is_plausible_field (const field& f) { return farm.find (f) != farm.end (); }
bool is_plausible_field (const e_vocabulary container, const e_property prop)
        { return is_plausible_field (field (container, prop)); };
