/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "symbol.h"
#include "context.h"
#include "type.h"

typedef enum
{   p_unknown,
    dt_accessed, r_acquaintance, p_action, p_additional_name, p_adr, p_affiliation, r_alternative, p_altitude, dt_anniversary, r_appendix,
    p_attendee, u_audio, p_author, r_author, p_average, dt_bday, p_best, r_bookmark, u_bookmark_of, p_brand, p_category, r_chapter, r_child,
    r_colleague, p_comment, p_contact, r_contact, e_content, p_content, r_contents, r_copyright, r_coresident, p_count, p_country_name,
    r_coworker, r_crush, r_date, e_description, p_description, r_directory, dt_duration, p_education, u_email, r_enclosure, dt_end, p_entry,
    p_experience, dt_expired, p_extended_address, p_family_name, u_featured, r_first, r_friend, p_gender_identity, p_geo, u_geo, p_given_name,
    r_glossary, r_help, r_home, p_honorific_prefix, p_honorific_suffix, u_identifier, u_impp, p_ingredient, r_in_reply_to, u_in_reply_to, e_instructions,
    p_item, r_its_rules, p_job_title, r_index, r_kin, u_key, p_label, r_last, p_latitude, r_licence, u_like, u_like_of, dt_listed, p_lister,
    p_locality, p_location, u_logo, p_longitude, r_me, r_met, r_muse, p_name, r_neighbour, r_next, p_nickname, r_nofollow, p_note, p_nutrition,
    p_org, p_organization_name, p_organization_unit, p_organizer, r_parent, r_payment, u_photo, p_post_office_box, p_postal_code, r_prev,
    p_price, r_pronunciation, p_publication, dt_published, p_rating, p_region, dt_rev, u_repost, u_repost_of, p_review, dt_reviewed,
    p_reviewer, p_role, p_rsvp, r_section, p_sex, r_sibling, r_sidebar, p_skill, p_sort_string, u_sound, r_spouse, dt_start, r_start, p_street_address,
    r_subsection, r_supercedes, r_stylesheet, p_summary, r_sweetheart, u_syndication, r_tag, p_tel, r_toc, r_top, r_transformation, p_tz, u_uid, r_up, dt_updated,
    u_url, r_vcs_git, r_vcs_svn, u_video, p_votes, p_worst, p_yield, r_micropub, r_pingback, r_webmention,
    r_canonical, r_code_licence, r_content_licence, r_discussion, r_issues,
    r_bibliography, r_cite, r_group, r_map, r_member,
    u_dnsprefetch, u_external, u_icon, u_noopener, u_noreferrer, u_preconnect, u_prefetch, u_preload, u_prerender, u_search,
    r_about, r_accessibility, r_amphtml, r_apple_touch_icon, r_apple_touch_icon_precomposed,
    r_apple_touch_startup_image, r_archived, r_archives, r_attachment, r_authorisation_endpoint, r_banner, r_begin, r_biblioentry,
    r_blocked_by, r_category, r_chrome_webstore_item, r_citation,
    r_cite_as, r_code_repository, r_collection, r_comment, r_component,
    r_content_repository, r_contribution, r_convertedfrom, r_create_form,
    r_current, r_dcterms_conformsto, r_dcterms_contributor, r_dcterms_creator, r_dcterms_description, r_dcterms_hasformat,
    r_dcterms_haspart, r_dcterms_hasversion, r_dcterms_isformatof, r_dcterms_ispartof, r_dcterms_isreferencedby, r_dcterms_isreplacedby,
    r_dcterms_isrequiredby, r_dcterms_isversionof, r_dcterms_licence, r_dcterms_mediator, r_dcterms_publisher, r_dcterms_references,
    r_dcterms_relation, r_dcterms_replaces, r_dcterms_requires, r_dcterms_rightsholder, r_dcterms_source, r_dcterms_subject, r_definition,
    r_describedby, r_describes, r_disclaimer, r_disclosure, r_dnsprefetch, r_docs_oasis_open_org_ns_cmis_link_200908_acl,
    r_duplicate, r_edit, r_edit_form, r_edit_media, r_editor, r_edituri, r_end, r_endorsed, r_entry_content, r_external,
    r_fan, r_feed, r_footnote, r_gbfs, r_gtfs_realtime, r_gtfs_static, r_hosts,
    r_hub, r_icon, r_image_src, r_import, r_intervalafter, r_intervalbefore, r_intervalcontains, r_intervaldisjoint,
    r_intervalduring, r_intervalequals, r_intervalfinishedby, r_intervalfinishes, r_intervalin, r_intervalmeets, r_intervalmetby,
    r_intervaloverlappedby, r_intervaloverlaps, r_intervalstartedby, r_intervalstarts, r_item, r_jslicence,
    r_kinetic_stylesheet, r_latest_version, r_lightbox, r_lightvideo, r_logo, r_longdesc, r_lrdd, r_m_pagescroll2id, r_made,
    r_manifest, r_maskicon, r_memento, r_meta, r_microsummary, r_monitor, r_monitor_group,
    r_next_archive, r_navigate, r_noopener, r_noreferrer, r_openid2_local_id, r_openid2_provider,
    r_openid_delegate, r_openid_server, r_origin2, r_original, r_p3pv1, r_pavatar, r_permalink, r_pgpkey, r_pointer,
    r_popover, r_preconnect, r_predecessor_version, r_prefetch, r_preload, r_prerender, r_prev_archive, r_preview, r_privacy, r_privacy_policy,
    r_profile, r_publickey, r_publisher, r_radioepg, r_referral, r_related, r_rendition, r_replies, r_reply_to, r_resource,
    r_respond_proxy, r_respond_redirect, r_restconf, r_root, r_schema_dc, r_schema_dcterms, r_search, r_self, r_service,
    r_service_desc, r_service_doc, r_service_meta, r_shortlink, r_sitemap, r_source, r_sponsor,
    r_status, r_stylesheetless, r_subresource, r_successor_version, r_sunset, r_sword, r_syndication,
    r_terms_of_service, r_timegate, r_timemap, r_timesheet, r_token_endpoint, r_tooltip, r_trackback, r_trademark,
    r_translation, r_type, r_unendorsed, r_urc, r_user, r_vcalendar_child, r_vcalendar_parent, r_vcalendar_sibling,
    r_version_history, r_via, r_w_api_org, r_widget, r_wlwmanifest, r_working_copy, r_working_copy_of,
    r_yandex_tableau_widget,
    r_cc_permits, r_cc_requires, r_cc_prohibits, r_cc_jurisdiction, r_cc_legalcode, r_cc_deprecatedon,
    r_cc_licence, r_cc_morepermissions, /* r_cc_attributionname, */ r_cc_attributionurl, r_cc_useguidelines } e_property;

class prop : public symbol < e_property >
{   ::std::string diagnosis_;
public:
    prop () = default;
    prop (const prop& s) = default;
    prop (prop&&) = default;
    explicit prop (const ::std::string& x)
    {   e_property p;
        if (parse (x, p, diagnosis_)) set (p); }
    prop& operator = (const prop&) = default;
    prop& operator = (prop&&) = default;
    void swap (prop& p) noexcept
    {   diagnosis_.swap (p.diagnosis_);
        symbol < e_property > :: swap (p); }
    static bool parse (const ::std::string& x, e_property& p, ::std::string& diagnosis);
    static void init ();
    bool unknown () const
    {   return (symbol < e_property > :: unknown ()) || (symbol < e_property > :: get () == p_unknown); }
    bool whoopsie () const { return ! diagnosis_.empty (); }
    ::std::string diagnosis () const { return diagnosis_; } };
