/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "symbol_table.h"

// VALUE is presumed to be an enum or an int ; will enforce once concepts are properly implemented
template < typename VALUE > class symbol
{   static symbol_table < VALUE > table_;
    VALUE value_;
    bool unknown_;
public:
    symbol () : unknown_ (true), value_ (static_cast <VALUE> (0)) { }
    symbol (const symbol& s) = default;
    symbol (symbol&&) = default;
    symbol& operator = (const symbol&) = default;
    symbol& operator = (symbol&&) = default;
    explicit symbol (const ::std::string& x) { unknown_ = ! find (x, value_); }
    static void init (const symbol_entry < VALUE > table [], const size_t size, const bool wildcards = false)
    {   table_.init (table, size, wildcards); }
    static bool find (const ::std::string& x, VALUE& res) { return table_.find (x, res); }
    static bool parse (const ::std::string& x, VALUE& res) { return table_.parse (x, res); }
    void swap (symbol& s) noexcept
    {   ::std::swap (unknown_, s.unknown_);
        ::std::swap (value_, s.value_); }
    static ::std::string value_list () { return table_.value_list (); }
    static ::std::size_t value_count () { return table_.value_count (); }
    static ::std::string name (const VALUE x) { return table_.name (x); }
    static void append (const ::std::string& symbol, const VALUE value)
    {   table_.extend (symbol, value); }
    VALUE get () const { if (unknown_) return static_cast <VALUE> (0); return value_; }
    void set (const VALUE& v)  { value_ = v; unknown_ = false; }
    operator VALUE () const { return get (); }
    bool unknown () const { return unknown_; }
    ::std::string name () const { return table_.name (get ()); }
    bool invalid () const { return unknown_; } };

template < typename VALUE > symbol_table < VALUE > symbol < VALUE > :: table_;
